/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.picketlink.idm.api.Attribute;
import org.picketlink.idm.spi.model.IdentityObjectAttribute;

public class SimpleAttribute
implements IdentityObjectAttribute,
Attribute,
Serializable {
    private final String name;
    private final List<Object> values = new LinkedList<Object>();

    public SimpleAttribute(String name) {
        this.name = name;
    }

    public SimpleAttribute(String name, Object[] values) {
        this.name = name;
        for (Object value : values) {
            this.values.add(value);
        }
    }

    public SimpleAttribute(String name, Object value) {
        this.name = name;
        if (value != null) {
            this.values.add(value);
        }
    }

    public SimpleAttribute(Attribute attribute) {
        this.name = attribute.getName();
        this.values.addAll(attribute.getValues());
    }

    public SimpleAttribute(IdentityObjectAttribute attribute) {
        this.name = attribute.getName();
        this.values.addAll(attribute.getValues());
    }

    public String getName() {
        return this.name;
    }

    public Collection getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public Object getValue() {
        if (this.values.size() > 0) {
            return this.values.iterator().next();
        }
        return null;
    }

    public int getSize() {
        return this.values.size();
    }

    public void addValue(Object value) {
        this.values.add(value);
    }
}

