/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.picketlink.idm.impl.api.attribute.IdentityObjectAttributeMetaDataImpl;
import org.picketlink.idm.impl.configuration.metadata.IdentityObjectTypeMetaDataImpl;
import org.picketlink.idm.impl.configuration.metadata.IdentityStoreConfigurationMetaDataImpl;
import org.picketlink.idm.spi.configuration.IdentityConfigurationContextRegistry;
import org.picketlink.idm.spi.configuration.IdentityStoreConfigurationContext;
import org.picketlink.idm.spi.configuration.metadata.IdentityConfigurationMetaData;
import org.picketlink.idm.spi.configuration.metadata.IdentityObjectAttributeMetaData;
import org.picketlink.idm.spi.configuration.metadata.IdentityObjectTypeMetaData;
import org.picketlink.idm.spi.configuration.metadata.IdentityStoreConfigurationMetaData;

public class ExoIdentityStoreConfigurationContext
implements IdentityStoreConfigurationContext {
    public static final String LDAP_USERS_ATTRIBUTES_NAMES_PROP = "exo.ldap.users.attributes.custom.names";
    public static final String LDAP_GROUPS_ATTRIBUTES_NAMES_PROP = "exo.ldap.groups.attributes.custom.names";
    public static final String LDAP_USERS_ATTRIBUTES_PROPS_PREFIX = "exo.ldap.users.attributes.";
    public static final String LDAP_GROUPS_ATTRIBUTES_PROPS_PREFIX = "exo.ldap.groups.attributes.";
    private IdentityStoreConfigurationContext identityStoreConfigurationContext;

    public ExoIdentityStoreConfigurationContext(IdentityStoreConfigurationContext identityStoreConfigurationContext) {
        this.identityStoreConfigurationContext = identityStoreConfigurationContext;
    }

    public IdentityStoreConfigurationMetaData getStoreConfigurationMetaData() {
        IdentityStoreConfigurationMetaDataImpl storeConfigurationMetaData = (IdentityStoreConfigurationMetaDataImpl)this.identityStoreConfigurationContext.getStoreConfigurationMetaData();
        List supportedIdentityTypes = storeConfigurationMetaData.getSupportedIdentityTypes();
        ArrayList<IdentityObjectTypeMetaData> enrichedSupportedIdentityTypes = new ArrayList<IdentityObjectTypeMetaData>(supportedIdentityTypes.size());
        for (IdentityObjectTypeMetaData supportedIdentityType : supportedIdentityTypes) {
            List<String> convertedCtxDNs = this.convertCtxDNs(supportedIdentityType);
            if (convertedCtxDNs != null) {
                supportedIdentityType.getOptions().put("ctxDNs", convertedCtxDNs);
            }
            List<IdentityObjectAttributeMetaData> enrichedAttributes = this.enrichAttributes(supportedIdentityType);
            ((IdentityObjectTypeMetaDataImpl)supportedIdentityType).setAttributes(enrichedAttributes);
            enrichedSupportedIdentityTypes.add(supportedIdentityType);
        }
        storeConfigurationMetaData.setSupportedIdentityTypes(enrichedSupportedIdentityTypes);
        return storeConfigurationMetaData;
    }

    protected List<IdentityObjectAttributeMetaData> enrichAttributes(IdentityObjectTypeMetaData supportedIdentityType) {
        String customAttributesNamesProperty;
        ArrayList<IdentityObjectAttributeMetaData> attributes;
        String customNamesPropertyName = LDAP_USERS_ATTRIBUTES_NAMES_PROP;
        String attributesPropertyPrefix = LDAP_USERS_ATTRIBUTES_PROPS_PREFIX;
        if ("GROUP".equals(supportedIdentityType.getName())) {
            customNamesPropertyName = LDAP_GROUPS_ATTRIBUTES_NAMES_PROP;
            attributesPropertyPrefix = LDAP_GROUPS_ATTRIBUTES_PROPS_PREFIX;
        }
        if ((attributes = supportedIdentityType.getAttributes()) == null) {
            attributes = new ArrayList<IdentityObjectAttributeMetaData>();
        }
        if (StringUtils.isNotBlank((CharSequence)(customAttributesNamesProperty = PropertyManager.getProperty((String)customNamesPropertyName)))) {
            String[] customAttributesNames;
            for (String name : customAttributesNames = customAttributesNamesProperty.split(",")) {
                String mapping = PropertyManager.getProperty((String)(attributesPropertyPrefix + name + ".mapping"));
                String type = PropertyManager.getProperty((String)(attributesPropertyPrefix + name + ".type"));
                String isRequired = PropertyManager.getProperty((String)(attributesPropertyPrefix + name + ".isRequired"));
                String isMultivalued = PropertyManager.getProperty((String)(attributesPropertyPrefix + name + ".isMultivalued"));
                IdentityObjectAttributeMetaDataImpl attribute = new IdentityObjectAttributeMetaDataImpl(name, mapping != null ? mapping : name, type != null ? type : "text", true, isMultivalued != null ? Boolean.valueOf(isMultivalued) : false, isRequired != null ? Boolean.valueOf(isRequired) : false, true);
                attributes.add((IdentityObjectAttributeMetaData)attribute);
            }
        }
        return attributes;
    }

    protected List<String> convertCtxDNs(IdentityObjectTypeMetaData supportedIdentityType) {
        Map options = supportedIdentityType.getOptions();
        if (options == null) {
            return null;
        }
        List ctxDNs = (List)options.get("ctxDNs");
        if (ctxDNs == null) {
            return null;
        }
        List<String> convertedCtxDNs = ctxDNs.stream().flatMap(ctxDN -> Arrays.stream(ctxDN.split(";"))).collect(Collectors.toList());
        return convertedCtxDNs;
    }

    public IdentityConfigurationMetaData getConfigurationMetaData() {
        return this.identityStoreConfigurationContext.getConfigurationMetaData();
    }

    public IdentityConfigurationContextRegistry getConfigurationRegistry() {
        return this.identityStoreConfigurationContext.getConfigurationRegistry();
    }
}

