/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.notification.rest;

import io.meeds.social.notification.rest.model.WebNotificationListRestEntity;
import io.meeds.social.notification.rest.utils.WebNotificationRestEntityBuilder;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.model.WebNotificationFilter;
import org.exoplatform.commons.api.notification.service.WebNotificationService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.http.PATCH;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;

@Path(value="notifications/webNotifications")
@Tag(name="notifications/webNotifications", description="Manage web notifications")
public class WebNotificationRestService
implements ResourceContainer {
    private static final String MARK_ALL_AS_READ_OPERATION = "markAllAsRead";
    private static final String RESET_NEW_OPERATION = "resetBadge";
    private static final String MARK_AS_READ_OPERATION = "markAsRead";
    private static final Log LOG = ExoLogger.getLogger(WebNotificationRestService.class);
    private WebNotificationService webNftService;
    private IdentityManager identityManager;
    private SpaceService spaceService;

    public WebNotificationRestService(WebNotificationService webNftService, IdentityManager identityManager, SpaceService spaceService) {
        this.webNftService = webNftService;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
    }

    @GET
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Get notifications list", description="This gets the list of the notifications", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Notifications list returned"), @ApiResponse(responseCode="404", description="Notifications list not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getNotifications(@Parameter(description="The list of plugins to include in list", required=false) @QueryParam(value="plugin") List<String> plugins, @Parameter(description="Includes in response the unread badges count by plugin", required=false) @DefaultValue(value="false") @QueryParam(value="badgeByPlugin") boolean badgeByPlugin, @Parameter(description="Includes hidden notifications in response", required=false) @DefaultValue(value="false") @QueryParam(value="includeHidden") boolean includeHidden, @Parameter(description="Whether include only unread notifications or all", required=false) @DefaultValue(value="false") @QueryParam(value="onlyUnread") boolean onlyUnread, @Parameter(description="Search Offset", required=false) @DefaultValue(value="0") @QueryParam(value="offset") int offset, @Parameter(description="Search Limit", required=false) @DefaultValue(value="10") @QueryParam(value="limit") int limit) {
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        int badge = this.webNftService.getNumberOnBadge(currentUser);
        WebNotificationFilter filter = new WebNotificationFilter(currentUser, plugins == null ? Collections.emptyList() : plugins.stream().map(PluginKey::key).toList(), !includeHidden);
        if (onlyUnread) {
            filter.setIsRead(Boolean.valueOf(false));
        }
        List notificationInfos = limit > 0 ? this.webNftService.getNotificationInfos(filter, offset, limit) : Collections.emptyList();
        Map badgesByPlugin = null;
        if (badgeByPlugin) {
            badgesByPlugin = this.webNftService.countUnreadByPlugin(currentUser);
        }
        WebNotificationListRestEntity webNotificationsList = WebNotificationRestEntityBuilder.toRestEntity(this.webNftService, this.identityManager, this.spaceService, notificationInfos, !includeHidden, badge, badgesByPlugin, offset, limit);
        return Response.ok((Object)webNotificationsList).build();
    }

    @DELETE
    @Path(value="{id}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Hide notification", description="Hides a designated notification", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fullfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response hideNotifications(@Parameter(description="notification id", required=true) @PathParam(value="id") String notificationId) {
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        if (notificationId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        NotificationInfo notification = this.webNftService.getNotificationInfo(notificationId);
        if (currentUser.equals(notification.getTo())) {
            this.webNftService.hidePopover(notificationId);
            return Response.noContent().build();
        }
        LOG.warn("User {} is not allowed to hide notification {}", new Object[]{currentUser, notificationId});
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @PATCH
    @Consumes(value={"text/plain"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Update notification", description="Perform some patch operations on notifications", method="PATCH")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Notification updated"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateNotifications(@Parameter(description="The list of plugins to include in list", required=false) @QueryParam(value="plugin") List<String> plugins, @Parameter(description="notification operation", required=true) @QueryParam(value="operation") String operation) {
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        if (RESET_NEW_OPERATION.equals(operation)) {
            this.webNftService.resetNumberOnBadge(plugins, currentUser);
        } else if (MARK_ALL_AS_READ_OPERATION.equals(operation)) {
            this.webNftService.markAllRead(plugins, currentUser);
            this.webNftService.resetNumberOnBadge(plugins, currentUser);
        } else {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Unrecognized operation parameter value: " + operation)).build();
        }
        return Response.noContent().build();
    }

    @PATCH
    @Path(value="{id}")
    @Consumes(value={"text/plain"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Update notification", description="Perform some patch operations on notifications", method="PATCH")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Notification updated"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateNotification(@Parameter(description="notification operation", required=true) @QueryParam(value="operation") String operation, @Parameter(description="notification id", required=false) @PathParam(value="id") String notificationId) {
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        if (MARK_AS_READ_OPERATION.equals(operation)) {
            if (notificationId == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            NotificationInfo notification = this.webNftService.getNotificationInfo(notificationId);
            if (!currentUser.equals(notification.getTo())) {
                LOG.warn("User {} is not allowed to mark notification {} as read", new Object[]{currentUser, notificationId});
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
        } else {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Unrecognized operation parameter value: " + operation)).build();
        }
        this.webNftService.markRead(notificationId);
        return Response.noContent().build();
    }
}

