/*
 * Decompiled with CFR 0.152.
 */
package liquibase.analytics.configuration;

import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import liquibase.Scope;
import liquibase.analytics.configuration.AnalyticsArgs;
import liquibase.analytics.configuration.AnalyticsConfiguration;
import liquibase.analytics.configuration.RemoteAnalyticsConfiguration;
import liquibase.configuration.ConfiguredValue;
import liquibase.logging.Logger;
import liquibase.util.Cache;
import lombok.Generated;
import org.yaml.snakeyaml.Yaml;

public class LiquibaseRemoteAnalyticsConfiguration
implements AnalyticsConfiguration {
    private static final Cache<RemoteAnalyticsConfiguration> remoteAnalyticsConfiguration = new Cache<RemoteAnalyticsConfiguration>(() -> {
        Logger log = Scope.getCurrentScope().getLog(AnalyticsConfiguration.class);
        Level logLevel = AnalyticsArgs.LOG_LEVEL.getCurrentValue();
        String url = AnalyticsArgs.CONFIG_ENDPOINT_URL.getCurrentValue();
        AtomicReference remoteAnalyticsConfiguration = new AtomicReference();
        AtomicBoolean timedOut = new AtomicBoolean(true);
        Thread thread = new Thread(() -> {
            try {
                InputStream input = new URL(url).openStream();
                Yaml yaml = new Yaml();
                Map loaded = (Map)yaml.loadAs(input, Map.class);
                remoteAnalyticsConfiguration.set(RemoteAnalyticsConfiguration.fromYaml(loaded));
            }
            catch (Exception e) {
                log.log(logLevel, "Failed to load analytics configuration from " + url, e);
            }
            timedOut.set(false);
        });
        thread.start();
        thread.join(AnalyticsArgs.CONFIG_ENDPOINT_TIMEOUT_MILLIS.getCurrentValue().intValue());
        if (timedOut.get()) {
            log.log(logLevel, "Timed out while attempting to load analytics configuration from " + url, null);
        }
        return (RemoteAnalyticsConfiguration)remoteAnalyticsConfiguration.get();
    }, false, AnalyticsArgs.CONFIG_CACHE_TIMEOUT_MILLIS.getCurrentValue());

    @Override
    public int getPriority() {
        return 0;
    }

    public int getTimeoutMillis() throws Exception {
        ConfiguredValue<Integer> userTimeoutMillis = AnalyticsArgs.TIMEOUT_MILLIS.getCurrentConfiguredValue();
        if (userTimeoutMillis.found()) {
            return userTimeoutMillis.getValue();
        }
        return remoteAnalyticsConfiguration.get().getTimeoutMs();
    }

    public String getDestinationUrl() throws Exception {
        return remoteAnalyticsConfiguration.get().getEndpointData();
    }

    @Override
    public boolean isOssAnalyticsEnabled() throws Exception {
        return remoteAnalyticsConfiguration.get().isSendOss();
    }

    @Override
    public boolean isProAnalyticsEnabled() throws Exception {
        return remoteAnalyticsConfiguration.get().isSendPro();
    }

    public String getWriteKey() throws Exception {
        return remoteAnalyticsConfiguration.get().getWriteKey();
    }

    public List<RemoteAnalyticsConfiguration.ExtensionName> getExtensionNames() throws Exception {
        return remoteAnalyticsConfiguration.get().getExtensions();
    }

    @Generated
    public LiquibaseRemoteAnalyticsConfiguration() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LiquibaseRemoteAnalyticsConfiguration)) {
            return false;
        }
        LiquibaseRemoteAnalyticsConfiguration other = (LiquibaseRemoteAnalyticsConfiguration)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LiquibaseRemoteAnalyticsConfiguration;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "LiquibaseRemoteAnalyticsConfiguration()";
    }
}

