/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import jakarta.servlet.ServletContext;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.BaseContainerLifecyclePlugin;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceInitContainerLifecyclePlugin
extends BaseContainerLifecyclePlugin {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceInitContainerLifecyclePlugin.class);

    public void startContainer(final ExoContainer container) throws Exception {
        if (container instanceof PortalContainer) {
            PortalContainer portalContainer = (PortalContainer)container;
            if (!PropertyManager.isDevelopping()) {
                PortalContainer.addInitTask((ServletContext)portalContainer.getPortalContext(), (RootContainer.PortalContainerInitTask)new RootContainer.PortalContainerPostCreateTask(this){

                    public void execute(ServletContext context, PortalContainer portalContainer) {
                        LOG.info("Proceed on resources caching initialization");
                        ((JavascriptConfigService)container.getComponentInstanceOfType(JavascriptConfigService.class)).initData();
                        ((SkinService)container.getComponentInstanceOfType(SkinService.class)).initData();
                    }
                });
            }
        }
    }
}

