/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.RateLimitSetting;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GoogleAiStudioServiceSettings
implements JsonpSerializable {
    private final String apiKey;
    private final String modelId;
    @Nullable
    private final RateLimitSetting rateLimit;
    public static final JsonpDeserializer<GoogleAiStudioServiceSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GoogleAiStudioServiceSettings::setupGoogleAiStudioServiceSettingsDeserializer);

    private GoogleAiStudioServiceSettings(Builder builder) {
        this.apiKey = ApiTypeHelper.requireNonNull(builder.apiKey, this, "apiKey");
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.rateLimit = builder.rateLimit;
    }

    public static GoogleAiStudioServiceSettings of(Function<Builder, ObjectBuilder<GoogleAiStudioServiceSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String apiKey() {
        return this.apiKey;
    }

    public final String modelId() {
        return this.modelId;
    }

    @Nullable
    public final RateLimitSetting rateLimit() {
        return this.rateLimit;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("api_key");
        generator.write(this.apiKey);
        generator.writeKey("model_id");
        generator.write(this.modelId);
        if (this.rateLimit != null) {
            generator.writeKey("rate_limit");
            this.rateLimit.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGoogleAiStudioServiceSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::apiKey, JsonpDeserializer.stringDeserializer(), "api_key");
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(Builder::rateLimit, RateLimitSetting._DESERIALIZER, "rate_limit");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GoogleAiStudioServiceSettings> {
        private String apiKey;
        private String modelId;
        @Nullable
        private RateLimitSetting rateLimit;

        public final Builder apiKey(String value) {
            this.apiKey = value;
            return this;
        }

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder rateLimit(@Nullable RateLimitSetting value) {
            this.rateLimit = value;
            return this;
        }

        public final Builder rateLimit(Function<RateLimitSetting.Builder, ObjectBuilder<RateLimitSetting>> fn) {
            return this.rateLimit(fn.apply(new RateLimitSetting.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GoogleAiStudioServiceSettings build() {
            this._checkSingleUse();
            return new GoogleAiStudioServiceSettings(this);
        }
    }
}

