/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.DtoProjectionTransformerDelegate;
import org.springframework.data.jpa.repository.query.JpaQueryTransformerSupport;
import org.springframework.data.jpa.repository.query.JpqlParser;
import org.springframework.data.jpa.repository.query.JpqlQueryRenderer;
import org.springframework.data.jpa.repository.query.QueryInformation;
import org.springframework.data.jpa.repository.query.QueryRenderer;
import org.springframework.data.jpa.repository.query.QueryToken;
import org.springframework.data.jpa.repository.query.QueryTokenStream;
import org.springframework.data.jpa.repository.query.QueryTokens;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class JpqlSortedQueryTransformer
extends JpqlQueryRenderer {
    private final JpaQueryTransformerSupport transformerSupport = new JpaQueryTransformerSupport();
    private final Sort sort;
    @Nullable
    private final String primaryFromAlias;
    @Nullable
    private final DtoProjectionTransformerDelegate dtoDelegate;

    JpqlSortedQueryTransformer(Sort sort, QueryInformation queryInformation, @Nullable ReturnedType returnedType) {
        Assert.notNull((Object)sort, (String)"Sort must not be null");
        Assert.notNull((Object)queryInformation, (String)"ParsedHqlQueryInformation must not be null");
        this.sort = sort;
        this.primaryFromAlias = queryInformation.getAlias();
        this.dtoDelegate = returnedType == null ? null : new DtoProjectionTransformerDelegate(returnedType);
    }

    @Override
    public QueryTokenStream visitSelect_statement(JpqlParser.Select_statementContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.select_clause()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.from_clause()));
        if (ctx.where_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.where_clause()));
        }
        if (ctx.groupby_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.groupby_clause()));
        }
        if (ctx.having_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.having_clause()));
        }
        this.doVisitOrderBy(builder, ctx);
        return builder;
    }

    @Override
    public QueryTokenStream visitSelect_clause(JpqlParser.Select_clauseContext ctx) {
        if (this.dtoDelegate == null) {
            return super.visitSelect_clause(ctx);
        }
        QueryRenderer.QueryRendererBuilder builder = this.prepareSelectClause(ctx);
        QueryTokenStream selectItems = QueryTokenStream.concat(ctx.select_item(), arg_0 -> ((JpqlSortedQueryTransformer)this).visit(arg_0), QueryTokens.TOKEN_COMMA);
        if (this.dtoDelegate != null && this.dtoDelegate.canRewrite()) {
            builder.append(this.dtoDelegate.getRewrittenSelectionList());
        } else {
            builder.append(selectItems);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSelect_item(JpqlParser.Select_itemContext ctx) {
        QueryTokenStream tokens = super.visitSelect_item(ctx);
        if (ctx.result_variable() != null && !tokens.isEmpty()) {
            this.transformerSupport.registerAlias(ctx.result_variable().getText());
        }
        return tokens;
    }

    @Override
    public QueryTokenStream visitSelect_expression(JpqlParser.Select_expressionContext ctx) {
        QueryTokenStream selectItem = super.visitSelect_expression(ctx);
        if (this.dtoDelegate != null && this.dtoDelegate.applyRewriting() && ctx.constructor_expression() == null) {
            this.dtoDelegate.appendSelectItem(selectItem);
        }
        return selectItem;
    }

    @Override
    public QueryTokenStream visitJoin(JpqlParser.JoinContext ctx) {
        QueryTokenStream tokens = super.visitJoin(ctx);
        if (ctx.identification_variable() != null) {
            this.transformerSupport.registerAlias(ctx.identification_variable().getText());
        }
        return tokens;
    }

    private void doVisitOrderBy(QueryRenderer.QueryRendererBuilder builder, JpqlParser.Select_statementContext ctx) {
        if (ctx.orderby_clause() != null) {
            QueryTokenStream existingOrder = (QueryTokenStream)this.visit((ParseTree)ctx.orderby_clause());
            if (this.sort.isSorted()) {
                builder.appendInline(existingOrder);
            } else {
                builder.append(existingOrder);
            }
        }
        if (this.sort.isSorted()) {
            List<QueryToken> sortBy = this.transformerSupport.orderBy(this.primaryFromAlias, this.sort);
            if (ctx.orderby_clause() != null) {
                QueryRenderer.QueryRendererBuilder extension = QueryRenderer.builder().append(QueryTokens.TOKEN_COMMA).append(sortBy);
                builder.appendInline(extension);
            } else {
                builder.append(QueryTokens.TOKEN_ORDER_BY);
                builder.append(sortBy);
            }
        }
    }
}

