/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.content.news.plugin;

import io.meeds.content.news.model.News;
import io.meeds.content.news.service.NewsService;
import io.meeds.content.news.utils.NewsUtils;
import jakarta.annotation.PostConstruct;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.attachment.AttachmentPlugin;
import org.exoplatform.social.attachment.AttachmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NewsPageAttachmentPlugin
extends AttachmentPlugin {
    @Autowired
    private AttachmentService attachmentService;
    @Autowired
    private NewsService newsService;
    public static final String OBJECT_TYPE = "articlePage";

    @PostConstruct
    public void init() {
        this.attachmentService.addPlugin((AttachmentPlugin)this);
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean hasAccessPermission(Identity identity, String articleId) throws ObjectNotFoundException {
        News news = this.newsService.getNewsArticleById(articleId);
        return news != null && this.newsService.canViewNews(news, identity.getUserId());
    }

    public boolean hasEditPermission(Identity identity, String articleId) throws ObjectNotFoundException {
        News news = null;
        try {
            news = this.newsService.getNewsById(articleId, identity, false, NewsUtils.NewsObjectType.ARTICLE.name());
        }
        catch (IllegalAccessException e) {
            return false;
        }
        return news != null && news.isCanEdit();
    }

    public long getAudienceId(String s) throws ObjectNotFoundException {
        return 0L;
    }

    public long getSpaceId(String articleId) throws ObjectNotFoundException {
        News news = this.newsService.getNewsArticleById(articleId);
        return news != null ? Long.parseLong(news.getSpaceId()) : 0L;
    }
}

