/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.plugin;

import com.fasterxml.jackson.core.type.TypeReference;
import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.layout.model.LayoutModel;
import io.meeds.layout.model.NavigationCreateModel;
import io.meeds.layout.model.NavigationUpdateModel;
import io.meeds.layout.model.NodeDefinition;
import io.meeds.layout.model.NodeLabel;
import io.meeds.layout.model.PortletInstanceContext;
import io.meeds.layout.model.SiteDefinition;
import io.meeds.layout.model.SiteTemplate;
import io.meeds.layout.model.SiteTemplateDatabind;
import io.meeds.layout.plugin.SiteTemplateDatabindPlugin$AjcClosure1;
import io.meeds.layout.service.NavigationLayoutService;
import io.meeds.layout.service.PageLayoutService;
import io.meeds.layout.service.PortletInstanceService;
import io.meeds.layout.service.SiteTemplateService;
import io.meeds.layout.util.DatabindUtils;
import io.meeds.layout.util.JsonUtils;
import io.meeds.social.databind.model.DatabindReport;
import io.meeds.social.databind.plugin.DatabindPlugin;
import io.meeds.social.databind.service.DatabindService;
import io.meeds.social.translation.model.TranslationField;
import io.meeds.social.translation.service.TranslationService;
import jakarta.annotation.PostConstruct;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.Utils;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationState;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeData;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.attachment.model.UploadedAttachmentDetail;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.upload.UploadResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class SiteTemplateDatabindPlugin
implements DatabindPlugin {
    private static final Log LOG;
    private static final Random RANDOM;
    public static final String OBJECT_TYPE = "SiteTemplate";
    public static final String CONFIG_JSON = "config.json";
    public static final String NAVIGATION_JSON = "navigation.json";
    @Autowired
    private SiteTemplateService siteTemplateService;
    @Autowired
    private LayoutService layoutService;
    @Autowired
    private DatabindService databindService;
    @Autowired
    private FileService fileService;
    @Autowired
    private TranslationService translationService;
    @Autowired
    private AttachmentService attachmentService;
    @Autowired
    private UserACL userAcl;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private PortletInstanceService portletInstanceService;
    @Autowired
    private NavigationService navigationService;
    @Autowired
    private NavigationLayoutService navigationLayoutService;
    @Autowired
    private PageLayoutService pageLayoutService;
    private long superUserIdentityId;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @PostConstruct
    public void init() {
        this.databindService.addPlugin((DatabindPlugin)this);
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean canHandleDatabind(String objectType, String objectId) {
        return StringUtils.equals((CharSequence)OBJECT_TYPE, (CharSequence)objectType);
    }

    public void serialize(String objectId, ZipOutputStream zipOutputStream, String username) {
        FileItem file;
        TranslationField translationDescriptionField;
        SiteTemplate siteTemplate = this.siteTemplateService.getSiteTemplate(Long.parseLong(objectId), Locale.getDefault());
        SiteTemplateDatabind databind = new SiteTemplateDatabind();
        databind.setIcon(siteTemplate.getIcon());
        TranslationField translationNameField = this.translationService.getTranslationField("siteTemplate", Long.parseLong(objectId), "title", username);
        if (translationNameField != null) {
            Map<String, String> names = translationNameField.getLabels().entrySet().stream().collect(Collectors.toMap(entry -> ((Locale)entry.getKey()).toLanguageTag(), Map.Entry::getValue));
            databind.setNames(names);
        }
        if ((translationDescriptionField = this.translationService.getTranslationField("siteTemplate", Long.parseLong(objectId), "description", username)) != null) {
            Map<String, String> descriptions = translationDescriptionField.getLabels().entrySet().stream().collect(Collectors.toMap(entry -> ((Locale)entry.getKey()).toLanguageTag(), Map.Entry::getValue));
            databind.setDescriptions(descriptions);
        }
        if ((file = this.fileService.getFile(siteTemplate.getIllustrationId())) != null) {
            databind.setIllustration(Base64.encodeBase64String((byte[])file.getAsByte()));
        }
        SiteKey siteKey = SiteKey.portalTemplate((String)siteTemplate.getLayout());
        PortalConfig portalConfig = this.layoutService.getPortalConfig(siteKey);
        SiteDefinition siteDefinition = new SiteDefinition();
        siteDefinition.setName(portalConfig.getName());
        siteDefinition.setType(portalConfig.getType());
        siteDefinition.setAccessPermissions(portalConfig.getAccessPermissions());
        siteDefinition.setEditPermission(portalConfig.getEditPermission());
        siteDefinition.setProperties(portalConfig.getProperties());
        siteDefinition.setLayout(new LayoutModel((ModelObject)portalConfig.getPortalLayout(), this.portletInstanceService, new PortletInstanceContext(true, null)));
        siteDefinition.getLayout().resetStorage();
        databind.setSiteDefinition(siteDefinition);
        String jsonData = JsonUtils.toJsonString(databind);
        String folderPath = String.valueOf(siteKey.getType()) + "-" + siteKey.getName();
        List pageContexts = this.layoutService.findPages(siteKey);
        List<Object> pages = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)pageContexts)) {
            pages = pageContexts.stream().map(this::toPage).toList();
        }
        List<NodeDefinition> nodeDefinitions = this.buildNodeDefinitions(siteKey, username);
        String navigationJsonData = JsonUtils.toJsonString(nodeDefinitions);
        for (Page page : pages) {
            try {
                LayoutModel layoutModel = new LayoutModel((ModelObject)page, this.portletInstanceService, new PortletInstanceContext(true, null));
                DatabindUtils.retrieveBackgroundImages(layoutModel, this.fileService);
                layoutModel.resetStorage();
                String pageJson = JsonUtils.toJsonString(layoutModel);
                this.writeToZip(zipOutputStream, folderPath + "/pages/" + page.getName() + ".json", pageJson);
            }
            catch (Exception e) {
                LOG.warn((Object)("Error processing page " + page.getName() + ": " + e.getMessage()));
            }
        }
        this.writeToZip(zipOutputStream, folderPath + "/config.json", jsonData);
        this.writeToZip(zipOutputStream, folderPath + "/navigation.json", navigationJsonData);
    }

    public CompletableFuture<Pair<DatabindReport, File>> deserialize(File zipFile, Map<String, String> params, String username) {
        return CompletableFuture.supplyAsync(() -> this.importSiteTemplates(zipFile, username)).thenApply(processedTemplates -> {
            DatabindReport report = new DatabindReport();
            report.setSuccess(!processedTemplates.isEmpty());
            report.setProcessedItems(processedTemplates);
            return Pair.of((Object)report, (Object)zipFile);
        });
    }

    @ContainerTransactional
    public List<String> importSiteTemplates(File zipFile, String username) {
        File file = zipFile;
        String string = username;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)file, (Object)string);
        Object[] objectArray = new Object[]{this, file, string, joinPoint};
        SiteTemplateDatabindPlugin$AjcClosure1 siteTemplateDatabindPlugin$AjcClosure1 = new SiteTemplateDatabindPlugin$AjcClosure1(objectArray);
        return (List)ContainerTransactionalAspect.aspectOf().around(siteTemplateDatabindPlugin$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private Map<String, SiteTemplateDatabind> extractTemplates(File zipFile) {
        HashMap<String, SiteTemplateDatabind> templateDatabindMap = new HashMap<String, SiteTemplateDatabind>();
        try (ZipInputStream zis = new ZipInputStream((InputStream)new FileInputStream(zipFile), StandardCharsets.UTF_8);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                LayoutModel page;
                SiteTemplateDatabind databind;
                String key;
                int bytesRead;
                if (entry.isDirectory()) continue;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((bytesRead = zis.read(buffer)) != -1) {
                    baos.write(buffer, 0, bytesRead);
                }
                String jsonContent = baos.toString(StandardCharsets.UTF_8);
                String entryName = entry.getName();
                if (entryName.endsWith(CONFIG_JSON)) {
                    SiteTemplateDatabind databindFromJson = JsonUtils.fromJsonString(jsonContent, SiteTemplateDatabind.class);
                    if (databindFromJson == null) continue;
                    key = entryName.substring(0, entryName.lastIndexOf(47));
                    SiteTemplateDatabind existing = (SiteTemplateDatabind)templateDatabindMap.get(key);
                    if (existing != null && existing.getPages() != null) {
                        databindFromJson.setPages(existing.getPages());
                    } else if (databindFromJson.getPages() == null) {
                        databindFromJson.setPages(new ArrayList<LayoutModel>());
                    }
                    templateDatabindMap.put(key, databindFromJson);
                    continue;
                }
                if (entryName.endsWith(NAVIGATION_JSON)) {
                    List<NodeDefinition> nodeDefinitions = JsonUtils.fromJsonString(jsonContent, new TypeReference<List<NodeDefinition>>(this){});
                    if (nodeDefinitions == null) continue;
                    key = entryName.substring(0, entryName.lastIndexOf(47));
                    databind = templateDatabindMap.computeIfAbsent(key, k -> {
                        SiteTemplateDatabind st = new SiteTemplateDatabind();
                        st.setPages(new ArrayList<LayoutModel>());
                        return st;
                    });
                    databind.setNodeDefinitions(nodeDefinitions);
                    continue;
                }
                if (!entryName.matches(".+/pages/.+\\.json$") || (page = JsonUtils.fromJsonString(jsonContent, LayoutModel.class)) == null) continue;
                key = entryName.substring(0, entryName.indexOf("/pages/"));
                databind = templateDatabindMap.computeIfAbsent(key, k -> {
                    SiteTemplateDatabind st = new SiteTemplateDatabind();
                    st.setPages(new ArrayList<LayoutModel>());
                    return st;
                });
                if (databind.getPages() == null) {
                    databind.setPages(new ArrayList<LayoutModel>());
                }
                databind.getPages().add(page);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error reading zip file", e);
        }
        return templateDatabindMap;
    }

    private void saveIllustration(long pageTemplateId, byte[] illustrationBytes) {
        File tempFile = null;
        try {
            tempFile = DatabindUtils.getIllustrationFile(illustrationBytes);
            String uploadId = "SiteTemplateIllustration" + RANDOM.nextLong();
            UploadResource uploadResource = new UploadResource(uploadId);
            uploadResource.setFileName(tempFile.getName());
            uploadResource.setMimeType("image/png");
            uploadResource.setStatus(1);
            uploadResource.setStoreLocation(tempFile.getPath());
            this.attachmentService.deleteAttachments("pageTemplate", String.valueOf(pageTemplateId));
            UploadedAttachmentDetail uploadedAttachmentDetail = new UploadedAttachmentDetail(uploadResource);
            this.attachmentService.saveAttachment(uploadedAttachmentDetail, "siteTemplate", String.valueOf(pageTemplateId), null, this.getSuperUserIdentityId());
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Error while saving illustration as attachment for site template '%s'", pageTemplateId), e);
        }
        finally {
            if (tempFile != null) {
                try {
                    Files.delete(tempFile.toPath());
                }
                catch (IOException e) {
                    tempFile.deleteOnExit();
                }
            }
        }
    }

    private void saveNames(SiteTemplateDatabind siteTemplateDatabind, SiteTemplate siteTemplate) {
        this.translationService.saveTranslationLabels("siteTemplate", siteTemplate.getId(), "title", siteTemplateDatabind.getNames().entrySet().stream().collect(Collectors.toMap(entry -> Locale.forLanguageTag((String)entry.getKey()), Map.Entry::getValue)));
    }

    private void saveDescriptions(SiteTemplateDatabind siteTemplateDatabind, SiteTemplate siteTemplate) {
        this.translationService.saveTranslationLabels("siteTemplate", siteTemplate.getId(), "description", siteTemplateDatabind.getDescriptions().entrySet().stream().collect(Collectors.toMap(entry -> Locale.forLanguageTag((String)entry.getKey()), Map.Entry::getValue)));
    }

    private void processSiteTemplate(SiteTemplateDatabind siteTemplateDatabind, String username) {
        List<NodeDefinition> nodeDefinitions;
        NodeContext parentNode;
        SiteTemplate siteTemplate = new SiteTemplate();
        siteTemplate.setName(siteTemplateDatabind.getNames().get("en"));
        siteTemplate.setDescription(siteTemplateDatabind.getDescriptions().get("en"));
        siteTemplate.setLayout(SiteTemplateDatabindPlugin.generateLayoutName(siteTemplate.getName()));
        siteTemplate.setIcon(siteTemplateDatabind.getIcon());
        siteTemplate.setSystem(false);
        PortalConfig portalConfig = siteTemplateDatabind.getSiteDefinition().getLayout().toSite();
        portalConfig.setName(siteTemplateDatabind.getSiteDefinition().getName());
        portalConfig.setType(siteTemplateDatabind.getSiteDefinition().getType());
        PortalConfig existSite = this.layoutService.getPortalConfig(portalConfig.getType(), portalConfig.getName());
        if (existSite == null) {
            this.layoutService.create(portalConfig);
            portalConfig = this.layoutService.getPortalConfig(portalConfig.getType(), portalConfig.getName());
        } else {
            portalConfig = existSite;
        }
        if (CollectionUtils.isNotEmpty(siteTemplateDatabind.getPages())) {
            for (LayoutModel layoutModel : siteTemplateDatabind.getPages()) {
                DatabindUtils.saveAppBackgroundImages(portalConfig.getId(), layoutModel, this.attachmentService, this.getSuperUserIdentityId());
                Page page = layoutModel.toPage();
                page.setOwnerType(layoutModel.getOwnerType());
                page.setOwnerId(layoutModel.getOwnerId());
                page.setName(layoutModel.getName());
                page.setType(layoutModel.getType());
                page.setEditPermission(layoutModel.getEditPermission());
                page.setAccessPermissions(layoutModel.getAccessPermissions());
                page.setLink(layoutModel.getLink());
                page.setShowMaxWindow(Boolean.valueOf(false));
                page.setHideSharedLayout(false);
                this.layoutService.save(new PageContext(page.getPageKey(), Utils.toPageState((Page)page)));
                this.pageLayoutService.updatePageLayout(page.getPageKey().format(), page, true, username);
            }
        }
        if ((parentNode = this.navigationService.loadNode(portalConfig.getSiteKey())) == null) {
            this.navigationService.saveNavigation(new NavigationContext(new SiteKey(portalConfig.getType(), portalConfig.getName()), new NavigationState(Integer.valueOf(1))));
            parentNode = this.navigationService.loadNode(portalConfig.getSiteKey());
        }
        if (CollectionUtils.isNotEmpty(nodeDefinitions = siteTemplateDatabind.getNodeDefinitions())) {
            NodeDefinition targetParentNode = nodeDefinitions.getFirst();
            NavigationUpdateModel navigationUpdateModel = new NavigationUpdateModel();
            navigationUpdateModel.setNodeLabel(targetParentNode.getName());
            navigationUpdateModel.setPageRef(this.getPageKey(portalConfig.getSiteKey(), targetParentNode));
            navigationUpdateModel.setVisible(targetParentNode.getVisibility().equals((Object)Visibility.DISPLAYED));
            navigationUpdateModel.setScheduled(false);
            navigationUpdateModel.setIcon(targetParentNode.getIcon());
            targetParentNode.setLabels(targetParentNode.getLabels());
            this.navigationLayoutService.updateNode(Long.parseLong(parentNode.getId()), navigationUpdateModel, username);
            parentNode.getNodes().forEach(node -> this.navigationLayoutService.deleteNode(Long.parseLong(node.getId())));
            this.createNodesRecursively(nodeDefinitions, parentNode.getId(), portalConfig.getSiteKey(), username);
        }
        SiteTemplate createdSiteTemplate = this.siteTemplateService.createSiteTemplate(siteTemplate, portalConfig.getSiteKey(), username, true);
        this.saveNames(siteTemplateDatabind, createdSiteTemplate);
        this.saveDescriptions(siteTemplateDatabind, createdSiteTemplate);
        if (siteTemplateDatabind.getIllustration() != null) {
            this.saveIllustration(createdSiteTemplate.getId(), Base64.decodeBase64((String)siteTemplateDatabind.getIllustration()));
        }
    }

    private long getSuperUserIdentityId() {
        if (this.superUserIdentityId == 0L) {
            this.superUserIdentityId = Long.parseLong(this.identityManager.getOrCreateUserIdentity(this.userAcl.getSuperUser()).getId());
        }
        return this.superUserIdentityId;
    }

    private static String generateLayoutName(String name) {
        String transformed = name.toLowerCase().chars().mapToObj(c -> String.valueOf((char)(c % 25 + 97))).collect(Collectors.joining());
        int randomNumber = ThreadLocalRandom.current().nextInt(1000);
        return transformed + randomNumber;
    }

    private void writeToZip(ZipOutputStream zipOutputStream, String filePath, String content) throws IOException {
        ZipEntry entry = new ZipEntry(filePath);
        zipOutputStream.putNextEntry(entry);
        zipOutputStream.write(content.getBytes(StandardCharsets.UTF_8));
        zipOutputStream.closeEntry();
    }

    private Page toPage(PageContext pageContext) {
        Page page = this.layoutService.getPage(pageContext.getKey());
        page.resetStorage();
        return page;
    }

    private List<NodeDefinition> buildNodeDefinitions(SiteKey siteKey, String username) {
        NavigationContext navigationContext = this.navigationService.loadNavigation(siteKey);
        NodeContext rootNode = this.navigationService.loadNode(NodeModel.SELF_MODEL, navigationContext, Scope.ALL, null);
        if (rootNode == null || rootNode.getNodeCount() == 0) {
            return Collections.emptyList();
        }
        ArrayList<NodeDefinition> nodeDefinitions = new ArrayList<NodeDefinition>();
        Collection<NodeContext<?>> children = this.getChildren(rootNode);
        for (NodeContext<?> child : children) {
            nodeDefinitions.add(this.buildNodeDefinitionRecursively(child, username));
        }
        return nodeDefinitions;
    }

    private NodeDefinition buildNodeDefinitionRecursively(NodeContext<?> nodeContext, String username) {
        NodeState state = nodeContext.getData().getState();
        NodeDefinition def = new NodeDefinition();
        def.setName(nodeContext.getName());
        def.setIcon(state.getIcon());
        def.setVisibility(state.getVisibility());
        def.setPageReference(state.getPageRef() != null ? state.getPageRef().format() : null);
        NodeLabel nodeLabel = this.navigationLayoutService.getNodeLabels(Long.parseLong(nodeContext.getId()), username);
        def.setLabels(nodeLabel.getLabels());
        Collection<NodeContext<?>> children = this.getChildren(nodeContext);
        for (NodeContext<?> child : children) {
            def.getChildren().add(this.buildNodeDefinitionRecursively(child, username));
        }
        return def;
    }

    private Collection<NodeContext<?>> getChildren(NodeContext<?> node) {
        Collection rawNodes = node.getNodes();
        if (rawNodes == null) {
            return Collections.emptyList();
        }
        return rawNodes;
    }

    private void createNodesRecursively(List<NodeDefinition> nodeDefinitions, String parentId, SiteKey siteKey, String username) {
        String previousNodeId = null;
        for (NodeDefinition nodeDefinition : nodeDefinitions) {
            NavigationCreateModel model = new NavigationCreateModel(parentId != null ? Long.valueOf(Long.parseLong(parentId)) : null, previousNodeId != null ? Long.valueOf(Long.parseLong(previousNodeId)) : null, nodeDefinition.getName(), nodeDefinition.getName(), nodeDefinition.getVisibility().equals((Object)Visibility.DISPLAYED), false, false, null, null, this.getPageKey(siteKey, nodeDefinition), null, false, nodeDefinition.getIcon(), nodeDefinition.getLabels());
            NodeData nodeData = null;
            if (!StringUtils.contains((CharSequence)nodeDefinition.getName(), (CharSequence)"_draft_")) {
                nodeData = this.navigationLayoutService.createNode(model, username);
            }
            String string = previousNodeId = nodeData != null ? nodeData.getId() : null;
            List<NodeDefinition> children = nodeDefinition.getChildren();
            if (children == null || children.isEmpty()) continue;
            this.createNodesRecursively(children, nodeData != null ? nodeData.getId() : null, siteKey, username);
        }
    }

    private String getPageKey(SiteKey siteKey, NodeDefinition nodeDefinition) {
        int lastIndex;
        String pageRef = nodeDefinition.getPageReference();
        String pageName = StringUtils.isNotBlank((CharSequence)pageRef) ? ((lastIndex = pageRef.lastIndexOf("::")) != -1 ? pageRef.substring(lastIndex + 2) : pageRef) : nodeDefinition.getName();
        PageKey pageKey = new PageKey(siteKey, pageName);
        String formattedKey = pageKey.format();
        if (StringUtils.isBlank((CharSequence)formattedKey)) {
            return null;
        }
        PageContext pageContext = this.layoutService.getPageContext(PageKey.parse((String)formattedKey));
        return pageContext != null ? pageContext.getKey().format() : null;
    }

    static {
        SiteTemplateDatabindPlugin.ajc$preClinit();
        LOG = ExoLogger.getLogger(SiteTemplateDatabindPlugin.class);
        RANDOM = new Random();
    }

    static final /* synthetic */ List importSiteTemplates_aroundBody0(SiteTemplateDatabindPlugin ajc$this, File zipFile, String username, JoinPoint joinPoint) {
        Map<String, SiteTemplateDatabind> templates = ajc$this.extractTemplates(zipFile);
        ArrayList<String> processedPageTemplates = new ArrayList<String>();
        for (Map.Entry<String, SiteTemplateDatabind> entry : templates.entrySet()) {
            SiteTemplateDatabind siteTemplate = entry.getValue();
            ajc$this.processSiteTemplate(siteTemplate, username);
            processedPageTemplates.add(siteTemplate.getSiteDefinition().getName());
        }
        return processedPageTemplates;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SiteTemplateDatabindPlugin.java", SiteTemplateDatabindPlugin.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "importSiteTemplates", "io.meeds.layout.plugin.SiteTemplateDatabindPlugin", "java.io.File:java.lang.String", "zipFile:username", "", "java.util.List"), 274);
    }
}

