/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import com.fasterxml.classmate.ResolvedType;
import jakarta.persistence.AttributeConverter;
import jakarta.persistence.EnumType;
import jakarta.persistence.TemporalType;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.Incubating;
import org.hibernate.Internal;
import org.hibernate.MappingException;
import org.hibernate.TimeZoneStorageStrategy;
import org.hibernate.annotations.SoftDelete;
import org.hibernate.annotations.SoftDeleteType;
import org.hibernate.annotations.TimeZoneStorageType;
import org.hibernate.boot.model.TypeDefinition;
import org.hibernate.boot.model.convert.internal.AutoApplicableConverterDescriptorBypassedImpl;
import org.hibernate.boot.model.convert.internal.ClassBasedConverterDescriptor;
import org.hibernate.boot.model.convert.internal.InstanceBasedConverterDescriptor;
import org.hibernate.boot.model.convert.spi.AutoApplicableConverterDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.convert.spi.JpaAttributeConverterCreationContext;
import org.hibernate.boot.model.process.internal.InferredBasicValueResolution;
import org.hibernate.boot.model.process.internal.InferredBasicValueResolver;
import org.hibernate.boot.model.process.internal.NamedBasicTypeResolution;
import org.hibernate.boot.model.process.internal.NamedConverterResolution;
import org.hibernate.boot.model.process.internal.UserTypeResolution;
import org.hibernate.boot.model.process.internal.VersionResolution;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.AggregateColumn;
import org.hibernate.mapping.CheckConstraint;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.MappingHelper;
import org.hibernate.mapping.Resolvable;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.resource.beans.internal.FallbackBeanInstanceProducer;
import org.hibernate.resource.beans.spi.BeanInstanceProducer;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.type.BasicType;
import org.hibernate.type.CustomType;
import org.hibernate.type.NumericBooleanConverter;
import org.hibernate.type.TrueFalseConverter;
import org.hibernate.type.Type;
import org.hibernate.type.WrapperArrayHandling;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.converter.spi.JpaAttributeConverter;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.descriptor.java.spi.JsonJavaType;
import org.hibernate.type.descriptor.java.spi.RegistryHelper;
import org.hibernate.type.descriptor.java.spi.XmlJavaType;
import org.hibernate.type.descriptor.jdbc.BooleanJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.type.spi.TypeConfigurationAware;
import org.hibernate.usertype.DynamicParameterizedType;
import org.hibernate.usertype.UserType;

public class BasicValue
extends SimpleValue
implements JdbcTypeIndicators,
Resolvable,
JpaAttributeConverterCreationContext {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(BasicValue.class);
    private String explicitTypeName;
    private Map<String, String> explicitLocalTypeParams;
    private Function<TypeConfiguration, BasicJavaType> explicitJavaTypeAccess;
    private Function<TypeConfiguration, JdbcType> explicitJdbcTypeAccess;
    private Function<TypeConfiguration, MutabilityPlan> explicitMutabilityPlanAccess;
    private Function<TypeConfiguration, java.lang.reflect.Type> implicitJavaTypeAccess;
    private EnumType enumerationStyle;
    private TemporalType temporalPrecision;
    private TimeZoneStorageType timeZoneStorageType;
    private boolean isSoftDelete;
    private SoftDeleteType softDeleteStrategy;
    private java.lang.reflect.Type resolvedJavaType;
    private String ownerName;
    private String propertyName;
    private AggregateColumn aggregateColumn;
    private Resolution<?> resolution;
    private Integer jdbcTypeCode;
    private static int COUNTER;

    public BasicValue(MetadataBuildingContext buildingContext) {
        this(buildingContext, null);
    }

    public BasicValue(MetadataBuildingContext buildingContext, Table table) {
        super(buildingContext, table);
        buildingContext.getMetadataCollector().registerValueMappingResolver(this::resolve);
    }

    public BasicValue(BasicValue original) {
        super(original);
        this.explicitTypeName = original.explicitTypeName;
        this.explicitLocalTypeParams = original.explicitLocalTypeParams == null ? null : new HashMap<String, String>(original.explicitLocalTypeParams);
        this.explicitJavaTypeAccess = original.explicitJavaTypeAccess;
        this.explicitJdbcTypeAccess = original.explicitJdbcTypeAccess;
        this.explicitMutabilityPlanAccess = original.explicitMutabilityPlanAccess;
        this.implicitJavaTypeAccess = original.implicitJavaTypeAccess;
        this.enumerationStyle = original.enumerationStyle;
        this.temporalPrecision = original.temporalPrecision;
        this.timeZoneStorageType = original.timeZoneStorageType;
        this.resolvedJavaType = original.resolvedJavaType;
        this.ownerName = original.ownerName;
        this.propertyName = original.propertyName;
    }

    @Override
    public BasicValue copy() {
        return new BasicValue(this);
    }

    public boolean isSoftDelete() {
        return this.isSoftDelete;
    }

    public SoftDeleteType getSoftDeleteStrategy() {
        return this.softDeleteStrategy;
    }

    public void makeSoftDelete(SoftDeleteType strategy) {
        this.isSoftDelete = true;
        this.softDeleteStrategy = strategy;
    }

    @Override
    public void setTypeUsingReflection(String className, String propertyName) throws MappingException {
        if (this.resolution != null) {
            throw new IllegalStateException("BasicValue already resolved");
        }
        this.ownerName = className;
        this.propertyName = propertyName;
        super.setTypeUsingReflection(className, propertyName);
    }

    public void setEnumerationStyle(EnumType enumerationStyle) {
        this.enumerationStyle = enumerationStyle;
    }

    public EnumType getEnumerationStyle() {
        return this.enumerationStyle;
    }

    public TimeZoneStorageType getTimeZoneStorageType() {
        return this.timeZoneStorageType;
    }

    public void setTimeZoneStorageType(TimeZoneStorageType timeZoneStorageType) {
        this.timeZoneStorageType = timeZoneStorageType;
    }

    @Override
    public void setJpaAttributeConverterDescriptor(ConverterDescriptor descriptor) {
        this.setAttributeConverterDescriptor(descriptor);
        super.setJpaAttributeConverterDescriptor(descriptor);
    }

    public void setExplicitJavaTypeAccess(Function<TypeConfiguration, BasicJavaType> explicitJavaTypeAccess) {
        this.explicitJavaTypeAccess = explicitJavaTypeAccess;
    }

    public void setExplicitJdbcTypeAccess(Function<TypeConfiguration, JdbcType> jdbcTypeAccess) {
        this.explicitJdbcTypeAccess = jdbcTypeAccess;
    }

    public void setExplicitMutabilityPlanAccess(Function<TypeConfiguration, MutabilityPlan> explicitMutabilityPlanAccess) {
        this.explicitMutabilityPlanAccess = explicitMutabilityPlanAccess;
    }

    public void setImplicitJavaTypeAccess(Function<TypeConfiguration, java.lang.reflect.Type> implicitJavaTypeAccess) {
        this.implicitJavaTypeAccess = implicitJavaTypeAccess;
    }

    public Selectable getColumn() {
        if (this.getColumnSpan() == 0) {
            return null;
        }
        return this.getColumn(0);
    }

    public java.lang.reflect.Type getResolvedJavaType() {
        return this.resolvedJavaType;
    }

    @Override
    public long getColumnLength() {
        Selectable selectable = this.getColumn();
        if (selectable instanceof Column) {
            Long length = ((Column)selectable).getLength();
            return length == null ? -1L : length;
        }
        return -1L;
    }

    @Override
    public int getColumnPrecision() {
        Selectable selectable = this.getColumn();
        if (selectable instanceof Column) {
            Column column = (Column)selectable;
            Integer temporalPrecision = column.getTemporalPrecision();
            if (temporalPrecision != null) {
                return temporalPrecision;
            }
            Integer precision = column.getPrecision();
            return precision == null ? -1 : precision;
        }
        return -1;
    }

    @Override
    public int getColumnScale() {
        Selectable selectable = this.getColumn();
        if (selectable instanceof Column) {
            Integer scale = ((Column)selectable).getScale();
            return scale == null ? -1 : scale;
        }
        return -1;
    }

    @Override
    public void addColumn(Column incomingColumn) {
        super.addColumn(incomingColumn);
        this.checkSelectable(incomingColumn);
    }

    @Override
    public void copyTypeFrom(SimpleValue sourceValue) {
        super.copyTypeFrom(sourceValue);
        if (sourceValue instanceof BasicValue) {
            BasicValue basicValue = (BasicValue)sourceValue;
            this.resolution = basicValue.resolution;
            this.implicitJavaTypeAccess = typeConfiguration -> basicValue.implicitJavaTypeAccess.apply((TypeConfiguration)typeConfiguration);
        }
    }

    private void checkSelectable(Selectable incomingColumn) {
        if (incomingColumn == null) {
            throw new IllegalArgumentException("Incoming column was null");
        }
        Selectable column = this.getColumn();
        if (column == incomingColumn || column.getText().equals(incomingColumn.getText())) {
            log.debugf("Skipping column re-registration: %s.%s", this.getTable().getName(), column.getText());
        }
    }

    @Override
    public void addColumn(Column incomingColumn, boolean isInsertable, boolean isUpdatable) {
        super.addColumn(incomingColumn, isInsertable, isUpdatable);
        this.checkSelectable(incomingColumn);
    }

    @Override
    public void addFormula(Formula formula) {
        super.addFormula(formula);
        this.checkSelectable(formula);
    }

    @Override
    public Type getType() throws MappingException {
        this.resolve();
        assert (this.getResolution() != null);
        return this.getResolution().getLegacyResolvedBasicType();
    }

    public Resolution<?> getResolution() {
        return this.resolution;
    }

    @Override
    public boolean resolve(MetadataBuildingContext buildingContext) {
        this.resolve();
        return true;
    }

    @Override
    public Resolution<?> resolve() {
        Size size;
        if (this.resolution != null) {
            return this.resolution;
        }
        this.resolution = this.buildResolution();
        if (this.resolution == null) {
            throw new IllegalStateException("Unable to resolve BasicValue : " + String.valueOf(this));
        }
        Selectable selectable = this.getColumn();
        if (selectable instanceof Column) {
            Column column = (Column)selectable;
            this.resolveColumn(column, this.getDialect());
            size = column.calculateColumnSize(this.getDialect(), this.getBuildingContext().getMetadataCollector());
        } else {
            size = Size.nil();
        }
        this.resolution.getJdbcType().addAuxiliaryDatabaseObjects(this.resolution.getRelationalJavaType(), size, this.getBuildingContext().getMetadataCollector().getDatabase(), this);
        return this.resolution;
    }

    @Override
    public String getExtraCreateTableInfo() {
        return this.resolution.getJdbcType().getExtraCreateTableInfo(this.resolution.getRelationalJavaType(), this.getColumn().getText(), this.getTable().getName(), this.getBuildingContext().getMetadataCollector().getDatabase());
    }

    @Override
    public Dialect getDialect() {
        return this.getMetadata().getDatabase().getDialect();
    }

    private void resolveColumn(Column column, Dialect dialect) {
        String checkCondition;
        if (column.getSqlTypeCode() == null) {
            column.setSqlTypeCode(this.resolution.getJdbcType().getDdlTypeCode());
        }
        if (dialect.supportsColumnCheck() && (checkCondition = this.resolution.getLegacyResolvedBasicType().getCheckCondition(column.getQuotedName(dialect), dialect)) != null) {
            column.addCheckConstraint(new CheckConstraint(checkCondition));
        }
    }

    public AggregateColumn getAggregateColumn() {
        return this.aggregateColumn;
    }

    public void setAggregateColumn(AggregateColumn aggregateColumn) {
        this.aggregateColumn = aggregateColumn;
    }

    public SelectablePath createSelectablePath(String selectableName) {
        if (this.aggregateColumn != null) {
            return this.aggregateColumn.getSelectablePath().append(selectableName);
        }
        return new SelectablePath(selectableName);
    }

    protected Resolution<?> buildResolution() {
        Properties typeParameters = this.getTypeParameters();
        if (typeParameters != null && Boolean.parseBoolean(typeParameters.getProperty("org.hibernate.type.ParameterType.dynamic")) && typeParameters.get("org.hibernate.type.ParameterType") == null) {
            this.createParameterImpl();
        }
        if (this.explicitTypeName != null) {
            return BasicValue.interpretExplicitlyNamedType(this.explicitTypeName, this.explicitJavaTypeAccess, this.explicitJdbcTypeAccess, this.explicitMutabilityPlanAccess, this.getAttributeConverterDescriptor(), typeParameters, this::setTypeParameters, this, this.getBuildingContext());
        }
        if (this.isVersion()) {
            return VersionResolution.from(this.implicitJavaTypeAccess, this.timeZoneStorageType, this.getBuildingContext());
        }
        BasicJavaType<?> explicitJavaType = this.getExplicitJavaType();
        JavaType<?> javaType = this.determineJavaType(explicitJavaType);
        ConverterDescriptor converterDescriptor = this.getConverterDescriptor(javaType);
        return converterDescriptor != null ? this.converterResolution(javaType, converterDescriptor) : this.resolution(explicitJavaType, javaType);
    }

    private BasicJavaType<?> getExplicitJavaType() {
        return this.explicitJavaTypeAccess == null ? null : this.explicitJavaTypeAccess.apply(this.getTypeConfiguration());
    }

    private ConverterDescriptor getConverterDescriptor(JavaType<?> javaType) {
        ConverterDescriptor converterDescriptor = this.getAttributeConverterDescriptor();
        if (this.isSoftDelete()) {
            assert (converterDescriptor != null);
            ConverterDescriptor softDeleteConverterDescriptor = this.getSoftDeleteConverterDescriptor(converterDescriptor, javaType);
            return this.getSoftDeleteStrategy() == SoftDeleteType.ACTIVE ? new ReversedConverterDescriptor(softDeleteConverterDescriptor) : softDeleteConverterDescriptor;
        }
        return converterDescriptor;
    }

    private ConverterDescriptor getSoftDeleteConverterDescriptor(ConverterDescriptor attributeConverterDescriptor, JavaType<?> javaType) {
        boolean conversionWasUnspecified = SoftDelete.UnspecifiedConversion.class.equals(attributeConverterDescriptor.getAttributeConverterClass());
        if (conversionWasUnspecified) {
            JdbcType jdbcType = BooleanJdbcType.INSTANCE.resolveIndicatedType(this, javaType);
            if (jdbcType.isNumber()) {
                return new InstanceBasedConverterDescriptor(NumericBooleanConverter.INSTANCE, this.getBuildingContext().getBootstrapContext().getClassmateContext());
            }
            if (jdbcType.isString()) {
                return new InstanceBasedConverterDescriptor(TrueFalseConverter.INSTANCE, this.getBuildingContext().getBootstrapContext().getClassmateContext());
            }
            return new InstanceBasedConverterDescriptor(PassThruSoftDeleteConverter.INSTANCE, this.getBuildingContext().getBootstrapContext().getClassmateContext());
        }
        return attributeConverterDescriptor;
    }

    private Resolution<?> resolution(BasicJavaType explicitJavaType, JavaType<?> javaType) {
        TypeDefinition autoAppliedTypeDef;
        JavaType<?> basicJavaType;
        JdbcType jdbcType;
        if (this.explicitJdbcTypeAccess != null) {
            TypeConfiguration typeConfiguration = this.getTypeConfiguration();
            jdbcType = this.explicitJdbcTypeAccess.apply(typeConfiguration);
            basicJavaType = javaType == null && jdbcType != null ? jdbcType.getJdbcRecommendedJavaTypeMapping(null, null, typeConfiguration) : javaType;
        } else {
            jdbcType = null;
            basicJavaType = javaType;
        }
        if (basicJavaType == null) {
            throw new MappingException("Unable to determine JavaType to use : " + String.valueOf(this));
        }
        if (basicJavaType instanceof BasicJavaType && (!basicJavaType.getJavaTypeClass().isEnum() || this.enumerationStyle == null) && (autoAppliedTypeDef = this.getBuildingContext().getTypeDefinitionRegistry().resolveAutoApplied((BasicJavaType)basicJavaType)) != null) {
            log.debug("BasicValue resolution matched auto-applied type-definition");
            return autoAppliedTypeDef.resolve(this.getTypeParameters(), null, this.getBuildingContext(), this);
        }
        return InferredBasicValueResolver.from(explicitJavaType, jdbcType, this.resolvedJavaType, this::determineReflectedJavaType, this.explicitMutabilityPlanAccess, this, this.getTable(), this.getColumn(), this.ownerName, this.propertyName, this.getBuildingContext());
    }

    @Override
    public ManagedBeanRegistry getManagedBeanRegistry() {
        return this.getServiceRegistry().requireService(ManagedBeanRegistry.class);
    }

    private Resolution<?> converterResolution(JavaType<?> javaType, ConverterDescriptor attributeConverterDescriptor) {
        NamedConverterResolution converterResolution = NamedConverterResolution.from(attributeConverterDescriptor, this.explicitJavaTypeAccess, this.explicitJdbcTypeAccess, this.explicitMutabilityPlanAccess, this.resolvedJavaType, this, this, this.getBuildingContext());
        if (javaType instanceof BasicPluralJavaType && !attributeConverterDescriptor.getDomainValueResolvedType().getErasedType().isAssignableFrom(javaType.getJavaTypeClass())) {
            BasicType<?> registeredType;
            BasicType registeredElementType = converterResolution.getLegacyResolvedBasicType();
            Selectable column = this.getColumn();
            BasicType<?> basicType = registeredElementType == null ? null : (registeredType = ((BasicPluralJavaType)((Object)javaType)).resolveType(this.getTypeConfiguration(), this.getDialect(), registeredElementType, column instanceof ColumnTypeInformation ? (ColumnTypeInformation)((Object)column) : null, this));
            if (registeredType != null) {
                this.getTypeConfiguration().getBasicTypeRegistry().register(registeredType);
                return new InferredBasicValueResolution(registeredType, registeredType.getJavaTypeDescriptor(), registeredType.getJavaTypeDescriptor(), registeredType.getJdbcType(), registeredType, null);
            }
        }
        return converterResolution;
    }

    private JavaType<?> determineJavaType(JavaType<?> explicitJavaType) {
        JavaType<?> reflectedJtd;
        JavaType<?> javaType = explicitJavaType;
        if (javaType == null && (reflectedJtd = this.determineReflectedJavaType()) != null) {
            javaType = reflectedJtd;
        }
        return javaType;
    }

    private JavaType<?> determineReflectedJavaType() {
        TypeConfiguration typeConfiguration = this.getTypeConfiguration();
        java.lang.reflect.Type impliedJavaType = this.impliedJavaType(typeConfiguration);
        if (impliedJavaType == null) {
            return null;
        }
        this.resolvedJavaType = impliedJavaType;
        return this.javaType(typeConfiguration, impliedJavaType);
    }

    private java.lang.reflect.Type impliedJavaType(TypeConfiguration typeConfiguration) {
        if (this.resolvedJavaType != null) {
            return this.resolvedJavaType;
        }
        if (this.implicitJavaTypeAccess != null) {
            return this.implicitJavaTypeAccess.apply(typeConfiguration);
        }
        if (this.ownerName != null && this.propertyName != null) {
            return ReflectHelper.reflectedPropertyType(this.ownerName, this.propertyName, this.getServiceRegistry().requireService(ClassLoaderService.class));
        }
        return null;
    }

    private JavaType<Object> javaType(TypeConfiguration typeConfiguration, java.lang.reflect.Type impliedJavaType) {
        JavaType<Object> javaType = typeConfiguration.getJavaTypeRegistry().findDescriptor(impliedJavaType);
        return javaType == null ? this.specialJavaType(typeConfiguration, impliedJavaType) : javaType;
    }

    private JavaType<Object> specialJavaType(TypeConfiguration typeConfiguration, java.lang.reflect.Type impliedJavaType) {
        JavaTypeRegistry javaTypeRegistry = typeConfiguration.getJavaTypeRegistry();
        if (this.jdbcTypeCode != null) {
            switch (this.jdbcTypeCode) {
                case 3001: {
                    JsonJavaType<Object> jsonJavaType = new JsonJavaType<Object>(impliedJavaType, this.mutabilityPlan(typeConfiguration, impliedJavaType), typeConfiguration);
                    javaTypeRegistry.addDescriptor(jsonJavaType);
                    return jsonJavaType;
                }
                case 2009: {
                    XmlJavaType<Object> xmlJavaType = new XmlJavaType<Object>(impliedJavaType, this.mutabilityPlan(typeConfiguration, impliedJavaType), typeConfiguration);
                    javaTypeRegistry.addDescriptor(xmlJavaType);
                    return xmlJavaType;
                }
            }
        }
        return javaTypeRegistry.resolveDescriptor(impliedJavaType);
    }

    private MutabilityPlan<Object> mutabilityPlan(TypeConfiguration typeConfiguration, java.lang.reflect.Type impliedJavaType) {
        MutabilityPlan<Object> explicitMutabilityPlan = this.getExplicitMutabilityPlan();
        return explicitMutabilityPlan != null ? explicitMutabilityPlan : RegistryHelper.INSTANCE.determineMutabilityPlan(impliedJavaType, typeConfiguration);
    }

    private MutabilityPlan<Object> getExplicitMutabilityPlan() {
        return this.explicitMutabilityPlanAccess == null ? null : this.explicitMutabilityPlanAccess.apply(this.getTypeConfiguration());
    }

    private static Resolution<?> interpretExplicitlyNamedType(String name, Function<TypeConfiguration, BasicJavaType> explicitJtdAccess, Function<TypeConfiguration, JdbcType> explicitStdAccess, Function<TypeConfiguration, MutabilityPlan> explicitMutabilityPlanAccess, ConverterDescriptor converterDescriptor, Map<Object, Object> localTypeParams, Consumer<Properties> combinedParameterConsumer, JdbcTypeIndicators stdIndicators, MetadataBuildingContext context) {
        StandardServiceRegistry serviceRegistry = context.getBootstrapContext().getServiceRegistry();
        final ManagedBeanRegistry managedBeanRegistry = serviceRegistry.requireService(ManagedBeanRegistry.class);
        final TypeConfiguration typeConfiguration = context.getBootstrapContext().getTypeConfiguration();
        JpaAttributeConverterCreationContext converterCreationContext = new JpaAttributeConverterCreationContext(){

            @Override
            public ManagedBeanRegistry getManagedBeanRegistry() {
                return managedBeanRegistry;
            }

            @Override
            public TypeConfiguration getTypeConfiguration() {
                return typeConfiguration;
            }
        };
        if (name.startsWith("converted::")) {
            return NamedConverterResolution.from(name, explicitJtdAccess, explicitStdAccess, explicitMutabilityPlanAccess, stdIndicators, converterCreationContext, context);
        }
        if (name.startsWith("basicType")) {
            BasicType basicType = context.getBootstrapContext().resolveAdHocBasicType(name);
            return new NamedBasicTypeResolution(basicType.getJavaTypeDescriptor(), basicType, null, explicitMutabilityPlanAccess, context);
        }
        BasicType basicTypeByName = typeConfiguration.getBasicTypeRegistry().getRegisteredType(name);
        if (basicTypeByName != null) {
            JavaType domainJtd;
            BasicValueConverter valueConverter;
            if (converterDescriptor != null) {
                valueConverter = converterDescriptor.createJpaAttributeConverter(converterCreationContext);
                domainJtd = valueConverter.getDomainJavaType();
            } else {
                valueConverter = basicTypeByName.getValueConverter();
                domainJtd = basicTypeByName.getJavaTypeDescriptor();
            }
            return new NamedBasicTypeResolution(domainJtd, basicTypeByName, valueConverter, explicitMutabilityPlanAccess, context);
        }
        TypeDefinition typeDefinition = context.getTypeDefinitionRegistry().resolve(name);
        if (typeDefinition != null) {
            Resolution<?> resolution = typeDefinition.resolve(localTypeParams, explicitMutabilityPlanAccess != null ? explicitMutabilityPlanAccess.apply(typeConfiguration) : null, context, stdIndicators);
            combinedParameterConsumer.accept(resolution.getCombinedTypeParameters());
            return resolution;
        }
        ClassLoaderService cls = serviceRegistry.requireService(ClassLoaderService.class);
        try {
            Class typeNamedClass = cls.classForName(name);
            if (CollectionHelper.isEmpty(localTypeParams)) {
                TypeDefinition implicitDefinition = new TypeDefinition(name, typeNamedClass, null, null);
                context.getTypeDefinitionRegistry().register(implicitDefinition);
                return implicitDefinition.resolve(localTypeParams, explicitMutabilityPlanAccess != null ? explicitMutabilityPlanAccess.apply(typeConfiguration) : null, context, stdIndicators);
            }
            return TypeDefinition.createLocalResolution(name, typeNamedClass, localTypeParams, context);
        }
        catch (ClassLoadingException e) {
            log.debugf("Could not resolve type-name [%s] as Java type : %s", name, (Object)e);
            throw new MappingException("Could not resolve named type : " + name);
        }
    }

    @Override
    public EnumType getEnumeratedType() {
        return this.getEnumerationStyle();
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return this.resolveJdbcTypeCode(this.getBuildingContext().getPreferredSqlTypeCodeForBoolean());
    }

    @Override
    public int getPreferredSqlTypeCodeForDuration() {
        return this.resolveJdbcTypeCode(this.getBuildingContext().getPreferredSqlTypeCodeForDuration());
    }

    @Override
    public int getPreferredSqlTypeCodeForUuid() {
        return this.resolveJdbcTypeCode(this.getBuildingContext().getPreferredSqlTypeCodeForUuid());
    }

    @Override
    public int getPreferredSqlTypeCodeForInstant() {
        return this.resolveJdbcTypeCode(this.getBuildingContext().getPreferredSqlTypeCodeForInstant());
    }

    @Override
    public int getPreferredSqlTypeCodeForArray() {
        return this.resolveJdbcTypeCode(this.getBuildingContext().getPreferredSqlTypeCodeForArray());
    }

    @Override
    public int resolveJdbcTypeCode(int jdbcTypeCode) {
        return this.aggregateColumn == null ? jdbcTypeCode : this.getDialect().getAggregateSupport().aggregateComponentSqlTypeCode(this.aggregateColumn.getSqlTypeCode(this.getMetadata()), jdbcTypeCode);
    }

    @Override
    public TimeZoneStorageStrategy getDefaultTimeZoneStorageStrategy() {
        return BasicValue.timeZoneStorageStrategy(this.timeZoneStorageType, this.getBuildingContext());
    }

    @Internal
    public static TimeZoneStorageStrategy timeZoneStorageStrategy(TimeZoneStorageType timeZoneStorageType, MetadataBuildingContext buildingContext) {
        if (timeZoneStorageType != null) {
            switch (timeZoneStorageType) {
                case COLUMN: {
                    return TimeZoneStorageStrategy.COLUMN;
                }
                case NATIVE: {
                    return TimeZoneStorageStrategy.NATIVE;
                }
                case NORMALIZE: {
                    return TimeZoneStorageStrategy.NORMALIZE;
                }
                case NORMALIZE_UTC: {
                    return TimeZoneStorageStrategy.NORMALIZE_UTC;
                }
            }
        }
        return buildingContext.getBuildingOptions().getDefaultTimeZoneStorage();
    }

    public void setExplicitTypeParams(Map<String, String> explicitLocalTypeParams) {
        this.explicitLocalTypeParams = explicitLocalTypeParams;
    }

    public void setExplicitTypeName(String typeName) {
        this.explicitTypeName = typeName;
    }

    @Override
    public void setTypeName(String typeName) {
        if (StringHelper.isNotEmpty(typeName)) {
            if (typeName.startsWith("converted::")) {
                String converterClassName = typeName.substring("converted::".length());
                ClassLoaderService cls = this.getServiceRegistry().requireService(ClassLoaderService.class);
                try {
                    Class converterClass = cls.classForName(converterClassName);
                    this.setAttributeConverterDescriptor(new ClassBasedConverterDescriptor(converterClass, false, this.getBuildingContext().getBootstrapContext().getClassmateContext()));
                    return;
                }
                catch (Exception e) {
                    log.logBadHbmAttributeConverterType(typeName, e.getMessage());
                }
            } else {
                this.setExplicitTypeName(typeName);
            }
        }
        super.setTypeName(typeName);
    }

    public void setExplicitCustomType(Class<? extends UserType<?>> explicitCustomType) {
        if (explicitCustomType != null) {
            if (this.resolution != null) {
                throw new UnsupportedOperationException("Unsupported attempt to set an explicit-custom-type when value is already resolved");
            }
            this.resolution = new UserTypeResolution(new CustomType(this.getConfiguredUserTypeBean(explicitCustomType, this.getCustomTypeProperties()), this.getTypeConfiguration()), null, this.getCustomTypeProperties());
        }
    }

    private Properties getCustomTypeProperties() {
        Properties properties = new Properties();
        if (CollectionHelper.isNotEmpty(this.getTypeParameters())) {
            properties.putAll((Map<?, ?>)this.getTypeParameters());
        }
        if (CollectionHelper.isNotEmpty(this.explicitLocalTypeParams)) {
            properties.putAll(this.explicitLocalTypeParams);
        }
        return properties;
    }

    private UserType<?> getConfiguredUserTypeBean(Class<? extends UserType<?>> explicitCustomType, Properties properties) {
        UserType<?> typeInstance;
        UserType<?> userType = typeInstance = !this.getBuildingContext().getBuildingOptions().isAllowExtensionsInCdi() ? FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(explicitCustomType) : this.getUserTypeBean(explicitCustomType, properties).getBeanInstance();
        if (typeInstance instanceof TypeConfigurationAware) {
            ((TypeConfigurationAware)((Object)typeInstance)).setTypeConfiguration(this.getTypeConfiguration());
        }
        if (typeInstance instanceof DynamicParameterizedType && Boolean.parseBoolean(properties.getProperty("org.hibernate.type.ParameterType.dynamic")) && properties.get("org.hibernate.type.ParameterType") == null) {
            properties.put("org.hibernate.type.ParameterType", this.makeParameterImpl());
        }
        MappingHelper.injectParameters(typeInstance, properties);
        this.setTypeParameters(properties);
        return typeInstance;
    }

    private <T> ManagedBean<T> getUserTypeBean(Class<T> explicitCustomType, Properties properties) {
        BeanInstanceProducer producer = this.getBuildingContext().getBootstrapContext().getCustomTypeProducer();
        ManagedBeanRegistry registry = this.getServiceRegistry().requireService(ManagedBeanRegistry.class);
        if (CollectionHelper.isNotEmpty(properties)) {
            String name = explicitCustomType.getName() + COUNTER++;
            return registry.getBean(name, explicitCustomType, producer);
        }
        return registry.getBean(explicitCustomType, producer);
    }

    public void setTemporalPrecision(TemporalType temporalPrecision) {
        this.temporalPrecision = temporalPrecision;
    }

    @Override
    public TemporalType getTemporalPrecision() {
        return this.temporalPrecision;
    }

    @Override
    public boolean isPreferJavaTimeJdbcTypesEnabled() {
        return this.getBuildingContext().isPreferJavaTimeJdbcTypesEnabled();
    }

    @Override
    public boolean isPreferNativeEnumTypesEnabled() {
        return this.getBuildingContext().isPreferNativeEnumTypesEnabled();
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }

    @Internal
    public boolean isDisallowedWrapperArray() {
        return this.getBuildingContext().getBuildingOptions().getWrapperArrayHandling() == WrapperArrayHandling.DISALLOW && !this.isLob() && (this.explicitJavaTypeAccess == null || this.explicitJavaTypeAccess.apply(this.getTypeConfiguration()) == null) && this.isWrapperByteOrCharacterArray();
    }

    private boolean isWrapperByteOrCharacterArray() {
        Class<?> javaTypeClass = this.getResolution().getDomainJavaType().getJavaTypeClass();
        return javaTypeClass == Byte[].class || javaTypeClass == Character[].class;
    }

    @Incubating
    public void setExplicitJdbcTypeCode(Integer jdbcTypeCode) {
        this.jdbcTypeCode = jdbcTypeCode;
    }

    @Override
    public Integer getExplicitJdbcTypeCode() {
        return this.jdbcTypeCode == null ? this.getPreferredSqlTypeCodeForArray() : this.jdbcTypeCode.intValue();
    }

    public static interface Resolution<J> {
        public BasicType<J> getLegacyResolvedBasicType();

        default public Properties getCombinedTypeParameters() {
            return null;
        }

        public JdbcMapping getJdbcMapping();

        public JavaType<J> getDomainJavaType();

        public JavaType<?> getRelationalJavaType();

        public JdbcType getJdbcType();

        public BasicValueConverter<J, ?> getValueConverter();

        public MutabilityPlan<J> getMutabilityPlan();

        default public void updateResolution(BasicType<?> type) {
            throw new UnsupportedOperationException();
        }
    }

    private static class PassThruSoftDeleteConverter
    implements AttributeConverter<Boolean, Boolean> {
        private static final PassThruSoftDeleteConverter INSTANCE = new PassThruSoftDeleteConverter();

        private PassThruSoftDeleteConverter() {
        }

        public Boolean convertToDatabaseColumn(Boolean domainValue) {
            return domainValue;
        }

        public Boolean convertToEntityAttribute(Boolean relationalValue) {
            return relationalValue;
        }
    }

    private static class ReversedJpaAttributeConverter<R, B extends AttributeConverter<Boolean, R>>
    implements JpaAttributeConverter<Boolean, R>,
    AttributeConverter<Boolean, R>,
    ManagedBean<B> {
        private final JpaAttributeConverter<Boolean, R> underlyingJpaConverter;
        private final JavaType<ReversedJpaAttributeConverter<R, B>> converterJavaType;

        public ReversedJpaAttributeConverter(JpaAttributeConverter<Boolean, R> underlyingJpaConverter, JavaType<ReversedJpaAttributeConverter<R, B>> converterJavaType) {
            this.underlyingJpaConverter = underlyingJpaConverter;
            this.converterJavaType = converterJavaType;
        }

        @Override
        public Boolean toDomainValue(R relationalValue) {
            return (Boolean)this.underlyingJpaConverter.toDomainValue(relationalValue) == false;
        }

        @Override
        public R toRelationalValue(Boolean domainValue) {
            return this.underlyingJpaConverter.toRelationalValue(domainValue != null ? Boolean.valueOf(domainValue == false) : null);
        }

        public Boolean convertToEntityAttribute(R relationalValue) {
            return this.toDomainValue((Object)relationalValue);
        }

        public R convertToDatabaseColumn(Boolean domainValue) {
            return this.toRelationalValue(domainValue);
        }

        @Override
        public JavaType<Boolean> getDomainJavaType() {
            return this.underlyingJpaConverter.getDomainJavaType();
        }

        @Override
        public JavaType<R> getRelationalJavaType() {
            return this.underlyingJpaConverter.getRelationalJavaType();
        }

        @Override
        public JavaType<? extends AttributeConverter<Boolean, R>> getConverterJavaType() {
            return this.converterJavaType;
        }

        @Override
        public ManagedBean<? extends AttributeConverter<Boolean, R>> getConverterBean() {
            return this;
        }

        @Override
        public Class<B> getBeanClass() {
            return this.getClass();
        }

        @Override
        public B getBeanInstance() {
            return (B)this;
        }
    }

    private static class ReversedConverterDescriptor<R>
    implements ConverterDescriptor {
        private final ConverterDescriptor underlyingDescriptor;

        public ReversedConverterDescriptor(ConverterDescriptor underlyingDescriptor) {
            this.underlyingDescriptor = underlyingDescriptor;
        }

        public Class<? extends AttributeConverter<Boolean, R>> getAttributeConverterClass() {
            return this.getClass();
        }

        @Override
        public ResolvedType getDomainValueResolvedType() {
            return this.underlyingDescriptor.getDomainValueResolvedType();
        }

        @Override
        public ResolvedType getRelationalValueResolvedType() {
            return this.underlyingDescriptor.getRelationalValueResolvedType();
        }

        @Override
        public AutoApplicableConverterDescriptor getAutoApplyDescriptor() {
            return AutoApplicableConverterDescriptorBypassedImpl.INSTANCE;
        }

        public JpaAttributeConverter<Boolean, R> createJpaAttributeConverter(JpaAttributeConverterCreationContext context) {
            return new ReversedJpaAttributeConverter(this.underlyingDescriptor.createJpaAttributeConverter(context), context.getJavaTypeRegistry().getDescriptor((java.lang.reflect.Type)((Object)ReversedJpaAttributeConverter.class)));
        }
    }
}

