/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.service.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.task.dao.DAOHandler;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.dao.ProjectQuery;
import org.exoplatform.task.dao.TaskQuery;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.dto.StatusDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.storage.ProjectStorage;
import org.exoplatform.task.util.StorageUtil;

@Singleton
public class ProjectServiceImpl
implements ProjectService {
    private static final Log LOG = ExoLogger.getExoLogger(ProjectServiceImpl.class);
    public static final String PREFIX_CLONE = "Copy of ";
    @Inject
    private ProjectStorage projectStorage;
    @Inject
    StatusService statusService;
    @Inject
    TaskService taskService;
    @Inject
    DAOHandler daoHandler;
    private ListenerService listenerService;

    public ProjectServiceImpl() {
    }

    public ProjectServiceImpl(StatusService statusService, TaskService taskService, DAOHandler daoHandler, ProjectStorage projectStorage, ListenerService listenerService) {
        this.daoHandler = daoHandler;
        this.statusService = statusService;
        this.taskService = taskService;
        this.projectStorage = projectStorage;
        this.listenerService = listenerService;
    }

    @Override
    public ProjectDto createProject(ProjectDto project) {
        ProjectDto proj = this.projectStorage.createProject(project);
        return proj;
    }

    @Override
    public ProjectDto createProject(ProjectDto project, long parentId) throws EntityNotFoundException {
        ProjectDto parentProject = this.projectStorage.getProject(parentId);
        if (parentProject != null) {
            project.setParent(parentProject);
            project.setParticipator(new HashSet<String>(parentProject.getParticipator()));
            project.setManager(new HashSet<String>(parentProject.getManager()));
            project.setLastModifiedDate(System.currentTimeMillis());
            project = this.createProject(project);
            List<StatusDto> prSt = this.statusService.getStatuses(parentProject.getId());
            for (StatusDto st : prSt) {
                this.statusService.createStatus(project, st.getName());
            }
            return project;
        }
        LOG.info((Object)("Can not find project for parent with ID: " + parentId));
        throw new EntityNotFoundException(parentId, (Class<?>)ProjectDto.class);
    }

    @Override
    public ProjectDto updateProject(ProjectDto proj) {
        proj.setLastModifiedDate(System.currentTimeMillis());
        return this.projectStorage.updateProject(proj);
    }

    @Override
    public void updateProjectNoReturn(ProjectDto proj) {
        proj.setLastModifiedDate(System.currentTimeMillis());
        this.projectStorage.updateProjectNoReturn(proj);
    }

    @Override
    public void removeProject(long id, boolean deleteChild) throws EntityNotFoundException {
        ProjectDto project = this.getProject(id);
        if (project == null) {
            throw new EntityNotFoundException(id, (Class<?>)ProjectDto.class);
        }
        this.projectStorage.removeProject(id, deleteChild);
    }

    @Override
    public ProjectDto cloneProject(long id, boolean cloneTask) throws Exception {
        Set<String> participators;
        ProjectDto project = this.getProject(id);
        ProjectDto newProject = project.clone(cloneTask);
        Set<String> managers = this.getManager(id);
        if (managers != null && !managers.isEmpty()) {
            newProject.setManager(managers);
        }
        if ((participators = this.getParticipator(id)) != null && !participators.isEmpty()) {
            newProject.setParticipator(participators);
        }
        newProject.setId(0L);
        newProject.setName(PREFIX_CLONE + newProject.getName());
        newProject = this.createProject(newProject);
        List<StatusDto> statuses = this.statusService.getStatuses(id);
        if (statuses != null) {
            for (StatusDto st : statuses) {
                StatusDto s = this.statusService.createStatus(newProject, st.getName());
                if (!cloneTask) continue;
                TaskQuery taskQuery = new TaskQuery();
                taskQuery.setStatus(StorageUtil.getStatusEntityById(st.getId()));
                for (TaskDto t : this.taskService.findTasks(taskQuery, 0, -1)) {
                    TaskDto newTask = t.clone();
                    newTask.setId(0L);
                    newTask.setStatus(s);
                    newTask.setCoworker(this.taskService.getCoworker(t.getId()));
                    newTask.setTitle(PREFIX_CLONE + newTask.getTitle());
                    this.taskService.createTask(newTask);
                }
            }
        }
        return newProject;
    }

    @Override
    public ProjectDto getProject(Long id) throws EntityNotFoundException {
        ProjectDto project = this.projectStorage.getProject(id);
        if (project == null) {
            throw new EntityNotFoundException((long)id, (Class<?>)ProjectDto.class);
        }
        return project;
    }

    @Override
    public List<ProjectDto> getSubProjects(long parentId, int offset, int limit) {
        try {
            ProjectDto parent = this.getProject(parentId);
            return this.projectStorage.getSubProjects(parentId, offset, limit);
        }
        catch (Exception ex) {
            return new ArrayList<ProjectDto>();
        }
    }

    @Override
    public List<ProjectDto> findProjects(ProjectQuery query, int offset, int limit) {
        return this.projectStorage.findProjects(query, offset, limit);
    }

    @Override
    public int countProjects(ProjectQuery query) {
        return this.projectStorage.countProjects(query);
    }

    @Override
    public List<ProjectDto> findProjects(List<String> memberships, String keyword, OrderBy order, int offset, int limit) {
        return this.projectStorage.findProjects(memberships, keyword, order, offset, limit);
    }

    @Override
    public List<ProjectDto> findCollaboratedProjects(String userName, String keyword, int offset, int limit) {
        return this.projectStorage.findCollaboratedProjects(userName, keyword, offset, limit);
    }

    @Override
    public List<ProjectDto> findNotEmptyProjects(List<String> memberships, String keyword, int offset, int limit) {
        return this.projectStorage.findNotEmptyProjects(memberships, keyword, offset, limit);
    }

    @Override
    public int countCollaboratedProjects(String userName, String keyword) {
        return this.projectStorage.countCollaboratedProjects(userName, keyword);
    }

    @Override
    public int countNotEmptyProjects(List<String> memberships, String keyword) {
        return this.projectStorage.countNotEmptyProjects(memberships, keyword);
    }

    @Override
    public int countProjects(List<String> memberships, String keyword) {
        return this.projectStorage.countProjects(memberships, keyword);
    }

    @Override
    public Set<String> getManager(long projectId) {
        return this.projectStorage.getManager(projectId);
    }

    @Override
    public Set<String> getParticipator(long projectId) {
        return this.projectStorage.getParticipator(projectId);
    }
}

