/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.Tuple;
import jakarta.persistence.TypedQuery;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.jpa.repository.QueryRewriter;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.QueryParameterSetter;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryCreationException;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.util.Lazy;
import org.springframework.lang.Nullable;

final class NamedQuery
extends AbstractJpaQuery {
    private static final String CANNOT_EXTRACT_QUERY = "Your persistence provider does not support extracting the JPQL query from a named query thus you can't use Pageable inside your query method; Make sure you have a JpaDialect configured at your EntityManagerFactoryBean as this affects discovering the concrete persistence provider";
    private static final Log LOG = LogFactory.getLog(NamedQuery.class);
    private final String queryName;
    private final String countQueryName;
    @Nullable
    private final String countProjection;
    private final boolean namedCountQueryIsPresent;
    private final Lazy<DeclaredQuery> declaredQuery;
    private final QueryParameterSetter.QueryMetadataCache metadataCache;
    private final QueryRewriter queryRewriter;

    private NamedQuery(JpaQueryMethod method, EntityManager em, QueryRewriter queryRewriter) {
        super(method, em);
        boolean cantExtractQuery;
        this.queryName = method.getNamedQueryName();
        this.countQueryName = method.getNamedCountQueryName();
        QueryExtractor extractor = method.getQueryExtractor();
        this.countProjection = method.getCountQueryProjection();
        this.queryRewriter = queryRewriter;
        JpaParameters parameters = method.getParameters();
        if (parameters.hasSortParameter()) {
            throw new IllegalStateException(String.format("Query method %s is backed by a NamedQuery and must not contain a sort parameter as we cannot modify the query; Use @%s(value=\u2026) instead to apply sorting or remove the 'Sort' parameter.", new Object[]{method, method.isNativeQuery() ? "NativeQuery" : "Query"}));
        }
        this.namedCountQueryIsPresent = NamedQuery.hasNamedQuery(em, this.countQueryName);
        Query query = em.createNamedQuery(this.queryName);
        boolean weNeedToCreateCountQuery = !this.namedCountQueryIsPresent && method.getParameters().hasLimitingParameters();
        boolean bl = cantExtractQuery = !extractor.canExtractQuery();
        if (weNeedToCreateCountQuery && cantExtractQuery) {
            throw QueryCreationException.create((QueryMethod)method, (String)CANNOT_EXTRACT_QUERY);
        }
        if (parameters.hasPageableParameter()) {
            LOG.warn((Object)String.format("Query method %s is backed by a NamedQuery but contains a Pageable parameter; Sorting delivered via this Pageable will not be applied; Use @%s(value=\u2026) instead to apply sorting.", new Object[]{method, method.isNativeQuery() ? "NativeQuery" : "Query"}));
        }
        String queryString = extractor.extractQueryString(query);
        this.declaredQuery = Lazy.of(() -> DeclaredQuery.of(queryString, method.isNativeQuery() || query.toString().contains("NativeQuery")));
        this.metadataCache = new QueryParameterSetter.QueryMetadataCache();
    }

    static boolean hasNamedQuery(EntityManager em, String queryName) {
        block13: {
            Throwable throwable = null;
            Object var3_4 = null;
            EntityManager lookupEm = em.getEntityManagerFactory().createEntityManager();
            try {
                lookupEm.createNamedQuery(queryName);
                if (lookupEm == null) break block13;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (lookupEm != null) {
                            lookupEm.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)String.format("Did not find named query %s", queryName));
                    }
                    return false;
                }
            }
            lookupEm.close();
        }
        return true;
    }

    @Nullable
    public static RepositoryQuery lookupFrom(JpaQueryMethod method, EntityManager em, QueryRewriter queryRewriter) {
        String queryName = method.getNamedQueryName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Looking up named query '%s'", queryName));
        }
        if (!NamedQuery.hasNamedQuery(em, queryName)) {
            return null;
        }
        if (method.isScrollQuery()) {
            throw QueryCreationException.create((QueryMethod)method, (String)String.format("Scroll queries are not supported using String-based queries as we cannot rewrite the query string. Use @%s(value=\u2026) instead.", method.isNativeQuery() ? "NativeQuery" : "Query"));
        }
        NamedQuery query = new NamedQuery(method, em, queryRewriter);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Found named query '%s'", queryName));
        }
        return query;
    }

    @Override
    protected Query doCreateQuery(JpaParametersParameterAccessor accessor) {
        EntityManager em = this.getEntityManager();
        JpaQueryMethod queryMethod = this.getQueryMethod();
        ResultProcessor processor = queryMethod.getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        Class<?> typeToRead = this.getTypeToRead(processor.getReturnedType());
        Query query = typeToRead == null ? em.createNamedQuery(this.queryName) : em.createNamedQuery(this.queryName, typeToRead);
        QueryParameterSetter.QueryMetadata metadata = this.metadataCache.getMetadata(this.queryName, query);
        return ((ParameterBinder)this.parameterBinder.get()).bindAndPrepare(query, metadata, accessor);
    }

    protected TypedQuery<Long> doCreateCountQuery(JpaParametersParameterAccessor accessor) {
        TypedQuery countQuery;
        String cacheKey;
        EntityManager em = this.getEntityManager();
        if (this.namedCountQueryIsPresent) {
            cacheKey = this.countQueryName;
            countQuery = em.createNamedQuery(this.countQueryName, Long.class);
        } else {
            String countQueryString = ((DeclaredQuery)this.declaredQuery.get()).deriveCountQuery(this.countProjection).getQueryString();
            cacheKey = countQueryString = this.potentiallyRewriteQuery(countQueryString, accessor.getSort(), accessor.getPageable());
            countQuery = em.createQuery(countQueryString, Long.class);
        }
        QueryParameterSetter.QueryMetadata metadata = this.metadataCache.getMetadata(cacheKey, (Query)countQuery);
        return ((ParameterBinder)this.parameterBinder.get()).bind(countQuery, metadata, accessor);
    }

    @Override
    protected Class<?> getTypeToRead(ReturnedType returnedType) {
        if (this.getQueryMethod().isNativeQuery()) {
            Class type = returnedType.getReturnedType();
            Class domainType = returnedType.getDomainType();
            if (domainType.isAssignableFrom(type)) {
                return type;
            }
            if (type.isAssignableFrom(domainType)) {
                return domainType;
            }
            return type.isInterface() ? Tuple.class : null;
        }
        return ((DeclaredQuery)this.declaredQuery.get()).hasConstructorExpression() ? null : super.getTypeToRead(returnedType);
    }

    private String potentiallyRewriteQuery(String originalQuery, Sort sort, Pageable pageable) {
        return pageable.isPaged() ? this.queryRewriter.rewrite(originalQuery, pageable) : this.queryRewriter.rewrite(originalQuery, sort);
    }
}

