/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.content.news.job;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.content.news.job.PostScheduledNewsArticleJob$AjcClosure1;
import io.meeds.content.news.job.PostScheduledNewsArticleJob$AjcClosure3;
import io.meeds.content.news.model.News;
import io.meeds.content.news.service.NewsService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.collections4.MapUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.metadata.MetadataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class PostScheduledNewsArticleJob {
    private static final Logger LOG;
    @Autowired
    private NewsService newsService;
    @Autowired
    private MetadataService metadataService;
    @Autowired
    private ActivityManager activityManager;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    @Scheduled(cron="${meeds.content.postScheduledNewsArticle.job.cron:15 */2 * * * ?}")
    @ContainerTransactional
    public void postScheduledNewsArticle() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        PostScheduledNewsArticleJob$AjcClosure1 postScheduledNewsArticleJob$AjcClosure1 = new PostScheduledNewsArticleJob$AjcClosure1(objectArray);
        ContainerTransactionalAspect.aspectOf().around(postScheduledNewsArticleJob$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @Scheduled(cron="${meeds.content.postScheduledNewsArticle.job.cron:15 */2 * * * ?}")
    @ContainerTransactional
    public void unpublishArticle() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        PostScheduledNewsArticleJob$AjcClosure3 postScheduledNewsArticleJob$AjcClosure3 = new PostScheduledNewsArticleJob$AjcClosure3(objectArray);
        ContainerTransactionalAspect.aspectOf().around(postScheduledNewsArticleJob$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    private boolean isScheduleDatePassed(String schedulePostDateString) {
        Calendar schedulePostDate = Calendar.getInstance();
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            format.setTimeZone(TimeZone.getTimeZone(ZoneOffset.UTC));
            schedulePostDate.setTime(format.parse(schedulePostDateString));
        }
        catch (ParseException e) {
            LOG.error("Error parsing schedule post date", (Throwable)e);
            return false;
        }
        Calendar now = Calendar.getInstance();
        return schedulePostDate.before(now) || now.equals(schedulePostDate);
    }

    private void unpublishArticle(News article) throws Exception {
        ExoSocialActivity activity;
        this.newsService.unpublishNews(article.getId(), article.getAuthor(), true);
        if (article.isActivityPosted() && article.getActivityId() != null && (activity = this.activityManager.getActivity(article.getActivityId())) != null) {
            this.activityManager.hideActivity(activity.getId());
        }
    }

    static {
        PostScheduledNewsArticleJob.ajc$preClinit();
        LOG = LoggerFactory.getLogger(PostScheduledNewsArticleJob.class);
    }

    static final /* synthetic */ void postScheduledNewsArticle_aroundBody0(PostScheduledNewsArticleJob ajc$this, JoinPoint joinPoint) {
        ajc$this.metadataService.getMetadataItemsByMetadataNameAndTypeAndObjectAndMetadataItemProperty("news", NewsService.NEWS_METADATA_TYPE.getName(), "newsPage", "publicationState", "staged", 0L, 0L).stream().filter(scheduledArticleMetadataItem -> {
            try {
                if (scheduledArticleMetadataItem.getProperties() != null && !scheduledArticleMetadataItem.getProperties().isEmpty()) {
                    String articleScheduleDate = scheduledArticleMetadataItem.getProperties().getOrDefault("schedulePostDate", null);
                    boolean articleDeleted = Boolean.parseBoolean(scheduledArticleMetadataItem.getProperties().getOrDefault("deleted", null));
                    if (articleScheduleDate != null && !articleDeleted && this.isScheduleDatePassed(articleScheduleDate)) {
                        return true;
                    }
                }
            }
            catch (Exception e) {
                return false;
            }
            return false;
        }).map(scheduledArticle -> this.newsService.getNewsArticleById(scheduledArticle.getObjectId())).forEach(article -> {
            try {
                if (article != null && (article = this.newsService.postNews((News)article, article.getAuthor())) != null) {
                    LOG.info("News scheduled news posted to {}", (Object)article.getUrl());
                }
            }
            catch (Exception e) {
                LOG.error("Error posting scheduled news article", (Throwable)e);
            }
        });
    }

    static final /* synthetic */ void unpublishArticle_aroundBody2(PostScheduledNewsArticleJob ajc$this, JoinPoint joinPoint) {
        ajc$this.metadataService.getMetadataItemsByMetadataNameAndTypeAndObjectAndMetadataItemProperty("news", NewsService.NEWS_METADATA_TYPE.getName(), "newsPage", "unpublishScheduled", "true", 0L, 0L).stream().filter(item -> {
            if (MapUtils.isNotEmpty((Map)item.getProperties())) {
                String scheduledUnpublishDate = item.getProperties().getOrDefault("unpublishScheduledDate", null);
                return scheduledUnpublishDate != null && this.isScheduleDatePassed(scheduledUnpublishDate);
            }
            return false;
        }).map(article -> this.newsService.getNewsArticleById(article.getObjectId())).forEach(article -> {
            if (article != null) {
                try {
                    this.unpublishArticle((News)article);
                    LOG.info("Unpublish schedule executed articleId: {}, articleTitle: {}", (Object)article.getId(), (Object)article.getTitle());
                }
                catch (Exception e) {
                    LOG.error("Error unpublishing scheduled news article", (Throwable)e);
                }
            }
        });
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PostScheduledNewsArticleJob.java", PostScheduledNewsArticleJob.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "postScheduledNewsArticle", "io.meeds.content.news.job.PostScheduledNewsArticleJob", "", "", "", "void"), 72);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "unpublishArticle", "io.meeds.content.news.job.PostScheduledNewsArticleJob", "", "", "", "void"), 117);
    }
}

