/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.Serializable;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.engine.spi.UnsavedValueStrategy;
import org.hibernate.internal.CoreLogging;
import org.jboss.logging.Logger;

public class IdentifierValue
implements UnsavedValueStrategy {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = CoreLogging.logger(IdentifierValue.class);
    private final @Nullable @UnknownKeyFor @Initialized Object value;
    public static final @UnknownKeyFor @NonNull @Initialized IdentifierValue ANY = new IdentifierValue(){

        @Override
        public Boolean isUnsaved(Object id) {
            LOG.trace((Object)"ID unsaved-value strategy ANY");
            return Boolean.TRUE;
        }

        @Override
        public Object getDefaultValue(Object currentValue) {
            return currentValue;
        }

        @Override
        public String toString() {
            return "SAVE_ANY";
        }
    };
    public static final @UnknownKeyFor @NonNull @Initialized IdentifierValue NONE = new IdentifierValue(){

        @Override
        public Boolean isUnsaved(Object id) {
            LOG.trace((Object)"ID unsaved-value strategy NONE");
            return Boolean.FALSE;
        }

        @Override
        public Object getDefaultValue(Object currentValue) {
            return currentValue;
        }

        @Override
        public String toString() {
            return "SAVE_NONE";
        }
    };
    public static final @UnknownKeyFor @NonNull @Initialized IdentifierValue NULL = new IdentifierValue(){

        @Override
        public Boolean isUnsaved(@Nullable Object id) {
            LOG.trace((Object)"ID unsaved-value strategy NULL");
            return id == null;
        }

        @Override
        public @Nullable Serializable getDefaultValue(Object currentValue) {
            return null;
        }

        @Override
        public String toString() {
            return "SAVE_NULL";
        }
    };
    public static final @UnknownKeyFor @NonNull @Initialized IdentifierValue UNDEFINED = new IdentifierValue(){

        @Override
        public @Nullable Boolean isUnsaved(Object id) {
            LOG.trace((Object)"ID unsaved-value strategy UNDEFINED");
            return null;
        }

        @Override
        public @Nullable Serializable getDefaultValue(Object currentValue) {
            return null;
        }

        @Override
        public String toString() {
            return "UNDEFINED";
        }
    };

    protected IdentifierValue() {
        this.value = null;
    }

    public IdentifierValue(@UnknownKeyFor @NonNull @Initialized Object value) {
        this.value = value;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Boolean isUnsaved(@Nullable @UnknownKeyFor @Initialized Object id) {
        LOG.tracev("ID unsaved-value: {0}", this.value);
        return id == null || id.equals(this.value);
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Object getDefaultValue(@Nullable @UnknownKeyFor @Initialized Object currentValue) {
        return this.value;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "identifier unsaved-value: " + this.value;
    }
}

