/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.owasp.html.CssSchema;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.HtmlSanitizer;
import org.owasp.html.HtmlStreamEventReceiver;
import org.owasp.html.HtmlStreamRenderer;

public abstract class HTMLSanitizer {
    private static final Pattern COLOR_NAME = Pattern.compile("(?:aqua|black|blue|fuchsia|gray|grey|green|lime|maroon|navy|olive|purple|red|silver|teal|white|yellow)");
    private static final Pattern COLOR_CODE = Pattern.compile("(?:#(?:[0-9a-fA-F]{3}(?:[0-9a-fA-F]{3})?))");
    private static final Pattern NUMBER_OR_PERCENT = Pattern.compile("[0-9]+%?");
    private static final Pattern HTML_ID = Pattern.compile("[a-zA-Z0-9\\:\\-_\\.]+");
    private static final Pattern HTML_TITLE = Pattern.compile("[\\p{L}\\p{N}\\s\\-_',:\\[\\]!\\./\\\\\\(\\)&]*");
    private static final Pattern HTML_CLASS = Pattern.compile("[a-zA-Z0-9\\s,\\-_]+");
    private static final Pattern ONSITE_URL = Pattern.compile("(?:[\\p{L}\\p{N} \\\\\\.\\#@\\$%\\+&;\\-_~,\\?=/!:]+|\\#(\\w)+)");
    private static final Pattern OFFSITE_URL = Pattern.compile("\\s*(?:(?:ht|f)tps?:\\/\\/|mailto:)[\\p{L}\\p{N}][\\p{L}\\p{N} \\p{Zs}\\.\\[\\]\\#@\\$%\\+&;:\\-_~,\\?=\\/!\\(\\)\\*]*+\\s*");
    private static final Pattern NUMBER = Pattern.compile("[+-]?(?:(?:[0-9]+(?:\\.[0-9]*)?)|\\.[0-9]+)");
    private static final Pattern NAME = Pattern.compile("[a-zA-Z0-9\\-_\\$]+");
    private static final Pattern ALIGN = Pattern.compile("(?i)center|left|right|justify|char");
    private static final Pattern VALIGN = Pattern.compile("(?i)baseline|bottom|middle|top");
    private static final Predicate<String> COLOR_NAME_OR_COLOR_CODE = HTMLSanitizer.matchesEither(COLOR_NAME, COLOR_CODE);
    private static final Predicate<String> ONSITE_OR_OFFSITE_URL = HTMLSanitizer.matchesEither(ONSITE_URL, OFFSITE_URL);
    private static final Pattern HISTORY_BACK = Pattern.compile("(?:javascript:)?\\Qhistory.go(-1)\\E");
    private static final Pattern ONE_CHAR = Pattern.compile(".?", 32);
    private static final Collection<String> CUSTOM_ALLOWED_STYLES = CollectionUtils.union((Collection)CssSchema.DEFAULT.allowedProperties(), Arrays.asList("float", "display", "clear", "position", "left", "top"));
    private static final Pattern ALLOW_FULL_SCREEN_ON_IFRAME = Pattern.compile("fullscreen");
    private static final CssSchema.Property ASPECT_RATIO_PROPERTY = new CssSchema.Property(5, ImmutableSet.of((Object)"auto", (Object)"inherit"), ImmutableMap.of());
    public static final Function<HtmlStreamEventReceiver, HtmlSanitizer.Policy> POLICY_DEFINITION = new HtmlPolicyBuilder().allowAttributes(new String[]{"id"}).matching(HTML_ID).globally().allowAttributes(new String[]{"class"}).matching(HTML_CLASS).globally().allowAttributes(new String[]{"lang"}).matching(Pattern.compile("[a-zA-Z]{2,20}")).globally().allowAttributes(new String[]{"title"}).matching(HTML_TITLE).globally().allowStyling(CssSchema.withProperties(CUSTOM_ALLOWED_STYLES)).allowStyling(CssSchema.withProperties(Map.of("aspect-ratio", ASPECT_RATIO_PROPERTY))).allowAttributes(new String[]{"align"}).matching(ALIGN).onElements(new String[]{"p"}).allowAttributes(new String[]{"for"}).matching(HTML_ID).onElements(new String[]{"label"}).allowAttributes(new String[]{"color"}).matching(COLOR_NAME_OR_COLOR_CODE).onElements(new String[]{"font"}).allowAttributes(new String[]{"face"}).matching(Pattern.compile("[\\w;, \\-]+")).onElements(new String[]{"font"}).allowAttributes(new String[]{"size"}).matching(NUMBER).onElements(new String[]{"font"}).allowAttributes(new String[]{"href"}).matching(ONSITE_OR_OFFSITE_URL).onElements(new String[]{"a"}).allowStandardUrlProtocols().allowAttributes(new String[]{"data-identity-id"}).globally().allowAttributes(new String[]{"data-role"}).globally().allowAttributes(new String[]{"data-object"}).globally().allowAttributes(new String[]{"nohref"}).onElements(new String[]{"a"}).allowAttributes(new String[]{"target"}).matching(true, new String[]{"_blank"}).onElements(new String[]{"a"}).requireRelNofollowOnLinks().allowAttributes(new String[]{"name", "rel"}).matching(NAME).onElements(new String[]{"a"}).allowAttributes(new String[]{"onfocus", "onblur", "onclick", "onmousedown", "onmouseup"}).matching(HISTORY_BACK).onElements(new String[]{"a"}).allowStandardUrlProtocols().allowUrlProtocols(new String[]{"tel", "ftp"}).requireRelNofollowOnLinks().allowAttributes(new String[]{"src"}).matching(ONSITE_OR_OFFSITE_URL).onElements(new String[]{"img"}).allowAttributes(new String[]{"archived_cke_uploadId"}).onElements(new String[]{"img"}).allowAttributes(new String[]{"src"}).matching(ONSITE_OR_OFFSITE_URL).onElements(new String[]{"img"}).allowAttributes(new String[]{"referrerpolicy", "data-plugin-name"}).onElements(new String[]{"img"}).allowAttributes(new String[]{"name"}).matching(NAME).onElements(new String[]{"img"}).allowAttributes(new String[]{"alt"}).matching(HTML_TITLE).onElements(new String[]{"img"}).allowAttributes(new String[]{"border", "hspace", "vspace"}).matching(NUMBER).onElements(new String[]{"img"}).allowAttributes(new String[]{"width", "height"}).matching(NUMBER_OR_PERCENT).onElements(new String[]{"img"}).allowAttributes(new String[]{"border", "cellpadding", "cellspacing"}).matching(NUMBER).onElements(new String[]{"table"}).allowAttributes(new String[]{"bgcolor"}).matching(COLOR_NAME_OR_COLOR_CODE).onElements(new String[]{"table"}).allowAttributes(new String[]{"background"}).matching(ONSITE_URL).onElements(new String[]{"table"}).allowAttributes(new String[]{"align"}).matching(ALIGN).onElements(new String[]{"table"}).allowAttributes(new String[]{"noresize"}).matching(Pattern.compile("(?i)noresize")).onElements(new String[]{"table"}).allowAttributes(new String[]{"summary"}).onElements(new String[]{"table"}).allowAttributes(new String[]{"background"}).matching(ONSITE_URL).onElements(new String[]{"td", "th", "tr"}).allowAttributes(new String[]{"bgcolor"}).matching(COLOR_NAME_OR_COLOR_CODE).onElements(new String[]{"td", "th"}).allowAttributes(new String[]{"abbr"}).matching(HTML_TITLE).onElements(new String[]{"td", "th"}).allowAttributes(new String[]{"axis", "headers"}).matching(NAME).onElements(new String[]{"td", "th"}).allowAttributes(new String[]{"scope"}).matching(Pattern.compile("(?i)(?:row|col)(?:group)?")).onElements(new String[]{"td", "th"}).allowAttributes(new String[]{"nowrap"}).onElements(new String[]{"td", "th"}).allowAttributes(new String[]{"height", "width"}).matching(NUMBER_OR_PERCENT).onElements(new String[]{"table", "td", "th", "tr", "img"}).allowAttributes(new String[]{"align"}).matching(ALIGN).onElements(new String[]{"thead", "tbody", "tfoot", "img", "td", "th", "tr", "colgroup", "col"}).allowAttributes(new String[]{"valign"}).matching(VALIGN).onElements(new String[]{"thead", "tbody", "tfoot", "td", "th", "tr", "colgroup", "col"}).allowAttributes(new String[]{"charoff"}).matching(NUMBER_OR_PERCENT).onElements(new String[]{"td", "th", "tr", "colgroup", "col", "thead", "tbody", "tfoot"}).allowAttributes(new String[]{"char"}).matching(ONE_CHAR).onElements(new String[]{"td", "th", "tr", "colgroup", "col", "thead", "tbody", "tfoot"}).allowAttributes(new String[]{"colspan", "rowspan"}).matching(NUMBER).onElements(new String[]{"td", "th"}).allowAttributes(new String[]{"span", "width"}).matching(NUMBER_OR_PERCENT).onElements(new String[]{"colgroup", "col"}).allowElements(new String[]{"a", "oembed", "label", "noscript", "h1", "h2", "h3", "h4", "h5", "h6", "p", "i", "b", "u", "s", "strong", "em", "small", "big", "pre", "code", "cite", "samp", "sub", "sup", "strike", "del", "tt", "center", "blockquote", "hr", "br", "col", "figure", "font", "map", "mark", "span", "div", "img", "ul", "ol", "li", "dd", "dt", "dl", "tbody", "thead", "tfoot", "table", "td", "th", "tr", "colgroup", "fieldset", "legend", "ins", "exo-wiki-children-pages", "exo-wiki-include-page", "content-link", "iframe"}).allowAttributes(new String[]{"page-name"}).onElements(new String[]{"exo-wiki-include-page"}).allowElements(new String[]{"figcaption"}).allowAttributes(new String[]{"class"}).matching(HTML_CLASS).onElements(new String[]{"figcaption"}).allowElements(new String[]{"wikiimage", "wikilink", "wikimacro"}).allowAttributes(new String[]{"wikiparam"}).globally().allowAttributes(new String[]{"src"}).onElements(new String[]{"iframe"}).allowAttributes(new String[]{"allow"}).matching(ALLOW_FULL_SCREEN_ON_IFRAME).onElements(new String[]{"iframe"}).allowAttributes(new String[]{"frameborder"}).onElements(new String[]{"iframe"}).allowAttributes(new String[]{"contenteditable", "data-url"}).globally().allowAttributes(new String[]{"v-identity-popover"}).globally().allowAttributes(new String[]{"is"}).globally().allowElements(new String[]{"caption"}).toFactory();

    public static String sanitize(String html) {
        StringBuilder sb = new StringBuilder();
        HtmlStreamRenderer renderer = HtmlStreamRenderer.create((StringBuilder)sb, x -> {
            throw new AssertionError(x);
        });
        HtmlSanitizer.sanitize((String)html, (HtmlSanitizer.Policy)((HtmlSanitizer.Policy)POLICY_DEFINITION.apply((Object)renderer)));
        return sb.toString();
    }

    private static Predicate<String> matchesEither(final Pattern a, final Pattern b) {
        return new Predicate<String>(){

            public boolean apply(String s) {
                return a.matcher(s).matches() || b.matcher(s).matches();
            }
        };
    }
}

