/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.domain;

import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.PluralAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.domain.Sort;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class JpaSort
extends Sort {
    private static final long serialVersionUID = 1L;

    private JpaSort(Sort.Direction direction, List<Path<?, ?>> paths) {
        this(Collections.emptyList(), direction, paths);
    }

    private JpaSort(List<Sort.Order> orders, @Nullable Sort.Direction direction, List<Path<?, ?>> paths) {
        super(JpaSort.combine(orders, direction, paths));
    }

    private JpaSort(List<Sort.Order> orders) {
        super(orders);
    }

    public static JpaSort of(Attribute<?, ?> ... attributes) {
        return new JpaSort(Sort.DEFAULT_DIRECTION, Arrays.asList(JpaSort.paths(attributes)));
    }

    public static JpaSort of(Path<?, ?> ... paths) {
        return new JpaSort(Sort.DEFAULT_DIRECTION, Arrays.asList(paths));
    }

    public static JpaSort of(Sort.Direction direction, Attribute<?, ?> ... attributes) {
        return new JpaSort(direction, Arrays.asList(JpaSort.paths(attributes)));
    }

    public static JpaSort of(Sort.Direction direction, Path<?, ?> ... paths) {
        return new JpaSort(direction, Arrays.asList(paths));
    }

    public JpaSort and(@Nullable Sort.Direction direction, Attribute<?, ?> ... attributes) {
        Assert.notNull(attributes, (String)"Attributes must not be null");
        return this.and(direction, JpaSort.paths(attributes));
    }

    public JpaSort and(@Nullable Sort.Direction direction, Path<?, ?> ... paths) {
        Assert.notNull(paths, (String)"Paths must not be null");
        ArrayList<Sort.Order> existing = new ArrayList<Sort.Order>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Sort.Order order = (Sort.Order)iterator.next();
            existing.add(order);
        }
        return new JpaSort(existing, direction, Arrays.asList(paths));
    }

    public JpaSort andUnsafe(@Nullable Sort.Direction direction, String ... properties) {
        Assert.notEmpty((Object[])properties, (String)"Properties must not be empty");
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Sort.Order order = (Sort.Order)iterator.next();
            orders.add(order);
        }
        String[] stringArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            orders.add(new JpaOrder(direction, property));
            ++n2;
        }
        return new JpaSort(orders, direction, Collections.emptyList());
    }

    private static Path<?, ?>[] paths(Attribute<?, ?>[] attributes) {
        Assert.notNull(attributes, (String)"Attributes must not be null");
        Assert.notEmpty((Object[])attributes, (String)"Attributes must not be empty");
        Path[] paths = new Path[attributes.length];
        int i = 0;
        while (i < attributes.length) {
            paths[i] = JpaSort.path(attributes[i]);
            ++i;
        }
        return paths;
    }

    private static List<Sort.Order> combine(List<Sort.Order> orders, @Nullable Sort.Direction direction, List<Path<?, ?>> paths) {
        ArrayList<Sort.Order> result = new ArrayList<Sort.Order>(orders);
        for (Path<?, ?> path : paths) {
            result.add(new Sort.Order(direction, path.toString()));
        }
        return result;
    }

    public static <A extends Attribute<T, S>, T, S> Path<T, S> path(A attribute) {
        Assert.notNull(attribute, (String)"Attribute must not be null");
        return new Path(Collections.singletonList(attribute));
    }

    public static <P extends PluralAttribute<T, ?, S>, T, S> Path<T, S> path(P attribute) {
        Assert.notNull(attribute, (String)"Attribute must not be null");
        return new Path(Collections.singletonList(attribute));
    }

    public static JpaSort unsafe(String ... properties) {
        return JpaSort.unsafe(Sort.DEFAULT_DIRECTION, properties);
    }

    public static JpaSort unsafe(Sort.Direction direction, String ... properties) {
        Assert.notNull((Object)direction, (String)"Direction must not be null");
        Assert.notEmpty((Object[])properties, (String)"Properties must not be empty");
        Assert.noNullElements((Object[])properties, (String)"Properties must not contain null values");
        return JpaSort.unsafe(direction, Arrays.asList(properties));
    }

    public static JpaSort unsafe(Sort.Direction direction, List<String> properties) {
        Assert.notEmpty(properties, (String)"Properties must not be empty");
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>(properties.size());
        for (String property : properties) {
            orders.add(new JpaOrder(direction, property));
        }
        return new JpaSort(orders);
    }

    public static class JpaOrder
    extends Sort.Order {
        private static final long serialVersionUID = 1L;
        private final boolean unsafe;

        private JpaOrder(@Nullable Sort.Direction direction, String property) {
            this(direction, property, Sort.NullHandling.NATIVE);
        }

        private JpaOrder(@Nullable Sort.Direction direction, String property, Sort.NullHandling nullHandlingHint) {
            this(direction, property, false, nullHandlingHint, true);
        }

        private JpaOrder(@Nullable Sort.Direction direction, String property, boolean ignoreCase, Sort.NullHandling nullHandling, boolean unsafe) {
            super(direction, property, ignoreCase, nullHandling);
            this.unsafe = unsafe;
        }

        public JpaOrder with(Sort.Direction order) {
            return new JpaOrder(order, this.getProperty(), this.isIgnoreCase(), this.getNullHandling(), this.unsafe);
        }

        public JpaOrder with(Sort.NullHandling nullHandling) {
            return new JpaOrder(this.getDirection(), this.getProperty(), this.isIgnoreCase(), nullHandling, this.unsafe);
        }

        public Sort withUnsafe(String ... properties) {
            Assert.notEmpty((Object[])properties, (String)"Properties must not be empty");
            Assert.noNullElements((Object[])properties, (String)"Properties must not contain null values");
            ArrayList<JpaOrder> orders = new ArrayList<JpaOrder>(properties.length);
            String[] stringArray = properties;
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                String property = stringArray[n2];
                orders.add(new JpaOrder(this.getDirection(), property, this.isIgnoreCase(), this.getNullHandling(), this.unsafe));
                ++n2;
            }
            return Sort.by(orders);
        }

        public JpaOrder ignoreCase() {
            return new JpaOrder(this.getDirection(), this.getProperty(), true, this.getNullHandling(), this.unsafe);
        }

        public boolean isUnsafe() {
            return this.unsafe;
        }
    }

    public static class Path<T, S> {
        private final Collection<Attribute<?, ?>> attributes;

        private Path(List<? extends Attribute<?, ?>> attributes) {
            this.attributes = Collections.unmodifiableList(attributes);
        }

        public <A extends Attribute<S, U>, U> Path<S, U> dot(A attribute) {
            return new Path<T, S>(this.add(attribute));
        }

        public <P extends PluralAttribute<S, ?, U>, U> Path<S, U> dot(P attribute) {
            return new Path<T, S>(this.add((Attribute<?, ?>)attribute));
        }

        private List<Attribute<?, ?>> add(Attribute<?, ?> attribute) {
            Assert.notNull(attribute, (String)"Attribute must not be null");
            ArrayList newAttributes = new ArrayList(this.attributes.size() + 1);
            newAttributes.addAll(this.attributes);
            newAttributes.add(attribute);
            return newAttributes;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (Attribute<?, ?> attribute : this.attributes) {
                builder.append(attribute.getName()).append(".");
            }
            return builder.length() == 0 ? "" : builder.substring(0, builder.lastIndexOf("."));
        }
    }
}

