/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;

@ComponentConfig(template="system:/groovy/portal/webui/page/UISiteBody.gtmpl")
public class UISiteBody
extends UIComponentDecorator {
    @Override
    public UIComponent getUIComponent() {
        if (this.isShowSiteBody()) {
            return this.getSiteComponent();
        }
        if (PortalRequestContext.getCurrentInstance().isMaximizePortlet()) {
            return this.getMaximizedPortlet();
        }
        return this.getPageComponent();
    }

    public String getSiteClass() {
        String portalOwner = PortalRequestContext.getCurrentInstance().getPortalOwner();
        if (StringUtils.isBlank((CharSequence)portalOwner)) {
            return "";
        }
        return portalOwner.toUpperCase() + "Site";
    }

    protected UIComponent getSiteComponent() {
        return PortalRequestContext.getCurrentInstance().getUiPortal();
    }

    protected UIComponent getPageComponent() {
        return this.getSiteComponent().findFirstComponentOfType(UIPageBody.class);
    }

    protected UIComponent getMaximizedPortlet() {
        return PortalRequestContext.getCurrentInstance().getMaximizedUIPortlet();
    }

    protected boolean isShowSiteBody() {
        PortalRequestContext requestContext = PortalRequestContext.getCurrentInstance();
        return !requestContext.isShowMaxWindow() && (requestContext.getUiPage() == null || !requestContext.getUiPage().isShowMaxWindow());
    }
}

