/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.validators;

import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Body;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public class SupportedLessBodyMembers {
    private static final EnumSet<ASTCssNodeType> KEYFRAMES_SUPPORTED_MEMBERS = EnumSet.of(ASTCssNodeType.RULE_SET, ASTCssNodeType.DETACHED_RULESET_REFERENCE, ASTCssNodeType.MIXIN_REFERENCE, ASTCssNodeType.REUSABLE_STRUCTURE, ASTCssNodeType.VARIABLE_DECLARATION);
    private static final EnumSet<ASTCssNodeType> ALL_NODE_TYPES = EnumSet.allOf(ASTCssNodeType.class);
    private static final EnumSet<ASTCssNodeType> STYLE_SHEET_SUPPORTED_MEMBERS = EnumSet.allOf(ASTCssNodeType.class);

    public Set<ASTCssNodeType> getSupportedMembers(Body node) {
        if (node.getParent() != null) {
            return this.getSupportedMembers(node.getType(), node.getParent().getType());
        }
        return this.getSupportedMembers(node.getType(), null);
    }

    public Set<ASTCssNodeType> getSupportedMembers(ASTCssNodeType bodyType, ASTCssNodeType ownerType) {
        switch (bodyType) {
            case STYLE_SHEET: {
                return Collections.unmodifiableSet(STYLE_SHEET_SUPPORTED_MEMBERS);
            }
        }
        if (ownerType == null) {
            return this.allNodeTypes();
        }
        switch (ownerType) {
            case KEYFRAMES: {
                return Collections.unmodifiableSet(KEYFRAMES_SUPPORTED_MEMBERS);
            }
        }
        return this.allNodeTypes();
    }

    private Set<ASTCssNodeType> allNodeTypes() {
        return Collections.unmodifiableSet(ALL_NODE_TYPES);
    }

    static {
        STYLE_SHEET_SUPPORTED_MEMBERS.remove((Object)ASTCssNodeType.DECLARATION);
        STYLE_SHEET_SUPPORTED_MEMBERS.remove((Object)ASTCssNodeType.PAGE_MARGIN_BOX);
    }
}

