/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.content.news.utils;

import io.meeds.content.news.model.ArticleTarget;
import io.meeds.content.news.rest.model.NewsSearchResultEntity;
import io.meeds.content.news.search.NewsESSearchResult;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.exoplatform.social.metadata.favorite.model.Favorite;
import org.exoplatform.social.metadata.model.Metadata;
import org.exoplatform.social.metadata.model.MetadataItem;

public class EntityBuilder {
    private EntityBuilder() {
    }

    public static NewsSearchResultEntity fromNewsSearchResult(FavoriteService favoriteService, NewsESSearchResult newsESSearchResult, Identity currentIdentity) {
        NewsSearchResultEntity newsSearchResultEntity = new NewsSearchResultEntity(newsESSearchResult);
        Favorite favorite = new Favorite("news", newsESSearchResult.getLang() != null ? newsESSearchResult.getId().concat("-").concat(newsESSearchResult.getLang()) : newsESSearchResult.getId(), null, Long.parseLong(currentIdentity.getId()));
        newsSearchResultEntity.setFavorite(favoriteService.isFavorite(favorite));
        return newsSearchResultEntity;
    }

    public static ArticleTarget toArticleTarget(MetadataItem metadataItem) {
        if (metadataItem == null) {
            return null;
        }
        Metadata metadata = metadataItem.getMetadata();
        Map properties = metadataItem.getProperties();
        String publishedDate = properties != null ? properties.getOrDefault("publishedDate", "0") : "0";
        return new ArticleTarget(metadata.getName(), Long.parseLong(publishedDate));
    }

    public static List<ArticleTarget> toArticleTargets(List<MetadataItem> metadataItems) {
        if (CollectionUtils.isEmpty(metadataItems)) {
            return null;
        }
        return metadataItems.stream().map(EntityBuilder::toArticleTarget).toList();
    }
}

