/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.storage;

import io.meeds.wallet.dao.WalletTransactionDAO;
import io.meeds.wallet.entity.TransactionEntity;
import io.meeds.wallet.model.TransactionDetail;
import io.meeds.wallet.utils.WalletUtils;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class TransactionStorage {
    private static final Log LOG = ExoLogger.getLogger(TransactionStorage.class);
    private WalletTransactionDAO walletTransactionDAO;
    private ListenerService listenerService;

    public TransactionStorage(ListenerService listenerService, WalletTransactionDAO walletTransactionDAO) {
        this.listenerService = listenerService;
        this.walletTransactionDAO = walletTransactionDAO;
    }

    public List<TransactionDetail> getPendingEtherTransactions(String address, long networkId) {
        List<TransactionEntity> transactions = this.walletTransactionDAO.getPendingEtherTransactions(address, networkId);
        return this.fromEntities(transactions);
    }

    public List<TransactionDetail> getPendingWalletTransactionsNotSent(String address, long networkId) {
        List<TransactionEntity> transactions = this.walletTransactionDAO.getPendingWalletTransactionsNotSent(address, networkId);
        return this.fromEntities(transactions);
    }

    public List<TransactionDetail> getPendingWalletTransactionsSent(String address, long networkId) {
        List<TransactionEntity> transactions = this.walletTransactionDAO.getPendingWalletTransactionsSent(address, networkId);
        return this.fromEntities(transactions);
    }

    public long countContractPendingTransactionsSent(long networkId) {
        return this.walletTransactionDAO.countContractPendingTransactionsSent(networkId);
    }

    public long countContractPendingTransactionsToSend(long networkId) {
        return this.walletTransactionDAO.countContractPendingTransactionsToSend(networkId);
    }

    public List<TransactionDetail> getTransactionsToSend(long networkId) {
        List<TransactionEntity> transactions = this.walletTransactionDAO.getTransactionsToSend(networkId);
        return this.fromEntities(transactions);
    }

    public long getMaxUsedNonce(long networkId, String fromAddress) {
        return this.walletTransactionDAO.getMaxUsedNonce(networkId, fromAddress);
    }

    public List<TransactionDetail> getContractTransactions(String contractAddress, String contractMethodName, int limit) {
        List<TransactionEntity> transactions = this.walletTransactionDAO.getContractTransactions(StringUtils.lowerCase((String)contractAddress), contractMethodName, limit);
        return this.fromEntities(transactions);
    }

    public List<TransactionDetail> getTransactions(long networkId, int limit) {
        List<TransactionEntity> transactions = this.walletTransactionDAO.getTransactions(networkId, limit);
        return this.fromEntities(transactions);
    }

    public List<TransactionDetail> getWalletTransactions(long networkId, String address, String contractAddress, String contractMethodName, String hash, int limit, boolean pending, boolean administration) {
        List<TransactionEntity> transactions = this.getWalletTransactions(networkId, address, contractAddress, contractMethodName, limit, pending, administration);
        boolean limitNotReached = transactions.size() == limit;
        int limitToSearchForHash = limit * 2;
        if (StringUtils.isNotBlank((CharSequence)hash) && limitNotReached && transactions.stream().noneMatch(transaction -> StringUtils.equalsIgnoreCase((CharSequence)transaction.getHash(), (CharSequence)hash))) {
            return this.getWalletTransactions(networkId, address, contractAddress, contractMethodName, hash, limitToSearchForHash, pending, administration);
        }
        return this.fromEntities(transactions);
    }

    private List<TransactionEntity> getWalletTransactions(long networkId, String address, String contractAddress, String contractMethodName, int limit, boolean pending, boolean administration) {
        return this.walletTransactionDAO.getWalletTransactions(networkId, address, contractAddress, contractMethodName, limit, pending, administration);
    }

    public void saveTransactionDetail(TransactionDetail transactionDetail) {
        TransactionEntity transactionEntity;
        if (transactionDetail.getTimestamp() <= 0L) {
            transactionDetail.setTimestamp(System.currentTimeMillis());
        }
        if (transactionDetail.getSentTimestamp() <= 0L && StringUtils.isBlank((CharSequence)transactionDetail.getRawTransaction())) {
            transactionDetail.setSentTimestamp(transactionDetail.getTimestamp());
        }
        if ((transactionEntity = this.toEntity(transactionDetail)).getId() == 0L) {
            transactionEntity = (TransactionEntity)this.walletTransactionDAO.create(transactionEntity);
            transactionDetail.setId(transactionEntity.getId());
            this.broadcastTransactionEvent(transactionDetail, "exo.wallet.transaction.created");
        } else {
            this.walletTransactionDAO.update(transactionEntity);
            this.broadcastTransactionEvent(transactionDetail, "exo.wallet.transaction.modified");
        }
    }

    public List<TransactionDetail> getPendingTransactionsWithSameNonce(long networkId, String transactionHash, String fromAddress, long nonce) {
        List<TransactionEntity> transactionEntities = this.walletTransactionDAO.getPendingTransactionsWithSameNonce(networkId, transactionHash, fromAddress, nonce);
        return this.fromEntities(transactionEntities);
    }

    public long countPendingTransactionsWithSameNonce(long networkId, String transactionHash, String fromAddress, long nonce) {
        return this.walletTransactionDAO.countPendingTransactionsWithSameNonce(networkId, transactionHash, fromAddress, nonce);
    }

    public TransactionDetail getTransactionByHash(String hash) {
        hash = WalletUtils.formatTransactionHash((String)hash);
        TransactionEntity transactionEntity = this.walletTransactionDAO.getTransactionByHash(hash);
        return this.fromEntity(transactionEntity);
    }

    public TransactionDetail getPendingTransactionByHash(String hash) {
        hash = WalletUtils.formatTransactionHash((String)hash);
        TransactionEntity transactionEntity = this.walletTransactionDAO.getPendingTransactionByHash(hash);
        return this.fromEntity(transactionEntity);
    }

    public long countPendingTransactionSent(long networkId, String fromAddress) {
        return this.walletTransactionDAO.countPendingTransactionSent(networkId, fromAddress);
    }

    public long countPendingTransactionAsSender(long networkId, String fromAddress) {
        return this.walletTransactionDAO.countPendingTransactionAsSender(networkId, fromAddress);
    }

    public double countReceivedContractAmount(String contractAddress, String address, ZonedDateTime startDate, ZonedDateTime endDate) {
        return this.walletTransactionDAO.countReceivedContractAmount(contractAddress, address, startDate, endDate);
    }

    public double countSentContractAmount(String contractAddress, String address, ZonedDateTime startDate, ZonedDateTime endDate) {
        return this.walletTransactionDAO.countSentContractAmount(contractAddress, address, startDate, endDate);
    }

    public long countTransactions() {
        return this.walletTransactionDAO.count();
    }

    private void broadcastTransactionEvent(TransactionDetail transactionDetail, String eventName) {
        try {
            this.listenerService.broadcast(eventName, (Object)transactionDetail, (Object)transactionDetail);
        }
        catch (Exception e) {
            LOG.warn("Error when broadcasting event '{}' on transaction '{}'", new Object[]{eventName, transactionDetail.getHash()});
        }
    }

    private List<TransactionDetail> fromEntities(List<TransactionEntity> transactions) {
        return transactions == null ? Collections.emptyList() : ((Stream)transactions.stream().sequential()).map(this::fromEntity).collect(Collectors.toList());
    }

    private TransactionDetail fromEntity(TransactionEntity entity) {
        if (entity == null) {
            return null;
        }
        TransactionDetail detail = new TransactionDetail();
        detail.setId(entity.getId());
        detail.setAdminOperation(entity.isAdminOperation());
        detail.setContractAddress(entity.getContractAddress());
        detail.setContractAmount(entity.getContractAmount());
        detail.setContractMethodName(entity.getContractMethodName());
        detail.setTimestamp(entity.getCreatedDate());
        detail.setValue(entity.getValue());
        detail.setIssuerId(entity.getIssuerIdentityId());
        detail.setHash(entity.getHash());
        detail.setFrom(entity.getFromAddress());
        detail.setTo(entity.getToAddress());
        detail.setBy(entity.getByAddress());
        detail.setLabel(entity.getLabel());
        detail.setMessage(entity.getMessage());
        detail.setNetworkId(entity.getNetworkId());
        detail.setPending(entity.isPending());
        detail.setSucceeded(entity.isSuccess());
        detail.setDropped(entity.isDropped());
        detail.setGasPrice(entity.getGasPrice());
        detail.setGasUsed(entity.getGasUsed());
        detail.setTokenFee(entity.getTokenFee());
        detail.setEtherFee(entity.getEtherFee());
        detail.setNoContractFunds(entity.isNoContractFunds());
        detail.setNonce(entity.getNonce());
        detail.setSentTimestamp(entity.getSentDate());
        detail.setSendingAttemptCount(entity.getSendingAttemptCount());
        detail.setRawTransaction(entity.getRawTransaction());
        detail.setBoost(entity.isBoost());
        return detail;
    }

    private TransactionEntity toEntity(TransactionDetail detail) {
        TransactionEntity entity = new TransactionEntity();
        if (detail.getId() > 0L) {
            entity.setId(detail.getId());
        }
        entity.setNetworkId(detail.getNetworkId());
        entity.setHash(WalletUtils.formatTransactionHash((String)detail.getHash()));
        entity.setFromAddress(StringUtils.lowerCase((String)detail.getFrom()));
        entity.setToAddress(StringUtils.lowerCase((String)detail.getTo()));
        entity.setByAddress(StringUtils.lowerCase((String)detail.getBy()));
        entity.setContractAddress(StringUtils.lowerCase((String)detail.getContractAddress()));
        entity.setContractAmount(detail.getContractAmount());
        entity.setContractMethodName(detail.getContractMethodName());
        entity.setAdminOperation(detail.isAdminOperation());
        entity.setLabel(detail.getLabel());
        entity.setMessage(detail.getMessage());
        entity.setPending(detail.isPending());
        entity.setSuccess(detail.isSucceeded());
        entity.setDropped(detail.isDropped());
        entity.setValue(detail.getValue());
        entity.setGasPrice(detail.getGasPrice());
        entity.setTokenFee(detail.getTokenFee());
        entity.setEtherFee(detail.getEtherFee());
        entity.setGasUsed(detail.getGasUsed());
        entity.setNoContractFunds(detail.isNoContractFunds());
        entity.setNonce(detail.getNonce());
        entity.setBoost(detail.isBoost());
        entity.setSentDate(detail.getSentTimestamp());
        entity.setSendingAttemptCount(detail.getSendingAttemptCount());
        entity.setRawTransaction(detail.getRawTransaction());
        if (detail.getTimestamp() == 0L) {
            entity.setCreatedDate(System.currentTimeMillis());
        }
        entity.setCreatedDate(detail.getTimestamp());
        if (detail.getIssuer() != null) {
            entity.setIssuerIdentityId(detail.getIssuer().getTechnicalId());
        } else if (detail.getIssuerId() > 0L) {
            entity.setIssuerIdentityId(detail.getIssuerId());
        }
        return entity;
    }
}

