/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.plugin;

import io.meeds.gamification.service.ProgramService;
import io.meeds.portal.plugin.AclPlugin;
import jakarta.annotation.PostConstruct;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.Identity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProgramAclPlugin
implements AclPlugin {
    public static final String OBJECT_TYPE = "program";
    @Autowired
    private ProgramService programService;
    @Autowired
    private PortalContainer container;

    @PostConstruct
    public void init() {
        ((UserACL)this.container.getComponentInstanceOfType(UserACL.class)).addAclPlugin((AclPlugin)this);
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean hasPermission(String objectId, String permissionType, Identity identity) {
        String username = identity == null ? null : identity.getUserId();
        return switch (permissionType) {
            case "VIEW" -> this.programService.canViewProgram(Long.parseLong(objectId), username);
            case "EDIT", "DELETE" -> this.programService.canEditProgram(Long.parseLong(objectId), username);
            default -> false;
        };
    }
}

