/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.hateoas.TemplateVariable;
import org.springframework.hateoas.server.core.UriTemplateFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriTemplate;

public class UriMapping {
    private final String mapping;
    private final MappingVariables variables;

    @Nullable
    public static UriMapping of(@Nullable String source) {
        if (source == null) {
            return null;
        }
        UriTemplate template = UriTemplateFactory.templateFor(source);
        MappingVariables mappingVariables = new MappingVariables(template);
        if (source.contains("{*")) {
            source = new PathCapturingMappingPreparer(mappingVariables).apply(source);
        }
        return new UriMapping(source, new MappingVariables(template));
    }

    private UriMapping(String mapping, MappingVariables variables) {
        Assert.notNull((Object)mapping, (String)"Mapping must not be null!");
        Assert.notNull((Object)variables, (String)"MappingVariables must not be null!");
        this.mapping = mapping;
        this.variables = variables;
    }

    public String getMapping() {
        return this.mapping;
    }

    MappingVariables getMappingVariables() {
        return this.variables;
    }

    static class MappingVariables
    implements Iterable<MappingVariable> {
        private final List<MappingVariable> variables;

        public MappingVariables(UriTemplate template) {
            this.variables = template.getVariableNames().stream().map(MappingVariable::of).collect(Collectors.toList());
        }

        public boolean hasCapturingVariable() {
            return this.variables.stream().anyMatch(it -> it.isCapturing());
        }

        public MappingVariable getVariable(String name) {
            Assert.hasText((String)name, (String)"Variable must not be null or empty!");
            return this.variables.stream().filter(it -> it.hasName(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("No variable named " + name + " found!"));
        }

        @Override
        public Iterator<MappingVariable> iterator() {
            return this.variables.iterator();
        }
    }

    private static class PathCapturingMappingPreparer
    implements Function<String, String> {
        private static final Pattern PATH_CAPTURE = Pattern.compile("\\/\\{\\*(\\w+)\\}");
        private final MappingVariables variables;

        public PathCapturingMappingPreparer(MappingVariables variables) {
            Assert.notNull((Object)variables, (String)"MappingVariables must not be null!");
            this.variables = variables;
        }

        @Override
        public String apply(String source) {
            Matcher matcher = PATH_CAPTURE.matcher(source);
            while (matcher.find()) {
                MappingVariable variable = this.variables.getVariable(matcher.group(1));
                source = source.replace(matcher.group(0), variable.getPlaceholder());
            }
            return source;
        }
    }

    static class MappingVariable {
        private final String name;
        private final boolean composite;

        public static MappingVariable of(String source) {
            Assert.hasText((String)source, (String)"Variable source must not be null or empty!");
            return source.startsWith("*") ? new MappingVariable(source.substring(1), true) : new MappingVariable(source, false);
        }

        private MappingVariable(String name, boolean composite) {
            this.name = name;
            this.composite = composite;
        }

        public boolean hasName(String candidate) {
            return this.name.equals(candidate);
        }

        public boolean isCapturing() {
            return this.composite;
        }

        public String getKey() {
            return this.composite ? "__composite-" + this.name + "__" : this.name;
        }

        public String getPlaceholder() {
            return "{" + this.getKey() + "}";
        }

        public TemplateVariable toSegment() {
            return TemplateVariable.segment(this.name);
        }

        public Object getAbsentValue() {
            return this.composite ? TemplateVariable.segment(this.name).composite().toString() : UriComponents.UriTemplateVariables.SKIP_VALUE;
        }
    }
}

