/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.lifecycle;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.picocontainer.Startable;

public class LifeCycleCompletionService
implements Startable {
    private static final String THREAD_NUMBER_KEY = "thread-number";
    private static final String ASYNC_EXECUTION_KEY = "async-execution";
    private static final int DEFAULT_THREAD_NUMBER = 1;
    private static final boolean DEFAULT_ASYNC_EXECUTION = true;
    private ExecutorService executor;
    private ExecutorCompletionService ecs;
    private int configThreadNumber;
    private boolean configAsyncExecution;

    public LifeCycleCompletionService(InitParams params) {
        ValueParam threadNumber = params == null ? null : params.getValueParam(THREAD_NUMBER_KEY);
        ValueParam asyncExecution = params == null ? null : params.getValueParam(ASYNC_EXECUTION_KEY);
        this.configThreadNumber = threadNumber == null ? 1 : Integer.valueOf(threadNumber.getValue());
        this.configAsyncExecution = asyncExecution == null ? true : Boolean.valueOf(asyncExecution.getValue());
        this.executor = Executors.newFixedThreadPool(this.configThreadNumber);
        this.ecs = new ExecutorCompletionService(this.executor);
    }

    public void stop() {
        this.executor.shutdown();
    }

    public void addTask(Callable callable) {
        this.ecs.submit(callable);
    }

    public void waitCompletionFinished() {
        this.executor.awaitTermination(1L, TimeUnit.SECONDS);
    }

    public boolean isAsync() {
        return this.configAsyncExecution;
    }

    public long getActiveTaskCount() {
        ExecutorService executorService = this.executor;
        if (executorService instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executorService;
            return threadPoolExecutor.getActiveCount();
        }
        return 0L;
    }

    public void waitAllTaskFinished(long timeout) {
        long start = System.currentTimeMillis();
        while (this.getActiveTaskCount() != 0L && System.currentTimeMillis() - start <= timeout) {
            Thread.sleep(100L);
        }
    }
}

