/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.services.organization.listener;

import java.util.Objects;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;

public class IdentityRegistryMembershipListener
extends MembershipEventListener {
    private IdentityRegistry identityRegistry;

    public IdentityRegistryMembershipListener(IdentityRegistry identityRegistry) {
        this.identityRegistry = identityRegistry;
    }

    public void postDelete(Membership membership) throws Exception {
        Identity identity = this.identityRegistry.getIdentity(membership.getUserName());
        if (identity != null) {
            MembershipEntry membershipEntry = this.toMembershipEntry(membership);
            identity.getMemberships().removeIf(m -> Objects.equals(m, membershipEntry));
        }
    }

    public void postSave(Membership membership, boolean isNew) throws Exception {
        Identity identity = this.identityRegistry.getIdentity(membership.getUserName());
        if (identity != null) {
            MembershipEntry membershipEntry = this.toMembershipEntry(membership);
            if (identity.getMemberships().stream().noneMatch(m -> m.equals((Object)membershipEntry))) {
                identity.getMemberships().add(membershipEntry);
            }
        }
    }

    private MembershipEntry toMembershipEntry(Membership membership) {
        return new MembershipEntry(membership.getGroupId(), membership.getMembershipType());
    }
}

