/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.api.notification.plugin.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class TemplateConfig {
    public static final String DEFAULT_SRC_RESOURCE_BUNDLE_KEY = "locale.notification.template.Notification";
    public static final String DEFAULT_SRC_RESOURCE_TEMPLATE_KEY = "war:/notification/templates";
    public static final String SUBJECT_KEY = "subject";
    public static final String DIGEST_KEY = "digest";
    public static final String DIGEST_ONE_KEY = "digest.one";
    public static final String DIGEST_THREE_KEY = "digest.three";
    public static final String DIGEST_MORE_KEY = "digest.more";
    public static final String FOOTER_KEY = "footer";
    private String providerId;
    private String bundlePath = "locale.notification.template.Notification";
    private String templatePath;
    private Map<String, String> keyMapping = new HashMap<String, String>();

    public TemplateConfig() {
    }

    public TemplateConfig(String providerId) {
        this();
        this.providerId = providerId;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public TemplateConfig setProviderId(String providerId) {
        this.providerId = providerId;
        return this;
    }

    public String getBundlePath() {
        return this.bundlePath;
    }

    public void setBundlePath(String bundlePath) {
        this.bundlePath = bundlePath;
    }

    public String getTemplatePath() {
        if (this.templatePath == null) {
            this.templatePath = new StringBuffer(DEFAULT_SRC_RESOURCE_TEMPLATE_KEY).append("/").append(this.providerId).append(".gtmpl").toString();
        }
        return this.templatePath;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public Map<String, String> getKeyMapping() {
        return this.keyMapping;
    }

    public void setKeyMapping(Map<String, String> keyMapping) {
        this.keyMapping = keyMapping;
    }

    public TemplateConfig addKeyMapping(String key, String value) {
        this.keyMapping.put(key, value);
        return this;
    }

    public String getKeyValue(String key, String defaultValue) {
        if (this.keyMapping.containsKey(key)) {
            return this.keyMapping.get(key);
        }
        return defaultValue;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TemplateConfig) {
            return ((TemplateConfig)obj).getProviderId().equals(this.getProviderId());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.providerId);
    }
}

