/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.oauth.jaas;

import io.meeds.oauth.spi.OAuthProviderTypeRegistry;
import jakarta.servlet.http.HttpServletRequest;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.UsernameCredential;
import org.exoplatform.services.security.jaas.AbstractLoginModule;
import org.exoplatform.web.security.AuthenticationRegistry;
import org.gatein.sso.agent.tomcat.ServletAccess;

public class OAuthLoginModule
extends AbstractLoginModule {
    private static final Log LOG = ExoLogger.getLogger(OAuthLoginModule.class);

    protected Log getLogger() {
        return LOG;
    }

    public boolean login() throws LoginException {
        try {
            ExoContainer container = this.getContainer();
            OAuthProviderTypeRegistry oauthRegistry = (OAuthProviderTypeRegistry)container.getComponentInstanceOfType(OAuthProviderTypeRegistry.class);
            if (!oauthRegistry.isOAuthEnabled()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)"OAuth is disabled. Ignoring this login module");
                }
                return false;
            }
            HttpServletRequest servletRequest = ServletAccess.getRequest();
            if (servletRequest == null) {
                LOG.warn((Object)"HttpServletRequest is null. OAuthLoginModule will be ignored.");
                return false;
            }
            User portalUser = this.getOauthAuthenticatedUser(container, servletRequest);
            if (portalUser == null) {
                return false;
            }
            Callback[] callbacks = new Callback[]{new NameCallback("Username")};
            this.callbackHandler.handle(callbacks);
            String username = ((NameCallback)callbacks[0]).getName();
            boolean authenticated = StringUtils.equals((CharSequence)username, (CharSequence)portalUser.getUserName());
            if (authenticated) {
                this.establishSecurityContext(container, username);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new LoginException("OAuth login failed due to exception: " + e.getMessage());
        }
    }

    private User getOauthAuthenticatedUser(ExoContainer container, HttpServletRequest servletRequest) {
        AuthenticationRegistry authRegistry = (AuthenticationRegistry)container.getComponentInstanceOfType(AuthenticationRegistry.class);
        User portalUser = (User)authRegistry.getAttributeOfClient(servletRequest, "_authenticatedPortalUserForJaas");
        if (portalUser != null) {
            authRegistry.removeAttributeOfClient(servletRequest, "_authenticatedPortalUserForJaas");
        }
        return portalUser;
    }

    public boolean commit() throws LoginException {
        return true;
    }

    public boolean abort() throws LoginException {
        return true;
    }

    public boolean logout() throws LoginException {
        return true;
    }

    protected void establishSecurityContext(ExoContainer container, String username) throws Exception {
        Authenticator authenticator = (Authenticator)container.getComponentInstanceOfType(Authenticator.class);
        Identity identity = authenticator.createIdentity(username);
        this.sharedState.put("exo.security.identity", identity);
        this.sharedState.put("javax.security.auth.login.name", username);
        this.subject.getPublicCredentials().add(new UsernameCredential(username));
    }
}

