/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.model;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Base64;
import lombok.Generated;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;

public class UserPushSubscription {
    private String id;
    private String auth;
    private String key;
    private String endpoint;
    private String deviceType;

    public byte[] authAsBytes() {
        return Base64.getDecoder().decode(this.getAuth());
    }

    public byte[] keyAsBytes() {
        return Base64.getDecoder().decode(this.getKey());
    }

    public PublicKey userPublicKey() throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        KeyFactory kf = KeyFactory.getInstance("ECDH", "BC");
        ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)"secp256r1");
        ECPoint point = ecSpec.getCurve().decodePoint(this.keyAsBytes());
        ECPublicKeySpec pubSpec = new ECPublicKeySpec(point, (ECParameterSpec)ecSpec);
        return kf.generatePublic((KeySpec)pubSpec);
    }

    @Generated
    public UserPushSubscription() {
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getAuth() {
        return this.auth;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getEndpoint() {
        return this.endpoint;
    }

    @Generated
    public String getDeviceType() {
        return this.deviceType;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setAuth(String auth) {
        this.auth = auth;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @Generated
    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserPushSubscription)) {
            return false;
        }
        UserPushSubscription other = (UserPushSubscription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$auth = this.getAuth();
        String other$auth = other.getAuth();
        if (this$auth == null ? other$auth != null : !this$auth.equals(other$auth)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        String this$deviceType = this.getDeviceType();
        String other$deviceType = other.getDeviceType();
        return !(this$deviceType == null ? other$deviceType != null : !this$deviceType.equals(other$deviceType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UserPushSubscription;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $auth = this.getAuth();
        result = result * 59 + ($auth == null ? 43 : $auth.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        String $deviceType = this.getDeviceType();
        result = result * 59 + ($deviceType == null ? 43 : $deviceType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "UserPushSubscription(id=" + this.getId() + ", auth=" + this.getAuth() + ", key=" + this.getKey() + ", endpoint=" + this.getEndpoint() + ", deviceType=" + this.getDeviceType() + ")";
    }
}

