/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.jsr168.api;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletMode;
import javax.portlet.RenderResponse;
import org.gatein.common.net.media.MediaType;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.cache.CacheControl;
import org.gatein.pc.api.info.CapabilitiesInfo;
import org.gatein.pc.api.info.ModeInfo;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.RenderInvocation;
import org.gatein.pc.api.invocation.response.ContentResponse;
import org.gatein.pc.api.invocation.response.FragmentResponse;
import org.gatein.pc.api.invocation.response.ResponseProperties;
import org.gatein.pc.portlet.impl.info.ContainerPortletInfo;
import org.gatein.pc.portlet.impl.jsr168.api.MimeResponseImpl;
import org.gatein.pc.portlet.impl.jsr168.api.PortletRequestImpl;

public class RenderResponseImpl
extends MimeResponseImpl
implements RenderResponse {
    protected Set<Mode> responseNextModes = null;
    protected String responseTitle = null;

    public RenderResponseImpl(RenderInvocation invocation, PortletRequestImpl preq) {
        super((PortletInvocation)invocation, preq);
    }

    public void setTitle(String title) {
        this.responseTitle = title;
    }

    public void setNextPossiblePortletModes(Collection<PortletMode> portletModes) {
        if (portletModes != null && portletModes.size() > 0) {
            if (this.responseNextModes == null) {
                this.responseNextModes = new LinkedHashSet<Mode>(portletModes.size());
            } else {
                this.responseNextModes.clear();
            }
            for (PortletMode portletMode : portletModes) {
                Mode mode;
                if (portletMode == null || !this.preq.supportedModes.contains(mode = Mode.create((String)portletMode.toString()))) continue;
                this.responseNextModes.add(mode);
            }
        }
    }

    @Override
    public void setContentType(String contentType) {
        int index = contentType.indexOf(59);
        if (index != -1) {
            contentType = contentType.substring(0, index);
        }
        Mode currentMode = this.preq.invocation.getMode();
        MediaType mediaType = MediaType.create((String)contentType);
        ContainerPortletInfo info = this.preq.container.getInfo();
        CapabilitiesInfo capabilities = info.getCapabilities();
        Set compatibleModes = capabilities.getModes(mediaType);
        for (ModeInfo modeInfo : compatibleModes) {
            if (!currentMode.equals((Object)modeInfo.getMode())) continue;
            super.setContentType(contentType);
            return;
        }
        throw new IllegalArgumentException("Mime type " + contentType + " not accepted as content type");
    }

    public String getCharacterEncoding() {
        return ((RenderInvocation)this.invocation).getEncoding();
    }

    @Override
    protected ContentResponse createResponse(ResponseProperties props, Map<String, Object> attrs, String contentType, byte[] bytes, CacheControl cacheControl) {
        return new FragmentResponse(props, attrs, contentType, null, bytes, this.responseTitle, cacheControl, this.responseNextModes != null ? this.responseNextModes : this.preq.supportedModes);
    }

    @Override
    protected ContentResponse createResponse(ResponseProperties props, Map<String, Object> attrs, String contentType, String chars, CacheControl cacheControl) {
        return new FragmentResponse(props, attrs, contentType, null, chars, this.responseTitle, cacheControl, this.responseNextModes != null ? this.responseNextModes : this.preq.supportedModes);
    }

    @Override
    protected ContentResponse createResponse(ResponseProperties props, Map<String, Object> attrs, String contentType, CacheControl cacheControl) {
        return new FragmentResponse(props, attrs, contentType, this.responseTitle, cacheControl, this.responseNextModes != null ? this.responseNextModes : this.preq.supportedModes);
    }
}

