/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.twitter.gamification.rest.builder;

import io.meeds.twitter.gamification.model.RemoteTwitterAccount;
import io.meeds.twitter.gamification.model.TokenStatus;
import io.meeds.twitter.gamification.model.TwitterAccount;
import io.meeds.twitter.gamification.rest.model.TwitterAccountRestEntity;
import io.meeds.twitter.gamification.service.TwitterConsumerService;
import io.meeds.twitter.gamification.service.TwitterService;
import org.springframework.data.domain.Page;

public class TwitterAccountBuilder {
    private TwitterAccountBuilder() {
    }

    public static TwitterAccountRestEntity toRestEntity(String twitterBearerToken, TokenStatus tokenStatus, TwitterConsumerService twitterConsumerService, TwitterAccount twitterAccount) {
        if (twitterAccount == null) {
            return null;
        }
        RemoteTwitterAccount remoteTwitterAccount = null;
        if (Boolean.TRUE.equals(tokenStatus != null && tokenStatus.getIsValid() != null && tokenStatus.getIsValid() != false) && tokenStatus.getRemaining() > 0L) {
            remoteTwitterAccount = twitterConsumerService.retrieveTwitterAccount(twitterAccount.getRemoteId(), twitterBearerToken);
        }
        return new TwitterAccountRestEntity(twitterAccount.getId(), String.valueOf(twitterAccount.getRemoteId()), twitterAccount.getIdentifier(), remoteTwitterAccount != null ? remoteTwitterAccount.getName() : twitterAccount.getName(), twitterAccount.getWatchedDate(), twitterAccount.getWatchedBy(), twitterAccount.getUpdatedDate(), twitterAccount.getRefreshDate(), remoteTwitterAccount != null ? remoteTwitterAccount.getDescription() : null, remoteTwitterAccount != null ? remoteTwitterAccount.getAvatarUrl() : null);
    }

    public static Page<TwitterAccountRestEntity> toRestEntities(TwitterService twitterAccountService, TwitterConsumerService twitterConsumerService, Page<TwitterAccount> twitterAccounts) {
        String twitterBearerToken = twitterAccountService.getTwitterBearerToken();
        TokenStatus tokenStatus = twitterConsumerService.checkTwitterTokenStatus(twitterBearerToken);
        return twitterAccounts.map(twitterAccount -> TwitterAccountBuilder.toRestEntity(twitterBearerToken, tokenStatus, twitterConsumerService, twitterAccount));
    }
}

