/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.core.spi;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.management.api.ExternalContext;
import org.gatein.management.api.ManagedUser;
import org.gatein.management.api.PathAddress;
import org.gatein.management.api.RuntimeContext;
import org.gatein.management.api.annotations.Managed;
import org.gatein.management.api.annotations.ManagedContext;
import org.gatein.management.api.annotations.ManagedOperation;
import org.gatein.management.api.annotations.ManagedRole;
import org.gatein.management.api.annotations.MappedAttribute;
import org.gatein.management.api.annotations.MappedPath;
import org.gatein.management.api.binding.Marshaller;
import org.gatein.management.api.exceptions.InvalidDataException;
import org.gatein.management.api.exceptions.NotAuthorizedException;
import org.gatein.management.api.exceptions.OperationException;
import org.gatein.management.api.exceptions.ResourceExistsException;
import org.gatein.management.api.exceptions.ResourceNotFoundException;
import org.gatein.management.api.model.ModelProvider;
import org.gatein.management.api.model.ModelValue;
import org.gatein.management.api.operation.OperationAttachment;
import org.gatein.management.api.operation.OperationAttributes;
import org.gatein.management.api.operation.OperationContext;
import org.gatein.management.api.operation.OperationHandler;
import org.gatein.management.api.operation.ResultHandler;
import org.gatein.management.api.operation.model.NoResultModel;
import org.gatein.management.core.api.AbstractManagedResource;
import org.gatein.management.core.api.model.DmrModelValue;
import org.gatein.management.core.spi.AnnotatedResource;

class AnnotatedOperation
implements OperationHandler {
    private static final Logger log = LoggerFactory.getLogger((String)"org.gatein.management.core.spi");
    private final AnnotatedResource owner;
    final Method method;
    private final String methodName;
    private final String managedRole;

    public AnnotatedOperation(AnnotatedResource owner, Method method) {
        this.owner = owner;
        this.method = method;
        this.methodName = this.getName();
        ManagedRole role = method.getAnnotation(ManagedRole.class);
        this.managedRole = role == null ? null : role.value();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void registerOperation(AbstractManagedResource managedResource) {
        Class<?> returnType;
        Managed subManaged;
        boolean debug;
        AbstractManagedResource resource = AnnotatedResource.registerOrGetResource(managedResource, this.method.getAnnotation(Managed.class));
        ManagedOperation mo = this.method.getAnnotation(ManagedOperation.class);
        String operationName = "read-resource";
        String desc = "";
        if (mo != null) {
            operationName = mo.name();
            desc = mo.description();
        }
        if (debug = log.isDebugEnabled()) {
            log.debug((Object)("Registering operation " + operationName + " for path " + resource.getPath()));
        }
        if ((subManaged = (returnType = this.method.getReturnType()).getAnnotation(Managed.class)) != null) {
            if (!"".equals(subManaged.value())) throw new RuntimeException("Cannot register method " + this.methodName + " for class " + this.owner.managedClass.getName() + " because return type " + returnType.getName() + " is annotated with a value for the @" + Managed.class.getSimpleName() + " annotation.");
            AnnotatedResource ar = new AnnotatedResource(returnType, this.owner, this);
            ar.register(resource);
            return;
        } else {
            resource.registerOperationHandler(operationName, this, AnnotatedResource.description(desc));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(OperationContext operationContext, ResultHandler resultHandler) throws ResourceNotFoundException, OperationException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Executing operation handler for annotated method %s for address %s", this.methodName, operationContext.getAddress()));
        }
        if (!AnnotatedOperation.isAuthorized(operationContext.getExternalContext(), this.managedRole, this.owner.managedRole)) {
            throw new NotAuthorizedException(operationContext.getUser(), operationContext.getOperationName());
        }
        this.invokeBefore(operationContext);
        try {
            Object result = this.invokeOperation(operationContext);
            if (this.method.getReturnType() == Void.TYPE) {
                resultHandler.completed((Object)NoResultModel.INSTANCE);
            } else {
                if (result == null) {
                    log.error((Object)("Result returned was null and method " + this.methodName + " for managed component " + this.owner.managedClass + " is not void."));
                    throw new ResourceNotFoundException("Resource not found.");
                }
                resultHandler.completed(result);
            }
        }
        finally {
            this.invokeAfter(operationContext);
        }
    }

    Object invokeOperation(OperationContext context) {
        return this.invokeMethod(context, this.owner.getInstance(context), this.method);
    }

    private void invokeBefore(OperationContext context) {
        if (this.owner.parent != null && this.owner.operation != null) {
            this.owner.operation.invokeBefore(context);
        }
        Object instance = this.owner.getInstance(context);
        if (this.owner.beforeMethod != null && instance != null) {
            this.invokeMethod(context, instance, this.owner.beforeMethod);
        }
    }

    private void invokeAfter(OperationContext context) {
        Object instance = this.owner.getInstance(context);
        if (this.owner.afterMethod != null && instance != null) {
            this.invokeMethod(context, instance, this.owner.afterMethod);
        }
        this.owner.discardInstance();
        if (this.owner.parent != null && this.owner.operation != null) {
            this.owner.operation.invokeAfter(context);
        }
    }

    private Object invokeMethod(OperationContext context, Object instance, Method method) {
        if (method == null || instance == null) {
            return null;
        }
        Object[] params = AnnotatedOperation.getParameters(context, method, AnnotatedOperation.getName(method), this.owner.managedClass);
        try {
            return method.invoke(instance, params);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot access method " + this.method + " on object " + instance, e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof ResourceNotFoundException) {
                throw (ResourceNotFoundException)e.getCause();
            }
            if (e.getCause() instanceof ResourceExistsException) {
                throw (ResourceExistsException)e.getCause();
            }
            if (e.getCause() instanceof OperationException) {
                throw (OperationException)e.getCause();
            }
            if (e.getCause() instanceof InvalidDataException) {
                throw (InvalidDataException)e.getCause();
            }
            throw new RuntimeException("Could not invoke method " + this.method + " on object " + instance, e);
        }
    }

    private static boolean isAuthorized(ExternalContext context, String operationRole, String resourceRole) {
        if (operationRole != null) {
            return context.isUserInRole(operationRole);
        }
        return resourceRole == null || context.isUserInRole(resourceRole);
    }

    private static Object[] getParameters(OperationContext operationContext, Method method, String methodName, Class<?> managedClass) {
        boolean debug = log.isDebugEnabled();
        String operationName = operationContext.getOperationName();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Object[] params = new Object[parameterAnnotations.length];
        OperationAttachment attachment = null;
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            MappedPath pathTemplate = AnnotatedOperation.getAnnotation(parameterAnnotations[i], MappedPath.class);
            if (pathTemplate != null) {
                params[i] = operationContext.getAddress().resolvePathTemplate(pathTemplate.value());
                if (!debug) continue;
                log.debug((Object)("Resolved path template " + pathTemplate.value() + "=" + params[i]));
                continue;
            }
            MappedAttribute managedAttribute = AnnotatedOperation.getAnnotation(parameterAnnotations[i], MappedAttribute.class);
            if (managedAttribute != null) {
                if (List.class == method.getParameterTypes()[i]) {
                    params[i] = operationContext.getAttributes().getValues(managedAttribute.value());
                } else if (String.class == method.getParameterTypes()[i]) {
                    params[i] = operationContext.getAttributes().getValue(managedAttribute.value());
                } else {
                    throw new RuntimeException("The parameter type " + method.getParameterTypes()[i] + " cannot be annotated by @" + MappedAttribute.class.getName() + ". Only List<String> and String are allowed.");
                }
                if (!debug) continue;
                log.debug((Object)("Resolved attribute " + managedAttribute.value() + "=" + params[i]));
                continue;
            }
            if (AnnotatedOperation.getAnnotation(parameterAnnotations[i], ManagedContext.class) != null) {
                Class<?> parameterType = method.getParameterTypes()[i];
                if (RuntimeContext.class == parameterType) {
                    params[i] = operationContext.getRuntimeContext();
                    continue;
                }
                if (PathAddress.class == parameterType) {
                    params[i] = operationContext.getAddress();
                    continue;
                }
                if (OperationAttributes.class == parameterType) {
                    params[i] = operationContext.getAttributes();
                    continue;
                }
                if (ManagedUser.class == parameterType) {
                    params[i] = operationContext.getUser();
                    continue;
                }
                if (ModelValue.class.isAssignableFrom(parameterType)) {
                    attachment = operationContext.getAttachment(true);
                    if (attachment != null) {
                        try {
                            params[i] = DmrModelValue.readFromJsonStream(attachment.getStream());
                            continue;
                        }
                        catch (IOException e) {
                            log.error((Object)"IOException reading from JSON stream for detyped model.", (Throwable)e);
                            throw new OperationException(operationName, "Could not properly read data stream. See log for more details.", (Throwable)e);
                        }
                    }
                    throw new OperationException(operationName, "Data stream not available.");
                }
                if (ModelProvider.class.isAssignableFrom(parameterType)) {
                    Class<?> type = parameterType;
                    params[i] = operationContext.newModel(type);
                    continue;
                }
                if (OperationContext.class != parameterType) continue;
                params[i] = operationContext;
                continue;
            }
            Class<?> marshalClass = method.getParameterTypes()[i];
            if (debug) {
                log.debug((Object)("Encountered unannotated parameter. Will try and find marshaller for type " + marshalClass));
            }
            if (attachment != null) {
                throw new RuntimeException("Cannot unmarshal " + marshalClass + " for method " + methodName + " and component " + managedClass.getName() + ". This is because input stream was already consumed. " + "This can happen if the marshaled type is not declared before @ManagedContext for detyped ModelValue type.");
            }
            Marshaller marshaller = operationContext.getBindingProvider().getMarshaller(marshalClass, operationContext.getContentType());
            if (marshaller != null) {
                attachment = operationContext.getAttachment(true);
                if (attachment == null) {
                    throw new OperationException(operationName, "No attachment was found for this operation.");
                }
                params[i] = marshaller.unmarshal(attachment.getStream());
                if (!debug) continue;
                log.debug((Object)("Successfully unmarshaled object of type " + marshalClass));
                continue;
            }
            throw new RuntimeException("Could not find marshaller for " + marshalClass + " and therefore cannot pass parameter of this type to method " + methodName + " for component " + managedClass.getName());
        }
        return params;
    }

    private String getName() {
        return AnnotatedOperation.getName(this.method);
    }

    private static String getName(Method method) {
        String name = method.getName();
        StringBuilder sb = new StringBuilder();
        sb.append(name).append("(");
        Class<?>[] parameters = method.getParameterTypes();
        for (int i = 0; i < parameters.length; ++i) {
            sb.append(parameters[i].getName());
            if (i == parameters.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    private static <A extends Annotation> A getAnnotation(Annotation[] annotations, Class<A> type) {
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != type) continue;
            return (A)((Annotation)type.cast(annotation));
        }
        return null;
    }
}

