/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.metamask.web;

import io.meeds.tenant.metamask.web.BaseMetamaskExtension;
import jakarta.servlet.http.HttpSession;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.api.settings.ExoFeatureService;
import org.exoplatform.web.ControllerContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MetamaskLoginExtension
extends BaseMetamaskExtension {
    private static final String METAMASK_LOGIN = "metamaskLogin";
    @Autowired
    protected ExoFeatureService exoFeatureService;

    public List<String> getExtensionNames() {
        return Collections.singletonList("LoginExtension");
    }

    public Map<String, Object> extendParameters(ControllerContext controllerContext, String extensionName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("metamaskEnabled", this.exoFeatureService.isActiveFeature(METAMASK_LOGIN));
        HttpSession httpSession = controllerContext.getRequest().getSession(true);
        params.put("rawMessage", this.metamaskLoginService.generateLoginMessage(httpSession));
        this.addDeedTenantParameters(httpSession, params);
        return params;
    }
}

