/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.perkstore.listener;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.perkstore.model.Product;
import org.exoplatform.perkstore.service.PerkStoreService;
import org.exoplatform.perkstore.service.utils.NotificationUtils;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;

@Asynchronous
public class ProductNotificationListener
extends Listener<Product, Boolean> {
    private ExoContainer container;
    private PerkStoreService perkStoreService;

    public ProductNotificationListener(ExoContainer container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<Product, Boolean> event) throws Exception {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            Product product = (Product)event.getSource();
            if (!product.isEnabled()) {
                return;
            }
            boolean isNew = (Boolean)event.getData();
            NotificationContext ctx = NotificationContextImpl.cloneInstance();
            ctx.append(NotificationUtils.SETTINGS_PARAMETER, (Object)this.getPerkStoreService().getGlobalSettings());
            ctx.append(NotificationUtils.PRODUCT_PARAMETER, (Object)product);
            ctx.append(NotificationUtils.PRODUCT_IS_NEW_PARAMETER, (Object)isNew);
            String pluginId = isNew ? "ProductAddedNotificationPlugin" : "ProductModifiedNotificationPlugin";
            ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)pluginId))).execute(ctx);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private PerkStoreService getPerkStoreService() {
        if (this.perkStoreService == null) {
            this.perkStoreService = (PerkStoreService)this.container.getComponentInstanceOfType(PerkStoreService.class);
        }
        return this.perkStoreService;
    }
}

