/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;

public class MentionUtils {
    private static final String DEFAULT_TITLE_TEMPLATE_PARAM = "default_title";
    private static final String COMMENT_TEMPLATE_PARAM = "comment";
    private static final Log LOG = ExoLogger.getLogger(MentionUtils.class);
    private static final Pattern USER_MENTION_PATTERN = Pattern.compile("@((?![\\s<>/%'\"=])[\\p{ASCII}])+([<\\s]|$)");
    private static final Pattern ROLE_MENTION_PATTERN = Pattern.compile("@((?![\\s<>/%'\"=])[\\p{ASCII}])+:(\\d+)([<\\s]|$)");
    private static IdentityManager identityManager;

    private MentionUtils() {
    }

    public static Set<String> getMentionedUsernames(String message) {
        if (message == null || message.trim().isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> usernames = new HashSet<String>();
        Matcher matcher = USER_MENTION_PATTERN.matcher(message);
        while (matcher.find()) {
            String username = matcher.group().substring(1).trim();
            if (username.endsWith("<")) {
                String string = username = username.length() > 1 ? username.substring(0, username.length() - 1) : "";
            }
            if (StringUtils.isBlank((CharSequence)username) || !MentionUtils.isUserEnabled(username)) continue;
            usernames.add(username);
        }
        return usernames;
    }

    public static Set<String> getMentionedRoles(String message, String identityId) {
        if (message == null || message.trim().isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> roles = new HashSet<String>();
        Matcher matcher = ROLE_MENTION_PATTERN.matcher(message);
        while (matcher.find()) {
            String[] roleParts = matcher.group().substring(1).trim().split(":");
            String role = roleParts[0];
            String groupIdentityId = roleParts[1];
            if (role.endsWith("<")) {
                String string = role = role.length() > 1 ? role.substring(0, role.length() - 1) : "";
            }
            if (StringUtils.isBlank((CharSequence)role) || !StringUtils.equals((CharSequence)identityId, (CharSequence)groupIdentityId)) continue;
            roles.add(role);
        }
        return roles;
    }

    public static String substituteUsernames(String message) {
        return MentionUtils.substituteUsernames(MentionUtils.getIdentityManager(), null, message, null);
    }

    public static String substituteUsernames(String message, Locale locale) {
        return MentionUtils.substituteUsernames(MentionUtils.getIdentityManager(), null, message, locale);
    }

    public static String substituteUsernames(String portalOwner, String message) {
        return MentionUtils.substituteUsernames(MentionUtils.getIdentityManager(), portalOwner, message, null);
    }

    public static String substituteUsernames(String portalOwner, String message, Locale locale) {
        return MentionUtils.substituteUsernames(MentionUtils.getIdentityManager(), portalOwner, message, locale);
    }

    public static void substituteUsernames(ExoSocialActivity activity, String portalOwner) {
        MentionUtils.substituteUsernames(activity, MentionUtils.getTemplateParamKeysToFilter(activity), portalOwner);
    }

    public static void substituteUsernames(ExoSocialActivity activity, List<String> templateParamKeys, String portalOwner) {
        activity.setTitle(MentionUtils.substituteUsernames(portalOwner, activity.getTitle()));
        activity.setBody(MentionUtils.substituteUsernames(portalOwner, activity.getBody()));
        Map templateParams = activity.getTemplateParams();
        if (MapUtils.isNotEmpty((Map)templateParams)) {
            for (String key2 : templateParamKeys) {
                templateParams.put(key2, MentionUtils.substituteUsernames(portalOwner, (String)templateParams.get(key2)));
            }
            templateParams.computeIfPresent(COMMENT_TEMPLATE_PARAM, (key, value) -> MentionUtils.substituteUsernames(portalOwner, value));
            templateParams.computeIfPresent(DEFAULT_TITLE_TEMPLATE_PARAM, (key, value) -> MentionUtils.substituteUsernames(portalOwner, value));
        }
    }

    public static String substituteUsernames(IdentityManager identityManager, String portalOwner, String message) {
        return MentionUtils.substituteUsernames(identityManager, portalOwner, message, null);
    }

    public static String substituteUsernames(IdentityManager identityManager, String portalOwner, String message, Locale locale) {
        if (message == null || message.trim().isEmpty()) {
            return message;
        }
        Matcher matcher = USER_MENTION_PATTERN.matcher(message);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            String username = matcher.group().substring(1).trim();
            if (username.endsWith("<")) {
                String string = username = username.length() > 1 ? username.substring(0, username.length() - 1) : "";
            }
            if (StringUtils.isBlank((CharSequence)username)) continue;
            MentionUtils.appendUsernameReplacement(identityManager, matcher, buf, username, portalOwner);
        }
        if (buf.length() > 0) {
            matcher.appendTail(buf);
            message = buf.toString().trim();
        }
        return MentionUtils.substituteRoles(identityManager, message, locale);
    }

    public static String substituteRoles(IdentityManager identityManager, String message, Locale locale) {
        if (StringUtils.isBlank((CharSequence)message)) {
            return message;
        }
        Matcher matcher = ROLE_MENTION_PATTERN.matcher(message);
        String identityId = null;
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            String[] roleParts = matcher.group().substring(1).trim().split(":");
            String role = roleParts[0];
            identityId = roleParts[1];
            if (role.endsWith("<")) {
                role = role.length() > 1 ? role.substring(0, role.length() - 1) : "";
            }
            Identity identity = identityManager.getIdentity(Long.parseLong(identityId));
            if (StringUtils.isBlank((CharSequence)role) || !MentionUtils.isIdentityEnabled(identity)) continue;
            MentionUtils.appendRoleReplacement(matcher, buf, role, identityId, locale);
        }
        if (buf.length() > 0) {
            matcher.appendTail(buf);
            message = buf.toString().trim();
        }
        return message;
    }

    public static void substituteRoleWithLocale(ExoSocialActivity activity, Locale locale) {
        activity.setTitle(MentionUtils.substituteRoleWithLocale(activity.getTitle(), locale));
        activity.setBody(MentionUtils.substituteRoleWithLocale(activity.getBody(), locale));
        Map templateParams = activity.getTemplateParams();
        if (MapUtils.isNotEmpty((Map)templateParams)) {
            templateParams.computeIfPresent(COMMENT_TEMPLATE_PARAM, (key, value) -> MentionUtils.substituteRoleWithLocale(value, locale));
            templateParams.computeIfPresent(DEFAULT_TITLE_TEMPLATE_PARAM, (key, value) -> MentionUtils.substituteRoleWithLocale(value, locale));
            List<String> templateParamKeys = MentionUtils.getTemplateParamKeysToFilter(activity);
            if (MapUtils.isNotEmpty((Map)templateParams)) {
                for (String key2 : templateParamKeys) {
                    templateParams.computeIfPresent(key2, (mapKey, value) -> MentionUtils.substituteRoleWithLocale(value, locale));
                }
            }
        }
    }

    public static String substituteRoleWithLocale(String message, Locale locale) {
        if (StringUtils.isNotBlank((CharSequence)message) && locale != null && !LinkProvider.getDefaultLocale().equals(locale)) {
            Locale defaultLocale = LinkProvider.getDefaultLocale();
            message = message.replace(LinkProvider.getGroupRoleLabel("member", defaultLocale), LinkProvider.getGroupRoleLabel("member", locale));
            message = message.replace(LinkProvider.getGroupRoleLabel("manager", defaultLocale), LinkProvider.getGroupRoleLabel("manager", locale));
            message = message.replace(LinkProvider.getGroupRoleLabel("redactor", defaultLocale), LinkProvider.getGroupRoleLabel("redactor", locale));
            message = message.replace(LinkProvider.getGroupRoleLabel("publisher", defaultLocale), LinkProvider.getGroupRoleLabel("publisher", locale));
        }
        return message;
    }

    private static void appendUsernameReplacement(IdentityManager identityManager, Matcher matcher, StringBuffer buf, String username, String portalOwner) {
        try {
            Identity identity = identityManager.getOrCreateUserIdentity(username);
            if (identity == null || identity.isDeleted() || !identity.isEnable()) {
                return;
            }
            String profileLink = LinkProvider.getProfileLink(username, portalOwner);
            if (StringUtils.isNotBlank((CharSequence)profileLink)) {
                matcher.appendReplacement(buf, profileLink + " ");
            }
        }
        catch (Exception e) {
            LOG.warn("Error while retrieving link for profile of user {}", new Object[]{username, e});
        }
    }

    private static void appendRoleReplacement(Matcher matcher, StringBuffer buf, String role, String identityId, Locale locale) {
        try {
            String roleLink = LinkProvider.getGroupRoleLink(role, identityId, locale);
            if (StringUtils.isNotBlank((CharSequence)roleLink)) {
                matcher.appendReplacement(buf, roleLink + " ");
            }
        }
        catch (Exception e) {
            LOG.warn("Error while retrieving link for role {} ans pace with identity id {}", new Object[]{role, identityId, e});
        }
    }

    private static boolean isUserEnabled(String username) {
        Identity identity = MentionUtils.getIdentityManager().getOrCreateUserIdentity(username);
        return MentionUtils.isIdentityEnabled(identity);
    }

    private static boolean isIdentityEnabled(Identity identity) {
        return identity != null && !identity.isDeleted() && identity.isEnable();
    }

    private static List<String> getTemplateParamKeysToFilter(ExoSocialActivity activity) {
        Map templateParams = activity.getTemplateParams();
        ArrayList<String> keys = new ArrayList<String>();
        if (templateParams != null && templateParams.containsKey("registeredKeysForProcessor")) {
            String[] templateParamKeys;
            for (String key : templateParamKeys = ((String)activity.getTemplateParams().get("registeredKeysForProcessor")).split("\\|")) {
                if (key.endsWith("\\")) {
                    key = key.replace("\\", "");
                }
                if (!templateParams.containsKey(key.replace("\\", ""))) continue;
                keys.add(key);
            }
        }
        return keys;
    }

    private static IdentityManager getIdentityManager() {
        if (identityManager == null) {
            identityManager = (IdentityManager)ExoContainerContext.getService(IdentityManager.class);
        }
        return identityManager;
    }
}

