/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.application.javascript;

import jakarta.servlet.ServletContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.javascript.DependencyDescriptor;
import org.exoplatform.web.application.javascript.Javascript;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.exoplatform.web.application.javascript.ScriptResourceDescriptor;
import org.gatein.portal.controller.resource.ResourceId;
import org.gatein.portal.controller.resource.script.ScriptResource;

public class JavascriptTask {
    private static final Log LOG = ExoLogger.getExoLogger(JavascriptTask.class);
    private static final boolean DEVELOPPING = PropertyManager.isDevelopping();
    private List<ScriptResourceDescriptor> descriptors = new ArrayList<ScriptResourceDescriptor>();

    public void execute(JavascriptConfigService javascriptService, ServletContext scontext) {
        for (ScriptResourceDescriptor desc : this.descriptors) {
            ScriptResource resource;
            String contextPath = scontext.getContextPath();
            if (CollectionUtils.isNotEmpty(desc.modules)) {
                contextPath = desc.modules.get(0).getContextPath();
            }
            if ((resource = javascriptService.getScriptGraph().addResource(desc.id, desc.fetchMode, desc.alias, desc.group, contextPath)) == null) continue;
            resource.setContextPath(contextPath);
            for (Javascript module : desc.modules) {
                module.addModuleTo(resource);
            }
            for (Locale locale : desc.getSupportedLocales()) {
                resource.addSupportedLocale(locale);
            }
            for (DependencyDescriptor dependency : desc.dependencies) {
                resource.addDependency(dependency.getResourceId(), dependency.getAlias(), dependency.getPluginResource());
            }
        }
    }

    public void addDescriptor(ScriptResourceDescriptor desc) {
        this.descriptors.add(desc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initJSModuleCache(JavascriptConfigService javascriptService, ResourceId resourceId) {
        ExoContainerContext.setCurrentContainer((ExoContainer)PortalContainer.getInstance());
        try {
            javascriptService.getScriptContent(resourceId.getScope(), resourceId.getName(), !DEVELOPPING);
        }
        catch (Exception e) {
            LOG.debug("Error while initializing cache of JS with id {}. Will reattempt in first portal request", new Object[]{resourceId, e});
        }
        finally {
            ExoContainerContext.setCurrentContainer(null);
        }
    }
}

