/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.core.ast.ReusableStructure;
import com.github.sommeri.less4j.core.compiler.expressions.ExpressionEvaluator;
import com.github.sommeri.less4j.core.compiler.expressions.GuardOnlyFunctions;
import com.github.sommeri.less4j.core.compiler.expressions.GuardValue;
import com.github.sommeri.less4j.core.compiler.scopes.IScope;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.LinkedList;
import java.util.List;

public class MixinsGuardsValidator {
    private final DefaultPoweredExpressionEvaluator ifDefaultExpressionEvaluator;
    private final DefaultPoweredExpressionEvaluator ifNotDefaultExpressionEvaluator;

    public MixinsGuardsValidator(IScope scope, ProblemsHandler problemsHandler, LessCompiler.Configuration configuration) {
        this.ifDefaultExpressionEvaluator = new DefaultPoweredExpressionEvaluator(scope, problemsHandler, configuration, true);
        this.ifNotDefaultExpressionEvaluator = new DefaultPoweredExpressionEvaluator(scope, problemsHandler, configuration, false);
    }

    public boolean guardsSatisfied(ReusableStructure mixin, boolean assumeDefault) {
        if (assumeDefault) {
            return this.ifDefaultExpressionEvaluator.guardsSatisfied(mixin);
        }
        return this.ifNotDefaultExpressionEvaluator.guardsSatisfied(mixin);
    }

    public GuardValue evaluateGuards(ReusableStructure mixin) {
        boolean ifDefaultGuardValue = this.guardsSatisfied(mixin, true);
        boolean ifNotDefaultGuardValue = this.guardsSatisfied(mixin, false);
        return this.toDefaultFunctionUse(ifDefaultGuardValue, ifNotDefaultGuardValue);
    }

    public GuardValue evaluateGuards(LinkedList<GuardValue> namespacesGuards, ReusableStructure mixin) {
        namespacesGuards.add(this.evaluateGuards(mixin));
        return this.andGuards(namespacesGuards);
    }

    private GuardValue toDefaultFunctionUse(boolean ifDefaultGuardValue, boolean ifNotDefaultGuardValue) {
        if (ifDefaultGuardValue && ifNotDefaultGuardValue) {
            return GuardValue.USE;
        }
        if (!ifDefaultGuardValue && !ifNotDefaultGuardValue) {
            return GuardValue.DO_NOT_USE;
        }
        if (ifDefaultGuardValue) {
            return GuardValue.USE_IF_DEFAULT;
        }
        return GuardValue.USE_IF_NOT_DEFAULT;
    }

    public GuardValue andGuards(List<GuardValue> guards) {
        boolean ifDefaultGuardValue = this.ifDefaultGuardValue(guards);
        boolean ifNotDefaultGuardValue = this.ifNotDefaultGuardValue(guards);
        return this.toDefaultFunctionUse(ifDefaultGuardValue, ifNotDefaultGuardValue);
    }

    private boolean ifNotDefaultGuardValue(List<GuardValue> guards) {
        for (GuardValue guardValue : guards) {
            switch (guardValue) {
                case USE: 
                case USE_IF_NOT_DEFAULT: {
                    break;
                }
                case DO_NOT_USE: 
                case USE_IF_DEFAULT: {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean ifDefaultGuardValue(List<GuardValue> guards) {
        for (GuardValue guardValue : guards) {
            switch (guardValue) {
                case USE: 
                case USE_IF_DEFAULT: {
                    break;
                }
                case USE_IF_NOT_DEFAULT: 
                case DO_NOT_USE: {
                    return false;
                }
            }
        }
        return true;
    }

    private class DefaultPoweredExpressionEvaluator
    extends ExpressionEvaluator {
        public DefaultPoweredExpressionEvaluator(IScope scope, ProblemsHandler problemsHandler, LessCompiler.Configuration configuration, boolean assumeDefault) {
            super(scope, problemsHandler, configuration);
            this.addFunctionsPack(new GuardOnlyFunctions(problemsHandler, assumeDefault));
        }
    }
}

