/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenChar;
import co.elastic.clients.elasticsearch._types.analysis.TokenizerBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenizerDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenizerDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class EdgeNGramTokenizer
extends TokenizerBase
implements TokenizerDefinitionVariant {
    @Nullable
    private final String customTokenChars;
    private final int maxGram;
    private final int minGram;
    private final List<TokenChar> tokenChars;
    public static final JsonpDeserializer<EdgeNGramTokenizer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, EdgeNGramTokenizer::setupEdgeNGramTokenizerDeserializer);

    private EdgeNGramTokenizer(Builder builder) {
        super(builder);
        this.customTokenChars = builder.customTokenChars;
        this.maxGram = ApiTypeHelper.requireNonNull(builder.maxGram, this, "maxGram");
        this.minGram = ApiTypeHelper.requireNonNull(builder.minGram, this, "minGram");
        this.tokenChars = ApiTypeHelper.unmodifiableRequired(builder.tokenChars, (Object)this, "tokenChars");
    }

    public static EdgeNGramTokenizer of(Function<Builder, ObjectBuilder<EdgeNGramTokenizer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenizerDefinition.Kind _tokenizerDefinitionKind() {
        return TokenizerDefinition.Kind.EdgeNgram;
    }

    @Nullable
    public final String customTokenChars() {
        return this.customTokenChars;
    }

    public final int maxGram() {
        return this.maxGram;
    }

    public final int minGram() {
        return this.minGram;
    }

    public final List<TokenChar> tokenChars() {
        return this.tokenChars;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "edge_ngram");
        super.serializeInternal(generator, mapper);
        if (this.customTokenChars != null) {
            generator.writeKey("custom_token_chars");
            generator.write(this.customTokenChars);
        }
        generator.writeKey("max_gram");
        generator.write(this.maxGram);
        generator.writeKey("min_gram");
        generator.write(this.minGram);
        if (ApiTypeHelper.isDefined(this.tokenChars)) {
            generator.writeKey("token_chars");
            generator.writeStartArray();
            for (TokenChar item0 : this.tokenChars) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupEdgeNGramTokenizerDeserializer(ObjectDeserializer<Builder> op) {
        TokenizerBase.setupTokenizerBaseDeserializer(op);
        op.add(Builder::customTokenChars, JsonpDeserializer.stringDeserializer(), "custom_token_chars");
        op.add(Builder::maxGram, JsonpDeserializer.integerDeserializer(), "max_gram");
        op.add(Builder::minGram, JsonpDeserializer.integerDeserializer(), "min_gram");
        op.add(Builder::tokenChars, JsonpDeserializer.arrayDeserializer(TokenChar._DESERIALIZER), "token_chars");
        op.ignore("type");
    }

    public static class Builder
    extends TokenizerBase.AbstractBuilder<Builder>
    implements ObjectBuilder<EdgeNGramTokenizer> {
        @Nullable
        private String customTokenChars;
        private Integer maxGram;
        private Integer minGram;
        private List<TokenChar> tokenChars;

        public final Builder customTokenChars(@Nullable String value) {
            this.customTokenChars = value;
            return this;
        }

        public final Builder maxGram(int value) {
            this.maxGram = value;
            return this;
        }

        public final Builder minGram(int value) {
            this.minGram = value;
            return this;
        }

        public final Builder tokenChars(List<TokenChar> list) {
            this.tokenChars = Builder._listAddAll(this.tokenChars, list);
            return this;
        }

        public final Builder tokenChars(TokenChar value, TokenChar ... values) {
            this.tokenChars = Builder._listAdd(this.tokenChars, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public EdgeNGramTokenizer build() {
            this._checkSingleUse();
            return new EdgeNGramTokenizer(this);
        }
    }
}

