/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class StandardDeviationBounds
implements JsonpSerializable {
    private final double upper;
    private final double lower;
    private final double upperPopulation;
    private final double lowerPopulation;
    private final double upperSampling;
    private final double lowerSampling;
    public static final JsonpDeserializer<StandardDeviationBounds> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StandardDeviationBounds::setupStandardDeviationBoundsDeserializer);

    private StandardDeviationBounds(Builder builder) {
        this.upper = ApiTypeHelper.requireNonNull(builder.upper, this, "upper");
        this.lower = ApiTypeHelper.requireNonNull(builder.lower, this, "lower");
        this.upperPopulation = ApiTypeHelper.requireNonNull(builder.upperPopulation, this, "upperPopulation");
        this.lowerPopulation = ApiTypeHelper.requireNonNull(builder.lowerPopulation, this, "lowerPopulation");
        this.upperSampling = ApiTypeHelper.requireNonNull(builder.upperSampling, this, "upperSampling");
        this.lowerSampling = ApiTypeHelper.requireNonNull(builder.lowerSampling, this, "lowerSampling");
    }

    public static StandardDeviationBounds of(Function<Builder, ObjectBuilder<StandardDeviationBounds>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final double upper() {
        return this.upper;
    }

    public final double lower() {
        return this.lower;
    }

    public final double upperPopulation() {
        return this.upperPopulation;
    }

    public final double lowerPopulation() {
        return this.lowerPopulation;
    }

    public final double upperSampling() {
        return this.upperSampling;
    }

    public final double lowerSampling() {
        return this.lowerSampling;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("upper");
        JsonpUtils.serializeDoubleOrNull(generator, this.upper, 0.0);
        generator.writeKey("lower");
        JsonpUtils.serializeDoubleOrNull(generator, this.lower, 0.0);
        generator.writeKey("upper_population");
        JsonpUtils.serializeDoubleOrNull(generator, this.upperPopulation, 0.0);
        generator.writeKey("lower_population");
        JsonpUtils.serializeDoubleOrNull(generator, this.lowerPopulation, 0.0);
        generator.writeKey("upper_sampling");
        JsonpUtils.serializeDoubleOrNull(generator, this.upperSampling, 0.0);
        generator.writeKey("lower_sampling");
        JsonpUtils.serializeDoubleOrNull(generator, this.lowerSampling, 0.0);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupStandardDeviationBoundsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::upper, JsonpDeserializer.doubleOrNullDeserializer(0.0), "upper");
        op.add(Builder::lower, JsonpDeserializer.doubleOrNullDeserializer(0.0), "lower");
        op.add(Builder::upperPopulation, JsonpDeserializer.doubleOrNullDeserializer(0.0), "upper_population");
        op.add(Builder::lowerPopulation, JsonpDeserializer.doubleOrNullDeserializer(0.0), "lower_population");
        op.add(Builder::upperSampling, JsonpDeserializer.doubleOrNullDeserializer(0.0), "upper_sampling");
        op.add(Builder::lowerSampling, JsonpDeserializer.doubleOrNullDeserializer(0.0), "lower_sampling");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<StandardDeviationBounds> {
        private Double upper;
        private Double lower;
        private Double upperPopulation;
        private Double lowerPopulation;
        private Double upperSampling;
        private Double lowerSampling;

        public final Builder upper(double value) {
            this.upper = value;
            return this;
        }

        public final Builder lower(double value) {
            this.lower = value;
            return this;
        }

        public final Builder upperPopulation(double value) {
            this.upperPopulation = value;
            return this;
        }

        public final Builder lowerPopulation(double value) {
            this.lowerPopulation = value;
            return this;
        }

        public final Builder upperSampling(double value) {
            this.upperSampling = value;
            return this;
        }

        public final Builder lowerSampling(double value) {
            this.lowerSampling = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public StandardDeviationBounds build() {
            this._checkSingleUse();
            return new StandardDeviationBounds(this);
        }
    }
}

