/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.service;

import io.meeds.chat.model.MatrixMessage;
import io.meeds.chat.model.Room;
import io.meeds.chat.service.MatrixService;
import io.meeds.chat.service.utils.MatrixConstants;
import io.meeds.pwa.model.PwaNotificationMessage;
import io.meeds.pwa.service.PwaNotificationService;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.ScheduledFuture;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChatNotificationService {
    @Autowired
    private MatrixService matrixService;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private SpaceService spaceService;
    @Autowired
    ResourceBundleService resourceBundleService;
    @Autowired
    private PwaNotificationService pwaNotificationService;
    public static String IN_KEY = "matrix.words.in";

    public ScheduledFuture<?> sendCreateNotificationAction(String eventId, String userName, String roomId, int unreadCount) {
        HashMap<String, String> params = new HashMap<String, String>();
        String encodedId = URLEncoder.encode(eventId + "|" + roomId, StandardCharsets.UTF_8).replace("+", "%20");
        params.put("notificationId", encodedId);
        params.put("username", userName);
        params.put("action", "open");
        params.put("type", "CHAT_NOTIFICATION");
        return this.pwaNotificationService.create(params);
    }

    public PwaNotificationMessage createNotification(MatrixMessage message, String userName) {
        if (message != null) {
            PwaNotificationMessage pwaNotificationMessage = new PwaNotificationMessage();
            Room room = this.matrixService.getById(message.getRoomId());
            LocaleConfig localeConfig = this.pwaNotificationService.getLocaleConfig(userName);
            String sender = message.getSender();
            if (room != null) {
                if (StringUtils.isBlank((CharSequence)room.getSpaceId())) {
                    String senderUserName = room.getFirstParticipant().equals(userName) ? room.getSecondParticipant() : room.getFirstParticipant();
                    Identity senderIdentity = this.identityManager.getOrCreateUserIdentity(senderUserName);
                    String senderFullName = senderIdentity != null ? senderIdentity.getProfile().getFullName() : sender;
                    pwaNotificationMessage.setTitle(senderFullName);
                    pwaNotificationMessage.setIcon(senderIdentity != null ? senderIdentity.getProfile().getAvatarUrl() : "");
                } else {
                    Space space = this.spaceService.getSpaceById(room.getSpaceId());
                    Identity senderIdentity = this.matrixService.findSpaceMemberByMatrixId(sender, space);
                    String senderFullName = senderIdentity != null ? senderIdentity.getProfile().getFullName() : sender;
                    pwaNotificationMessage.setTitle(senderFullName + " " + this.resourceBundleService.getSharedString(IN_KEY, localeConfig.getLocale()) + " " + space.getDisplayName());
                    pwaNotificationMessage.setIcon(space.getAvatarUrl());
                }
                pwaNotificationMessage.setBody(message.getMessageContent());
                this.pwaNotificationService.setDefaultNotificationMessageProperties(pwaNotificationMessage, message.getEventId(), localeConfig);
                return pwaNotificationMessage;
            }
            return null;
        }
        return null;
    }

    public PwaNotificationMessage createNotification(String eventId, String roomId, String userName, String token) {
        MatrixMessage message = this.matrixService.getRoomEvent(eventId, roomId, token);
        return this.createNotification(message, userName);
    }

    public void createMentionNotification(String eventId, String roomId, String userName) {
        Room room = this.matrixService.getById(roomId);
        MatrixMessage message = this.matrixService.getRoomEvent(eventId, roomId);
        Identity receiverIdentity = this.identityManager.getOrCreateUserIdentity(userName);
        String matrixReceiverId = userName;
        if (receiverIdentity != null) {
            matrixReceiverId = (String)receiverIdentity.getProfile().getProperties().get("matrixId");
        }
        String roomName = "";
        String senderFullName = "";
        if (message != null && message.getMentionedUsers() != null && !message.getMentionedUsers().isEmpty() && message.getMentionedUsers().contains(matrixReceiverId) && room != null && StringUtils.isNotBlank((CharSequence)room.getSpaceId())) {
            Space space = this.spaceService.getSpaceById(room.getSpaceId());
            roomName = space.getDisplayName();
            Identity senderIdentity = this.matrixService.findSpaceMemberByMatrixId(message.getSender(), space);
            if (senderIdentity != null) {
                senderFullName = senderIdentity.getProfile().getFullName();
            }
            NotificationContext ctx = NotificationContextImpl.cloneInstance();
            ctx.append(MatrixConstants.MATRIX_ROOM_ID, (Object)message.getRoomId());
            ctx.append(MatrixConstants.MATRIX_ROOM_NAME, (Object)roomName);
            ctx.append(MatrixConstants.MATRIX_ROOM_MEMBER, (Object)userName);
            ctx.append(MatrixConstants.MATRIX_MESSAGE_SENDER_FULLNAME, (Object)senderFullName);
            ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"MatrixMentionReceivedNotificationPlugin"))).execute(ctx);
        }
    }
}

