/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.security.rest;

import io.meeds.web.security.authenticator.DigestAuthenticatorService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/digest"})
@Tag(name="/digest", description="Manage digest authentication code")
public class DigestAuthenticatorRest {
    @Autowired
    private DigestAuthenticatorService digestAuthenticatorService;

    @GetMapping
    @Secured(value={"users"})
    @Operation(summary="Generates a temporary password for current user", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fullfilled")})
    public String generatePassword(HttpServletRequest request) throws IOException {
        return this.digestAuthenticatorService.generatePassword(request.getRemoteUser());
    }
}

