/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import org.hibernate.Incubating;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;

public interface BasicType<T>
extends Type,
BasicDomainType<T>,
MappingType,
BasicValuedMapping,
JdbcMapping {
    public String[] getRegistrationKeys();

    @Override
    default public MappingType getMappedType() {
        return this;
    }

    @Override
    default public JavaType<T> getJavaTypeDescriptor() {
        return this.getMappedJavaType();
    }

    @Override
    default public JavaType<T> getExpressibleJavaType() {
        return this.getJavaTypeDescriptor();
    }

    @Override
    default public int forEachJdbcType(IndexedConsumer<JdbcMapping> action) {
        action.accept(0, this);
        return 1;
    }

    @Override
    default public JdbcMapping getJdbcMapping() {
        return this;
    }

    @Override
    default public int getJdbcTypeCount() {
        return 1;
    }

    @Override
    default public JdbcMapping getJdbcMapping(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException(index);
        }
        return this;
    }

    @Override
    default public JdbcMapping getSingleJdbcMapping() {
        return this;
    }

    default public JavaType<T> getMappedJavaType() {
        return this.getJavaTypeDescriptor();
    }

    @Override
    @Incubating
    default public BasicValueConverter<T, ?> getValueConverter() {
        return null;
    }

    default public ValueExtractor<T> getJdbcValueExtractor() {
        return this.getJdbcType().getExtractor(this.getMappedJavaType());
    }

    @Override
    default public ValueBinder<T> getJdbcValueBinder() {
        return this.getJdbcType().getBinder(this.getMappedJavaType());
    }

    @Override
    default public JdbcLiteralFormatter<T> getJdbcLiteralFormatter() {
        return this.getJdbcType().getJdbcLiteralFormatter(this.getMappedJavaType());
    }

    @Override
    default public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, this.getJdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Override
    default public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return value;
    }

    @Override
    default public <X, Y> int forEachDisassembledJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, x, y, value, this.getJdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Incubating
    default public String getCheckCondition(String columnName, Dialect dialect) {
        String checkCondition = this.getJdbcType().getCheckCondition(columnName, this.getMappedJavaType(), this.getValueConverter(), dialect);
        if (checkCondition == null) {
            checkCondition = this.getMappedJavaType().getCheckCondition(columnName, this.getJdbcType(), this.getValueConverter(), dialect);
        }
        return checkCondition;
    }

    @Override
    default public int compare(Object x, Object y, SessionFactoryImplementor sessionFactory) {
        return this.compare(x, y);
    }
}

