/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.spi;

import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.query.spi.HqlInterpretation;
import org.hibernate.query.spi.ParameterMetadataImplementor;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;

public class SimpleHqlInterpretationImpl<R>
implements HqlInterpretation<R> {
    private final SqmStatement<R> sqmStatement;
    private final ParameterMetadataImplementor parameterMetadata;
    private final DomainParameterXref domainParameterXref;
    private final ConcurrentHashMap<Class<?>, Object> allowedReturnTypes;

    public SimpleHqlInterpretationImpl(SqmStatement<R> sqmStatement, ParameterMetadataImplementor parameterMetadata, DomainParameterXref domainParameterXref) {
        this.sqmStatement = sqmStatement;
        this.parameterMetadata = parameterMetadata;
        this.domainParameterXref = domainParameterXref;
        this.allowedReturnTypes = new ConcurrentHashMap();
    }

    @Override
    public SqmStatement<R> getSqmStatement() {
        return this.sqmStatement;
    }

    @Override
    public ParameterMetadataImplementor getParameterMetadata() {
        return this.parameterMetadata;
    }

    @Override
    public DomainParameterXref getDomainParameterXref() {
        return this.domainParameterXref.copy();
    }

    @Override
    public void validateResultType(Class<?> resultType) {
        assert (this.sqmStatement instanceof SqmSelectStatement);
        if (resultType != null && !SqmUtil.isResultTypeAlwaysAllowed(resultType) && !this.allowedReturnTypes.containsKey(resultType)) {
            SqmUtil.checkQueryReturnType(((SqmSelectStatement)this.sqmStatement).getQueryPart(), resultType);
            this.allowedReturnTypes.put(resultType, Boolean.TRUE);
        }
    }
}

