/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SimpleFromClauseAccessImpl;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.jboss.logging.Logger;

public class FromClauseIndex
extends SimpleFromClauseAccessImpl {
    private static final Logger log = Logger.getLogger(FromClauseIndex.class);
    private final Map<String, TableGroup> tableGroupByAliasXref = new HashMap<String, TableGroup>();
    private Map<String, SqmAttributeJoin> fetchesByPath;

    public FromClauseIndex(FromClauseIndex parent) {
        super(parent);
    }

    public TableGroup findTableGroup(String alias) {
        return this.tableGroupByAliasXref.get(alias);
    }

    public void register(SqmPath<?> sqmPath, TableGroup tableGroup) {
        this.register(sqmPath, tableGroup, null);
    }

    public void register(SqmPath<?> sqmPath, TableGroup tableGroup, NavigablePath identifierForTableGroup) {
        SqmAttributeJoin sqmJoin;
        TableGroup previousAliasReg;
        this.registerTableGroup(sqmPath.getNavigablePath(), tableGroup);
        if (identifierForTableGroup != null) {
            this.registerTableGroup(identifierForTableGroup, tableGroup);
        }
        if (sqmPath.getExplicitAlias() != null && (previousAliasReg = this.tableGroupByAliasXref.put(sqmPath.getExplicitAlias(), tableGroup)) != null && log.isDebugEnabled()) {
            log.debugf("Encountered previous TableGroup registration [%s] for alias : %s", (Object)previousAliasReg, (Object)sqmPath.getExplicitAlias());
        }
        if (sqmPath instanceof SqmAttributeJoin && (sqmJoin = (SqmAttributeJoin)sqmPath).isFetched()) {
            this.registerJoinFetch(sqmJoin, identifierForTableGroup);
        }
    }

    private void registerJoinFetch(SqmAttributeJoin sqmJoin, NavigablePath identifierForTableGroup) {
        if (this.fetchesByPath == null) {
            this.fetchesByPath = new HashMap<String, SqmAttributeJoin>();
        }
        if (identifierForTableGroup != null) {
            this.fetchesByPath.put(identifierForTableGroup.getIdentifierForTableGroup(), sqmJoin);
        } else {
            NavigablePath navigablePath = sqmJoin.getNavigablePath();
            this.fetchesByPath.put(navigablePath.getIdentifierForTableGroup(), sqmJoin);
        }
    }

    public boolean isResolved(SqmFrom fromElement) {
        return this.tableGroupMap.containsKey(fromElement.getNavigablePath()) || this.parent != null && ((FromClauseIndex)this.parent).isResolved(fromElement);
    }

    public SqmAttributeJoin findFetchedJoinByPath(NavigablePath path) {
        return this.fetchesByPath == null ? null : this.fetchesByPath.get(path.getIdentifierForTableGroup());
    }
}

