/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common;

public class RuntimeContext {
    public static final String GATEIN_RUNTIME_CONTEXT_PROP_NAME = "gatein.runtime.context";
    private final RunningEnvironment ENV;

    RuntimeContext(String runtimeContextValue) {
        RunningEnvironment runningEnvironment = RunningEnvironment.UNKNOWN;
        try {
            runningEnvironment = RunningEnvironment.valueOf(runtimeContextValue);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.ENV = runningEnvironment;
    }

    private RuntimeContext() {
        this(System.getProperty(GATEIN_RUNTIME_CONTEXT_PROP_NAME, RunningEnvironment.gtn.getName()));
    }

    public static RuntimeContext getInstance() {
        return InstanceHolder.instance;
    }

    public boolean isRunningIn(RunningEnvironment env) {
        return this.ENV.equals((Object)env);
    }

    public boolean isRunningInUnknownEnvironment() {
        return RunningEnvironment.UNKNOWN.equals((Object)this.ENV);
    }

    public static enum RunningEnvironment {
        epp("epp"),
        gtn("gtn"),
        plf("plf"),
        UNKNOWN("__unknown__");

        private final String name;

        private RunningEnvironment(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    private static final class InstanceHolder {
        public static final RuntimeContext instance = new RuntimeContext();

        private InstanceHolder() {
        }
    }
}

