/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.store.hibernate;

import jakarta.persistence.Tuple;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.collections4.CollectionUtils;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.query.Query;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.helper.Tools;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObject;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectAttribute;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectAttributeBinaryValue;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectCredential;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectCredentialBinaryValue;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectCredentialType;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectRelationship;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectRelationshipName;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectRelationshipType;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectType;
import org.picketlink.idm.impl.model.hibernate.HibernateRealm;
import org.picketlink.idm.impl.store.FeaturesMetaDataImpl;
import org.picketlink.idm.impl.store.hibernate.ExoHibernateIdentityStoreSessionImpl;
import org.picketlink.idm.impl.store.hibernate.HibernateIdentityStoreImpl;
import org.picketlink.idm.impl.types.SimpleIdentityObject;
import org.picketlink.idm.spi.configuration.IdentityStoreConfigurationContext;
import org.picketlink.idm.spi.configuration.metadata.IdentityObjectAttributeMetaData;
import org.picketlink.idm.spi.configuration.metadata.IdentityObjectTypeMetaData;
import org.picketlink.idm.spi.configuration.metadata.IdentityStoreConfigurationMetaData;
import org.picketlink.idm.spi.configuration.metadata.RealmConfigurationMetaData;
import org.picketlink.idm.spi.model.IdentityObject;
import org.picketlink.idm.spi.model.IdentityObjectAttribute;
import org.picketlink.idm.spi.model.IdentityObjectCredential;
import org.picketlink.idm.spi.model.IdentityObjectCredentialType;
import org.picketlink.idm.spi.model.IdentityObjectRelationship;
import org.picketlink.idm.spi.model.IdentityObjectRelationshipType;
import org.picketlink.idm.spi.model.IdentityObjectType;
import org.picketlink.idm.spi.search.IdentityObjectSearchCriteria;
import org.picketlink.idm.spi.store.FeaturesMetaData;
import org.picketlink.idm.spi.store.IdentityObjectSearchCriteriaType;
import org.picketlink.idm.spi.store.IdentityStore;
import org.picketlink.idm.spi.store.IdentityStoreInvocationContext;
import org.picketlink.idm.spi.store.IdentityStoreSession;

public class PatchedHibernateIdentityStoreImpl
implements IdentityStore,
Serializable {
    private static final String ATTRIBUTES_NULL_MSG = "attributes are null";
    private static final String RELATIONSHIP_NOT_FOUND_MSG = "Relationship name '%s' not present in the store";
    private static final String NAME_IS_NULL_MSG = "name is null";
    private static final String ASC_ORDER = " ASC";
    private static final String DESC_ORDER = " DESC";
    private static final String TO_IDENTITY_OBJECT_PROP_NAME = "toIdentityObject";
    private static final String FROM_IDENTITY_OBJECT_PROP_NAME = "fromIdentityObject";
    private static final String TYPE_ID_PROP_NAME = "typeId";
    private static final String REALM_PROP_NAME = "realm";
    private static final String NAME_PROP_NAME = "name";
    private static final String TYPE_NAME_PROP_NAME = "typeName";
    private static final String REALM_NAME_PROP_NAME = "realmName";
    private static final long serialVersionUID = -130355852189832805L;
    private static Logger log = Logger.getLogger(PatchedHibernateIdentityStoreImpl.class.getName());
    public static final String HIBERNATE_SESSION_FACTORY_REGISTRY_NAME = "hibernateSessionFactoryRegistryName";
    public static final String HIBERNATE_CONFIGURATION = "hibernateConfiguration";
    public static final String ADD_HIBERNATE_MAPPINGS = "addHibernateMappings";
    public static final String HIBERNATE_SESSION_FACTORY_JNDI_NAME = "hibernateSessionFactoryJNDIName";
    public static final String POPULATE_MEMBERSHIP_TYPES = "populateRelationshipTypes";
    public static final String POPULATE_IDENTITY_OBJECT_TYPES = "populateIdentityObjectTypes";
    public static final String IS_REALM_AWARE = "isRealmAware";
    public static final String MANAGE_TRANSACTION_DURING_BOOTSTRAP = "manageTransactionDuringBootstrap";
    public static final String ALLOW_NOT_DEFINED_ATTRIBUTES = "allowNotDefinedAttributes";
    public static final String ALLOW_NOT_DEFINED_IDENTITY_OBJECT_TYPES_OPTION = "allowNotDefinedIdentityObjectTypes";
    public static final String ALLOW_NOT_CASE_SENSITIVE_SEARCH = "allowNotCaseSensitiveSearch";
    public static final String LAZY_START_OF_HIBERNATE_TRANSACTION = "lazyStartOfHibernateTransaction";
    public static final String DEFAULT_REALM_NAME = HibernateIdentityStoreImpl.class.getName() + ".DEFAULT_REALM";
    public static final String CREDENTIAL_TYPE_PASSWORD = "PASSWORD";
    public static final String CREDENTIAL_TYPE_BINARY = "BINARY";
    public static final String ALL_GROUPS_TYPE = "@@ALL_GROUPS@@";
    private String id;
    private FeaturesMetaData supportedFeatures;
    private SessionFactory sessionFactory;
    private boolean isRealmAware = false;
    private boolean isAllowNotDefinedAttributes = false;
    private boolean isAllowNotDefinedIdentityObjectTypes = false;
    private boolean isAllowNotCaseSensitiveSearch = false;
    private boolean lazyStartOfHibernateTransaction = false;
    private boolean isManageTransactionDuringBootstrap = true;
    private IdentityStoreConfigurationMetaData configurationMD;
    private static Set<IdentityObjectSearchCriteriaType> supportedIdentityObjectSearchCriteria = new HashSet<IdentityObjectSearchCriteriaType>();
    private static Set<String> supportedCredentialTypes = new HashSet<String>();
    private Map<String, Set<String>> attributeMappings = new HashMap<String, Set<String>>();
    private Map<String, Map<String, IdentityObjectAttributeMetaData>> attributesMetaData = new HashMap<String, Map<String, IdentityObjectAttributeMetaData>>();
    private Map<String, Map<String, String>> reverseAttributeMappings = new HashMap<String, Map<String, String>>();

    public PatchedHibernateIdentityStoreImpl(String id) {
        this.id = id;
    }

    public void bootstrap(IdentityStoreConfigurationContext configurationContext) throws IdentityException {
        String lazyStartOfHibernateTransactionString;
        String allowNotCaseSensitiveSearch;
        String allowNotDefinedIOT;
        String allowNotDefineAttributes;
        String realmAware;
        this.configurationMD = configurationContext.getStoreConfigurationMetaData();
        this.id = this.configurationMD.getId();
        this.supportedFeatures = new FeaturesMetaDataImpl(this.configurationMD, supportedIdentityObjectSearchCriteria, true, true, new HashSet());
        String populateMembershipTypes = this.configurationMD.getOptionSingleValue(POPULATE_MEMBERSHIP_TYPES);
        String populateIdentityObjectTypes = this.configurationMD.getOptionSingleValue(POPULATE_IDENTITY_OBJECT_TYPES);
        String manageTransactionDuringBootstrap = this.configurationMD.getOptionSingleValue(MANAGE_TRANSACTION_DURING_BOOTSTRAP);
        if (manageTransactionDuringBootstrap != null && manageTransactionDuringBootstrap.equalsIgnoreCase("false")) {
            this.isAllowNotDefinedAttributes = false;
        }
        this.sessionFactory = this.bootstrapHibernateSessionFactory(configurationContext);
        Session hibernateSession = this.sessionFactory.openSession();
        for (Object identityObjectTypeMetaData : this.configurationMD.getSupportedIdentityTypes()) {
            HashSet<String> names = new HashSet<String>();
            HashMap<String, IdentityObjectAttributeMetaData> metadataMap = new HashMap<String, IdentityObjectAttributeMetaData>();
            HashMap<String, String> reverseMap = new HashMap<String, String>();
            for (IdentityObjectAttributeMetaData attributeMetaData : identityObjectTypeMetaData.getAttributes()) {
                names.add(attributeMetaData.getName());
                metadataMap.put(attributeMetaData.getName(), attributeMetaData);
                if (attributeMetaData.getStoreMapping() == null) continue;
                reverseMap.put(attributeMetaData.getStoreMapping(), attributeMetaData.getName());
            }
            this.attributeMappings.put(identityObjectTypeMetaData.getName(), Collections.unmodifiableSet(names));
            this.attributesMetaData.put(identityObjectTypeMetaData.getName(), metadataMap);
            this.reverseAttributeMappings.put(identityObjectTypeMetaData.getName(), reverseMap);
        }
        this.attributeMappings = Collections.unmodifiableMap(this.attributeMappings);
        if (this.isManageTransactionDuringBootstrap()) {
            hibernateSession.getTransaction().begin();
        }
        if (populateMembershipTypes != null && populateMembershipTypes.equalsIgnoreCase("true")) {
            LinkedList<String> memberships = new LinkedList<String>();
            for (String membership : this.configurationMD.getSupportedRelationshipTypes()) {
                memberships.add(membership);
            }
            try {
                this.populateRelationshipTypes(hibernateSession, memberships.toArray(new String[memberships.size()]));
            }
            catch (Exception e) {
                throw new IdentityException("Failed to populate relationship types", (Throwable)e);
            }
        }
        if (populateIdentityObjectTypes != null && populateIdentityObjectTypes.equalsIgnoreCase("true")) {
            LinkedList<String> types = new LinkedList<String>();
            for (IdentityObjectTypeMetaData metaData : this.configurationMD.getSupportedIdentityTypes()) {
                types.add(metaData.getName());
            }
            try {
                this.populateObjectTypes(hibernateSession, types.toArray(new String[types.size()]));
            }
            catch (Exception e) {
                throw new IdentityException("Failed to populate identity object types", (Throwable)e);
            }
        }
        if (supportedCredentialTypes != null && !supportedCredentialTypes.isEmpty()) {
            try {
                this.populateCredentialTypes(hibernateSession, supportedCredentialTypes.toArray(new String[supportedCredentialTypes.size()]));
            }
            catch (Exception e) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Exception occurred: ", e);
                }
                throw new IdentityException("Failed to populated credential types", (Throwable)e);
            }
        }
        if ((realmAware = this.configurationMD.getOptionSingleValue(IS_REALM_AWARE)) != null && realmAware.equalsIgnoreCase("true")) {
            this.isRealmAware = true;
        }
        if ((allowNotDefineAttributes = this.configurationMD.getOptionSingleValue(ALLOW_NOT_DEFINED_ATTRIBUTES)) != null && allowNotDefineAttributes.equalsIgnoreCase("true")) {
            this.isAllowNotDefinedAttributes = true;
        }
        if ((allowNotDefinedIOT = this.configurationMD.getOptionSingleValue(ALLOW_NOT_DEFINED_IDENTITY_OBJECT_TYPES_OPTION)) != null && allowNotDefinedIOT.equalsIgnoreCase("true")) {
            this.isAllowNotDefinedIdentityObjectTypes = true;
        }
        if ((allowNotCaseSensitiveSearch = this.configurationMD.getOptionSingleValue(ALLOW_NOT_CASE_SENSITIVE_SEARCH)) == null || allowNotCaseSensitiveSearch.equalsIgnoreCase("true")) {
            this.isAllowNotCaseSensitiveSearch = true;
        }
        if ((lazyStartOfHibernateTransactionString = this.configurationMD.getOptionSingleValue(LAZY_START_OF_HIBERNATE_TRANSACTION)) != null && lazyStartOfHibernateTransactionString.equalsIgnoreCase("true")) {
            this.lazyStartOfHibernateTransaction = true;
        }
        HibernateRealm realm = null;
        try {
            realm = this.getHibernateRealmByName(hibernateSession, DEFAULT_REALM_NAME);
        }
        catch (HibernateException attributeMetaData) {
            // empty catch block
        }
        if (realm == null) {
            this.addRealm(hibernateSession, DEFAULT_REALM_NAME);
        }
        if (this.isRealmAware()) {
            HashSet<String> realmNames = new HashSet<String>();
            for (RealmConfigurationMetaData realmMD : configurationContext.getConfigurationMetaData().getRealms()) {
                realmNames.add(realmMD.getId());
            }
            for (String rid : realmNames) {
                realm = this.getHibernateRealmByName(hibernateSession, rid);
                if (realm != null) continue;
                this.addRealm(hibernateSession, rid);
            }
        }
        if (this.isManageTransactionDuringBootstrap()) {
            hibernateSession.getTransaction().commit();
        }
        if (hibernateSession.getTransaction().isActive()) {
            hibernateSession.flush();
        }
        hibernateSession.close();
    }

    protected SessionFactory bootstrapHibernateSessionFactory(IdentityStoreConfigurationContext configurationContext) throws IdentityException {
        String sfJNDIName = configurationContext.getStoreConfigurationMetaData().getOptionSingleValue(HIBERNATE_SESSION_FACTORY_JNDI_NAME);
        String sfRegistryName = configurationContext.getStoreConfigurationMetaData().getOptionSingleValue(HIBERNATE_SESSION_FACTORY_REGISTRY_NAME);
        String hibernateConfiguration = configurationContext.getStoreConfigurationMetaData().getOptionSingleValue(HIBERNATE_CONFIGURATION);
        if (sfJNDIName != null) {
            try {
                return (SessionFactory)new InitialContext().lookup(sfJNDIName);
            }
            catch (NamingException e) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Exception occurred: ", e);
                }
                throw new IdentityException("Cannot obtain hibernate SessionFactory from provided JNDI name: " + sfJNDIName, (Throwable)e);
            }
        }
        if (sfRegistryName != null) {
            Object registryObject = configurationContext.getConfigurationRegistry().getObject(sfRegistryName);
            if (registryObject == null) {
                throw new IdentityException("Cannot obtain hibernate SessionFactory from provided registry name: " + sfRegistryName);
            }
            if (!(registryObject instanceof SessionFactory)) {
                throw new IdentityException("Cannot obtain hibernate SessionFactory from provided registry name: " + sfRegistryName + "; Registered object is not an instance of SessionFactory: " + registryObject.getClass().getName());
            }
            return (SessionFactory)registryObject;
        }
        if (hibernateConfiguration != null) {
            try {
                Configuration config = new Configuration().configure(hibernateConfiguration);
                return config.addAnnotatedClass(HibernateIdentityObject.class).addAnnotatedClass(HibernateIdentityObjectCredentialBinaryValue.class).addAnnotatedClass(HibernateIdentityObjectAttributeBinaryValue.class).addAnnotatedClass(HibernateIdentityObjectAttribute.class).addAnnotatedClass(HibernateIdentityObjectCredential.class).addAnnotatedClass(HibernateIdentityObjectCredentialType.class).addAnnotatedClass(HibernateIdentityObjectRelationship.class).addAnnotatedClass(HibernateIdentityObjectRelationshipName.class).addAnnotatedClass(HibernateIdentityObjectRelationshipType.class).addAnnotatedClass(HibernateIdentityObjectType.class).addAnnotatedClass(HibernateRealm.class).buildSessionFactory();
            }
            catch (Exception e) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Exception occurred: ", e);
                }
                throw new IdentityException("Cannot obtain hibernate SessionFactory using provided hibernate configuration: " + hibernateConfiguration, (Throwable)e);
            }
        }
        throw new IdentityException("Cannot obtain hibernate SessionFactory. None of supported options specified: hibernateSessionFactoryJNDIName, hibernateSessionFactoryRegistryName, hibernateConfiguration");
    }

    public IdentityStoreSession createIdentityStoreSession() throws IdentityException {
        try {
            return new ExoHibernateIdentityStoreSessionImpl(this.sessionFactory, this.lazyStartOfHibernateTransaction);
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Failed to obtain Hibernate SessionFactory", (Throwable)e);
        }
    }

    public IdentityStoreSession createIdentityStoreSession(Map<String, Object> sessionOptions) throws IdentityException {
        return this.createIdentityStoreSession();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public FeaturesMetaData getSupportedFeatures() {
        return this.supportedFeatures;
    }

    public IdentityObject createIdentityObject(IdentityStoreInvocationContext invocationCtx, String name, IdentityObjectType identityObjectType) throws IdentityException {
        return this.createIdentityObject(invocationCtx, name, identityObjectType, null);
    }

    public IdentityObject createIdentityObject(IdentityStoreInvocationContext ctx, String name, IdentityObjectType identityObjectType, Map<String, String[]> attributes) throws IdentityException {
        if (name == null) {
            throw new IllegalArgumentException("IdentityObject name is null");
        }
        this.checkIOType(identityObjectType);
        Session session = this.getHibernateSession(ctx);
        HibernateRealm realm = this.getRealm(session, ctx);
        Number boxedSize = null;
        boxedSize = this.isAllowNotCaseSensitiveSearch(identityObjectType.getName()) ? (Number)((Number)session.createNamedQuery("HibernateIdentityObject.countIdentityObjectByNameAndTypeIgnoreCase", Number.class).setParameter(NAME_PROP_NAME, (Object)name.toLowerCase()).setParameter(REALM_NAME_PROP_NAME, (Object)realm.getName()).setParameter(TYPE_NAME_PROP_NAME, (Object)identityObjectType.getName()).uniqueResult()) : (Number)((Number)session.createNamedQuery("HibernateIdentityObject.countIdentityObjectByNameAndType", Number.class).setParameter(NAME_PROP_NAME, (Object)name).setParameter(REALM_NAME_PROP_NAME, (Object)realm.getName()).setParameter(TYPE_NAME_PROP_NAME, (Object)identityObjectType.getName()).uniqueResult());
        int size = boxedSize.intValue();
        if (size != 0) {
            throw new IdentityException("IdentityObject already present in this IdentityStore:name=" + name + "; type=" + identityObjectType.getName() + "; realm=" + String.valueOf(realm));
        }
        HibernateIdentityObjectType hibernateType = this.getHibernateIdentityObjectType(ctx, identityObjectType);
        HibernateIdentityObject io = new HibernateIdentityObject(name, hibernateType, realm);
        if (attributes != null) {
            for (Map.Entry<String, String[]> entry : attributes.entrySet()) {
                io.addTextAttribute(entry.getKey(), entry.getValue());
            }
        }
        try {
            this.getHibernateSession(ctx).persist((Object)io);
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Cannot persist new IdentityObject" + String.valueOf(io), (Throwable)e);
        }
        return io;
    }

    public void removeIdentityObject(IdentityStoreInvocationContext ctx, IdentityObject identity) throws IdentityException {
        HibernateIdentityObject hio = this.safeGet(ctx, identity);
        Session hibernateSession = this.getHibernateSession(ctx);
        Hibernate.initialize((Object)hio);
        try {
            HibernateIdentityObjectRelationship[] from = new HibernateIdentityObjectRelationship[hio.getFromRelationships().size()];
            for (HibernateIdentityObjectRelationship relationship : hio.getFromRelationships().toArray(from)) {
                relationship.getFromIdentityObject().getFromRelationships().remove(relationship);
                relationship.getToIdentityObject().getToRelationships().remove(relationship);
                hibernateSession.remove((Object)relationship);
                hibernateSession.flush();
            }
            HibernateIdentityObjectRelationship[] to = new HibernateIdentityObjectRelationship[hio.getToRelationships().size()];
            for (HibernateIdentityObjectRelationship relationship : hio.getToRelationships().toArray(to)) {
                relationship.getFromIdentityObject().getFromRelationships().remove(relationship);
                relationship.getToIdentityObject().getToRelationships().remove(relationship);
                hibernateSession.remove((Object)relationship);
                hibernateSession.flush();
            }
            hio.getCredentials().forEach(cred -> {
                hibernateSession.refresh((Object)hio);
                hibernateSession.remove(cred);
                hibernateSession.flush();
            });
            hibernateSession.refresh((Object)hio);
            hibernateSession.remove((Object)hio);
            hibernateSession.flush();
        }
        catch (Exception e) {
            throw new IdentityException(String.format("Cannot remove IdentityObject: %s", identity), (Throwable)e);
        }
    }

    public int getIdentityObjectsCount(IdentityStoreInvocationContext ctx, IdentityObjectType identityType) throws IdentityException {
        this.checkIOType(identityType);
        HibernateIdentityObjectType jpaType = this.getHibernateIdentityObjectType(ctx, identityType);
        Session hibernateSession = this.getHibernateSession(ctx);
        try {
            return ((Long)hibernateSession.createNamedQuery("HibernateIdentityObject.countIdentityObjectsByType", Long.class).setParameter(TYPE_NAME_PROP_NAME, (Object)jpaType.getName()).setParameter(REALM_NAME_PROP_NAME, (Object)this.getRealmName(ctx)).setCacheable(true).uniqueResult()).intValue();
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Cannot count stored IdentityObjects with type: " + identityType.getName(), (Throwable)e);
        }
    }

    public IdentityObject findIdentityObject(IdentityStoreInvocationContext ctx, String name, IdentityObjectType type) throws IdentityException {
        if (name == null) {
            throw new IllegalArgumentException("IdentityObject name is null");
        }
        this.checkIOType(type);
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, (IdentityObject)new SimpleIdentityObject(name, type));
        if (this.isAllowNotCaseSensitiveSearch() || hibernateObject != null && hibernateObject.getName().equals(name)) {
            return hibernateObject;
        }
        return null;
    }

    public IdentityObject findIdentityObject(IdentityStoreInvocationContext ctx, String id) throws IdentityException {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        try {
            return (IdentityObject)this.getHibernateSession(ctx).get(HibernateIdentityObject.class, (Object)Long.parseLong(id));
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Cannot find IdentityObject with id: " + id, (Throwable)e);
        }
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext ctx, IdentityObjectType identityType, IdentityObjectSearchCriteria criteria) throws IdentityException {
        this.checkIOType(identityType);
        HibernateIdentityObjectType hibernateType = this.getHibernateIdentityObjectType(ctx, identityType);
        HibernateRealm realm = this.getRealm(this.getHibernateSession(ctx), ctx);
        Session hibernateSession = this.getHibernateSession(ctx);
        try {
            StringBuilder hqlBuilderSelect = new StringBuilder("select distinct io from HibernateIdentityObject io");
            HashMap<String, Object> queryParams = new HashMap<String, Object>();
            StringBuilder hqlBuilderConditions = new StringBuilder(" where io.realm=:realm");
            queryParams.put(REALM_PROP_NAME, realm);
            String hibernateTypeName = hibernateType.getName();
            if (ALL_GROUPS_TYPE.equals(hibernateTypeName)) {
                hqlBuilderConditions.append(" and io.identityType.name <> 'USER'");
            } else {
                hqlBuilderConditions.append(" and io.identityType=:identityType");
                queryParams.put("identityType", hibernateType);
            }
            if (criteria != null && criteria.getFilter() != null) {
                String attrValue = criteria.getFilter().replace("\\*", "%").replace("*", "%");
                Object operator = "=";
                if (attrValue.contains("%")) {
                    operator = "like";
                }
                if (this.isAllowNotCaseSensitiveSearch()) {
                    attrValue = attrValue.toLowerCase();
                    hqlBuilderConditions.append(" and lower(io.name) " + (String)operator + " :ioName");
                } else {
                    hqlBuilderConditions.append(" and io.name " + (String)operator + " :ioName");
                }
                queryParams.put("ioName", attrValue);
            }
            if (criteria != null && criteria.isFiltered() && criteria.getValues() != null) {
                int i = 0;
                for (Map.Entry entry : criteria.getValues().entrySet()) {
                    String mappedAttributeName = null;
                    try {
                        mappedAttributeName = this.resolveAttributeStoreMapping(hibernateType, (String)entry.getKey());
                    }
                    catch (IdentityException identityException) {
                        // empty catch block
                    }
                    if (entry.getValue() == null || ((String[])entry.getValue()).length == 0) {
                        String attrTableJoinName = "attrs" + ++i;
                        String attrParamName = "attr" + i;
                        hqlBuilderConditions.append(" and not exists(from io.attributes as " + attrTableJoinName + " where " + attrTableJoinName + ".name = :" + attrParamName + ")");
                        queryParams.put(attrParamName, mappedAttributeName);
                        continue;
                    }
                    HashSet<String> given = new HashSet<String>(Arrays.asList((String[])entry.getValue()));
                    for (String attrValue : given) {
                        attrValue = attrValue.replace("\\*", "%").replace("*", "%");
                        String operator = "=";
                        if (attrValue.contains("%")) {
                            operator = "like";
                        }
                        if (this.isAllowNotCaseSensitiveSearch()) {
                            attrValue = attrValue.toLowerCase();
                        }
                        String attrTableJoinName = "attrs" + ++i;
                        String textValuesTableJoinName = "textValues" + i;
                        String attrParamName = "attr" + i;
                        String textValueParamName = "textValue" + i;
                        hqlBuilderSelect.append(" join io.attributes as " + attrTableJoinName);
                        hqlBuilderSelect.append(" join " + attrTableJoinName + ".textValues as " + textValuesTableJoinName);
                        hqlBuilderConditions.append(" and " + attrTableJoinName + ".name = :" + attrParamName);
                        if (this.isAllowNotCaseSensitiveSearch()) {
                            hqlBuilderConditions.append(" and lower(" + textValuesTableJoinName + ") " + operator + " :" + textValueParamName);
                        } else {
                            hqlBuilderConditions.append(" and " + textValuesTableJoinName + " " + operator + " :" + textValueParamName);
                        }
                        queryParams.put(attrParamName, mappedAttributeName);
                        queryParams.put(textValueParamName, attrValue);
                    }
                }
            }
            if (criteria != null && criteria.isSorted()) {
                if (criteria.isAscending()) {
                    hqlBuilderConditions.append(" order by io.name asc");
                } else {
                    hqlBuilderConditions.append(" order by io.name desc");
                }
            }
            Query hibernateQuery = hibernateSession.createQuery(hqlBuilderSelect.toString() + hqlBuilderConditions.toString(), HibernateIdentityObject.class);
            if (criteria != null && criteria.isPaged()) {
                if (criteria.getMaxResults() > 0) {
                    hibernateQuery.setMaxResults(criteria.getMaxResults());
                }
                hibernateQuery.setFirstResult(criteria.getFirstResult());
            }
            this.applyQueryParameters(hibernateQuery, queryParams);
            hibernateQuery.setCacheable(true);
            List results = hibernateQuery.list();
            Hibernate.initialize((Object)results);
            return results.stream().map(IdentityObject.class::cast).toList();
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Cannot find IdentityObjects with type '" + identityType.getName() + "'", (Throwable)e);
        }
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext ctx, IdentityObjectType identityType) throws IdentityException {
        return this.findIdentityObject(ctx, identityType, null);
    }

    public int getIdentityObjectCount(IdentityStoreInvocationContext invocationCxt, IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent, IdentityObjectSearchCriteria criteria) throws IdentityException {
        return this.getIdentityObjectCount(invocationCxt, identity, relationshipType, null, parent, criteria);
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext invocationCxt, IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent, IdentityObjectSearchCriteria criteria) throws IdentityException {
        return this.findIdentityObject(invocationCxt, identity, relationshipType, null, parent, criteria);
    }

    public int getIdentityObjectCount(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, Collection<IdentityObjectType> excludes, boolean parent, IdentityObjectSearchCriteria criteria) throws IdentityException {
        try {
            Query<?> q = this.prepareIdentityObjectQuery(ctx, identity, relationshipType, excludes, parent, criteria, false);
            Number result = (Number)q.uniqueResult();
            return Tools.convertToInt((Number)result);
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Cannot get IdentityObject count", (Throwable)e);
        }
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, Collection<IdentityObjectType> excludes, boolean parent, IdentityObjectSearchCriteria criteria) throws IdentityException {
        try {
            Query<?> q = this.prepareIdentityObjectQuery(ctx, identity, relationshipType, excludes, parent, criteria, false);
            List results = q.getResultList();
            Hibernate.initialize((Object)results);
            List<IdentityObject> identities = new ArrayList<IdentityObject>(results.stream().map(IdentityObject.class::cast).toList());
            if (criteria != null && criteria.isFiltered()) {
                this.filterByAttributesValues(identities, criteria);
                if (criteria.isPaged()) {
                    identities = this.cutPageFromResults(identities, criteria);
                }
            }
            return identities;
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Cannot find IdentityObjects", (Throwable)e);
        }
    }

    public Query<?> prepareIdentityObjectQuery(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, Collection<IdentityObjectType> excludes, boolean parent, IdentityObjectSearchCriteria criteria, boolean count) throws IdentityException {
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identity);
        HibernateRealm realm = this.getRealm(this.getHibernateSession(ctx), ctx);
        boolean orderByName = false;
        boolean ascending = true;
        if (criteria != null && criteria.isSorted()) {
            orderByName = true;
            ascending = criteria.isAscending();
        }
        try {
            StringBuilder hqlString = new StringBuilder("");
            if (parent) {
                if (count) {
                    hqlString.append("select count(distinct toio) from HibernateIdentityObjectRelationship ior join ior.toIdentityObject toio where ");
                } else {
                    hqlString.append("select distinct toio from HibernateIdentityObjectRelationship ior join ior.toIdentityObject toio where ");
                }
                hqlString.append("toio.realm = :realm and ior.fromIdentityObject.realm = :realm and ");
                if (relationshipType != null) {
                    hqlString.append("toio.name like :nameFilter and ior.type.name = :relType and ior.fromIdentityObject = :identity");
                } else {
                    hqlString.append("toio.name like :nameFilter and ior.fromIdentityObject = :identity");
                }
                if (CollectionUtils.isNotEmpty(excludes)) {
                    for (i = 0; i < excludes.size(); ++i) {
                        hqlString.append(" and toio.identityType.id <> ").append(":exclude" + i);
                    }
                }
                if (orderByName) {
                    hqlString.append(" order by toio.name");
                    if (ascending) {
                        hqlString.append(" asc");
                    }
                }
            } else {
                if (count) {
                    hqlString.append("select count(distinct fromio) from HibernateIdentityObjectRelationship ior join ior.fromIdentityObject fromio where ");
                } else {
                    hqlString.append("select distinct fromio from HibernateIdentityObjectRelationship ior join ior.fromIdentityObject fromio where ");
                }
                hqlString.append("ior.toIdentityObject.realm = :realm and fromio.realm = :realm and ");
                if (relationshipType != null) {
                    hqlString.append("fromio.name like :nameFilter and ior.type.name = :relType and ior.toIdentityObject = :identity");
                } else {
                    hqlString.append("fromio.name like :nameFilter and ior.toIdentityObject = :identity");
                }
                if (CollectionUtils.isNotEmpty(excludes)) {
                    for (i = 0; i < excludes.size(); ++i) {
                        hqlString.append(" and fromio.identityType.id <> ").append(":exclude" + i);
                    }
                }
                if (orderByName) {
                    hqlString.append(" order by fromio.name");
                    if (ascending) {
                        hqlString.append(" asc");
                    }
                }
            }
            Query q = count ? this.getHibernateSession(ctx).createQuery(hqlString.toString(), Long.class) : this.getHibernateSession(ctx).createQuery(hqlString.toString(), HibernateIdentityObject.class);
            q.setParameter("identity", (Object)hibernateObject).setParameter(REALM_PROP_NAME, (Object)realm).setCacheable(true);
            if (relationshipType != null) {
                q.setParameter("relType", (Object)relationshipType.getName());
            }
            if (criteria != null && criteria.getFilter() != null) {
                q.setParameter("nameFilter", (Object)criteria.getFilter().replace("\\*", "%").replace("*", "%"));
            } else {
                q.setParameter("nameFilter", (Object)"%");
            }
            if (CollectionUtils.isNotEmpty(excludes)) {
                int i = 0;
                for (IdentityObjectType exclude : excludes) {
                    HibernateIdentityObjectType exType = this.getHibernateIdentityObjectType(ctx, exclude);
                    q.setParameter("exclude" + i++, (Object)exType.getId());
                }
            }
            if (criteria != null && criteria.isPaged() && !criteria.isFiltered()) {
                q.setFirstResult(criteria.getFirstResult());
                if (criteria.getMaxResults() > 0) {
                    q.setMaxResults(criteria.getMaxResults());
                }
            }
            q.setCacheable(true);
            return q;
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Cannot prepare hibernate query", (Throwable)e);
        }
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent) throws IdentityException {
        return this.findIdentityObject(ctx, identity, relationshipType, parent, null);
    }

    public IdentityObjectRelationship createRelationship(IdentityStoreInvocationContext ctx, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType, String name, boolean createNames) throws IdentityException {
        if (relationshipType == null) {
            throw new IllegalArgumentException("RelationshipType is null");
        }
        HibernateIdentityObject fromIO = this.safeGet(ctx, fromIdentity);
        HibernateIdentityObject toIO = this.safeGet(ctx, toIdentity);
        HibernateIdentityObjectRelationshipType type = this.getHibernateIdentityObjectRelationshipType(ctx, relationshipType);
        Session hibernateSession = this.getHibernateSession(ctx);
        if (!this.isAllowNotDefinedIdentityObjectTypes() && !this.getSupportedFeatures().isRelationshipTypeSupported((IdentityObjectType)fromIO.getIdentityType(), (IdentityObjectType)toIO.getIdentityType(), relationshipType)) {
            throw new IdentityException("Relationship not supported. RelationshipType[ " + relationshipType.getName() + " ] beetween: [ " + fromIO.getIdentityType().getName() + " ] and [ " + toIO.getIdentityType().getName() + " ]");
        }
        HibernateIdentityObjectRelationship relationship = null;
        if (name != null) {
            HibernateIdentityObjectRelationshipName relationshipName = this.getRelationshipByName(hibernateSession, this.getRealmName(ctx), name);
            if (relationshipName == null) {
                throw new IdentityException(String.format(RELATIONSHIP_NOT_FOUND_MSG, name));
            }
            relationship = new HibernateIdentityObjectRelationship(type, fromIO, toIO, relationshipName);
        } else {
            relationship = new HibernateIdentityObjectRelationship(type, fromIO, toIO);
        }
        try {
            Session session = hibernateSession;
            session.persist((Object)relationship);
            session.flush();
        }
        catch (HibernateException e) {
            throw new IdentityException("Cannot create relationship: ", (Throwable)e);
        }
        return relationship;
    }

    public void removeRelationship(IdentityStoreInvocationContext ctx, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType, String name) throws IdentityException {
        if (relationshipType == null) {
            throw new IllegalArgumentException("RelationshipType is null");
        }
        HibernateIdentityObject fromIO = this.safeGet(ctx, fromIdentity);
        HibernateIdentityObject toIO = this.safeGet(ctx, toIdentity);
        HibernateIdentityObjectRelationshipType type = this.getHibernateIdentityObjectRelationshipType(ctx, relationshipType);
        Session hibernateSession = this.getHibernateSession(ctx);
        Query query = null;
        if (name == null) {
            query = hibernateSession.createNamedQuery("HibernateIdentityObjectRelationship.findIdentityObjectRelationshipWithoutName", HibernateIdentityObjectRelationship.class).setParameter(TYPE_ID_PROP_NAME, (Object)type.getId()).setParameter(FROM_IDENTITY_OBJECT_PROP_NAME, (Object)fromIO).setParameter(TO_IDENTITY_OBJECT_PROP_NAME, (Object)toIO);
        } else {
            HibernateIdentityObjectRelationshipName relationshipName = this.getRelationshipByName(hibernateSession, this.getRealmName(ctx), name);
            if (relationshipName == null) {
                throw new IdentityException(String.format(RELATIONSHIP_NOT_FOUND_MSG, name));
            }
            query = hibernateSession.createNamedQuery("HibernateIdentityObjectRelationship.findIdentityObjectRelationshipByAttributes", HibernateIdentityObjectRelationship.class).setParameter(TYPE_ID_PROP_NAME, (Object)type.getId()).setParameter(NAME_PROP_NAME, (Object)name).setParameter(FROM_IDENTITY_OBJECT_PROP_NAME, (Object)fromIO).setParameter(TO_IDENTITY_OBJECT_PROP_NAME, (Object)toIO);
        }
        HibernateIdentityObjectRelationship relationship = (HibernateIdentityObjectRelationship)query.uniqueResult();
        if (relationship == null) {
            throw new IdentityException("Relationship not present in the store");
        }
        try {
            fromIO.getFromRelationships().remove(relationship);
            toIO.getToRelationships().remove(relationship);
            hibernateSession.remove((Object)relationship);
            hibernateSession.flush();
        }
        catch (HibernateException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Cannot remove relationship");
        }
    }

    public void removeRelationships(IdentityStoreInvocationContext ctx, IdentityObject identity1, IdentityObject identity2, boolean named) throws IdentityException {
        HibernateIdentityObject hio1 = this.safeGet(ctx, identity1);
        HibernateIdentityObject hio2 = this.safeGet(ctx, identity2);
        Session hibernateSession = this.getHibernateSession(ctx);
        List results = hibernateSession.createNamedQuery("HibernateIdentityObjectRelationship.findIdentityObjectRelationshipsByIdentities", HibernateIdentityObjectRelationship.class).setParameter("hio1", (Object)hio1).setParameter("hio2", (Object)hio2).list();
        Hibernate.initialize((Object)results);
        for (HibernateIdentityObjectRelationship relationship : results) {
            if ((!named || relationship.getName() == null) && (named || relationship.getName() != null)) continue;
            try {
                relationship.getFromIdentityObject().getFromRelationships().remove(relationship);
                relationship.getToIdentityObject().getToRelationships().remove(relationship);
                hibernateSession.remove((Object)relationship);
                hibernateSession.flush();
            }
            catch (HibernateException e) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Exception occurred: ", e);
                }
                throw new IdentityException("Cannot remove relationship");
            }
        }
    }

    public Set<IdentityObjectRelationship> resolveRelationships(IdentityStoreInvocationContext ctx, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType) throws IdentityException {
        HibernateIdentityObject hio1 = this.safeGet(ctx, fromIdentity);
        HibernateIdentityObject hio2 = this.safeGet(ctx, toIdentity);
        List results = null;
        results = relationshipType == null ? this.getHibernateSession(ctx).createNamedQuery("HibernateIdentityObjectRelationship.findIdentityObjectRelationshipByIdentityByType", HibernateIdentityObjectRelationship.class).setParameter(FROM_IDENTITY_OBJECT_PROP_NAME, (Object)hio1).setParameter(TO_IDENTITY_OBJECT_PROP_NAME, (Object)hio2).list() : this.getHibernateSession(ctx).createNamedQuery("HibernateIdentityObjectRelationship.findIdentityObjectRelationshipByIdentityByType", HibernateIdentityObjectRelationship.class).setParameter(TYPE_NAME_PROP_NAME, (Object)relationshipType.getName()).setParameter(FROM_IDENTITY_OBJECT_PROP_NAME, (Object)hio1).setParameter(TO_IDENTITY_OBJECT_PROP_NAME, (Object)hio2).list();
        Hibernate.initialize((Object)results);
        return new HashSet<IdentityObjectRelationship>(results);
    }

    public int getRelationshipsCount(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType type, boolean parent, boolean named, String name, IdentityObjectSearchCriteria searchCriteria) throws IdentityException {
        Query<?> criteria = this.prepareResolveRelationshipsCriteria(ctx, identity, type, parent, named, name, searchCriteria, true);
        Number result = (Number)criteria.uniqueResult();
        return Tools.convertToInt((Number)result);
    }

    public Set<IdentityObjectRelationship> resolveRelationships(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType type, boolean parent, boolean named, String name, IdentityObjectSearchCriteria searchCriteria) throws IdentityException {
        Query<?> criteria = this.prepareResolveRelationshipsCriteria(ctx, identity, type, parent, named, name, searchCriteria, false);
        ArrayList<HibernateIdentityObjectRelationship> results = new ArrayList<HibernateIdentityObjectRelationship>();
        List list = criteria.list();
        Hibernate.initialize((Object)list);
        for (Object object : list) {
            HibernateIdentityObjectRelationship hibernateIdentityObjectRelationship;
            if (object instanceof Tuple) {
                Tuple t = (Tuple)object;
                hibernateIdentityObjectRelationship = (HibernateIdentityObjectRelationship)t.get(0, HibernateIdentityObjectRelationship.class);
                results.add(hibernateIdentityObjectRelationship);
                continue;
            }
            if (object instanceof HibernateIdentityObjectRelationship) {
                HibernateIdentityObjectRelationship hioRel = (HibernateIdentityObjectRelationship)object;
                results.add(hioRel);
                continue;
            }
            if (object.getClass().isArray()) {
                hibernateIdentityObjectRelationship = (HibernateIdentityObjectRelationship)((Object[])object)[0];
                results.add(hibernateIdentityObjectRelationship);
                continue;
            }
            log.warning("Unsupported retrieved object type: " + String.valueOf(object.getClass()));
        }
        return new HashSet<IdentityObjectRelationship>(results);
    }

    public Query<?> prepareResolveRelationshipsCriteria(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType type, boolean parent, boolean named, String name, IdentityObjectSearchCriteria searchCriteria, boolean count) throws IdentityException {
        boolean isSorted = searchCriteria != null && searchCriteria.isSorted();
        StringBuilder queryString = null;
        queryString = count ? new StringBuilder("SELECT COUNT(r) FROM HibernateIdentityObjectRelationship r ") : (isSorted ? new StringBuilder("SELECT r, io.name FROM HibernateIdentityObjectRelationship r ") : new StringBuilder("SELECT r FROM HibernateIdentityObjectRelationship r "));
        if (parent) {
            if (isSorted) {
                queryString.append(" JOIN r.toIdentityObject io");
            }
            queryString.append(" WHERE r.fromIdentityObject = :hio");
        } else {
            if (isSorted) {
                queryString.append(" JOIN r.fromIdentityObject io");
            }
            queryString.append(" WHERE r.toIdentityObject = :hio");
        }
        if (type != null) {
            queryString.append(" AND r.type.id = :typeId");
        }
        if (name != null) {
            queryString.append(" AND r.name.name = :name");
        } else if (named) {
            queryString.append(" AND r.name IS NOT NULL");
        } else {
            queryString.append(" AND r.name IS NULL");
        }
        if (isSorted) {
            queryString.append(" ORDER BY io.name");
            if (searchCriteria.isAscending()) {
                queryString.append(ASC_ORDER);
            } else {
                queryString.append(DESC_ORDER);
            }
        }
        Session hibernateSession = this.getHibernateSession(ctx);
        Query query = count ? hibernateSession.createQuery(queryString.toString(), Long.class) : (isSorted ? hibernateSession.createQuery(queryString.toString(), Tuple.class) : hibernateSession.createQuery(queryString.toString(), HibernateIdentityObjectRelationship.class));
        HibernateIdentityObject hio = this.safeGet(ctx, identity);
        query.setParameter("hio", (Object)hio);
        if (type != null) {
            HibernateIdentityObjectRelationshipType hibernateType = this.getHibernateIdentityObjectRelationshipType(ctx, type);
            query.setParameter(TYPE_ID_PROP_NAME, (Object)hibernateType.getId());
        }
        if (name != null) {
            query.setParameter(NAME_PROP_NAME, (Object)name);
        }
        if (searchCriteria != null && searchCriteria.isPaged() && !searchCriteria.isFiltered()) {
            if (searchCriteria.getMaxResults() > 0) {
                query.setMaxResults(searchCriteria.getMaxResults());
            }
            query.setFirstResult(searchCriteria.getFirstResult());
        }
        return query;
    }

    public String createRelationshipName(IdentityStoreInvocationContext ctx, String name) throws IdentityException {
        if (name == null) {
            throw new IllegalArgumentException(NAME_IS_NULL_MSG);
        }
        Session hibernateSession = this.getHibernateSession(ctx);
        try {
            HibernateIdentityObjectRelationshipName hiorn = this.getRelationshipByName(hibernateSession, this.getRealmName(ctx), name);
            if (hiorn != null) {
                throw new IdentityException(String.format("Relationship name '%s' already exists in the store", name));
            }
            HibernateRealm realm = this.getRealm(hibernateSession, ctx);
            hiorn = new HibernateIdentityObjectRelationshipName(name, realm);
            this.getHibernateSession(ctx).persist((Object)hiorn);
            this.getHibernateSession(ctx).flush();
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Cannot create new relationship name: " + name, (Throwable)e);
        }
        return name;
    }

    public String removeRelationshipName(IdentityStoreInvocationContext ctx, String name) throws IdentityException {
        if (name == null) {
            throw new IllegalArgumentException(NAME_IS_NULL_MSG);
        }
        Session hibernateSession = this.getHibernateSession(ctx);
        try {
            HibernateIdentityObjectRelationshipName hioRel = this.getRelationshipByName(hibernateSession, this.getRealmName(ctx), name);
            if (hioRel == null) {
                throw new IdentityException(String.format(RELATIONSHIP_NOT_FOUND_MSG, name));
            }
            this.removeRelationshipsByName(hibernateSession, hioRel);
            hibernateSession.flush();
            hibernateSession.getTransaction().commit();
            hibernateSession = this.getHibernateSession(ctx);
            hibernateSession.beginTransaction();
            hibernateSession.remove((Object)hioRel);
            hibernateSession.flush();
        }
        catch (Exception e) {
            throw new IdentityException("Cannot remove new relationship name: " + name, (Throwable)e);
        }
        return name;
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObjectSearchCriteria criteria) throws IdentityException {
        try {
            boolean isSorted;
            boolean hasFilter;
            StringBuilder queryString = new StringBuilder("SELECT DISTINCT rn.name FROM HibernateIdentityObjectRelationshipName rn ");
            queryString.append(" INNER JOIN rn.realm r ON r.name = :realmName");
            boolean bl = hasFilter = criteria != null && criteria.getFilter() != null;
            if (hasFilter) {
                queryString.append(" WHERE rn.name LIKE :name");
            } else {
                queryString.append(" WHERE rn.name IS NOT NULL");
            }
            boolean bl2 = isSorted = criteria != null && criteria.isSorted();
            if (isSorted) {
                queryString.append(" ORDER BY rn.name ");
                if (criteria.isAscending()) {
                    queryString.append(ASC_ORDER);
                } else {
                    queryString.append(DESC_ORDER);
                }
            }
            Query query = this.getHibernateSession(ctx).createQuery(queryString.toString(), String.class);
            query.setParameter(REALM_NAME_PROP_NAME, (Object)this.getRealmName(ctx));
            if (hasFilter) {
                query.setParameter(NAME_PROP_NAME, (Object)criteria.getFilter().replace("\\*", "%").replace("*", "%"));
            }
            if (criteria != null && criteria.isPaged()) {
                query.setFirstResult(criteria.getFirstResult());
                if (criteria.getMaxResults() > 0) {
                    query.setMaxResults(criteria.getMaxResults());
                }
            }
            List results = query.list();
            Hibernate.initialize((Object)results);
            return new LinkedHashSet<String>(results);
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Cannot get relationship names. ", (Throwable)e);
        }
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx) throws IdentityException {
        return this.getRelationshipNames(ctx, (IdentityObjectSearchCriteria)null);
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectSearchCriteria criteria) throws IdentityException {
        try {
            boolean isSorted;
            boolean hasFilter;
            StringBuilder queryString = new StringBuilder("SELECT DISTINCT rn.name FROM HibernateIdentityObjectRelationship r ");
            queryString.append(" INNER JOIN r.name rn");
            boolean bl = hasFilter = criteria != null && criteria.getFilter() != null;
            if (hasFilter) {
                queryString.append(" ON rn.name LIKE :name");
            }
            if (identity != null) {
                queryString.append(" WHERE r.fromIdentityObject = :hio OR r.toIdentityObject = :hio ");
            }
            boolean bl2 = isSorted = criteria != null && criteria.isSorted();
            if (isSorted) {
                queryString.append(" ORDER BY rn.name ");
                if (criteria.isAscending()) {
                    queryString.append(ASC_ORDER);
                } else {
                    queryString.append(DESC_ORDER);
                }
            }
            Query query = this.getHibernateSession(ctx).createQuery(queryString.toString(), String.class);
            if (hasFilter) {
                query.setParameter(NAME_PROP_NAME, (Object)criteria.getFilter().replace("\\*", "%").replace("*", "%"));
            }
            if (identity != null) {
                HibernateIdentityObject hibernateObject = this.safeGet(ctx, identity);
                query.setParameter("hio", (Object)hibernateObject);
            }
            if (criteria != null && criteria.isPaged()) {
                query.setFirstResult(criteria.getFirstResult());
                if (criteria.getMaxResults() > 0) {
                    query.setMaxResults(criteria.getMaxResults());
                }
            }
            List results = query.list();
            Hibernate.initialize((Object)results);
            return new LinkedHashSet<String>(results);
        }
        catch (Exception e) {
            throw new IdentityException("Cannot get relationship names. ", (Throwable)e);
        }
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObject identity) throws IdentityException {
        return this.getRelationshipNames(ctx, identity, null);
    }

    public Map<String, String> getRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name) throws IdentityException {
        if (name == null) {
            throw new IllegalArgumentException(NAME_IS_NULL_MSG);
        }
        Session hibernateSession = this.getHibernateSession(ctx);
        try {
            HibernateIdentityObjectRelationshipName hiorn = this.getRelationshipByName(hibernateSession, this.getRealmName(ctx), name);
            if (hiorn == null) {
                throw new IdentityException(String.format(RELATIONSHIP_NOT_FOUND_MSG, name));
            }
            Hibernate.initialize(hiorn.getProperties());
            return new HashMap<String, String>(hiorn.getProperties());
        }
        catch (Exception e) {
            throw new IdentityException("Cannot get relationship name properties: " + name, (Throwable)e);
        }
    }

    public void setRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name, Map<String, String> properties) throws IdentityException {
        if (name == null) {
            throw new IllegalArgumentException(NAME_IS_NULL_MSG);
        }
        Session hibernateSession = this.getHibernateSession(ctx);
        try {
            HibernateIdentityObjectRelationshipName hiorn = this.getRelationshipByName(hibernateSession, this.getRealmName(ctx), name);
            if (hiorn == null) {
                throw new IdentityException("Relationship name doesn't exist");
            }
            hiorn.getProperties().putAll(properties);
        }
        catch (Exception e) {
            throw new IdentityException("Cannot set relationship name properties: " + name, (Throwable)e);
        }
    }

    public void removeRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name, Set<String> properties) throws IdentityException {
        if (name == null) {
            throw new IllegalArgumentException(NAME_IS_NULL_MSG);
        }
        Session hibernateSession = this.getHibernateSession(ctx);
        try {
            HibernateIdentityObjectRelationshipName hiorn = this.getRelationshipByName(hibernateSession, this.getRealmName(ctx), name);
            if (hiorn == null) {
                throw new IdentityException("Relationship name doesn't exist");
            }
            Hibernate.initialize(hiorn.getProperties());
            for (String property : properties) {
                hiorn.getProperties().remove(property);
            }
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Cannot remove relationship name properties: " + name, (Throwable)e);
        }
    }

    public Map<String, String> getRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship) throws IdentityException {
        try {
            HibernateIdentityObjectRelationship hibernateRelationship = this.getHibernateIdentityObjectRelationship(ctx, relationship);
            Hibernate.initialize(hibernateRelationship.getProperties());
            return new HashMap<String, String>(hibernateRelationship.getProperties());
        }
        catch (HibernateException e) {
            throw new IdentityException("Cannot obtain relationship properties: ", (Throwable)e);
        }
    }

    public void setRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship, Map<String, String> properties) throws IdentityException {
        HibernateIdentityObjectRelationship hibernateRelationship = this.getHibernateIdentityObjectRelationship(ctx, relationship);
        try {
            hibernateRelationship.getProperties().putAll(properties);
        }
        catch (HibernateException e) {
            throw new IdentityException("Cannot update relationship properties: ", (Throwable)e);
        }
    }

    public void removeRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship, Set<String> properties) throws IdentityException {
        HibernateIdentityObjectRelationship hibernateRelationship = this.getHibernateIdentityObjectRelationship(ctx, relationship);
        try {
            Hibernate.initialize(hibernateRelationship.getProperties());
            for (String property : properties) {
                hibernateRelationship.getProperties().remove(property);
            }
        }
        catch (HibernateException e) {
            throw new IdentityException("Cannot update relationship properties: ", (Throwable)e);
        }
    }

    public Set<String> getSupportedAttributeNames(IdentityStoreInvocationContext ctx, IdentityObjectType identityType) throws IdentityException {
        this.checkIOType(identityType);
        if (this.attributeMappings.containsKey(identityType.getName())) {
            return this.attributeMappings.get(identityType.getName());
        }
        return new HashSet<String>();
    }

    public IdentityObjectAttribute getAttribute(IdentityStoreInvocationContext ctx, IdentityObject identity, String name) throws IdentityException {
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identity);
        Set<HibernateIdentityObjectAttribute> storeAttributes = hibernateObject.getAttributes();
        Hibernate.initialize(storeAttributes);
        for (HibernateIdentityObjectAttribute attribute : storeAttributes) {
            String mappedName = this.resolveAttributeNameFromStoreMapping(identity.getIdentityType(), name);
            if (mappedName == null) continue;
            return attribute;
        }
        return null;
    }

    public Map<String, IdentityObjectAttribute> getAttributes(IdentityStoreInvocationContext ctx, IdentityObject identity) throws IdentityException {
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identity);
        Hibernate.initialize(hibernateObject.getAttributes());
        HashMap<String, IdentityObjectAttribute> result = new HashMap<String, IdentityObjectAttribute>();
        for (HibernateIdentityObjectAttribute attribute : hibernateObject.getAttributes()) {
            String name = this.resolveAttributeNameFromStoreMapping(identity.getIdentityType(), attribute.getName());
            if (name == null) continue;
            result.put(name, attribute);
        }
        return result;
    }

    public Map<String, IdentityObjectAttributeMetaData> getAttributesMetaData(IdentityStoreInvocationContext invocationContext, IdentityObjectType identityType) {
        return this.attributesMetaData.get(identityType.getName());
    }

    public void updateAttributes(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectAttribute[] attributes) throws IdentityException {
        if (attributes == null) {
            throw new IllegalArgumentException(ATTRIBUTES_NULL_MSG);
        }
        HashMap<String, IdentityObjectAttribute> mappedAttributes = new HashMap<String, IdentityObjectAttribute>();
        Map<String, IdentityObjectAttributeMetaData> mdMap = this.attributesMetaData.get(identity.getIdentityType().getName());
        for (IdentityObjectAttribute attribute : attributes) {
            IdentityObject checkIdentity;
            String name = this.resolveAttributeStoreMapping(identity.getIdentityType(), attribute.getName());
            mappedAttributes.put(name, attribute);
            if (!(this.isAllowNotDefinedAttributes || mdMap != null && mdMap.containsKey(attribute.getName()))) {
                throw new IdentityException(String.format("Cannot add not defined attribute. Use '%s' option if needed. Attribute name: %s", ALLOW_NOT_DEFINED_ATTRIBUTES, attribute.getName()));
            }
            if (mdMap == null || !mdMap.containsKey(attribute.getName())) continue;
            IdentityObjectAttributeMetaData amd = mdMap.get(attribute.getName());
            if (!amd.isMultivalued() && attribute.getSize() > 1) {
                throw new IdentityException("Cannot assigned multiply values to single valued attribute: " + attribute.getName());
            }
            if (amd.isReadonly()) {
                mappedAttributes.remove(name);
                continue;
            }
            if (amd.isUnique() && (checkIdentity = this.findIdentityObjectByUniqueAttribute(ctx, identity.getIdentityType(), attribute)) != null && !checkIdentity.getName().equals(identity.getName())) {
                throw new IdentityException("Unique attribute '" + attribute.getName() + " value already set for identityObject: " + String.valueOf(checkIdentity));
            }
            String type = amd.getType();
            for (HibernateIdentityObjectAttribute value : attribute.getValues()) {
                if (type.equals("text") && !(value instanceof String)) {
                    throw new IdentityException("Cannot update text type attribute with not String type value: " + attribute.getName() + " / " + String.valueOf(value));
                }
                if (!type.equals("binary") || value instanceof byte[]) continue;
                throw new IdentityException("Cannot update binary type attribute with not byte[] type value: " + attribute.getName() + " / " + String.valueOf(value));
            }
            if (!type.equals("binary") || attribute.getValues().size() <= 1) continue;
            throw new IdentityException("Cannot add binary type attribute with more than one value - this implementationsupport only single value binary attributes: " + attribute.getName());
        }
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identity);
        Hibernate.initialize(hibernateObject.getAttributes());
        for (String name : mappedAttributes.keySet()) {
            IdentityObjectAttribute attribute;
            attribute = (IdentityObjectAttribute)mappedAttributes.get(name);
            IdentityObjectAttributeMetaData amd = null;
            if (mdMap != null) {
                amd = mdMap.get(attribute.getName());
            }
            String type = amd != null ? amd.getType() : "text";
            boolean present = false;
            for (HibernateIdentityObjectAttribute storeAttribute : hibernateObject.getAttributes()) {
                if (!storeAttribute.getName().equals(name)) continue;
                present = true;
                if (storeAttribute.getType().equals("text")) {
                    if (!type.equals("text")) {
                        throw new IdentityException("Wrong attribute mapping. Attribute persisted as text is mapped with: " + type + ". Attribute name: " + name);
                    }
                    HashSet<String> v = new HashSet<String>();
                    for (Object value : attribute.getValues()) {
                        v.add(value.toString());
                    }
                    storeAttribute.setTextValues(v);
                    break;
                }
                if (storeAttribute.getType().equals("binary")) {
                    if (!type.equals("binary")) {
                        throw new IdentityException("Wrong attribute mapping. Attribute persisted as binary is mapped with: " + type + ". Attribute name: " + name);
                    }
                    HibernateIdentityObjectAttributeBinaryValue bv = new HibernateIdentityObjectAttributeBinaryValue((byte[])attribute.getValue());
                    this.getHibernateSession(ctx).persist((Object)bv);
                    storeAttribute.setBinaryValue(bv);
                    break;
                }
                throw new IdentityException("Internal identity store error");
            }
            if (present || attribute.getValues() == null || attribute.getValues().isEmpty()) continue;
            HibernateIdentityObjectAttribute newAttribute = new HibernateIdentityObjectAttribute(hibernateObject, name, type);
            if (type.equals("text")) {
                newAttribute.setTextValues(attribute.getValues());
            } else if (type.equals("binary")) {
                HibernateIdentityObjectAttributeBinaryValue bv = new HibernateIdentityObjectAttributeBinaryValue((byte[])attribute.getValue());
                this.getHibernateSession(ctx).persist((Object)bv);
                newAttribute.setBinaryValue(bv);
            }
            hibernateObject.addAttribute(newAttribute);
        }
    }

    public void addAttributes(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectAttribute[] attributes) throws IdentityException {
        if (attributes == null) {
            throw new IllegalArgumentException(ATTRIBUTES_NULL_MSG);
        }
        HashMap<String, IdentityObjectAttribute> mappedAttributes = new HashMap<String, IdentityObjectAttribute>();
        Map<String, IdentityObjectAttributeMetaData> mdMap = this.attributesMetaData.get(identity.getIdentityType().getName());
        Session hibernateSession = this.getHibernateSession(ctx);
        for (IdentityObjectAttribute attribute : attributes) {
            IdentityObject checkIdentity;
            String name = this.resolveAttributeStoreMapping(identity.getIdentityType(), attribute.getName());
            mappedAttributes.put(name, attribute);
            if (!(mdMap != null && mdMap.containsKey(attribute.getName()) || this.isAllowNotDefinedAttributes)) {
                throw new IdentityException("Cannot add not defined attribute. Use 'allowNotDefinedAttributes' option if needed. Attribute name: " + attribute.getName());
            }
            IdentityObjectAttributeMetaData amd = null;
            if (mdMap != null) {
                amd = mdMap.get(attribute.getName());
            }
            if (amd == null) continue;
            if (!amd.isMultivalued() && attribute.getSize() > 1) {
                throw new IdentityException("Cannot add multiply values to single valued attribute: " + attribute.getName());
            }
            if (amd.isReadonly()) {
                mappedAttributes.remove(name);
                continue;
            }
            if (amd.isUnique() && (checkIdentity = this.findIdentityObjectByUniqueAttribute(ctx, identity.getIdentityType(), attribute)) != null && !checkIdentity.getName().equals(identity.getName())) {
                throw new IdentityException("Unique attribute '" + attribute.getName() + " value already set for identityObject: " + String.valueOf(checkIdentity));
            }
            String type = amd.getType();
            for (HibernateIdentityObjectAttribute hibernateIdentityObjectAttribute : attribute.getValues()) {
                if (type.equals("text") && !(hibernateIdentityObjectAttribute instanceof String)) {
                    throw new IdentityException("Cannot add text type attribute with not String type value: " + attribute.getName() + " / " + String.valueOf(hibernateIdentityObjectAttribute));
                }
                if (!type.equals("binary") || hibernateIdentityObjectAttribute instanceof byte[]) continue;
                throw new IdentityException("Cannot add binary type attribute with not byte[] type value: " + attribute.getName() + " / " + String.valueOf(hibernateIdentityObjectAttribute));
            }
            if (!type.equals("binary") || attribute.getValues().size() <= 1) continue;
            throw new IdentityException("Cannot add binary type attribute with more than one value - this implementationsupport only single value binary attributes: " + attribute.getName());
        }
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identity);
        Hibernate.initialize(hibernateObject.getAttributes());
        for (String name : mappedAttributes.keySet()) {
            IdentityObjectAttribute attribute;
            attribute = (IdentityObjectAttribute)mappedAttributes.get(name);
            IdentityObjectAttributeMetaData amd = mdMap != null ? mdMap.get(attribute.getName()) : null;
            String type = amd != null ? amd.getType() : "text";
            HibernateIdentityObjectAttribute hibernateAttribute = null;
            for (HibernateIdentityObjectAttribute hibernateIdentityObjectAttribute : hibernateObject.getAttributes()) {
                if (!hibernateIdentityObjectAttribute.getName().equals(name)) continue;
                hibernateAttribute = hibernateIdentityObjectAttribute;
                break;
            }
            if (hibernateAttribute != null) {
                if (hibernateAttribute.getType().equals("text")) {
                    if (!type.equals("text")) {
                        throw new IdentityException("Wrong attribute mapping. Attribute persisted as text is mapped with: " + type + ". Attribute name: " + name);
                    }
                    HashSet<String> mergedValues = new HashSet<String>(hibernateAttribute.getValues());
                    for (Object value : attribute.getValues()) {
                        mergedValues.add(value.toString());
                    }
                    hibernateAttribute.setTextValues(mergedValues);
                    break;
                }
                if (hibernateAttribute.getType().equals("binary")) {
                    if (!type.equals("binary")) {
                        throw new IdentityException("Wrong attribute mapping. Attribute persisted as binary is mapped with: " + type + ". Attribute name: " + name);
                    }
                    HibernateIdentityObjectAttributeBinaryValue bv = new HibernateIdentityObjectAttributeBinaryValue((byte[])attribute.getValue());
                    hibernateSession.persist((Object)bv);
                    hibernateAttribute.setBinaryValue(bv);
                    break;
                }
                throw new IdentityException("Internal identity store error");
            }
            if (type.equals("text")) {
                values = new HashSet<String>();
                for (Object value : attribute.getValues()) {
                    values.add(value.toString());
                }
                hibernateAttribute = new HibernateIdentityObjectAttribute(hibernateObject, name, "text");
                hibernateAttribute.setTextValues(values);
            } else if (type.equals("binary")) {
                values = new HashSet();
                for (Object value : attribute.getValues()) {
                    values.add((String)((byte[])value));
                }
                hibernateAttribute = new HibernateIdentityObjectAttribute(hibernateObject, name, "binary");
                HibernateIdentityObjectAttributeBinaryValue hibernateIdentityObjectAttributeBinaryValue = new HibernateIdentityObjectAttributeBinaryValue((byte[])attribute.getValue());
                hibernateSession.persist((Object)hibernateIdentityObjectAttributeBinaryValue);
                hibernateAttribute.setBinaryValue(hibernateIdentityObjectAttributeBinaryValue);
            }
            hibernateObject.addAttribute(hibernateAttribute);
        }
    }

    public void removeAttributes(IdentityStoreInvocationContext ctx, IdentityObject identity, String[] attributes) throws IdentityException {
        if (attributes == null) {
            throw new IllegalArgumentException(ATTRIBUTES_NULL_MSG);
        }
        String[] mappedAttributes = new String[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            String name;
            mappedAttributes[i] = name = this.resolveAttributeStoreMapping(identity.getIdentityType(), attributes[i]);
            Map<String, IdentityObjectAttributeMetaData> mdMap = this.attributesMetaData.get(identity.getIdentityType().getName());
            if (mdMap != null) {
                IdentityObjectAttributeMetaData amd = mdMap.get(attributes[i]);
                if (amd == null || !amd.isRequired()) continue;
                throw new IdentityException("Cannot remove required attribute: " + attributes[i]);
            }
            if (this.isAllowNotDefinedAttributes) continue;
            throw new IdentityException("Cannot remove not defined attribute. Use 'allowNotDefinedAttributes' option if needed. Attribute name: " + attributes[i]);
        }
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identity);
        Hibernate.initialize(hibernateObject.getAttributes());
        for (String attr : mappedAttributes) {
            hibernateObject.removeAttribute(attr);
        }
    }

    public IdentityObject findIdentityObjectByUniqueAttribute(IdentityStoreInvocationContext invocationCtx, IdentityObjectType identityObjectType, IdentityObjectAttribute attribute) throws IdentityException {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        this.checkIOType(identityObjectType);
        String attrMappedName = this.resolveAttributeStoreMapping(identityObjectType, attribute.getName());
        HibernateIdentityObjectType hiot = this.getHibernateIdentityObjectType(invocationCtx, identityObjectType);
        Session session = this.getHibernateSession(invocationCtx);
        HibernateRealm realm = this.getRealm(session, invocationCtx);
        if (attribute.getValues() == null || attribute.getValues().isEmpty()) {
            return null;
        }
        boolean attrDuctTypeText = true;
        if (attribute.getValue() instanceof byte[]) {
            attrDuctTypeText = false;
        }
        StringBuilder queryString = new StringBuilder("SELECT a FROM HibernateIdentityObjectAttribute a ");
        queryString.append(" WHERE a.identityObject.identityType = :identityType");
        queryString.append(" AND a.name = :attributeName");
        queryString.append(" AND a.identityObject.realm = :realm");
        if (attrDuctTypeText) {
            for (int i = 0; i < attribute.getValues().size(); ++i) {
                String paramName = " :value" + i;
                queryString.append(" and").append(paramName).append(" = any elements(a.textValues)");
            }
        } else {
            queryString.append(" and :value = a.binaryValue");
        }
        Query q = session.createQuery(queryString.toString(), HibernateIdentityObjectAttribute.class).setParameter("identityType", (Object)hiot).setParameter("attributeName", (Object)attrMappedName).setParameter(REALM_PROP_NAME, (Object)realm);
        if (attrDuctTypeText) {
            int i = 0;
            for (Object o : attribute.getValues()) {
                String value = o.toString();
                String paramName = "value" + i;
                q.setParameter(paramName, (Object)value);
                ++i;
            }
        } else {
            q.setParameter("value", attribute.getValue());
        }
        List attrs = q.list();
        if (CollectionUtils.isEmpty((Collection)attrs)) {
            return null;
        }
        if (attrs.size() > 1) {
            throw new IdentityException("Illegal state - more than one IdentityObject with the same unique attribute value: " + String.valueOf(attribute));
        }
        return ((HibernateIdentityObjectAttribute)attrs.get(0)).getIdentityObject();
    }

    public boolean validateCredential(IdentityStoreInvocationContext ctx, IdentityObject identityObject, IdentityObjectCredential credential) throws IdentityException {
        if (credential == null) {
            throw new IllegalArgumentException();
        }
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identityObject);
        if (this.supportedFeatures.isCredentialSupported((IdentityObjectType)hibernateObject.getIdentityType(), credential.getType())) {
            Session hibernateSession = this.getHibernateSession(ctx);
            Query query = hibernateSession.createNamedQuery("HibernateIdentityObjectCredential.findCredentialByTypeAndIdentity", HibernateIdentityObjectCredential.class);
            query.setParameter("cTypeName", (Object)credential.getType().getName());
            query.setParameter("ioId", (Object)hibernateObject.getIdLong());
            HibernateIdentityObjectCredential hibernateCredential = (HibernateIdentityObjectCredential)query.uniqueResult();
            if (hibernateCredential == null) {
                return false;
            }
            Object tmpEncodedValue = credential.getEncodedValue();
            Object value = null;
            value = tmpEncodedValue != null ? tmpEncodedValue : credential.getValue();
            if (value instanceof String && hibernateCredential.getTextValue() != null) {
                return value.toString().equals(hibernateCredential.getTextValue());
            }
            if (value instanceof byte[]) {
                byte[] bytes = (byte[])value;
                if (hibernateCredential.getBinaryValue() != null) {
                    return Arrays.equals(bytes, hibernateCredential.getBinaryValue().getValue());
                }
            }
            throw new IdentityException("Not supported credential value: " + String.valueOf(value.getClass()));
        }
        throw new IdentityException("CredentialType not supported for a given IdentityObjectType");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateCredential(IdentityStoreInvocationContext ctx, IdentityObject identityObject, IdentityObjectCredential credential) throws IdentityException {
        if (credential == null) {
            throw new IllegalArgumentException();
        }
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identityObject);
        Session hibernateSession = this.getHibernateSession(ctx);
        if (!this.supportedFeatures.isCredentialSupported((IdentityObjectType)hibernateObject.getIdentityType(), credential.getType())) throw new IdentityException("CredentialType not supported for a given IdentityObjectType");
        HibernateIdentityObjectCredentialType hibernateCredentialType = this.getHibernateIdentityObjectCredentialType(ctx, credential.getType());
        if (hibernateCredentialType == null) {
            throw new IllegalStateException("Credential type not present in this store: " + credential.getType().getName());
        }
        Object value = null;
        Object tmpEncodedValue = credential.getEncodedValue();
        value = tmpEncodedValue != null ? tmpEncodedValue : credential.getValue();
        HibernateIdentityObjectCredential hibernateCredential = hibernateObject.getCredential(credential.getType());
        if (hibernateCredential == null) {
            hibernateCredential = new HibernateIdentityObjectCredential();
            hibernateCredential.setType(hibernateCredentialType);
            hibernateObject.addCredential(hibernateCredential);
        }
        if (value instanceof String) {
            hibernateCredential.setTextValue(value.toString());
        } else {
            if (!(value instanceof byte[])) throw new IdentityException("Not supported credential value: " + String.valueOf(value.getClass()));
            byte[] bytes = (byte[])value;
            HibernateIdentityObjectCredentialBinaryValue bv = new HibernateIdentityObjectCredentialBinaryValue(bytes);
            this.getHibernateSession(ctx).persist((Object)bv);
            hibernateCredential.setBinaryValue(bv);
        }
        hibernateSession.persist((Object)hibernateCredential);
        hibernateObject.addCredential(hibernateCredential);
        hibernateSession.flush();
    }

    public void addIdentityObjectType(IdentityStoreInvocationContext ctx, IdentityObjectType type) throws IdentityException {
        HibernateIdentityObjectType hibernateType = new HibernateIdentityObjectType(type);
        this.getHibernateSession(ctx).persist((Object)hibernateType);
        this.getHibernateSession(ctx).flush();
    }

    public void addIdentityObjectRelationshipType(IdentityStoreInvocationContext ctx, IdentityObjectRelationshipType type) throws IdentityException {
        HibernateIdentityObjectRelationshipType hibernateType = new HibernateIdentityObjectRelationshipType(type);
        this.getHibernateSession(ctx).persist((Object)hibernateType);
        this.getHibernateSession(ctx).flush();
    }

    protected Session getHibernateSession(IdentityStoreInvocationContext ctx) throws IdentityException {
        try {
            ExoHibernateIdentityStoreSessionImpl hbIdentityStoreSession = (ExoHibernateIdentityStoreSessionImpl)ctx.getIdentityStoreSession();
            if (this.lazyStartOfHibernateTransaction) {
                hbIdentityStoreSession.startHibernateTransactionIfNotStartedYet();
            }
            return (Session)hbIdentityStoreSession.getSessionContext();
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Cannot obtain Hibernate Session", (Throwable)e);
        }
    }

    private void checkIOInstance(IdentityObject io) {
        if (io == null) {
            throw new IllegalArgumentException("IdentityObject is null");
        }
    }

    private HibernateIdentityObject safeGet(IdentityStoreInvocationContext ctx, IdentityObject io) throws IdentityException {
        this.checkIOInstance(io);
        if (io instanceof HibernateIdentityObject) {
            HibernateIdentityObject hio = (HibernateIdentityObject)io;
            return hio;
        }
        return this.getHibernateIdentityObject(ctx, io);
    }

    private void checkIOType(IdentityObjectType iot) throws IdentityException {
        if (iot == null) {
            throw new IllegalArgumentException("IdentityObjectType is null");
        }
        if (!this.isAllowNotDefinedIdentityObjectTypes() && !this.getSupportedFeatures().isIdentityObjectTypeSupported(iot)) {
            throw new IdentityException("IdentityType not supported by this IdentityStore implementation: " + String.valueOf(iot));
        }
    }

    private HibernateIdentityObjectType getHibernateIdentityObjectType(IdentityStoreInvocationContext ctx, IdentityObjectType type) throws IdentityException {
        this.checkIOType(type);
        String typeName = type.getName();
        try {
            Session hibernateSession = this.getHibernateSession(ctx);
            HibernateIdentityObjectType hibernateType = this.getHibernateIdentityObjectType(hibernateSession, typeName);
            if (hibernateType == null && this.isAllowNotDefinedIdentityObjectTypes()) {
                this.populateObjectTypes(hibernateSession, new String[]{typeName});
                hibernateType = this.getHibernateIdentityObjectType(hibernateSession, typeName);
            }
            if (hibernateType == null) {
                throw new IdentityException("IdentityObjectType[" + typeName + "] not present in the store.");
            }
            return hibernateType;
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("IdentityObjectType[" + typeName + "] not present in the store.", (Throwable)e);
        }
    }

    private HibernateIdentityObjectType getHibernateIdentityObjectType(Session hibernateSession, String typeName) {
        Query query = hibernateSession.createNamedQuery("HibernateIdentityObjectType.findIdentityObjectTypeByName", HibernateIdentityObjectType.class);
        query.setParameter(NAME_PROP_NAME, (Object)typeName);
        return (HibernateIdentityObjectType)query.uniqueResult();
    }

    private HibernateIdentityObject getHibernateIdentityObject(IdentityStoreInvocationContext ctx, IdentityObject io) throws IdentityException {
        Session hibernateSession = this.getHibernateSession(ctx);
        String typeName = io.getIdentityType().getName();
        try {
            if (this.isAllowNotCaseSensitiveSearch(typeName)) {
                return (HibernateIdentityObject)hibernateSession.createNamedQuery("HibernateIdentityObject.findIdentityObjectByNameAndTypeIgnoreCase", HibernateIdentityObject.class).setParameter(NAME_PROP_NAME, (Object)io.getName().toLowerCase()).setParameter(REALM_NAME_PROP_NAME, (Object)this.getRealmName(ctx)).setParameter(TYPE_NAME_PROP_NAME, (Object)typeName).uniqueResult();
            }
            return (HibernateIdentityObject)hibernateSession.createNamedQuery("HibernateIdentityObject.findIdentityObjectByNameAndType", HibernateIdentityObject.class).setParameter(NAME_PROP_NAME, (Object)io.getName()).setParameter(REALM_NAME_PROP_NAME, (Object)this.getRealmName(ctx)).setParameter(TYPE_NAME_PROP_NAME, (Object)typeName).uniqueResult();
        }
        catch (NonUniqueResultException e) {
            log.log(Level.SEVERE, "The identity of type '" + typeName + "' and with name '" + io.getName() + "' is not unique. Thus a null result will be returned.", e);
            return null;
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("IdentityObject[ " + io.getName() + " | " + typeName + "] not present in the store.", (Throwable)e);
        }
    }

    private HibernateIdentityObjectRelationshipType getHibernateIdentityObjectRelationshipType(IdentityStoreInvocationContext ctx, IdentityObjectRelationshipType iot) throws IdentityException {
        Session hibernateSession = this.getHibernateSession(ctx);
        String typeName = iot.getName();
        try {
            return this.getHibernateIdentityObjectRelationshipType(hibernateSession, typeName);
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("IdentityObjectRelationshipType[ " + typeName + "] not present in the store.");
        }
    }

    private HibernateIdentityObjectRelationshipType getHibernateIdentityObjectRelationshipType(Session hibernateSession, String typeName) {
        return (HibernateIdentityObjectRelationshipType)hibernateSession.createNamedQuery("HibernateIdentityObjectRelationshipType.findIdentityRelationshipTypeByName", HibernateIdentityObjectRelationshipType.class).setParameter(NAME_PROP_NAME, (Object)typeName).uniqueResult();
    }

    private HibernateIdentityObjectCredentialType getHibernateIdentityObjectCredentialType(IdentityStoreInvocationContext ctx, IdentityObjectCredentialType credentialType) throws IdentityException {
        Session hibernateSession = this.getHibernateSession(ctx);
        String typeName = credentialType.getName();
        try {
            return this.getHibernateIdentityObjectCredentialType(hibernateSession, typeName);
        }
        catch (HibernateException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("IdentityObjectCredentialType[ " + typeName + "] not present in the store.");
        }
    }

    private HibernateIdentityObjectCredentialType getHibernateIdentityObjectCredentialType(Session hibernateSession, String typeName) {
        return (HibernateIdentityObjectCredentialType)hibernateSession.createNamedQuery("HibernateIdentityObjectCredentialType.findIdentityCredentialTypeByName", HibernateIdentityObjectCredentialType.class).setParameter(NAME_PROP_NAME, (Object)typeName).uniqueResult();
    }

    public void populateObjectTypes(Session hibernateSession, String[] typeNames) {
        for (String typeName : typeNames) {
            HibernateIdentityObjectType hibernateType = this.getHibernateIdentityObjectType(hibernateSession, typeName);
            if (hibernateType != null) continue;
            hibernateType = new HibernateIdentityObjectType(typeName);
            hibernateSession.persist((Object)hibernateType);
        }
    }

    public void populateRelationshipTypes(Session hibernateSession, String[] typeNames) {
        for (String typeName : typeNames) {
            HibernateIdentityObjectRelationshipType hibernateType = this.getHibernateIdentityObjectRelationshipType(hibernateSession, typeName);
            if (hibernateType != null) continue;
            hibernateType = new HibernateIdentityObjectRelationshipType(typeName);
            hibernateSession.persist((Object)hibernateType);
        }
    }

    public void populateCredentialTypes(Session hibernateSession, String[] typeNames) {
        for (String typeName : typeNames) {
            HibernateIdentityObjectCredentialType hibernateType = this.getHibernateIdentityObjectCredentialType(hibernateSession, typeName);
            if (hibernateType != null) continue;
            hibernateType = new HibernateIdentityObjectCredentialType(typeName);
            hibernateSession.persist((Object)hibernateType);
        }
    }

    public void addRealm(Session hibernateSession, String realmName) throws IdentityException {
        try {
            HibernateRealm realm = new HibernateRealm(realmName);
            hibernateSession.persist((Object)realm);
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Failed to create store realm", (Throwable)e);
        }
    }

    private HibernateRealm getRealm(Session hibernateSession, IdentityStoreInvocationContext ctx) {
        if (this.getRealmName(ctx) == null) {
            throw new IllegalStateException("Realm Id not present");
        }
        HibernateRealm realm = null;
        if (!this.isRealmAware()) {
            realm = this.getHibernateRealmByName(hibernateSession, DEFAULT_REALM_NAME);
            if (realm == null) {
                throw new IllegalStateException("Default store realm is not present: " + DEFAULT_REALM_NAME);
            }
        } else {
            realm = this.getHibernateRealmByName(hibernateSession, this.getRealmName(ctx));
            if (realm == null) {
                HibernateRealm newRealm = new HibernateRealm(this.getRealmName(ctx));
                hibernateSession.persist((Object)newRealm);
                return newRealm;
            }
        }
        return realm;
    }

    private String getRealmName(IdentityStoreInvocationContext ctx) {
        if (this.isRealmAware()) {
            return ctx.getRealmId();
        }
        return DEFAULT_REALM_NAME;
    }

    private boolean isRealmAware() {
        return this.isRealmAware;
    }

    private boolean isAllowNotDefinedAttributes() {
        return this.isAllowNotDefinedAttributes;
    }

    private String resolveAttributeStoreMapping(IdentityObjectType type, String name) throws IdentityException {
        IdentityObjectAttributeMetaData amd;
        String mapping = null;
        if (this.attributesMetaData.containsKey(type.getName()) && (amd = this.attributesMetaData.get(type.getName()).get(name)) != null) {
            mapping = amd.getStoreMapping() != null ? amd.getStoreMapping() : amd.getName();
            return mapping;
        }
        if (this.isAllowNotDefinedAttributes()) {
            mapping = name;
            return mapping;
        }
        throw new IdentityException("Attribute name is not configured in this store");
    }

    private String resolveAttributeNameFromStoreMapping(IdentityObjectType type, String mapping) {
        Map<String, String> map;
        if (this.reverseAttributeMappings.containsKey(type.getName()) && (map = this.reverseAttributeMappings.get(type.getName())) != null) {
            return map.containsKey(mapping) ? map.get(mapping) : mapping;
        }
        if (this.isAllowNotDefinedAttributes()) {
            return mapping;
        }
        return null;
    }

    private void filterByAttributesValues(Collection<IdentityObject> objects, IdentityObjectSearchCriteria criteria) {
        HashSet<IdentityObject> toRemove = new HashSet<IdentityObject>();
        Map attrs = criteria.getValues();
        block2: for (IdentityObject object : objects) {
            Map<String, Collection> presentAttrs = ((HibernateIdentityObject)object).getAttributesAsMap();
            block3: for (Map.Entry entry : attrs.entrySet()) {
                String mappedAttributeName = null;
                try {
                    mappedAttributeName = this.resolveAttributeStoreMapping(object.getIdentityType(), (String)entry.getKey());
                }
                catch (IdentityException identityException) {
                    // empty catch block
                }
                if (((String)entry.getKey()).equals("enabled") && entry.getValue() != null && ((String[])entry.getValue()).length == 0) {
                    if (!presentAttrs.containsKey(mappedAttributeName)) continue;
                    toRemove.add(object);
                    continue;
                }
                if (mappedAttributeName == null) {
                    toRemove.add(object);
                    continue block2;
                }
                if (presentAttrs.containsKey(mappedAttributeName)) {
                    HashSet<String> given = new HashSet<String>(Arrays.asList((String[])entry.getValue()));
                    Collection present = presentAttrs.get(mappedAttributeName);
                    for (String s : given) {
                        String regex = Tools.wildcardToRegex((String)s);
                        boolean matches = false;
                        for (Object o : present) {
                            if (!o.toString().matches(regex)) continue;
                            matches = true;
                        }
                        if (matches) continue;
                        toRemove.add(object);
                        continue block3;
                    }
                    continue;
                }
                toRemove.add(object);
                continue block2;
            }
        }
        for (IdentityObject identityObject : toRemove) {
            objects.remove(identityObject);
        }
    }

    private <T> List<T> cutPageFromResults(List<T> objects, IdentityObjectSearchCriteria criteria) {
        LinkedList<T> results = new LinkedList<T>();
        if (criteria.getMaxResults() == 0) {
            for (int i = criteria.getFirstResult(); i < objects.size(); ++i) {
                if (i >= objects.size()) continue;
                results.add(objects.get(i));
            }
        } else {
            for (int i = criteria.getFirstResult(); i < criteria.getFirstResult() + criteria.getMaxResults(); ++i) {
                if (i >= objects.size()) continue;
                results.add(objects.get(i));
            }
        }
        return results;
    }

    private void applyQueryParameters(Query<?> hibernateQuery, Map<String, Object> queryParams) {
        for (Map.Entry<String, Object> entry : queryParams.entrySet()) {
            hibernateQuery.setParameter(entry.getKey(), entry.getValue());
        }
    }

    protected boolean isAllowNotDefinedIdentityObjectTypes() {
        return this.isAllowNotDefinedIdentityObjectTypes;
    }

    public boolean isManageTransactionDuringBootstrap() {
        return this.isManageTransactionDuringBootstrap;
    }

    public boolean isAllowNotCaseSensitiveSearch() {
        return this.isAllowNotCaseSensitiveSearch;
    }

    private boolean isAllowNotCaseSensitiveSearch(String typeName) {
        return this.isAllowNotCaseSensitiveSearch() && typeName.equalsIgnoreCase("USER");
    }

    private void removeRelationshipsByName(Session hibernateSession, HibernateIdentityObjectRelationshipName hiorn) throws IdentityException {
        hibernateSession.createNamedQuery("HibernateIdentityObjectRelationship.removeRelationshipsByName").setParameter("nameId", (Object)hiorn.getId()).executeUpdate();
    }

    private HibernateRealm getHibernateRealmByName(Session hibernateSession, String realmName) {
        return (HibernateRealm)hibernateSession.createNamedQuery("HibernateRealm.findRealmByName", HibernateRealm.class).setParameter(NAME_PROP_NAME, (Object)realmName).uniqueResult();
    }

    private HibernateIdentityObjectRelationshipName getRelationshipByName(Session hibernateSession, String realmName, String name) {
        return (HibernateIdentityObjectRelationshipName)hibernateSession.createNamedQuery("HibernateIdentityObjectRelationshipName.findIdentityObjectRelationshipNameByName", HibernateIdentityObjectRelationshipName.class).setParameter(NAME_PROP_NAME, (Object)name).setParameter(REALM_NAME_PROP_NAME, (Object)realmName).uniqueResult();
    }

    private HibernateIdentityObjectRelationship getHibernateIdentityObjectRelationship(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship) throws IdentityException {
        try {
            StringBuilder queryString = new StringBuilder("SELECT r FROM HibernateIdentityObjectRelationship r");
            queryString.append(" WHERE r.type.id = :typeId ");
            queryString.append(" AND r.fromIdentityObject = :fromIo ");
            queryString.append(" AND r.toIdentityObject = :toIo ");
            if (relationship.getName() != null) {
                queryString.append(" AND r.name.id = :nameId ");
            }
            Session hibernateSession = this.getHibernateSession(ctx);
            Query query = hibernateSession.createQuery(queryString.toString(), HibernateIdentityObjectRelationship.class);
            HibernateIdentityObjectRelationshipType type = this.getHibernateIdentityObjectRelationshipType(ctx, relationship.getType());
            query.setParameter(TYPE_ID_PROP_NAME, (Object)type.getId());
            HibernateIdentityObject fromIO = this.safeGet(ctx, relationship.getFromIdentityObject());
            query.setParameter("fromIo", (Object)fromIO);
            HibernateIdentityObject toIO = this.safeGet(ctx, relationship.getToIdentityObject());
            query.setParameter("toIo", (Object)toIO);
            if (relationship.getName() != null) {
                HibernateIdentityObjectRelationshipName relationshipName = this.getRelationshipByName(hibernateSession, this.getRealmName(ctx), relationship.getName());
                if (relationshipName == null) {
                    throw new IdentityException("Relationship name not present in the store");
                }
                query.setParameter("nameId", (Object)relationshipName.getId());
            }
            return (HibernateIdentityObjectRelationship)query.uniqueResult();
        }
        catch (HibernateException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Cannot obtain relationship properties: ", (Throwable)e);
        }
    }

    static {
        supportedIdentityObjectSearchCriteria.add(IdentityObjectSearchCriteriaType.ATTRIBUTE_FILTER);
        supportedIdentityObjectSearchCriteria.add(IdentityObjectSearchCriteriaType.NAME_FILTER);
        supportedIdentityObjectSearchCriteria.add(IdentityObjectSearchCriteriaType.PAGE);
        supportedIdentityObjectSearchCriteria.add(IdentityObjectSearchCriteriaType.SORT);
        supportedCredentialTypes.add(CREDENTIAL_TYPE_PASSWORD);
        supportedCredentialTypes.add(CREDENTIAL_TYPE_BINARY);
    }
}

