/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.AggregationProfile;
import co.elastic.clients.elasticsearch.core.search.DfsProfile;
import co.elastic.clients.elasticsearch.core.search.FetchProfile;
import co.elastic.clients.elasticsearch.core.search.SearchProfile;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ShardProfile
implements JsonpSerializable {
    private final List<AggregationProfile> aggregations;
    private final String cluster;
    @Nullable
    private final DfsProfile dfs;
    @Nullable
    private final FetchProfile fetch;
    private final String id;
    private final String index;
    private final String nodeId;
    private final List<SearchProfile> searches;
    private final long shardId;
    public static final JsonpDeserializer<ShardProfile> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardProfile::setupShardProfileDeserializer);

    private ShardProfile(Builder builder) {
        this.aggregations = ApiTypeHelper.unmodifiableRequired(builder.aggregations, (Object)this, "aggregations");
        this.cluster = ApiTypeHelper.requireNonNull(builder.cluster, this, "cluster");
        this.dfs = builder.dfs;
        this.fetch = builder.fetch;
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.nodeId = ApiTypeHelper.requireNonNull(builder.nodeId, this, "nodeId");
        this.searches = ApiTypeHelper.unmodifiableRequired(builder.searches, (Object)this, "searches");
        this.shardId = ApiTypeHelper.requireNonNull(builder.shardId, (Object)this, "shardId", 0L);
    }

    public static ShardProfile of(Function<Builder, ObjectBuilder<ShardProfile>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<AggregationProfile> aggregations() {
        return this.aggregations;
    }

    public final String cluster() {
        return this.cluster;
    }

    @Nullable
    public final DfsProfile dfs() {
        return this.dfs;
    }

    @Nullable
    public final FetchProfile fetch() {
        return this.fetch;
    }

    public final String id() {
        return this.id;
    }

    public final String index() {
        return this.index;
    }

    public final String nodeId() {
        return this.nodeId;
    }

    public final List<SearchProfile> searches() {
        return this.searches;
    }

    public final long shardId() {
        return this.shardId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.aggregations)) {
            generator.writeKey("aggregations");
            generator.writeStartArray();
            for (AggregationProfile aggregationProfile : this.aggregations) {
                aggregationProfile.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("cluster");
        generator.write(this.cluster);
        if (this.dfs != null) {
            generator.writeKey("dfs");
            this.dfs.serialize(generator, mapper);
        }
        if (this.fetch != null) {
            generator.writeKey("fetch");
            this.fetch.serialize(generator, mapper);
        }
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("index");
        generator.write(this.index);
        generator.writeKey("node_id");
        generator.write(this.nodeId);
        if (ApiTypeHelper.isDefined(this.searches)) {
            generator.writeKey("searches");
            generator.writeStartArray();
            for (SearchProfile searchProfile : this.searches) {
                searchProfile.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("shard_id");
        generator.write(this.shardId);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupShardProfileDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aggregations, JsonpDeserializer.arrayDeserializer(AggregationProfile._DESERIALIZER), "aggregations");
        op.add(Builder::cluster, JsonpDeserializer.stringDeserializer(), "cluster");
        op.add(Builder::dfs, DfsProfile._DESERIALIZER, "dfs");
        op.add(Builder::fetch, FetchProfile._DESERIALIZER, "fetch");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::nodeId, JsonpDeserializer.stringDeserializer(), "node_id");
        op.add(Builder::searches, JsonpDeserializer.arrayDeserializer(SearchProfile._DESERIALIZER), "searches");
        op.add(Builder::shardId, JsonpDeserializer.longDeserializer(), "shard_id");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ShardProfile> {
        private List<AggregationProfile> aggregations;
        private String cluster;
        @Nullable
        private DfsProfile dfs;
        @Nullable
        private FetchProfile fetch;
        private String id;
        private String index;
        private String nodeId;
        private List<SearchProfile> searches;
        private Long shardId;

        public final Builder aggregations(List<AggregationProfile> list) {
            this.aggregations = Builder._listAddAll(this.aggregations, list);
            return this;
        }

        public final Builder aggregations(AggregationProfile value, AggregationProfile ... values) {
            this.aggregations = Builder._listAdd(this.aggregations, value, values);
            return this;
        }

        public final Builder aggregations(Function<AggregationProfile.Builder, ObjectBuilder<AggregationProfile>> fn) {
            return this.aggregations(fn.apply(new AggregationProfile.Builder()).build(), new AggregationProfile[0]);
        }

        public final Builder cluster(String value) {
            this.cluster = value;
            return this;
        }

        public final Builder dfs(@Nullable DfsProfile value) {
            this.dfs = value;
            return this;
        }

        public final Builder dfs(Function<DfsProfile.Builder, ObjectBuilder<DfsProfile>> fn) {
            return this.dfs(fn.apply(new DfsProfile.Builder()).build());
        }

        public final Builder fetch(@Nullable FetchProfile value) {
            this.fetch = value;
            return this;
        }

        public final Builder fetch(Function<FetchProfile.Builder, ObjectBuilder<FetchProfile>> fn) {
            return this.fetch(fn.apply(new FetchProfile.Builder()).build());
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder nodeId(String value) {
            this.nodeId = value;
            return this;
        }

        public final Builder searches(List<SearchProfile> list) {
            this.searches = Builder._listAddAll(this.searches, list);
            return this;
        }

        public final Builder searches(SearchProfile value, SearchProfile ... values) {
            this.searches = Builder._listAdd(this.searches, value, values);
            return this;
        }

        public final Builder searches(Function<SearchProfile.Builder, ObjectBuilder<SearchProfile>> fn) {
            return this.searches(fn.apply(new SearchProfile.Builder()).build(), new SearchProfile[0]);
        }

        public final Builder shardId(long value) {
            this.shardId = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ShardProfile build() {
            this._checkSingleUse();
            return new ShardProfile(this);
        }
    }
}

