/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.inference.PutWatsonxResponse;
import co.elastic.clients.elasticsearch.inference.WatsonxServiceSettings;
import co.elastic.clients.elasticsearch.inference.WatsonxServiceType;
import co.elastic.clients.elasticsearch.inference.WatsonxTaskType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;

@JsonpDeserializable
public class PutWatsonxRequest
extends RequestBase
implements JsonpSerializable {
    private final WatsonxServiceType service;
    private final WatsonxServiceSettings serviceSettings;
    private final WatsonxTaskType taskType;
    private final String watsonxInferenceId;
    public static final JsonpDeserializer<PutWatsonxRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutWatsonxRequest::setupPutWatsonxRequestDeserializer);
    public static final Endpoint<PutWatsonxRequest, PutWatsonxResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutWatsonxRequest, PutWatsonxResponse>("es/inference.put_watsonx", request -> "PUT", request -> {
        boolean _watsonxInferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskType.jsonValue(), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.watsonxInferenceId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _watsonxInferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("taskType", request.taskType.jsonValue());
            params.put("watsonxInferenceId", request.watsonxInferenceId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutWatsonxResponse._DESERIALIZER);

    private PutWatsonxRequest(Builder builder) {
        this.service = ApiTypeHelper.requireNonNull(builder.service, this, "service");
        this.serviceSettings = ApiTypeHelper.requireNonNull(builder.serviceSettings, this, "serviceSettings");
        this.taskType = ApiTypeHelper.requireNonNull(builder.taskType, this, "taskType");
        this.watsonxInferenceId = ApiTypeHelper.requireNonNull(builder.watsonxInferenceId, this, "watsonxInferenceId");
    }

    public static PutWatsonxRequest of(Function<Builder, ObjectBuilder<PutWatsonxRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final WatsonxServiceType service() {
        return this.service;
    }

    public final WatsonxServiceSettings serviceSettings() {
        return this.serviceSettings;
    }

    public final WatsonxTaskType taskType() {
        return this.taskType;
    }

    public final String watsonxInferenceId() {
        return this.watsonxInferenceId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("service");
        this.service.serialize(generator, mapper);
        generator.writeKey("service_settings");
        this.serviceSettings.serialize(generator, mapper);
    }

    protected static void setupPutWatsonxRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::service, WatsonxServiceType._DESERIALIZER, "service");
        op.add(Builder::serviceSettings, WatsonxServiceSettings._DESERIALIZER, "service_settings");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutWatsonxRequest> {
        private WatsonxServiceType service;
        private WatsonxServiceSettings serviceSettings;
        private WatsonxTaskType taskType;
        private String watsonxInferenceId;

        public final Builder service(WatsonxServiceType value) {
            this.service = value;
            return this;
        }

        public final Builder serviceSettings(WatsonxServiceSettings value) {
            this.serviceSettings = value;
            return this;
        }

        public final Builder serviceSettings(Function<WatsonxServiceSettings.Builder, ObjectBuilder<WatsonxServiceSettings>> fn) {
            return this.serviceSettings(fn.apply(new WatsonxServiceSettings.Builder()).build());
        }

        public final Builder taskType(WatsonxTaskType value) {
            this.taskType = value;
            return this;
        }

        public final Builder watsonxInferenceId(String value) {
            this.watsonxInferenceId = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutWatsonxRequest build() {
            this._checkSingleUse();
            return new PutWatsonxRequest(this);
        }
    }
}

