/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.threads;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.res.StringManager;

public class VirtualThreadExecutor
extends AbstractExecutorService {
    private static final StringManager sm = StringManager.getManager(VirtualThreadExecutor.class);
    private final CountDownLatch shutdown = new CountDownLatch(1);
    private final JreCompat jreCompat = JreCompat.getInstance();
    private Object threadBuilder;

    public VirtualThreadExecutor(String namePrefix) {
        this.threadBuilder = this.jreCompat.createVirtualThreadBuilder(namePrefix);
    }

    @Override
    public void execute(Runnable command) {
        if (this.isShutdown()) {
            throw new RejectedExecutionException(sm.getString("virtualThreadExecutor.taskRejected", command.toString(), this.toString()));
        }
        this.jreCompat.threadBuilderStart(this.threadBuilder, command);
    }

    @Override
    public void shutdown() {
        this.shutdown.countDown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown.getCount() == 0L;
    }

    @Override
    public boolean isTerminated() {
        return this.isShutdown();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.shutdown.await(timeout, unit);
    }
}

