/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.json;

import java.util.Arrays;
import twitter4j.IDs;
import twitter4j.TwitterException;
import twitter4j.conf.Configuration;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.DataObjectFactoryUtil;
import twitter4j.internal.json.TwitterResponseImpl;
import twitter4j.internal.json.z_T4JInternalParseUtil;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

final class IDsJSONImpl
extends TwitterResponseImpl
implements IDs {
    private long[] ids;
    private long previousCursor = -1L;
    private long nextCursor = -1L;
    private static final long serialVersionUID = -6585026560164704953L;

    IDsJSONImpl(HttpResponse res, Configuration conf) throws TwitterException {
        super(res);
        String json = res.asString();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    IDsJSONImpl(String json) throws TwitterException {
        this.init(json);
    }

    private void init(String jsonStr) throws TwitterException {
        try {
            if (jsonStr.startsWith("{")) {
                JSONObject json = new JSONObject(jsonStr);
                JSONArray idList = json.getJSONArray("ids");
                this.ids = new long[idList.length()];
                for (int i = 0; i < idList.length(); ++i) {
                    try {
                        this.ids[i] = Long.parseLong(idList.getString(i));
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new TwitterException("Twitter API returned malformed response: " + json, nfe);
                    }
                }
                this.previousCursor = z_T4JInternalParseUtil.getLong("previous_cursor", json);
                this.nextCursor = z_T4JInternalParseUtil.getLong("next_cursor", json);
            } else {
                JSONArray idList = new JSONArray(jsonStr);
                this.ids = new long[idList.length()];
                for (int i = 0; i < idList.length(); ++i) {
                    try {
                        this.ids[i] = Long.parseLong(idList.getString(i));
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new TwitterException("Twitter API returned malformed response: " + idList, nfe);
                    }
                }
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    @Override
    public long[] getIDs() {
        return this.ids;
    }

    @Override
    public boolean hasPrevious() {
        return 0L != this.previousCursor;
    }

    @Override
    public long getPreviousCursor() {
        return this.previousCursor;
    }

    @Override
    public boolean hasNext() {
        return 0L != this.nextCursor;
    }

    @Override
    public long getNextCursor() {
        return this.nextCursor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IDs)) {
            return false;
        }
        IDs iDs = (IDs)o;
        return Arrays.equals(this.ids, iDs.getIDs());
    }

    public int hashCode() {
        return this.ids != null ? Arrays.hashCode(this.ids) : 0;
    }

    public String toString() {
        return "IDsJSONImpl{ids=" + Arrays.toString(this.ids) + ", previousCursor=" + this.previousCursor + ", nextCursor=" + this.nextCursor + '}';
    }
}

