/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.geo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.elasticsearch.core.geo.GeoJson;
import org.springframework.data.elasticsearch.core.geo.GeoPoint;
import org.springframework.data.geo.Point;
import org.springframework.util.Assert;

public class GeoJsonLineString
implements GeoJson<Iterable<Point>> {
    public static final String TYPE = "LineString";
    private final List<Point> points;

    private GeoJsonLineString(List<Point> points) {
        this.points = new ArrayList<Point>(points);
    }

    public static GeoJsonLineString of(List<Point> points) {
        Assert.notNull(points, (String)"Points must not be null.");
        Assert.isTrue((points.size() >= 2 ? 1 : 0) != 0, (String)"Minimum of 2 Points required.");
        return new GeoJsonLineString(points);
    }

    public static GeoJsonLineString of(Point first, Point second, Point ... others) {
        Assert.notNull((Object)first, (String)"First point must not be null!");
        Assert.notNull((Object)second, (String)"Second point must not be null!");
        Assert.notNull((Object)others, (String)"Additional points must not be null!");
        ArrayList<Point> points = new ArrayList<Point>(2 + others.length);
        points.add(first);
        points.add(second);
        points.addAll(Arrays.asList(others));
        return new GeoJsonLineString(points);
    }

    public static GeoJsonLineString ofGeoPoints(List<GeoPoint> geoPoints) {
        Assert.notNull(geoPoints, (String)"Points must not be null.");
        Assert.isTrue((geoPoints.size() >= 2 ? 1 : 0) != 0, (String)"Minimum of 2 Points required.");
        return new GeoJsonLineString(geoPoints.stream().map(GeoPoint::toPoint).collect(Collectors.toList()));
    }

    public static GeoJsonLineString of(GeoPoint first, GeoPoint second, GeoPoint ... others) {
        Assert.notNull((Object)first, (String)"First point must not be null!");
        Assert.notNull((Object)second, (String)"Second point must not be null!");
        Assert.notNull((Object)others, (String)"Additional points must not be null!");
        ArrayList<Point> points = new ArrayList<Point>(2 + others.length);
        points.add(GeoPoint.toPoint(first));
        points.add(GeoPoint.toPoint(second));
        points.addAll(Arrays.stream(others).map(GeoPoint::toPoint).collect(Collectors.toList()));
        return new GeoJsonLineString(points);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public List<Point> getCoordinates() {
        return Collections.unmodifiableList(this.points);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoJsonLineString that = (GeoJsonLineString)o;
        return this.points.equals(that.points);
    }

    public int hashCode() {
        return this.points.hashCode();
    }

    public String toString() {
        return "GeoJsonLineString{points=" + String.valueOf(this.points) + "}";
    }
}

