/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.spi;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.Internal;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.QueryException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.SelectItemReferenceStrategy;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.AbstractDelegatingWrapperOptions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.FilterJdbcParameter;
import org.hibernate.internal.util.MathHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.internal.util.collections.StandardStack;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityAssociationMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.DiscriminatorHelper;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.internal.SqlFragmentPredicate;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.NullPrecedence;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.SortDirection;
import org.hibernate.query.spi.Limit;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.sqm.BinaryArithmeticOperator;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.FetchClauseType;
import org.hibernate.query.sqm.FrameExclusion;
import org.hibernate.query.sqm.FrameKind;
import org.hibernate.query.sqm.FrameMode;
import org.hibernate.query.sqm.SetOperator;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.UnaryArithmeticOperator;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.MultipatternSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SelfRenderingAggregateFunctionSqlAstExpression;
import org.hibernate.query.sqm.function.SelfRenderingFunctionSqlAstExpression;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.query.sqm.sql.internal.SqmParameterInterpretation;
import org.hibernate.query.sqm.sql.internal.SqmPathInterpretation;
import org.hibernate.query.sqm.tree.expression.Conversion;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlTreeCreationException;
import org.hibernate.sql.ast.SqlTreePrinter;
import org.hibernate.sql.ast.internal.ParameterMarkerStrategyStandard;
import org.hibernate.sql.ast.internal.TableGroupHelper;
import org.hibernate.sql.ast.spi.AggregateFunctionChecker;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.AbstractUpdateOrDeleteStatement;
import org.hibernate.sql.ast.tree.MutationStatement;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteColumn;
import org.hibernate.sql.ast.tree.cte.CteContainer;
import org.hibernate.sql.ast.tree.cte.CteMaterialization;
import org.hibernate.sql.ast.tree.cte.CteObject;
import org.hibernate.sql.ast.tree.cte.CteSearchClauseKind;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.cte.CteTableGroup;
import org.hibernate.sql.ast.tree.cte.SearchClauseSpecification;
import org.hibernate.sql.ast.tree.cte.SelfRenderingCteObject;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.AggregateColumnWriteExpression;
import org.hibernate.sql.ast.tree.expression.Any;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.CaseSimpleExpression;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.Collation;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Distinct;
import org.hibernate.sql.ast.tree.expression.Duration;
import org.hibernate.sql.ast.tree.expression.DurationUnit;
import org.hibernate.sql.ast.tree.expression.EmbeddableTypeLiteral;
import org.hibernate.sql.ast.tree.expression.EntityTypeLiteral;
import org.hibernate.sql.ast.tree.expression.Every;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.ExtractUnit;
import org.hibernate.sql.ast.tree.expression.Format;
import org.hibernate.sql.ast.tree.expression.JdbcLiteral;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.LiteralAsParameter;
import org.hibernate.sql.ast.tree.expression.ModifiedSubQueryExpression;
import org.hibernate.sql.ast.tree.expression.NestedColumnReference;
import org.hibernate.sql.ast.tree.expression.OrderedSetAggregateFunctionExpression;
import org.hibernate.sql.ast.tree.expression.Over;
import org.hibernate.sql.ast.tree.expression.Overflow;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.SelfRenderingExpression;
import org.hibernate.sql.ast.tree.expression.SelfRenderingSqlFragmentExpression;
import org.hibernate.sql.ast.tree.expression.SqlSelectionExpression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.SqlTupleContainer;
import org.hibernate.sql.ast.tree.expression.Star;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.expression.TrimSpecification;
import org.hibernate.sql.ast.tree.expression.UnaryOperation;
import org.hibernate.sql.ast.tree.expression.UnparsedNumericLiteral;
import org.hibernate.sql.ast.tree.from.DerivedTableReference;
import org.hibernate.sql.ast.tree.from.FromClause;
import org.hibernate.sql.ast.tree.from.FunctionTableReference;
import org.hibernate.sql.ast.tree.from.LazyTableGroup;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.QueryPartTableGroup;
import org.hibernate.sql.ast.tree.from.QueryPartTableReference;
import org.hibernate.sql.ast.tree.from.StandardTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.from.ValuesTableReference;
import org.hibernate.sql.ast.tree.from.VirtualTableGroup;
import org.hibernate.sql.ast.tree.insert.ConflictClause;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.insert.Values;
import org.hibernate.sql.ast.tree.predicate.BetweenPredicate;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.ExistsPredicate;
import org.hibernate.sql.ast.tree.predicate.FilterPredicate;
import org.hibernate.sql.ast.tree.predicate.GroupedPredicate;
import org.hibernate.sql.ast.tree.predicate.InArrayPredicate;
import org.hibernate.sql.ast.tree.predicate.InListPredicate;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.LikePredicate;
import org.hibernate.sql.ast.tree.predicate.NegatedPredicate;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.predicate.SelfRenderingPredicate;
import org.hibernate.sql.ast.tree.predicate.ThruthnessPredicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.ExecutionException;
import org.hibernate.sql.exec.internal.AbstractJdbcParameter;
import org.hibernate.sql.exec.internal.JdbcOperationQueryInsertImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParametersImpl;
import org.hibernate.sql.exec.internal.SqlTypedMappingJdbcParameter;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcLockStrategy;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.exec.spi.JdbcOperationQuery;
import org.hibernate.sql.exec.spi.JdbcOperationQueryDelete;
import org.hibernate.sql.exec.spi.JdbcOperationQueryInsert;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcOperationQueryUpdate;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.ast.ColumnValueParameter;
import org.hibernate.sql.model.ast.ColumnWriteFragment;
import org.hibernate.sql.model.ast.RestrictedTableMutation;
import org.hibernate.sql.model.ast.TableMutation;
import org.hibernate.sql.model.internal.OptionalTableUpdate;
import org.hibernate.sql.model.internal.TableDeleteCustomSql;
import org.hibernate.sql.model.internal.TableDeleteStandard;
import org.hibernate.sql.model.internal.TableInsertCustomSql;
import org.hibernate.sql.model.internal.TableInsertStandard;
import org.hibernate.sql.model.internal.TableUpdateCustomSql;
import org.hibernate.sql.model.internal.TableUpdateStandard;
import org.hibernate.sql.results.graph.DomainResultGraphPrinter;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMappingProducer;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class AbstractSqlAstTranslator<T extends JdbcOperation>
implements SqlAstTranslator<T>,
SqlAppender {
    private static final int MAX_RECURSION_DEPTH_ESTIMATE = 1000;
    private static final int DATE_CHAR_SIZE_ESTIMATE = 10;
    private static final int TIME_CHAR_SIZE_ESTIMATE = 8;
    private static final int TIMESTAMP_CHAR_SIZE_ESTIMATE = 29;
    private static final int OFFSET_TIMESTAMP_CHAR_SIZE_ESTIMATE = 36;
    private final SessionFactoryImplementor sessionFactory;
    private final StringBuilder sqlBuffer = new StringBuilder();
    private final List<JdbcParameterBinder> parameterBinders = new ArrayList<JdbcParameterBinder>();
    private final JdbcParametersImpl jdbcParameters = new JdbcParametersImpl();
    private JdbcParameterBindings jdbcParameterBindings;
    private Map<JdbcParameter, JdbcParameterBinding> appliedParameterBindings = Collections.emptyMap();
    private SqlAstNodeRenderingMode parameterRenderingMode = SqlAstNodeRenderingMode.DEFAULT;
    private final ParameterMarkerStrategy parameterMarkerStrategy;
    private final Stack<Clause> clauseStack = new StandardStack<Clause>(Clause.class);
    private final Stack<QueryPart> queryPartStack = new StandardStack<QueryPart>(QueryPart.class);
    private final Stack<Statement> statementStack = new StandardStack<Statement>(Statement.class);
    private final Dialect dialect;
    private final Set<String> affectedTableNames = new HashSet<String>();
    private CteStatement currentCteStatement;
    private boolean needsSelectAliases;
    private List<String> columnAliases;
    private Predicate additionalWherePredicate;
    private QueryPart queryPartForRowNumbering;
    private int queryPartForRowNumberingClauseDepth = -1;
    private int queryPartForRowNumberingAliasCounter;
    private int queryGroupAliasCounter;
    private int topLevelWithClauseIndex;
    private int withClauseRecursiveIndex = -1;
    private transient AbstractSqmSelfRenderingFunctionDescriptor castFunction;
    private transient LazySessionWrapperOptions lazySessionWrapperOptions;
    private transient BasicType<Integer> integerType;
    private transient BasicType<String> stringType;
    private transient BasicType<Boolean> booleanType;
    private LockOptions lockOptions;
    private Limit limit;
    private JdbcParameter offsetParameter;
    private JdbcParameter limitParameter;
    private ForUpdateClause forUpdate;

    protected AbstractSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        this.sessionFactory = sessionFactory;
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        this.dialect = jdbcServices.getDialect();
        this.statementStack.push(statement);
        this.parameterMarkerStrategy = jdbcServices.getParameterMarkerStrategy();
    }

    private static Clause matchWithClause(Clause clause) {
        if (clause == Clause.WITH) {
            return Clause.WITH;
        }
        return null;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    protected AbstractSqmSelfRenderingFunctionDescriptor castFunction() {
        if (this.castFunction == null) {
            this.castFunction = this.findSelfRenderingFunction("cast", 2);
        }
        return this.castFunction;
    }

    protected WrapperOptions getWrapperOptions() {
        if (this.lazySessionWrapperOptions == null) {
            this.lazySessionWrapperOptions = new LazySessionWrapperOptions(this.sessionFactory);
        }
        return this.lazySessionWrapperOptions;
    }

    public BasicType<Integer> getIntegerType() {
        if (this.integerType == null) {
            this.integerType = this.sessionFactory.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER);
        }
        return this.integerType;
    }

    public BasicType<String> getStringType() {
        if (this.stringType == null) {
            this.stringType = this.sessionFactory.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.STRING);
        }
        return this.stringType;
    }

    public BasicType<Boolean> getBooleanType() {
        if (this.booleanType == null) {
            this.booleanType = this.sessionFactory.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.BOOLEAN);
        }
        return this.booleanType;
    }

    public String getSql() {
        return this.sqlBuffer.toString();
    }

    @Internal
    public StringBuilder getSqlBuffer() {
        return this.sqlBuffer;
    }

    protected void cleanup() {
        if (this.lazySessionWrapperOptions != null) {
            this.lazySessionWrapperOptions.cleanup();
            this.lazySessionWrapperOptions = null;
        }
        this.jdbcParameterBindings = null;
        this.lockOptions = null;
        this.limit = null;
        this.setOffsetParameter(null);
        this.setLimitParameter(null);
    }

    public List<JdbcParameterBinder> getParameterBinders() {
        return this.parameterBinders;
    }

    protected SqlAppender getSqlAppender() {
        return this;
    }

    @Override
    public Set<String> getAffectedTableNames() {
        return this.affectedTableNames;
    }

    protected Statement getStatement() {
        return this.statementStack.getRoot();
    }

    public MutationStatement getCurrentDmlStatement() {
        return this.statementStack.findCurrentFirst(AbstractSqlAstTranslator::matchMutationStatement);
    }

    private static MutationStatement matchMutationStatement(Statement stmt) {
        if (stmt instanceof MutationStatement) {
            return (MutationStatement)stmt;
        }
        return null;
    }

    protected SqlAstNodeRenderingMode getParameterRenderingMode() {
        return this.parameterRenderingMode;
    }

    protected void addAdditionalWherePredicate(Predicate predicate) {
        this.additionalWherePredicate = Predicate.combinePredicates(this.additionalWherePredicate, predicate);
    }

    @Override
    public boolean supportsFilterClause() {
        return false;
    }

    @Override
    public void appendSql(String fragment) {
        this.sqlBuffer.append(fragment);
    }

    @Override
    public void appendSql(char fragment) {
        this.sqlBuffer.append(fragment);
    }

    @Override
    public void appendSql(int value) {
        this.sqlBuffer.append(value);
    }

    @Override
    public void appendSql(long value) {
        this.sqlBuffer.append(value);
    }

    @Override
    public void appendSql(boolean value) {
        this.sqlBuffer.append(value);
    }

    @Override
    public Appendable append(CharSequence csq) {
        this.sqlBuffer.append(csq);
        return this;
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) {
        this.sqlBuffer.append(csq, start, end);
        return this;
    }

    @Override
    public Appendable append(char c) {
        this.sqlBuffer.append(c);
        return this;
    }

    protected JdbcServices getJdbcServices() {
        return this.getSessionFactory().getJdbcServices();
    }

    protected void addAppliedParameterBinding(JdbcParameter parameter, JdbcParameterBinding binding) {
        if (this.appliedParameterBindings.isEmpty()) {
            this.appliedParameterBindings = new IdentityHashMap<JdbcParameter, JdbcParameterBinding>();
        }
        if (binding == null) {
            this.appliedParameterBindings.put(parameter, null);
        } else {
            JdbcMapping bindType = binding.getBindType();
            Object value = bindType.getJdbcJavaType().getMutabilityPlan().deepCopy(binding.getBindValue());
            this.appliedParameterBindings.put(parameter, new JdbcParameterBindingImpl(bindType, value));
        }
    }

    protected Map<JdbcParameter, JdbcParameterBinding> getAppliedParameterBindings() {
        return this.appliedParameterBindings;
    }

    protected JdbcLockStrategy getJdbcLockStrategy() {
        return this.lockOptions == null ? JdbcLockStrategy.FOLLOW_ON : JdbcLockStrategy.NONE;
    }

    protected JdbcParameterBindings getJdbcParameterBindings() {
        return this.jdbcParameterBindings;
    }

    protected LockOptions getLockOptions() {
        return this.lockOptions;
    }

    protected Limit getLimit() {
        return this.limit;
    }

    protected boolean hasLimit() {
        return this.limit != null && !this.limit.isEmpty();
    }

    protected boolean hasLimit(QueryPart queryPart) {
        if (queryPart.isRoot() && this.hasLimit() && this.limit.getMaxRows() != null) {
            return true;
        }
        return queryPart.getFetchClauseExpression() != null;
    }

    protected boolean hasOffset(QueryPart queryPart) {
        if (queryPart.isRoot() && this.hasLimit() && this.limit.getFirstRow() != null) {
            return true;
        }
        return queryPart.getOffsetClauseExpression() != null;
    }

    protected boolean useOffsetFetchClause(QueryPart queryPart) {
        return !queryPart.isRoot() || this.limit == null || this.limit.isEmpty();
    }

    protected boolean isRowsOnlyFetchClauseType(QueryPart queryPart) {
        if (queryPart.isRoot() && this.hasLimit() || queryPart.getFetchClauseType() == null) {
            return true;
        }
        return queryPart.getFetchClauseType() == FetchClauseType.ROWS_ONLY;
    }

    protected JdbcParameter getOffsetParameter() {
        return this.offsetParameter;
    }

    protected void setOffsetParameter(JdbcParameter offsetParameter) {
        this.offsetParameter = offsetParameter;
    }

    protected JdbcParameter getLimitParameter() {
        return this.limitParameter;
    }

    protected void setLimitParameter(JdbcParameter limitParameter) {
        this.limitParameter = limitParameter;
    }

    protected <R> R interpretExpression(Expression expression, JdbcParameterBindings jdbcParameterBindings) {
        if (expression instanceof Literal) {
            return (R)((Literal)expression).getLiteralValue();
        }
        if (expression instanceof JdbcParameter) {
            if (jdbcParameterBindings == null) {
                throw new IllegalArgumentException("Can't interpret expression because no parameter bindings are available");
            }
            return (R)this.getParameterBindValue((JdbcParameter)expression);
        }
        if (expression instanceof SqmParameterInterpretation) {
            if (jdbcParameterBindings == null) {
                throw new IllegalArgumentException("Can't interpret expression because no parameter bindings are available");
            }
            return (R)this.getParameterBindValue((JdbcParameter)((SqmParameterInterpretation)expression).getResolvedExpression());
        }
        throw new UnsupportedOperationException("Can't interpret expression: " + String.valueOf(expression));
    }

    protected void renderExpressionAsLiteral(Expression expression, JdbcParameterBindings jdbcParameterBindings) {
        if (expression instanceof Literal) {
            expression.accept(this);
            return;
        }
        if (expression instanceof JdbcParameter) {
            if (jdbcParameterBindings == null) {
                throw new IllegalArgumentException("Can't interpret expression because no parameter bindings are available");
            }
            JdbcParameter parameter = (JdbcParameter)expression;
            this.renderAsLiteral(parameter, this.getParameterBindValue(parameter));
            return;
        }
        if (expression instanceof SqmParameterInterpretation) {
            if (jdbcParameterBindings == null) {
                throw new IllegalArgumentException("Can't interpret expression because no parameter bindings are available");
            }
            JdbcParameter parameter = (JdbcParameter)((SqmParameterInterpretation)expression).getResolvedExpression();
            this.renderAsLiteral(parameter, this.getParameterBindValue(parameter));
            return;
        }
        throw new UnsupportedOperationException("Can't render expression as literal: " + String.valueOf(expression));
    }

    protected Object getParameterBindValue(JdbcParameter parameter) {
        JdbcParameterBinding binding = parameter == this.getOffsetParameter() ? new JdbcParameterBindingImpl(this.getIntegerType(), this.getLimit().getFirstRow()) : (parameter == this.getLimitParameter() ? new JdbcParameterBindingImpl(this.getIntegerType(), this.getLimit().getMaxRows()) : this.jdbcParameterBindings.getBinding(parameter));
        this.addAppliedParameterBinding(parameter, binding);
        return binding.getBindValue();
    }

    protected Expression getLeftHandExpression(Predicate predicate) {
        if (predicate instanceof NullnessPredicate) {
            return ((NullnessPredicate)predicate).getExpression();
        }
        assert (predicate instanceof ComparisonPredicate);
        return ((ComparisonPredicate)predicate).getLeftHandExpression();
    }

    protected boolean inOverOrWithinGroupClause() {
        return this.clauseStack.findCurrentFirst(AbstractSqlAstTranslator::matchOverOrWithinGroupClauses) != null;
    }

    private static Boolean matchOverOrWithinGroupClauses(Clause clause) {
        switch (clause) {
            case OVER: 
            case WITHIN_GROUP: {
                return Boolean.TRUE;
            }
        }
        return null;
    }

    protected Stack<Clause> getClauseStack() {
        return this.clauseStack;
    }

    protected Stack<Statement> getStatementStack() {
        return this.statementStack;
    }

    protected Stack<QueryPart> getQueryPartStack() {
        return this.queryPartStack;
    }

    @Override
    public QueryPart getCurrentQueryPart() {
        return this.queryPartStack.getCurrent();
    }

    @Override
    public Stack<Clause> getCurrentClauseStack() {
        return this.clauseStack;
    }

    protected CteStatement getCurrentCteStatement() {
        return this.currentCteStatement;
    }

    protected CteStatement getCteStatement(String cteName) {
        return this.statementStack.findCurrentFirstWithParameter(cteName, AbstractSqlAstTranslator::matchCteStatement);
    }

    private static CteStatement matchCteStatement(Statement stmt, String cteName) {
        if (stmt instanceof CteContainer) {
            CteContainer cteContainer = (CteContainer)((Object)stmt);
            return cteContainer.getCteStatement(cteName);
        }
        return null;
    }

    private static CteContainer matchCteContainerByStatement(Statement stmt, String cteName) {
        CteContainer cteContainer;
        if (stmt instanceof CteContainer && (cteContainer = (CteContainer)((Object)stmt)).getCteStatement(cteName) != null) {
            return cteContainer;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T translate(JdbcParameterBindings jdbcParameterBindings, QueryOptions queryOptions) {
        try {
            JdbcOperationQuery jdbcOperation;
            this.jdbcParameterBindings = jdbcParameterBindings;
            Statement statement = this.statementStack.pop();
            if (statement instanceof TableMutation) {
                T t = this.translateTableMutation((TableMutation)statement);
                return t;
            }
            this.lockOptions = queryOptions.getLockOptions().makeCopy();
            Limit limit = this.limit = queryOptions.getLimit() == null ? null : queryOptions.getLimit().makeCopy();
            if (statement instanceof DeleteStatement) {
                jdbcOperation = this.translateDelete((DeleteStatement)statement);
            } else if (statement instanceof UpdateStatement) {
                jdbcOperation = this.translateUpdate((UpdateStatement)statement);
            } else if (statement instanceof InsertSelectStatement) {
                jdbcOperation = this.translateInsert((InsertSelectStatement)statement);
            } else if (statement instanceof SelectStatement) {
                jdbcOperation = this.translateSelect((SelectStatement)statement);
            } else {
                throw new IllegalArgumentException("Unexpected statement - " + String.valueOf(statement));
            }
            JdbcOperationQueryDelete jdbcOperationQueryDelete = jdbcOperation;
            return (T)jdbcOperationQueryDelete;
        }
        finally {
            this.cleanup();
        }
    }

    protected JdbcOperationQueryDelete translateDelete(DeleteStatement sqlAst) {
        this.visitDeleteStatement(sqlAst);
        return new JdbcOperationQueryDelete(this.getSql(), this.getParameterBinders(), this.getAffectedTableNames(), this.getAppliedParameterBindings());
    }

    protected JdbcOperationQueryUpdate translateUpdate(UpdateStatement sqlAst) {
        this.visitUpdateStatement(sqlAst);
        return new JdbcOperationQueryUpdate(this.getSql(), this.getParameterBinders(), this.getAffectedTableNames(), this.getAppliedParameterBindings());
    }

    protected JdbcOperationQueryInsert translateInsert(InsertSelectStatement sqlAst) {
        this.visitInsertStatement(sqlAst);
        return new JdbcOperationQueryInsertImpl(this.getSql(), this.getParameterBinders(), this.getAffectedTableNames(), this.getUniqueConstraintNameThatMayFail(sqlAst));
    }

    protected String getUniqueConstraintNameThatMayFail(InsertSelectStatement sqlAst) {
        ConflictClause conflictClause = sqlAst.getConflictClause();
        if (conflictClause == null || !conflictClause.getConstraintColumnNames().isEmpty()) {
            return null;
        }
        if (sqlAst.getSourceSelectStatement() != null && !this.isFetchFirstRowOnly(sqlAst.getSourceSelectStatement()) || sqlAst.getValuesList().size() > 1) {
            throw new IllegalQueryOperationException("Can't emulate conflict clause with constraint name for more than one row to insert");
        }
        return conflictClause.getConstraintName() == null ? "" : conflictClause.getConstraintName();
    }

    protected JdbcOperationQuerySelect translateSelect(SelectStatement selectStatement) {
        DomainResultGraphPrinter.logDomainResultGraph(selectStatement.getDomainResultDescriptors());
        SqlTreePrinter.logSqlAst(selectStatement);
        this.visitSelectStatement(selectStatement);
        int rowsToSkip = this.getRowsToSkip(selectStatement, this.getJdbcParameterBindings());
        return new JdbcOperationQuerySelect(this.getSql(), this.getParameterBinders(), this.buildJdbcValuesMappingProducer(selectStatement), this.getAffectedTableNames(), rowsToSkip, this.getMaxRows(selectStatement, this.getJdbcParameterBindings(), rowsToSkip), this.getAppliedParameterBindings(), this.getJdbcLockStrategy(), this.getOffsetParameter(), this.getLimitParameter());
    }

    private JdbcValuesMappingProducer buildJdbcValuesMappingProducer(SelectStatement selectStatement) {
        return this.getSessionFactory().getFastSessionServices().getJdbcValuesMappingProducerProvider().buildMappingProducer(selectStatement, this.getSessionFactory());
    }

    protected int getRowsToSkip(SelectStatement sqlAstSelect, JdbcParameterBindings jdbcParameterBindings) {
        if (this.hasLimit()) {
            if (this.offsetParameter != null && this.needsRowsToSkip()) {
                return (Integer)this.interpretExpression(this.offsetParameter, jdbcParameterBindings);
            }
        } else {
            Expression offsetClauseExpression = sqlAstSelect.getQueryPart().getOffsetClauseExpression();
            if (offsetClauseExpression != null && this.needsRowsToSkip()) {
                return (Integer)this.interpretExpression(offsetClauseExpression, jdbcParameterBindings);
            }
        }
        return 0;
    }

    protected int getMaxRows(SelectStatement sqlAstSelect, JdbcParameterBindings jdbcParameterBindings, int rowsToSkip) {
        if (this.hasLimit()) {
            if (this.limitParameter != null && this.needsMaxRows()) {
                Number fetchCount = (Number)this.interpretExpression(this.limitParameter, jdbcParameterBindings);
                return rowsToSkip + fetchCount.intValue();
            }
        } else {
            Expression fetchClauseExpression = sqlAstSelect.getQueryPart().getFetchClauseExpression();
            if (fetchClauseExpression != null && this.needsMaxRows()) {
                Number fetchCount = (Number)this.interpretExpression(fetchClauseExpression, jdbcParameterBindings);
                return rowsToSkip + fetchCount.intValue();
            }
        }
        return Integer.MAX_VALUE;
    }

    protected boolean needsRowsToSkip() {
        return false;
    }

    protected boolean needsMaxRows() {
        return false;
    }

    protected void prepareLimitOffsetParameters() {
        Limit limit = this.getLimit();
        if (limit.getFirstRow() != null) {
            this.setOffsetParameter(new OffsetJdbcParameter(this.sessionFactory.getTypeConfiguration().getBasicTypeForJavaType(Integer.class)));
        }
        if (limit.getMaxRows() != null) {
            this.setLimitParameter(new LimitJdbcParameter(this.sessionFactory.getTypeConfiguration().getBasicTypeForJavaType(Integer.class)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitSelectStatement(SelectStatement statement) {
        SqlAstNodeRenderingMode oldParameterRenderingMode = this.getParameterRenderingMode();
        try {
            boolean needsParenthesis;
            this.statementStack.push(statement);
            this.parameterRenderingMode = SqlAstNodeRenderingMode.DEFAULT;
            boolean bl = needsParenthesis = !statement.getQueryPart().isRoot();
            if (needsParenthesis) {
                this.appendSql('(');
            }
            this.visitCteContainer(statement);
            statement.getQueryPart().accept(this);
            if (needsParenthesis) {
                this.appendSql(')');
            }
        }
        finally {
            this.parameterRenderingMode = oldParameterRenderingMode;
            this.statementStack.pop();
        }
    }

    @Override
    public void visitDeleteStatement(DeleteStatement statement) {
        try {
            this.statementStack.push(statement);
            this.visitCteContainer(statement);
            this.visitDeleteStatementOnly(statement);
        }
        finally {
            this.statementStack.pop();
        }
    }

    @Override
    public void visitUpdateStatement(UpdateStatement statement) {
        try {
            this.statementStack.push(statement);
            this.visitCteContainer(statement);
            this.visitUpdateStatementOnly(statement);
        }
        finally {
            this.statementStack.pop();
        }
    }

    @Override
    public void visitAssignment(Assignment assignment) {
        throw new SqlTreeCreationException("Encountered unexpected assignment clause");
    }

    @Override
    public void visitInsertStatement(InsertSelectStatement statement) {
        try {
            this.statementStack.push(statement);
            this.visitCteContainer(statement);
            this.visitInsertStatementOnly(statement);
        }
        finally {
            this.statementStack.pop();
        }
    }

    protected void visitDeleteStatementOnly(DeleteStatement statement) {
        this.renderDeleteClause(statement);
        if (this.supportsJoinsInDelete() || !AbstractSqlAstTranslator.hasNonTrivialFromClause(statement.getFromClause())) {
            this.visitWhereClause(statement.getRestriction());
        } else {
            this.visitWhereClause(this.determineWhereClauseRestrictionWithJoinEmulation(statement));
        }
        this.visitReturningColumns(statement.getReturningColumns());
    }

    protected boolean supportsJoinsInDelete() {
        return false;
    }

    protected void renderDeleteClause(DeleteStatement statement) {
        this.appendSql("delete from ");
        Stack<Clause> clauseStack = this.getClauseStack();
        try {
            clauseStack.push(Clause.DELETE);
            this.renderDmlTargetTableExpression(statement.getTargetTable());
        }
        finally {
            clauseStack.pop();
        }
    }

    protected void visitUpdateStatementOnly(UpdateStatement statement) {
        this.renderUpdateClause(statement);
        this.renderSetClause(statement.getAssignments());
        this.renderFromClauseAfterUpdateSet(statement);
        if (this.dialect.supportsFromClauseInUpdate() || !AbstractSqlAstTranslator.hasNonTrivialFromClause(statement.getFromClause())) {
            this.visitWhereClause(statement.getRestriction());
        } else {
            this.visitWhereClause(this.determineWhereClauseRestrictionWithJoinEmulation(statement));
        }
        this.visitReturningColumns(statement.getReturningColumns());
    }

    protected void renderUpdateClause(UpdateStatement updateStatement) {
        this.appendSql("update ");
        Stack<Clause> clauseStack = this.getClauseStack();
        try {
            clauseStack.push(Clause.UPDATE);
            this.renderDmlTargetTableExpression(updateStatement.getTargetTable());
        }
        finally {
            clauseStack.pop();
        }
    }

    protected void renderDmlTargetTableExpression(NamedTableReference tableReference) {
        this.appendSql(tableReference.getTableExpression());
        this.registerAffectedTable(tableReference);
    }

    protected static boolean hasNonTrivialFromClause(FromClause fromClause) {
        return fromClause != null && !fromClause.getRoots().isEmpty() && (fromClause.getRoots().size() > 1 || fromClause.getRoots().get(0).hasRealJoins());
    }

    protected Predicate determineWhereClauseRestrictionWithJoinEmulation(AbstractUpdateOrDeleteStatement statement) {
        return this.determineWhereClauseRestrictionWithJoinEmulation(statement, null);
    }

    protected Predicate determineWhereClauseRestrictionWithJoinEmulation(AbstractUpdateOrDeleteStatement statement, String dmlTargetAlias) {
        QuerySpec querySpec = new QuerySpec(false);
        querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(new QueryLiteral<Integer>(1, this.getIntegerType())));
        querySpec.applyPredicate(statement.getRestriction());
        if (this.supportsJoinInMutationStatementSubquery()) {
            for (TableGroup root : statement.getFromClause().getRoots()) {
                if (root.getPrimaryTableReference() == statement.getTargetTable()) {
                    StandardTableGroup dmlTargetTableGroup = new StandardTableGroup(true, new NavigablePath("dual"), null, null, new NamedTableReference(this.getDual(), "d_"), null, this.sessionFactory);
                    querySpec.getFromClause().addRoot(dmlTargetTableGroup);
                    dmlTargetTableGroup.getTableReferenceJoins().addAll(root.getTableReferenceJoins());
                    for (TableGroupJoin tableGroupJoin : root.getTableGroupJoins()) {
                        dmlTargetTableGroup.addTableGroupJoin(tableGroupJoin);
                    }
                    for (TableGroupJoin tableGroupJoin : root.getNestedTableGroupJoins()) {
                        dmlTargetTableGroup.addNestedTableGroupJoin(tableGroupJoin);
                    }
                    continue;
                }
                querySpec.getFromClause().addRoot(root);
            }
        } else {
            assert (dmlTargetAlias != null);
            TableGroup dmlTargetTableGroup = statement.getFromClause().getRoots().get(0);
            assert (dmlTargetTableGroup.getPrimaryTableReference() == statement.getTargetTable());
            for (TableGroup root : statement.getFromClause().getRoots()) {
                querySpec.getFromClause().addRoot(root);
            }
            querySpec.applyPredicate(this.createRowMatchingPredicate(dmlTargetTableGroup, dmlTargetAlias, dmlTargetTableGroup.getPrimaryTableReference().getIdentificationVariable()));
        }
        return new ExistsPredicate(querySpec, false, this.getBooleanType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderSetClause(List<Assignment> assignments) {
        this.appendSql(" set");
        int separator = 32;
        try {
            this.clauseStack.push(Clause.SET);
            for (Assignment assignment : assignments) {
                this.appendSql((char)separator);
                separator = 44;
                this.visitSetAssignment(assignment);
            }
        }
        finally {
            this.clauseStack.pop();
        }
    }

    protected void visitSetAssignment(Assignment assignment) {
        List<ColumnReference> columnReferences = assignment.getAssignable().getColumnReferences();
        if (columnReferences.size() == 1) {
            this.appendAssignmentColumn(columnReferences.get(0));
            this.appendSql('=');
            Expression assignedValue = assignment.getAssignedValue();
            SqlTuple sqlTuple = SqlTupleContainer.getSqlTuple(assignedValue);
            if (sqlTuple != null) {
                assert (sqlTuple.getExpressions().size() == 1);
                sqlTuple.getExpressions().get(0).accept(this);
            } else {
                assignedValue.accept(this);
            }
        } else {
            int separator = 40;
            for (ColumnReference columnReference : columnReferences) {
                this.appendSql((char)separator);
                this.appendAssignmentColumn(columnReference);
                separator = 44;
            }
            this.appendSql(")=");
            assignment.getAssignedValue().accept(this);
        }
    }

    protected void appendAssignmentColumn(ColumnReference column) {
        column.appendColumnForWrite(this, null);
    }

    protected void visitSetAssignmentEmulateJoin(Assignment assignment, UpdateStatement statement) {
        Expression valueExpression;
        List<ColumnReference> columnReferences = assignment.getAssignable().getColumnReferences();
        if (columnReferences.size() == 1) {
            columnReferences.get(0).appendColumnForWrite(this, null);
            this.appendSql('=');
            Expression assignedValue = assignment.getAssignedValue();
            SqlTuple sqlTuple = SqlTupleContainer.getSqlTuple(assignedValue);
            if (sqlTuple != null) {
                assert (sqlTuple.getExpressions().size() == 1);
                valueExpression = sqlTuple.getExpressions().get(0);
            } else {
                valueExpression = assignedValue;
            }
        } else {
            int separator = 40;
            for (ColumnReference columnReference : columnReferences) {
                this.appendSql((char)separator);
                columnReference.appendColumnForWrite(this, null);
                separator = 44;
            }
            this.appendSql(")=");
            valueExpression = assignment.getAssignedValue();
        }
        QuerySpec querySpec = new QuerySpec(false, 1);
        TableGroup dmlTargetTableGroup = statement.getFromClause().getRoots().get(0);
        assert (dmlTargetTableGroup.getPrimaryTableReference() == statement.getTargetTable());
        for (TableGroup root : statement.getFromClause().getRoots()) {
            querySpec.getFromClause().addRoot(root);
        }
        querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(valueExpression));
        querySpec.applyPredicate(this.createRowMatchingPredicate(dmlTargetTableGroup, "dml_target_", dmlTargetTableGroup.getPrimaryTableReference().getIdentificationVariable()));
        new SelectStatement(querySpec).accept(this);
    }

    protected boolean isStruct(JdbcMappingContainer expressionType) {
        if (expressionType instanceof EmbeddableValuedModelPart) {
            EmbeddableMappingType embeddableMappingType = ((EmbeddableValuedModelPart)expressionType).getEmbeddableTypeDescriptor();
            return embeddableMappingType.getAggregateMapping() != null && embeddableMappingType.getAggregateMapping().getJdbcMapping().getJdbcType().getDefaultSqlTypeCode() == 2002;
        }
        if (expressionType instanceof BasicValuedMapping) {
            JdbcMapping jdbcMapping = ((BasicValuedMapping)expressionType).getJdbcMapping();
            return jdbcMapping.getJdbcType().getDefaultSqlTypeCode() == 2002;
        }
        return false;
    }

    protected void visitInsertStatementOnly(InsertSelectStatement statement) {
        this.clauseStack.push(Clause.INSERT);
        this.appendSql("insert into ");
        this.renderDmlTargetTableExpression(statement.getTargetTable());
        this.appendSql('(');
        boolean firstPass = true;
        List<ColumnReference> targetColumnReferences = statement.getTargetColumns();
        if (targetColumnReferences == null) {
            this.renderImplicitTargetColumnSpec();
        } else {
            for (ColumnReference targetColumnReference : targetColumnReferences) {
                if (firstPass) {
                    firstPass = false;
                } else {
                    this.appendSql(',');
                }
                this.appendSql(targetColumnReference.getColumnExpression());
            }
        }
        this.appendSql(") ");
        this.clauseStack.pop();
        this.visitInsertSource(statement);
        this.visitConflictClause(statement.getConflictClause());
        this.visitReturningColumns(statement.getReturningColumns());
    }

    protected boolean isIntegerDivisionEmulationRequired(BinaryArithmeticExpression expression) {
        return expression.getOperator() == BinaryArithmeticOperator.DIVIDE_PORTABLE && this.jdbcType(expression.getLeftHandOperand()).isInteger() && this.jdbcType(expression.getRightHandOperand()).isInteger();
    }

    private JdbcType jdbcType(Expression expression) {
        return expression.getExpressionType().getSingleJdbcMapping().getJdbcType();
    }

    protected void visitInsertSource(InsertSelectStatement statement) {
        if (statement.getSourceSelectStatement() != null) {
            statement.getSourceSelectStatement().accept(this);
        } else {
            this.visitValuesList(statement.getValuesList());
        }
    }

    protected void visitInsertStatementEmulateMerge(InsertSelectStatement statement) {
        assert (statement.getConflictClause() != null);
        ConflictClause conflictClause = statement.getConflictClause();
        String constraintName = conflictClause.getConstraintName();
        if (constraintName != null) {
            throw new IllegalQueryOperationException("Dialect does not support constraint name in conflict clause");
        }
        this.appendSql("merge into ");
        this.clauseStack.push(Clause.MERGE);
        this.renderNamedTableReference(statement.getTargetTable(), LockMode.NONE);
        this.clauseStack.pop();
        this.appendSql(" using ");
        List<ColumnReference> targetColumnReferences = statement.getTargetColumns();
        ArrayList<String> columnNames = new ArrayList<String>(targetColumnReferences.size());
        for (ColumnReference targetColumnReference : targetColumnReferences) {
            columnNames.add(targetColumnReference.getColumnExpression());
        }
        DerivedTableReference derivedTableReference = statement.getSourceSelectStatement() != null ? new QueryPartTableReference(new SelectStatement(statement.getSourceSelectStatement()), "excluded", columnNames, false, this.sessionFactory) : new ValuesTableReference(statement.getValuesList(), "excluded", columnNames, this.sessionFactory);
        this.clauseStack.push(Clause.FROM);
        derivedTableReference.accept(this);
        this.appendSql(" on (");
        String separator = "";
        for (String constraintColumnName : conflictClause.getConstraintColumnNames()) {
            this.appendSql(separator);
            this.appendSql(statement.getTargetTable().getIdentificationVariable());
            this.appendSql('.');
            this.appendSql(constraintColumnName);
            this.appendSql("=excluded.");
            this.appendSql(constraintColumnName);
            separator = " and ";
        }
        this.appendSql(')');
        List<Assignment> assignments = conflictClause.getAssignments();
        if (!assignments.isEmpty()) {
            this.appendSql(" when matched");
            this.renderMergeUpdateClause(assignments, conflictClause.getPredicate());
        }
        this.appendSql(" when not matched then insert ");
        int separatorChar = 40;
        for (ColumnReference targetColumnReference : targetColumnReferences) {
            this.appendSql((char)separatorChar);
            this.appendSql(targetColumnReference.getColumnExpression());
            separatorChar = 44;
        }
        this.clauseStack.pop();
        this.clauseStack.push(Clause.VALUES);
        this.appendSql(") values ");
        separatorChar = 40;
        for (ColumnReference targetColumnReference : targetColumnReferences) {
            this.appendSql((char)separatorChar);
            this.appendSql("excluded.");
            this.appendSql(targetColumnReference.getColumnExpression());
            separatorChar = 44;
        }
        this.clauseStack.pop();
        this.appendSql(')');
        this.visitReturningColumns(statement.getReturningColumns());
    }

    protected void visitUpdateStatementEmulateMerge(UpdateStatement statement) {
        this.appendSql("merge into ");
        this.clauseStack.push(Clause.MERGE);
        this.appendSql(statement.getTargetTable().getTableExpression());
        this.registerAffectedTable(statement.getTargetTable());
        this.appendSql(" as t");
        this.clauseStack.pop();
        QueryPartTableReference inlineView = this.updateSourceAsSubquery(statement, false);
        this.appendSql(" using ");
        this.clauseStack.push(Clause.FROM);
        this.visitQueryPartTableReference(inlineView);
        this.clauseStack.pop();
        this.appendSql(" on ");
        String rowIdExpression = this.dialect.rowId(null);
        if (rowIdExpression == null) {
            TableGroup dmlTargetTableGroup = statement.getFromClause().getRoots().get(0);
            assert (dmlTargetTableGroup.getPrimaryTableReference() == statement.getTargetTable());
            this.createRowMatchingPredicate(dmlTargetTableGroup, "t", "s").accept(this);
        } else {
            this.appendSql("t.");
            this.appendSql(rowIdExpression);
            this.appendSql("=s.c");
            this.appendSql(inlineView.getColumnNames().size() - 1);
        }
        this.appendSql(" when matched then update set");
        int separator = 32;
        int column = 0;
        for (Assignment assignment : statement.getAssignments()) {
            List<ColumnReference> columnReferences = assignment.getAssignable().getColumnReferences();
            for (int j = 0; j < columnReferences.size(); ++j) {
                this.appendSql((char)separator);
                columnReferences.get(j).appendColumnForWrite(this, "t");
                this.appendSql("=s.c");
                this.appendSql(column++);
                separator = 44;
            }
        }
        this.visitReturningColumns(statement.getReturningColumns());
    }

    private QueryPartTableReference updateSourceAsSubquery(UpdateStatement statement, boolean correlated) {
        QuerySpec inlineView = new QuerySpec(!correlated);
        SelectClause selectClause = inlineView.getSelectClause();
        List<Assignment> assignments = statement.getAssignments();
        ArrayList<String> columnNames = new ArrayList<String>(assignments.size());
        for (Assignment assignment : assignments) {
            List<ColumnReference> columnReferences = assignment.getAssignable().getColumnReferences();
            Expression assignedValue = assignment.getAssignedValue();
            if (columnReferences.size() == 1) {
                selectClause.addSqlSelection(new SqlSelectionImpl(assignedValue));
                columnNames.add("c" + columnNames.size());
                continue;
            }
            if (assignedValue instanceof SqlTuple) {
                List<? extends Expression> expressions = ((SqlTuple)assignedValue).getExpressions();
                for (int i = 0; i < columnReferences.size(); ++i) {
                    selectClause.addSqlSelection(new SqlSelectionImpl(expressions.get(i)));
                    columnNames.add("c" + columnNames.size());
                }
                continue;
            }
            throw new IllegalQueryOperationException("Unsupported tuple assignment in update query with joins.");
        }
        if (!correlated) {
            String rowIdExpression = this.dialect.rowId(null);
            if (rowIdExpression == null) {
                TableGroup dmlTargetTableGroup = statement.getFromClause().getRoots().get(0);
                assert (dmlTargetTableGroup.getPrimaryTableReference() == statement.getTargetTable());
                EntityIdentifierMapping identifierMapping = dmlTargetTableGroup.getModelPart().asEntityMappingType().getIdentifierMapping();
                identifierMapping.forEachSelectable(0, (selectionIndex, selectableMapping) -> {
                    selectClause.addSqlSelection(new SqlSelectionImpl(new ColumnReference(statement.getTargetTable(), selectableMapping)));
                    columnNames.add(selectableMapping.getSelectionExpression());
                });
            } else {
                selectClause.addSqlSelection(new SqlSelectionImpl(new ColumnReference(statement.getTargetTable(), rowIdExpression, this.sessionFactory.getTypeConfiguration().getBasicTypeRegistry().resolve(Object.class, this.dialect.rowIdSqlType()))));
                columnNames.add("c" + columnNames.size());
            }
        }
        if (correlated) {
            for (TableGroup root : statement.getFromClause().getRoots()) {
                if (statement.getTargetTable() == root.getPrimaryTableReference()) {
                    StandardTableGroup dmlTargetTableGroup = new StandardTableGroup(true, new NavigablePath("dual"), null, null, new NamedTableReference(this.getDual(), "d_"), null, this.sessionFactory);
                    inlineView.getFromClause().addRoot(dmlTargetTableGroup);
                    dmlTargetTableGroup.getTableReferenceJoins().addAll(root.getTableReferenceJoins());
                    for (TableGroupJoin tableGroupJoin : root.getTableGroupJoins()) {
                        dmlTargetTableGroup.addTableGroupJoin(tableGroupJoin);
                    }
                    for (TableGroupJoin tableGroupJoin : root.getNestedTableGroupJoins()) {
                        dmlTargetTableGroup.addNestedTableGroupJoin(tableGroupJoin);
                    }
                    continue;
                }
                inlineView.getFromClause().addRoot(root);
            }
        } else {
            for (TableGroup root : statement.getFromClause().getRoots()) {
                inlineView.getFromClause().addRoot(root);
            }
        }
        inlineView.applyPredicate(statement.getRestriction());
        return new QueryPartTableReference(new SelectStatement(inlineView), "s", columnNames, false, this.getSessionFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitUpdateStatementEmulateInlineView(UpdateStatement statement) {
        this.appendSql("update ");
        Stack<Clause> clauseStack = this.getClauseStack();
        try {
            clauseStack.push(Clause.UPDATE);
            QueryPartTableReference inlineView = this.updateSourceAsInlineView(statement);
            this.visitQueryPartTableReference(inlineView);
            this.appendSql(" set");
            int separator = 32;
            for (int i = 0; i < inlineView.getColumnNames().size(); i += 2) {
                this.appendSql((char)separator);
                this.appendSql("t.c");
                this.appendSql(i);
                this.appendSql("=t.c");
                this.appendSql(i + 1);
                separator = 44;
            }
        }
        finally {
            clauseStack.pop();
        }
        this.visitReturningColumns(statement.getReturningColumns());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitUpdateStatementEmulateTupleSet(UpdateStatement statement) {
        this.renderUpdateClause(statement);
        this.appendSql(" set ");
        int separator = 40;
        try {
            this.clauseStack.push(Clause.SET);
            for (Assignment assignment : statement.getAssignments()) {
                List<ColumnReference> columnReferences = assignment.getAssignable().getColumnReferences();
                for (ColumnReference columnReference : columnReferences) {
                    this.appendSql((char)separator);
                    separator = 44;
                    columnReference.appendColumnForWrite(this, null);
                }
            }
            this.appendSql(")=");
            this.updateSourceAsSubquery(statement, true).getStatement().accept(this);
        }
        finally {
            this.clauseStack.pop();
        }
        this.visitWhereClause(this.determineWhereClauseRestrictionWithJoinEmulation(statement));
    }

    private QueryPartTableReference updateSourceAsInlineView(UpdateStatement statement) {
        QuerySpec inlineView = new QuerySpec(true);
        SelectClause selectClause = inlineView.getSelectClause();
        List<Assignment> assignments = statement.getAssignments();
        ArrayList<String> columnNames = new ArrayList<String>(assignments.size());
        for (Assignment assignment : assignments) {
            List<ColumnReference> columnReferences = assignment.getAssignable().getColumnReferences();
            Expression assignedValue = assignment.getAssignedValue();
            if (columnReferences.size() == 1) {
                selectClause.addSqlSelection(new SqlSelectionImpl(columnReferences.get(0)));
                selectClause.addSqlSelection(new SqlSelectionImpl(assignedValue));
                columnNames.add("c" + columnNames.size());
                columnNames.add("c" + columnNames.size());
                continue;
            }
            if (assignedValue instanceof SqlTuple) {
                List<? extends Expression> expressions = ((SqlTuple)assignedValue).getExpressions();
                for (int i = 0; i < columnReferences.size(); ++i) {
                    selectClause.addSqlSelection(new SqlSelectionImpl(columnReferences.get(i)));
                    selectClause.addSqlSelection(new SqlSelectionImpl(expressions.get(i)));
                    columnNames.add("c" + columnNames.size());
                    columnNames.add("c" + columnNames.size());
                }
                continue;
            }
            throw new IllegalQueryOperationException("Unsupported tuple assignment in update query with joins.");
        }
        for (TableGroup root : statement.getFromClause().getRoots()) {
            inlineView.getFromClause().addRoot(root);
        }
        inlineView.applyPredicate(statement.getRestriction());
        return new QueryPartTableReference(new SelectStatement(inlineView), "t", columnNames, false, this.getSessionFactory());
    }

    protected void renderMergeUpdateClause(List<Assignment> assignments, Predicate wherePredicate) {
        if (wherePredicate != null) {
            this.appendSql(" and ");
            this.clauseStack.push(Clause.WHERE);
            wherePredicate.accept(this);
            this.clauseStack.pop();
        }
        this.appendSql(" then update");
        this.renderSetClause(assignments);
    }

    private void renderImplicitTargetColumnSpec() {
    }

    protected void visitValuesList(List<Values> valuesList) {
        this.visitValuesListStandard(valuesList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void visitValuesListStandard(List<Values> valuesList) {
        if (valuesList.size() != 1 && !this.dialect.supportsValuesListForInsert()) {
            throw new IllegalQueryOperationException("Dialect does not support values lists for insert statements");
        }
        this.appendSql("values");
        Stack<Clause> clauseStack = this.getClauseStack();
        try {
            clauseStack.push(Clause.VALUES);
            for (int i = 0; i < valuesList.size(); ++i) {
                if (i != 0) {
                    this.appendSql(',');
                }
                this.appendSql(" (");
                List<Expression> expressions = valuesList.get(i).getExpressions();
                for (int j = 0; j < expressions.size(); ++j) {
                    if (j != 0) {
                        this.appendSql(',');
                    }
                    expressions.get(j).accept(this);
                }
                this.appendSql(')');
            }
        }
        finally {
            clauseStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitValuesListEmulateSelectUnion(List<Values> valuesList) {
        String separator = "";
        Stack<Clause> clauseStack = this.getClauseStack();
        try {
            clauseStack.push(Clause.VALUES);
            for (int i = 0; i < valuesList.size(); ++i) {
                this.appendSql(separator);
                this.renderExpressionsAsSubquery(valuesList.get(i).getExpressions());
                separator = " union all ";
            }
        }
        finally {
            clauseStack.pop();
        }
    }

    protected void visitForUpdateClause(QuerySpec querySpec) {
        if (querySpec.isRoot()) {
            if (this.forUpdate != null) {
                Boolean followOnLocking;
                Boolean bl = followOnLocking = this.getLockOptions() == null ? Boolean.FALSE : this.getLockOptions().getFollowOnLocking();
                if (Boolean.TRUE.equals(followOnLocking)) {
                    this.lockOptions = null;
                } else {
                    this.forUpdate.merge(this.getLockOptions());
                    this.forUpdate.applyAliases(this.dialect.getWriteRowLockStrategy(), querySpec);
                    if (LockMode.READ.lessThan(this.forUpdate.getLockMode())) {
                        LockStrategy lockStrategy = this.determineLockingStrategy(querySpec, this.forUpdate, followOnLocking);
                        switch (lockStrategy) {
                            case CLAUSE: {
                                this.renderForUpdateClause(querySpec, this.forUpdate);
                                break;
                            }
                            case FOLLOW_ON: {
                                this.lockOptions = null;
                            }
                        }
                    }
                }
                this.forUpdate = null;
            } else {
                Boolean followOnLocking;
                LockOptions lockOptions = this.getLockOptions();
                Boolean bl = followOnLocking = lockOptions == null ? Boolean.FALSE : lockOptions.getFollowOnLocking();
                if (Boolean.TRUE.equals(followOnLocking)) {
                    this.lockOptions = null;
                } else if (lockOptions != null && lockOptions.getLockMode() != LockMode.NONE) {
                    ForUpdateClause forUpdateClause = new ForUpdateClause();
                    forUpdateClause.merge(this.getLockOptions());
                    forUpdateClause.applyAliases(this.dialect.getWriteRowLockStrategy(), querySpec);
                    if (LockMode.READ.lessThan(forUpdateClause.getLockMode())) {
                        LockStrategy lockStrategy = this.determineLockingStrategy(querySpec, forUpdateClause, followOnLocking);
                        switch (lockStrategy) {
                            case CLAUSE: {
                                this.renderForUpdateClause(querySpec, forUpdateClause);
                                break;
                            }
                            case FOLLOW_ON: {
                                if (Boolean.FALSE.equals(followOnLocking)) {
                                    throw new UnsupportedOperationException("");
                                }
                                this.lockOptions = null;
                            }
                        }
                    }
                }
            }
        } else if (this.forUpdate != null) {
            this.forUpdate.merge(this.getLockOptions());
            this.forUpdate.applyAliases(this.dialect.getWriteRowLockStrategy(), querySpec);
            if (LockMode.READ.lessThan(this.forUpdate.getLockMode())) {
                LockStrategy lockStrategy = this.determineLockingStrategy(querySpec, this.forUpdate, null);
                switch (lockStrategy) {
                    case CLAUSE: {
                        this.renderForUpdateClause(querySpec, this.forUpdate);
                        break;
                    }
                    case FOLLOW_ON: {
                        throw new UnsupportedOperationException("Follow-on locking for subqueries is not supported");
                    }
                }
            }
            this.forUpdate = null;
        }
    }

    protected void renderForUpdateClause(QuerySpec querySpec, ForUpdateClause forUpdateClause) {
        int timeoutMillis = forUpdateClause.getTimeoutMillis();
        LockKind lockKind = LockKind.NONE;
        switch (forUpdateClause.getLockMode()) {
            case PESSIMISTIC_WRITE: {
                lockKind = LockKind.UPDATE;
                break;
            }
            case PESSIMISTIC_READ: {
                lockKind = LockKind.SHARE;
                break;
            }
            case UPGRADE_NOWAIT: 
            case PESSIMISTIC_FORCE_INCREMENT: {
                timeoutMillis = 0;
                lockKind = LockKind.UPDATE;
                break;
            }
            case UPGRADE_SKIPLOCKED: {
                timeoutMillis = -2;
                lockKind = LockKind.UPDATE;
                break;
            }
        }
        if (lockKind != LockKind.NONE) {
            if (lockKind == LockKind.SHARE) {
                this.appendSql(this.getForShare(timeoutMillis));
                if (forUpdateClause.hasAliases() && this.dialect.getReadRowLockStrategy() != RowLockStrategy.NONE) {
                    this.appendSql(" of ");
                    forUpdateClause.appendAliases(this);
                }
            } else {
                this.appendSql(this.getForUpdate());
                if (forUpdateClause.hasAliases() && this.dialect.getWriteRowLockStrategy() != RowLockStrategy.NONE) {
                    this.appendSql(" of ");
                    forUpdateClause.appendAliases(this);
                }
            }
            this.appendSql(this.getForUpdateWithClause());
            switch (timeoutMillis) {
                case 0: {
                    if (!this.dialect.supportsNoWait()) break;
                    this.appendSql(this.getNoWait());
                    break;
                }
                case -2: {
                    if (!this.dialect.supportsSkipLocked()) break;
                    this.appendSql(this.getSkipLocked());
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    if (!this.dialect.supportsWait()) break;
                    this.appendSql(" wait ");
                    this.appendSql(Math.round((float)timeoutMillis / 1000.0f));
                }
            }
        }
    }

    protected String getForUpdate() {
        return " for update";
    }

    protected String getForShare(int timeoutMillis) {
        return " for update";
    }

    protected String getForUpdateWithClause() {
        return "";
    }

    protected String getNoWait() {
        return " nowait";
    }

    protected String getSkipLocked() {
        return " skip locked";
    }

    protected LockMode getEffectiveLockMode(String alias) {
        QueryPart currentQueryPart = this.getQueryPartStack().getCurrent();
        return currentQueryPart == null ? LockMode.NONE : this.getEffectiveLockMode(alias, currentQueryPart.isRoot());
    }

    protected LockMode getEffectiveLockMode(String alias, boolean isRoot) {
        if (this.getLockOptions() == null) {
            return LockMode.NONE;
        }
        LockMode lockMode = this.getLockOptions().getAliasSpecificLockMode(alias);
        if (isRoot && lockMode == null) {
            lockMode = this.getLockOptions().getLockMode();
        }
        return lockMode == null ? LockMode.NONE : lockMode;
    }

    protected int getEffectiveLockTimeout(LockMode lockMode) {
        if (this.getLockOptions() == null) {
            return -1;
        }
        int timeoutMillis = this.getLockOptions().getTimeOut();
        switch (lockMode) {
            case UPGRADE_NOWAIT: 
            case PESSIMISTIC_FORCE_INCREMENT: {
                timeoutMillis = 0;
                break;
            }
            case UPGRADE_SKIPLOCKED: {
                timeoutMillis = -2;
                break;
            }
        }
        return timeoutMillis;
    }

    protected boolean hasAggregateFunctions(QuerySpec querySpec) {
        return AggregateFunctionChecker.hasAggregateFunctions(querySpec);
    }

    protected LockStrategy determineLockingStrategy(QuerySpec querySpec, ForUpdateClause forUpdateClause, Boolean followOnLocking) {
        LockStrategy strategy = LockStrategy.CLAUSE;
        if (!querySpec.getGroupByClauseExpressions().isEmpty()) {
            if (Boolean.FALSE.equals(followOnLocking)) {
                throw new IllegalQueryOperationException("Locking with GROUP BY is not supported");
            }
            strategy = LockStrategy.FOLLOW_ON;
        }
        if (querySpec.getHavingClauseRestrictions() != null) {
            if (Boolean.FALSE.equals(followOnLocking)) {
                throw new IllegalQueryOperationException("Locking with HAVING is not supported");
            }
            strategy = LockStrategy.FOLLOW_ON;
        }
        if (querySpec.getSelectClause().isDistinct()) {
            if (Boolean.FALSE.equals(followOnLocking)) {
                throw new IllegalQueryOperationException("Locking with DISTINCT is not supported");
            }
            strategy = LockStrategy.FOLLOW_ON;
        }
        if (!this.dialect.supportsOuterJoinForUpdate()) {
            if (forUpdateClause.hasAliases()) {
                if (querySpec.getFromClause().queryTableGroupJoins(tableGroupJoin -> {
                    TableGroup group = tableGroupJoin.getJoinedGroup();
                    if (forUpdateClause.hasAlias(group.getSourceAlias()) && tableGroupJoin.isInitialized() && tableGroupJoin.getJoinType() != SqlAstJoinType.INNER && !group.isVirtual()) {
                        if (Boolean.FALSE.equals(followOnLocking)) {
                            throw new IllegalQueryOperationException("Locking with OUTER joins is not supported");
                        }
                        return Boolean.TRUE;
                    }
                    return null;
                }) != null) {
                    strategy = LockStrategy.FOLLOW_ON;
                }
            } else if (querySpec.getFromClause().queryTableJoins(tableJoin -> {
                if (tableJoin.isInitialized() && tableJoin.getJoinType() != SqlAstJoinType.INNER && !(tableJoin.getJoinedNode() instanceof VirtualTableGroup)) {
                    if (Boolean.FALSE.equals(followOnLocking)) {
                        throw new IllegalQueryOperationException("Locking with OUTER joins is not supported");
                    }
                    return Boolean.TRUE;
                }
                return null;
            }) != null) {
                strategy = LockStrategy.FOLLOW_ON;
            }
        }
        if (this.hasAggregateFunctions(querySpec)) {
            if (Boolean.FALSE.equals(followOnLocking)) {
                throw new IllegalQueryOperationException("Locking with aggregate functions is not supported");
            }
            strategy = LockStrategy.FOLLOW_ON;
        }
        return strategy;
    }

    protected void visitConflictClause(ConflictClause conflictClause) {
        if (conflictClause != null) {
            if (!conflictClause.getConstraintColumnNames().isEmpty()) {
                throw new IllegalQueryOperationException("Insert conflict clause with constraint column names is not supported");
            }
            if (conflictClause.isDoUpdate()) {
                throw new IllegalQueryOperationException("Insert conflict do update clause is not supported");
            }
        }
    }

    protected void visitStandardConflictClause(ConflictClause conflictClause) {
        if (conflictClause == null) {
            return;
        }
        this.clauseStack.push(Clause.CONFLICT);
        this.appendSql(" on conflict");
        String constraintName = conflictClause.getConstraintName();
        if (constraintName != null) {
            this.appendSql(" on constraint ");
            this.appendSql(constraintName);
        } else if (!conflictClause.getConstraintColumnNames().isEmpty()) {
            int separator = 40;
            for (String columnName : conflictClause.getConstraintColumnNames()) {
                this.appendSql((char)separator);
                this.appendSql(columnName);
                separator = 44;
            }
            this.appendSql(')');
        }
        List<Assignment> assignments = conflictClause.getAssignments();
        if (assignments.isEmpty()) {
            this.appendSql(" do nothing");
        } else {
            this.appendSql(" do update");
            this.renderSetClause(assignments);
            Predicate predicate = conflictClause.getPredicate();
            if (predicate != null) {
                this.clauseStack.push(Clause.WHERE);
                this.appendSql(" where ");
                predicate.accept(this);
                this.clauseStack.pop();
            }
        }
        this.clauseStack.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitOnDuplicateKeyConflictClause(ConflictClause conflictClause) {
        if (conflictClause == null) {
            return;
        }
        String constraintName = conflictClause.getConstraintName();
        if (constraintName != null) {
            if (conflictClause.isDoUpdate()) {
                throw new IllegalQueryOperationException("Insert conflict 'do update' clause with constraint name is not supported");
            }
            return;
        }
        InsertSelectStatement statement = (InsertSelectStatement)this.statementStack.getCurrent();
        this.clauseStack.push(Clause.CONFLICT);
        this.appendSql(" on duplicate key update");
        List<Assignment> assignments = conflictClause.getAssignments();
        if (assignments.isEmpty()) {
            ColumnReference columnReference = statement.getTargetColumns().get(0);
            try {
                this.clauseStack.push(Clause.SET);
                this.appendSql(' ');
                this.appendSql(columnReference.getColumnExpression());
                this.appendSql('=');
                this.visitColumnReference(columnReference);
            }
            finally {
                this.clauseStack.pop();
            }
        } else {
            this.renderPredicatedSetAssignments(assignments, conflictClause.getPredicate());
        }
        this.clauseStack.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderPredicatedSetAssignments(List<Assignment> assignments, Predicate predicate) {
        int separator = 32;
        try {
            this.clauseStack.push(Clause.SET);
            for (Assignment assignment : assignments) {
                this.appendSql((char)separator);
                separator = 44;
                if (predicate == null) {
                    this.visitSetAssignment(assignment);
                    continue;
                }
                assert (assignment.getAssignable().getColumnReferences().size() == 1);
                CaseSearchedExpression expression = new CaseSearchedExpression((MappingModelExpressible)assignment.getAssignedValue().getExpressionType(), List.of(new CaseSearchedExpression.WhenFragment(predicate, assignment.getAssignedValue())), assignment.getAssignable().getColumnReferences().get(0));
                this.visitSetAssignment(new Assignment(assignment.getAssignable(), expression));
            }
        }
        finally {
            this.clauseStack.pop();
        }
    }

    protected void visitReturningColumns(Supplier<List<ColumnReference>> returningColumnsAccess) {
        List<ColumnReference> returningColumns = returningColumnsAccess.get();
        if (returningColumns.isEmpty()) {
            return;
        }
        this.visitReturningColumns(returningColumns);
    }

    protected void visitReturningColumns(List<ColumnReference> returningColumns) {
        int size = returningColumns.size();
        if (size == 0) {
            return;
        }
        this.appendSql(" returning ");
        String separator = "";
        for (int i = 0; i < size; ++i) {
            this.appendSql(separator);
            this.appendSql(returningColumns.get(i).getColumnExpression());
            separator = ",";
        }
    }

    public void visitCteContainer(CteContainer cteContainer) {
        boolean renderRecursiveKeyword;
        Collection<CteStatement> cteStatements;
        Collection<CteStatement> originalCteStatements = cteContainer.getCteStatements().values();
        if (this.needsCteInlining() && !originalCteStatements.isEmpty()) {
            cteStatements = new ArrayList<CteStatement>(originalCteStatements.size());
            for (CteStatement cteStatement : originalCteStatements) {
                if (!cteStatement.isRecursive()) continue;
                cteStatements.add(cteStatement);
            }
        } else {
            cteStatements = originalCteStatements;
        }
        Collection<CteObject> cteObjects = cteContainer.getCteObjects().values();
        if (cteStatements.isEmpty() && cteObjects.isEmpty()) {
            return;
        }
        if (!this.supportsWithClause()) {
            if (this.isRecursive(cteStatements) && cteObjects.isEmpty()) {
                throw new UnsupportedOperationException("Can't emulate recursive CTEs!");
            }
            throw new IllegalStateException("Non-recursive CTEs found that need inlining, but were collected: " + String.valueOf(cteStatements));
        }
        boolean bl = renderRecursiveKeyword = this.needsRecursiveKeywordInWithClause() && this.isRecursive(cteStatements);
        if (renderRecursiveKeyword && !this.dialect.supportsRecursiveCTE()) {
            throw new UnsupportedOperationException("Can't emulate recursive CTEs!");
        }
        boolean isTopLevel = this.clauseStack.isEmpty();
        boolean pushToTopLevel = isTopLevel ? false : !this.supportsNestedWithClause() || !this.supportsWithClauseInSubquery() && this.isInSubquery();
        boolean inNestedWithClause = this.clauseStack.findCurrentFirst(AbstractSqlAstTranslator::matchWithClause) != null;
        this.clauseStack.push(Clause.WITH);
        if (!pushToTopLevel) {
            this.appendSql("with ");
            this.withClauseRecursiveIndex = this.sqlBuffer.length();
            if (renderRecursiveKeyword) {
                this.appendSql("recursive ");
            }
        }
        String mainSeparator = "";
        if (isTopLevel) {
            this.topLevelWithClauseIndex = this.sqlBuffer.length();
            for (CteObject cteObject : cteObjects) {
                this.visitCteObject(cteObject);
                this.topLevelWithClauseIndex = this.sqlBuffer.length();
            }
            for (CteStatement cteStatement : cteStatements) {
                this.appendSql(mainSeparator);
                this.visitCteStatement(cteStatement);
                mainSeparator = ",";
                this.topLevelWithClauseIndex = this.sqlBuffer.length();
            }
            this.appendSql(' ');
        } else if (pushToTopLevel) {
            if (this.topLevelWithClauseIndex == 0) {
                this.withClauseRecursiveIndex = 5;
                if (renderRecursiveKeyword) {
                    this.sqlBuffer.insert(0, "with recursive ");
                    this.topLevelWithClauseIndex = 15;
                } else {
                    this.sqlBuffer.insert(0, "with ");
                    this.topLevelWithClauseIndex = 5;
                }
            } else if (renderRecursiveKeyword) {
                String recursiveKeyword = "recursive ";
                if (!this.sqlBuffer.substring(this.withClauseRecursiveIndex, "recursive ".length()).equals("recursive ")) {
                    this.sqlBuffer.insert(this.withClauseRecursiveIndex, "recursive ");
                    this.topLevelWithClauseIndex += "recursive ".length();
                }
            }
            String temporaryRest = this.sqlBuffer.substring(this.topLevelWithClauseIndex);
            this.sqlBuffer.setLength(this.topLevelWithClauseIndex);
            if (this.sqlBuffer.charAt(this.topLevelWithClauseIndex - 1) == ')') {
                mainSeparator = ",";
            }
            for (CteObject cteObject : cteObjects) {
                this.visitCteObject(cteObject);
                this.topLevelWithClauseIndex = this.sqlBuffer.length();
            }
            for (CteStatement cteStatement : cteStatements) {
                this.appendSql(mainSeparator);
                this.visitCteStatement(cteStatement);
                mainSeparator = ",";
                this.topLevelWithClauseIndex = this.sqlBuffer.length();
            }
            if (inNestedWithClause) {
                this.appendSql(mainSeparator);
            }
            this.sqlBuffer.append(temporaryRest);
        } else {
            for (CteObject cteObject : cteObjects) {
                this.visitCteObject(cteObject);
            }
            for (CteStatement cteStatement : cteStatements) {
                this.appendSql(mainSeparator);
                this.visitCteStatement(cteStatement);
                mainSeparator = ",";
            }
            this.appendSql(' ');
        }
        this.clauseStack.pop();
    }

    private void visitCteStatement(CteStatement cte) {
        boolean needsParenthesis;
        this.appendSql(cte.getCteTable().getTableExpression());
        this.appendSql(" (");
        this.renderCteColumns(cte);
        this.appendSql(") as ");
        if (cte.getMaterialization() != CteMaterialization.UNDEFINED) {
            this.renderMaterializationHint(cte.getMaterialization());
        }
        boolean bl = needsParenthesis = !(cte.getCteDefinition() instanceof SelectStatement) || ((SelectStatement)cte.getCteDefinition()).getQueryPart().isRoot();
        if (needsParenthesis) {
            this.appendSql('(');
        }
        this.visitCteDefinition(cte);
        if (needsParenthesis) {
            this.appendSql(')');
        }
        this.renderSearchClause(cte);
        this.renderCycleClause(cte);
    }

    protected void visitCteObject(CteObject cteObject) {
        if (!(cteObject instanceof SelfRenderingCteObject)) {
            throw new IllegalArgumentException("Can't render CTE object " + cteObject.getName() + ": " + String.valueOf(cteObject));
        }
        ((SelfRenderingCteObject)cteObject).render(this, this, this.sessionFactory);
    }

    private boolean isRecursive(Collection<CteStatement> cteStatements) {
        for (CteStatement cteStatement : cteStatements) {
            if (!cteStatement.isRecursive()) continue;
            return true;
        }
        return false;
    }

    protected void renderCteColumns(CteStatement cte) {
        String separator = "";
        if (cte.getCteTable().getCteColumns() == null) {
            ArrayList columnExpressions = new ArrayList();
            cte.getCteTable().getTableGroupProducer().visitSubParts(modelPart -> modelPart.forEachSelectable(0, (index, mapping) -> columnExpressions.add(mapping.getSelectionExpression())), null);
            for (String columnExpression : columnExpressions) {
                this.appendSql(separator);
                this.appendSql(columnExpression);
                separator = ",";
            }
        } else {
            for (CteColumn cteColumn : cte.getCteTable().getCteColumns()) {
                this.appendSql(separator);
                this.appendSql(cteColumn.getColumnExpression());
                separator = ",";
            }
        }
        if (cte.isRecursive()) {
            if (!this.supportsRecursiveSearchClause() && cte.getSearchColumn() != null) {
                this.appendSql(",");
                if (cte.getSearchClauseKind() == CteSearchClauseKind.BREADTH_FIRST) {
                    this.appendSql(this.determineDepthColumnName(cte));
                    this.appendSql(",");
                }
                this.appendSql(cte.getSearchColumn().getColumnExpression());
            }
            if (!this.supportsRecursiveCycleClause() && cte.getCycleMarkColumn() != null) {
                this.appendSql(",");
                this.appendSql(cte.getCycleMarkColumn().getColumnExpression());
            }
            if (cte.getCycleMarkColumn() != null && !this.supportsRecursiveCycleClause() || cte.getCyclePathColumn() != null && !this.supportsRecursiveCycleUsingClause()) {
                this.appendSql(",");
                this.appendSql(this.determineCyclePathColumnName(cte));
            }
        }
    }

    private String determineDepthColumnName(CteStatement cte) {
        String baseName = "depth";
        block0: for (int tries = 0; tries < 5; ++tries) {
            String name = tries == 0 ? baseName : baseName + "_" + tries;
            for (CteColumn cteColumn : cte.getCteTable().getCteColumns()) {
                if (!name.equals(cteColumn.getColumnExpression())) continue;
                continue block0;
            }
            if (cte.getSearchColumn() != null && name.equals(cte.getSearchColumn().getColumnExpression()) || cte.getCycleMarkColumn() != null && name.equals(cte.getCycleMarkColumn().getColumnExpression()) || cte.getCyclePathColumn() != null && name.equals(cte.getCyclePathColumn().getColumnExpression())) continue;
            return name;
        }
        throw new IllegalStateException("Could not determine a depth column name after 5 tries!");
    }

    protected String determineCyclePathColumnName(CteStatement cte) {
        CteColumn cyclePathColumn = cte.getCyclePathColumn();
        if (cyclePathColumn != null) {
            return cyclePathColumn.getColumnExpression();
        }
        String baseName = "path";
        block0: for (int tries = 0; tries < 5; ++tries) {
            String name = tries == 0 ? baseName : baseName + "_" + tries;
            for (CteColumn cteColumn : cte.getCteTable().getCteColumns()) {
                if (!name.equals(cteColumn.getColumnExpression())) continue;
                continue block0;
            }
            if (cte.getSearchColumn() != null && name.equals(cte.getSearchColumn().getColumnExpression()) || cte.getCycleMarkColumn() != null && name.equals(cte.getCycleMarkColumn().getColumnExpression())) continue;
            return name;
        }
        throw new IllegalStateException("Could not determine a path column name after 5 tries!");
    }

    protected boolean isInRecursiveQueryPart() {
        return this.currentCteStatement != null && this.currentCteStatement.isRecursive() && ((QueryGroup)((SelectStatement)this.currentCteStatement.getCteDefinition()).getQueryPart()).getQueryParts().get(1) == this.getCurrentQueryPart();
    }

    protected boolean isInSubquery() {
        return this.statementStack.depth() > 1 && this.statementStack.getCurrent() instanceof SelectStatement && !((SelectStatement)this.statementStack.getCurrent()).getQueryPart().isRoot();
    }

    protected void visitCteDefinition(CteStatement cte) {
        CteStatement oldCteStatement = this.currentCteStatement;
        this.currentCteStatement = cte;
        Limit oldLimit = this.limit;
        this.limit = null;
        cte.getCteDefinition().accept(this);
        this.currentCteStatement = oldCteStatement;
        this.limit = oldLimit;
    }

    protected boolean supportsWithClause() {
        return true;
    }

    protected boolean supportsNestedWithClause() {
        return this.supportsWithClauseInSubquery();
    }

    protected boolean supportsWithClauseInSubquery() {
        return this.supportsWithClause();
    }

    protected boolean needsCteInlining() {
        return !this.supportsWithClause() || !this.supportsWithClauseInSubquery() && this.isInSubquery();
    }

    protected boolean shouldInlineCte(TableGroup tableGroup) {
        if (tableGroup instanceof CteTableGroup) {
            if (!this.supportsWithClause()) {
                return true;
            }
            if (!this.supportsWithClauseInSubquery() && this.isInSubquery()) {
                String cteName = tableGroup.getPrimaryTableReference().getTableId();
                CteContainer cteOwner = this.statementStack.findCurrentFirstWithParameter(cteName, AbstractSqlAstTranslator::matchCteContainerByStatement);
                return cteOwner != this.statementStack.getRoot() && !cteOwner.getCteStatement(cteName).isRecursive();
            }
        }
        return false;
    }

    protected boolean needsRecursiveKeywordInWithClause() {
        return true;
    }

    protected boolean supportsRecursiveSearchClause() {
        return false;
    }

    protected boolean supportsRecursiveCycleClause() {
        return false;
    }

    protected boolean supportsRecursiveCycleUsingClause() {
        return false;
    }

    protected boolean supportsRecursiveClauseArrayAndRowEmulation() {
        return (this.supportsRowConstructor() || this.currentCteStatement.getSearchClauseKind() == CteSearchClauseKind.DEPTH_FIRST && this.currentCteStatement.getSearchBySpecifications().size() == 1) && this.supportsArrayConstructor();
    }

    protected boolean supportsRowConstructor() {
        return false;
    }

    protected boolean supportsArrayConstructor() {
        return false;
    }

    protected void renderMaterializationHint(CteMaterialization materialization) {
    }

    protected void renderSearchClause(CteStatement cte) {
        if (this.supportsRecursiveSearchClause()) {
            this.renderStandardSearchClause(cte);
        }
    }

    protected void renderStandardSearchClause(CteStatement cte) {
        if (cte.getSearchClauseKind() != null) {
            this.appendSql(" search ");
            if (cte.getSearchClauseKind() == CteSearchClauseKind.DEPTH_FIRST) {
                this.appendSql(" depth ");
            } else {
                this.appendSql(" breadth ");
            }
            this.appendSql(" first by ");
            String separator = "";
            for (SearchClauseSpecification searchBySpecification : cte.getSearchBySpecifications()) {
                this.appendSql(separator);
                this.appendSql(searchBySpecification.getCteColumn().getColumnExpression());
                SortDirection sortOrder = searchBySpecification.getSortOrder();
                if (sortOrder != null) {
                    boolean renderNullPrecedence;
                    NullPrecedence nullPrecedence = searchBySpecification.getNullPrecedence();
                    if (nullPrecedence == null || nullPrecedence == NullPrecedence.NONE) {
                        nullPrecedence = this.sessionFactory.getSessionFactoryOptions().getDefaultNullPrecedence();
                    }
                    boolean bl = renderNullPrecedence = nullPrecedence != null && !nullPrecedence.isDefaultOrdering(sortOrder, this.dialect.getNullOrdering());
                    if (sortOrder == SortDirection.DESCENDING) {
                        this.appendSql(" desc");
                    } else if (renderNullPrecedence) {
                        this.appendSql(" asc");
                    }
                    if (renderNullPrecedence) {
                        if (searchBySpecification.getNullPrecedence() == NullPrecedence.FIRST) {
                            this.appendSql(" nulls first");
                        } else {
                            this.appendSql(" nulls last");
                        }
                    }
                }
                separator = ",";
            }
            this.appendSql(" set ");
            this.appendSql(cte.getSearchColumn().getColumnExpression());
        }
    }

    protected void renderCycleClause(CteStatement cte) {
        if (this.supportsRecursiveCycleClause()) {
            this.renderStandardCycleClause(cte);
        }
    }

    protected void renderStandardCycleClause(CteStatement cte) {
        if (cte.getCycleMarkColumn() != null) {
            this.appendSql(" cycle ");
            String separator = "";
            for (CteColumn cycleColumn : cte.getCycleColumns()) {
                this.appendSql(separator);
                this.appendSql(cycleColumn.getColumnExpression());
                separator = ",";
            }
            this.appendSql(" set ");
            this.appendSql(cte.getCycleMarkColumn().getColumnExpression());
            this.appendSql(" to ");
            cte.getCycleValue().accept(this);
            this.appendSql(" default ");
            cte.getNoCycleValue().accept(this);
            if (cte.getCyclePathColumn() != null && this.supportsRecursiveCycleUsingClause()) {
                this.appendSql(" using ");
                this.appendSql(cte.getCyclePathColumn().getColumnExpression());
            }
        }
    }

    protected void renderRecursiveCteVirtualSelections(SelectClause selectClause) {
        if (this.currentCteStatement != null && this.currentCteStatement.isRecursive()) {
            if (this.currentCteStatement.getSearchColumn() != null && !this.supportsRecursiveSearchClause()) {
                this.appendSql(",");
                if (this.supportsRecursiveClauseArrayAndRowEmulation()) {
                    this.emulateSearchClauseOrderWithRowAndArray(selectClause);
                } else {
                    this.emulateSearchClauseOrderWithString(selectClause);
                }
            }
            if ((!this.supportsRecursiveCycleClause() || this.currentCteStatement.getCyclePathColumn() != null && !this.supportsRecursiveCycleUsingClause()) && this.currentCteStatement.getCycleMarkColumn() != null) {
                this.appendSql(",");
                if (this.supportsRecursiveClauseArrayAndRowEmulation()) {
                    this.emulateCycleClauseWithRowAndArray(selectClause);
                } else {
                    this.emulateCycleClauseWithString(selectClause);
                }
                if (!this.supportsRecursiveCycleClause() && this.isInRecursiveQueryPart()) {
                    ColumnReference cycleColumnReference = new ColumnReference(this.findTableReferenceByTableId(this.currentCteStatement.getCteTable().getTableExpression()), this.currentCteStatement.getCycleMarkColumn().getColumnExpression(), false, null, this.currentCteStatement.getCycleMarkColumn().getJdbcMapping());
                    if (this.currentCteStatement.getCycleValue().getJdbcMapping() == this.getBooleanType() && this.currentCteStatement.getCycleValue().getLiteralValue() == Boolean.TRUE && this.currentCteStatement.getNoCycleValue().getLiteralValue() == Boolean.FALSE) {
                        this.addAdditionalWherePredicate(new BooleanExpressionPredicate(cycleColumnReference, true, cycleColumnReference.getExpressionType()));
                    } else {
                        this.addAdditionalWherePredicate(new ComparisonPredicate(cycleColumnReference, ComparisonOperator.EQUAL, this.currentCteStatement.getNoCycleValue()));
                    }
                }
            }
        }
    }

    protected void emulateSearchClauseOrderWithRowAndArray(SelectClause selectClause) {
        BasicType<Integer> integerType = this.getIntegerType();
        if (this.isInRecursiveQueryPart()) {
            TableReference recursiveTableReference = this.findTableReferenceByTableId(this.currentCteStatement.getCteTable().getTableExpression());
            if (this.currentCteStatement.getSearchClauseKind() == CteSearchClauseKind.BREADTH_FIRST) {
                String depthColumnName = this.determineDepthColumnName(this.currentCteStatement);
                ColumnReference depthColumnReference = new ColumnReference(recursiveTableReference, depthColumnName, false, null, integerType);
                this.visitColumnReference(depthColumnReference);
                this.appendSql("+1");
                this.appendSql(",");
                this.appendSql("row(");
                this.visitColumnReference(depthColumnReference);
                for (SearchClauseSpecification searchBySpecification : this.currentCteStatement.getSearchBySpecifications()) {
                    if (searchBySpecification.getSortOrder() == SortDirection.DESCENDING) {
                        throw new IllegalArgumentException("Can't emulate search clause for descending search specifications");
                    }
                    if (searchBySpecification.getNullPrecedence() != NullPrecedence.NONE) {
                        throw new IllegalArgumentException("Can't emulate search clause for search specifications with explicit null precedence");
                    }
                    int selectionIndex = this.currentCteStatement.getCteTable().getCteColumns().indexOf(searchBySpecification.getCteColumn());
                    SqlSelection sqlSelection = selectClause.getSqlSelections().get(selectionIndex);
                    this.appendSql(",");
                    sqlSelection.accept(this);
                }
                this.appendSql(')');
            } else {
                this.visitColumnReference(new ColumnReference(recursiveTableReference, this.currentCteStatement.getSearchColumn().getColumnExpression(), false, null, this.currentCteStatement.getSearchColumn().getJdbcMapping()));
                this.appendSql("||");
                this.appendSql("array[");
                if (this.currentCteStatement.getSearchBySpecifications().size() > 1) {
                    this.appendSql("row(");
                }
                String separator = "";
                for (SearchClauseSpecification searchBySpecification : this.currentCteStatement.getSearchBySpecifications()) {
                    if (searchBySpecification.getSortOrder() == SortDirection.DESCENDING) {
                        throw new IllegalArgumentException("Can't emulate search clause for descending search specifications");
                    }
                    if (searchBySpecification.getNullPrecedence() != NullPrecedence.NONE) {
                        throw new IllegalArgumentException("Can't emulate search clause for search specifications with explicit null precedence");
                    }
                    int selectionIndex = this.currentCteStatement.getCteTable().getCteColumns().indexOf(searchBySpecification.getCteColumn());
                    SqlSelection sqlSelection = selectClause.getSqlSelections().get(selectionIndex);
                    this.appendSql(separator);
                    sqlSelection.accept(this);
                    separator = ",";
                }
                if (this.currentCteStatement.getSearchBySpecifications().size() > 1) {
                    this.appendSql(')');
                }
                this.appendSql(']');
            }
        } else if (this.currentCteStatement.getSearchClauseKind() == CteSearchClauseKind.BREADTH_FIRST) {
            this.appendSql('1');
            this.appendSql(",");
            this.appendSql("row(0");
            for (SearchClauseSpecification searchBySpecification : this.currentCteStatement.getSearchBySpecifications()) {
                if (searchBySpecification.getSortOrder() == SortDirection.DESCENDING) {
                    throw new IllegalArgumentException("Can't emulate search clause for descending search specifications");
                }
                if (searchBySpecification.getNullPrecedence() != NullPrecedence.NONE) {
                    throw new IllegalArgumentException("Can't emulate search clause for search specifications with explicit null precedence");
                }
                int selectionIndex = this.currentCteStatement.getCteTable().getCteColumns().indexOf(searchBySpecification.getCteColumn());
                SqlSelection sqlSelection = selectClause.getSqlSelections().get(selectionIndex);
                this.appendSql(",");
                sqlSelection.accept(this);
            }
            this.appendSql(')');
        } else {
            this.appendSql("array[");
            if (this.currentCteStatement.getSearchBySpecifications().size() > 1) {
                this.appendSql("row(");
            }
            String separator = "";
            for (SearchClauseSpecification searchBySpecification : this.currentCteStatement.getSearchBySpecifications()) {
                if (searchBySpecification.getSortOrder() == SortDirection.DESCENDING) {
                    throw new IllegalArgumentException("Can't emulate search clause for descending search specifications");
                }
                if (searchBySpecification.getNullPrecedence() != NullPrecedence.NONE) {
                    throw new IllegalArgumentException("Can't emulate search clause for search specifications with explicit null precedence");
                }
                int selectionIndex = this.currentCteStatement.getCteTable().getCteColumns().indexOf(searchBySpecification.getCteColumn());
                SqlSelection sqlSelection = selectClause.getSqlSelections().get(selectionIndex);
                this.appendSql(separator);
                sqlSelection.accept(this);
                separator = ",";
            }
            if (this.currentCteStatement.getSearchBySpecifications().size() > 1) {
                this.appendSql(')');
            }
            this.appendSql(']');
        }
    }

    private void emulateSearchClauseOrderWithString(SelectClause selectClause) {
        AbstractSqmSelfRenderingFunctionDescriptor concat = this.findSelfRenderingFunction("concat", 2);
        AbstractSqmSelfRenderingFunctionDescriptor coalesce = this.findSelfRenderingFunction("coalesce", 2);
        BasicType<String> stringType = this.getStringType();
        BasicType<Integer> integerType = this.getIntegerType();
        ArrayList<Expression> arguments = new ArrayList<Expression>(this.currentCteStatement.getSearchBySpecifications().size() << 1);
        Expression nullSeparator = this.createNullSeparator();
        if (this.isInRecursiveQueryPart()) {
            TableReference recursiveTableReference = this.findTableReferenceByTableId(this.currentCteStatement.getCteTable().getTableExpression());
            if (this.currentCteStatement.getSearchClauseKind() == CteSearchClauseKind.BREADTH_FIRST) {
                String depthColumnName = this.determineDepthColumnName(this.currentCteStatement);
                ColumnReference depthColumnReference = new ColumnReference(recursiveTableReference, depthColumnName, false, null, integerType);
                this.visitColumnReference(depthColumnReference);
                this.appendSql("+1");
                this.appendSql(",");
                arguments.add(this.lpad(this.castToString(depthColumnReference), 10, "0"));
                arguments.add(nullSeparator);
                for (SearchClauseSpecification searchBySpecification : this.currentCteStatement.getSearchBySpecifications()) {
                    if (searchBySpecification.getSortOrder() == SortDirection.DESCENDING) {
                        throw new IllegalArgumentException("Can't emulate search clause for descending search specifications");
                    }
                    if (searchBySpecification.getNullPrecedence() != NullPrecedence.NONE) {
                        throw new IllegalArgumentException("Can't emulate search clause for search specifications with explicit null precedence");
                    }
                    int selectionIndex = this.currentCteStatement.getCteTable().getCteColumns().indexOf(searchBySpecification.getCteColumn());
                    Expression selectionExpression = selectClause.getSqlSelections().get(selectionIndex).getExpression();
                    arguments.add(new SelfRenderingFunctionSqlAstExpression("coalesce", coalesce, List.of(this.wrapRowComponentAsOrderPreservingConcatArgument(selectionExpression), nullSeparator), stringType, stringType));
                    arguments.add(nullSeparator);
                }
                concat.render((SqlAppender)this, arguments, stringType, this);
            } else {
                arguments.add(new ColumnReference(recursiveTableReference, this.currentCteStatement.getSearchColumn().getColumnExpression(), false, null, this.currentCteStatement.getSearchColumn().getJdbcMapping()));
                for (SearchClauseSpecification searchBySpecification : this.currentCteStatement.getSearchBySpecifications()) {
                    if (searchBySpecification.getSortOrder() == SortDirection.DESCENDING) {
                        throw new IllegalArgumentException("Can't emulate search clause for descending search specifications");
                    }
                    if (searchBySpecification.getNullPrecedence() != NullPrecedence.NONE) {
                        throw new IllegalArgumentException("Can't emulate search clause for search specifications with explicit null precedence");
                    }
                    int selectionIndex = this.currentCteStatement.getCteTable().getCteColumns().indexOf(searchBySpecification.getCteColumn());
                    Expression selectionExpression = selectClause.getSqlSelections().get(selectionIndex).getExpression();
                    arguments.add(new SelfRenderingFunctionSqlAstExpression("coalesce", coalesce, List.of(this.wrapRowComponentAsOrderPreservingConcatArgument(selectionExpression), nullSeparator), stringType, stringType));
                    arguments.add(nullSeparator);
                }
                arguments.add(nullSeparator);
                concat.render((SqlAppender)this, arguments, stringType, this);
            }
        } else {
            int columnSizeEstimate = 0;
            if (this.currentCteStatement.getSearchClauseKind() == CteSearchClauseKind.BREADTH_FIRST) {
                this.appendSql('1');
                this.appendSql(",");
                arguments.add(new QueryLiteral<String>(StringHelper.repeat('0', 10), stringType));
                arguments.add(nullSeparator);
                columnSizeEstimate += 11;
                for (SearchClauseSpecification searchBySpecification : this.currentCteStatement.getSearchBySpecifications()) {
                    if (searchBySpecification.getSortOrder() == SortDirection.DESCENDING) {
                        throw new IllegalArgumentException("Can't emulate search clause for descending search specifications");
                    }
                    if (searchBySpecification.getNullPrecedence() != NullPrecedence.NONE) {
                        throw new IllegalArgumentException("Can't emulate search clause for search specifications with explicit null precedence");
                    }
                    int selectionIndex = this.currentCteStatement.getCteTable().getCteColumns().indexOf(searchBySpecification.getCteColumn());
                    Expression selectionExpression = selectClause.getSqlSelections().get(selectionIndex).getExpression();
                    arguments.add(new SelfRenderingFunctionSqlAstExpression("coalesce", coalesce, List.of(this.wrapRowComponentAsOrderPreservingConcatArgument(selectionExpression), nullSeparator), stringType, stringType));
                    arguments.add(nullSeparator);
                    columnSizeEstimate += this.wrapRowComponentAsOrderPreservingConcatArgumentSizeEstimate(selectionExpression) + 1;
                }
                this.visitRecursivePath(new SelfRenderingFunctionSqlAstExpression("concat", concat, arguments, stringType, stringType), columnSizeEstimate);
            } else {
                for (SearchClauseSpecification searchBySpecification : this.currentCteStatement.getSearchBySpecifications()) {
                    if (searchBySpecification.getSortOrder() == SortDirection.DESCENDING) {
                        throw new IllegalArgumentException("Can't emulate search clause for descending search specifications");
                    }
                    if (searchBySpecification.getNullPrecedence() != NullPrecedence.NONE) {
                        throw new IllegalArgumentException("Can't emulate search clause for search specifications with explicit null precedence");
                    }
                    int selectionIndex = this.currentCteStatement.getCteTable().getCteColumns().indexOf(searchBySpecification.getCteColumn());
                    Expression selectionExpression = selectClause.getSqlSelections().get(selectionIndex).getExpression();
                    arguments.add(new SelfRenderingFunctionSqlAstExpression("coalesce", coalesce, List.of(this.wrapRowComponentAsEqualityPreservingConcatArgument(selectionExpression), nullSeparator), stringType, stringType));
                    arguments.add(nullSeparator);
                    columnSizeEstimate += this.wrapRowComponentAsOrderPreservingConcatArgumentSizeEstimate(selectionExpression) + 1;
                }
                arguments.add(nullSeparator);
                this.visitRecursivePath(new SelfRenderingFunctionSqlAstExpression("concat", concat, arguments, stringType, stringType), ++columnSizeEstimate * 1000);
            }
        }
    }

    protected void visitRecursivePath(Expression recursivePath, int sizeEstimate) {
        recursivePath.accept(this);
    }

    protected void emulateCycleClauseWithRowAndArray(SelectClause selectClause) {
        if (this.isInRecursiveQueryPart()) {
            BasicType<String> stringType = this.getStringType();
            TableReference recursiveTableReference = this.findTableReferenceByTableId(this.currentCteStatement.getCteTable().getTableExpression());
            String cyclePathColumnName = this.determineCyclePathColumnName(this.currentCteStatement);
            ColumnReference cyclePathColumnReference = new ColumnReference(recursiveTableReference, cyclePathColumnName, false, null, stringType);
            if (!this.supportsRecursiveCycleClause()) {
                this.appendSql("case when ");
                String arrayContainsFunction = this.getArrayContainsFunction();
                if (arrayContainsFunction != null) {
                    this.appendSql(arrayContainsFunction);
                    this.appendSql('(');
                    this.visitColumnReference(cyclePathColumnReference);
                    this.appendSql(",");
                }
                if (this.currentCteStatement.getCycleColumns().size() > 1) {
                    this.appendSql("row(");
                    String separator = "";
                    for (CteColumn cycleColumn : this.currentCteStatement.getCycleColumns()) {
                        int selectionIndex = this.currentCteStatement.getCteTable().getCteColumns().indexOf(cycleColumn);
                        SqlSelection sqlSelection = selectClause.getSqlSelections().get(selectionIndex);
                        this.appendSql(separator);
                        sqlSelection.accept(this);
                        separator = ",";
                    }
                    this.appendSql(')');
                } else {
                    int selectionIndex = this.currentCteStatement.getCteTable().getCteColumns().indexOf(this.currentCteStatement.getCycleColumns().get(0));
                    SqlSelection sqlSelection = selectClause.getSqlSelections().get(selectionIndex);
                    sqlSelection.accept(this);
                }
                if (arrayContainsFunction == null) {
                    this.appendSql("=any(");
                    this.visitColumnReference(cyclePathColumnReference);
                }
                this.appendSql(')');
                this.appendSql(" then ");
                this.currentCteStatement.getCycleValue().accept(this);
                this.appendSql(" else ");
                this.currentCteStatement.getNoCycleValue().accept(this);
                this.appendSql(" end");
                this.appendSql(",");
            }
            this.visitColumnReference(cyclePathColumnReference);
            this.appendSql("||array[");
            if (this.currentCteStatement.getCycleColumns().size() > 1) {
                this.appendSql("row(");
            }
            String separator = "";
            for (CteColumn cycleColumn : this.currentCteStatement.getCycleColumns()) {
                int selectionIndex = this.currentCteStatement.getCteTable().getCteColumns().indexOf(cycleColumn);
                SqlSelection sqlSelection = selectClause.getSqlSelections().get(selectionIndex);
                this.appendSql(separator);
                sqlSelection.accept(this);
                separator = ",";
            }
            if (this.currentCteStatement.getCycleColumns().size() > 1) {
                this.appendSql(')');
            }
            this.appendSql(']');
        } else {
            if (!this.supportsRecursiveCycleClause()) {
                this.currentCteStatement.getNoCycleValue().accept(this);
                this.appendSql(",");
            }
            this.appendSql("array[");
            if (this.currentCteStatement.getCycleColumns().size() > 1) {
                this.appendSql("row(");
            }
            String separator = "";
            for (CteColumn cycleColumn : this.currentCteStatement.getCycleColumns()) {
                int selectionIndex = this.currentCteStatement.getCteTable().getCteColumns().indexOf(cycleColumn);
                SqlSelection sqlSelection = selectClause.getSqlSelections().get(selectionIndex);
                this.appendSql(separator);
                sqlSelection.accept(this);
                separator = ",";
            }
            if (this.currentCteStatement.getCycleColumns().size() > 1) {
                this.appendSql(')');
            }
            this.appendSql(']');
        }
    }

    protected String getArrayContainsFunction() {
        return null;
    }

    private Expression createNullSeparator() {
        AbstractSqmSelfRenderingFunctionDescriptor chr = this.findSelfRenderingFunction("chr", 1);
        BasicType<String> stringType = this.getStringType();
        return new SelfRenderingFunctionSqlAstExpression("chr", chr, List.of(new QueryLiteral<Integer>(0, this.getIntegerType())), stringType, stringType);
    }

    private void emulateCycleClauseWithString(SelectClause selectClause) {
        AbstractSqmSelfRenderingFunctionDescriptor concat = this.findSelfRenderingFunction("concat", 2);
        AbstractSqmSelfRenderingFunctionDescriptor coalesce = this.findSelfRenderingFunction("coalesce", 2);
        BasicType<String> stringType = this.getStringType();
        ArrayList<Expression> arguments = new ArrayList<Expression>(this.currentCteStatement.getCycleColumns().size() << 2);
        Expression nullSeparator = this.createNullSeparator();
        if (this.isInRecursiveQueryPart()) {
            TableReference recursiveTableReference = this.findTableReferenceByTableId(this.currentCteStatement.getCteTable().getTableExpression());
            String cyclePathColumnName = this.determineCyclePathColumnName(this.currentCteStatement);
            ColumnReference cyclePathColumnReference = new ColumnReference(recursiveTableReference, cyclePathColumnName, false, null, stringType);
            for (CteColumn cycleColumn : this.currentCteStatement.getCycleColumns()) {
                int selectionIndex = this.currentCteStatement.getCteTable().getCteColumns().indexOf(cycleColumn);
                Expression selectionExpression = selectClause.getSqlSelections().get(selectionIndex).getExpression();
                arguments.add(nullSeparator);
                arguments.add(new SelfRenderingFunctionSqlAstExpression("coalesce", coalesce, List.of(this.wrapRowComponentAsEqualityPreservingConcatArgument(selectionExpression), nullSeparator), stringType, stringType));
                arguments.add(nullSeparator);
            }
            arguments.add(nullSeparator);
            if (!this.supportsRecursiveCycleClause()) {
                this.appendSql("case when ");
                this.renderStringContainsExactlyPredicate(cyclePathColumnReference, new SelfRenderingFunctionSqlAstExpression("concat", concat, arguments, stringType, stringType));
                this.appendSql(" then ");
                this.currentCteStatement.getCycleValue().accept(this);
                this.appendSql(" else ");
                this.currentCteStatement.getNoCycleValue().accept(this);
                this.appendSql(" end");
                this.appendSql(",");
            }
            arguments.add(0, cyclePathColumnReference);
            concat.render((SqlAppender)this, arguments, stringType, this);
        } else {
            if (!this.supportsRecursiveCycleClause()) {
                this.currentCteStatement.getNoCycleValue().accept(this);
                this.appendSql(",");
            }
            int columnSizeEstimate = 1;
            for (CteColumn cycleColumn : this.currentCteStatement.getCycleColumns()) {
                int selectionIndex = this.currentCteStatement.getCteTable().getCteColumns().indexOf(cycleColumn);
                Expression selectionExpression = selectClause.getSqlSelections().get(selectionIndex).getExpression();
                arguments.add(nullSeparator);
                arguments.add(new SelfRenderingFunctionSqlAstExpression("coalesce", coalesce, List.of(this.wrapRowComponentAsEqualityPreservingConcatArgument(selectionExpression), nullSeparator), stringType, stringType));
                arguments.add(nullSeparator);
                columnSizeEstimate += this.wrapRowComponentAsEqualityPreservingConcatArgumentSizeEstimate(selectionExpression) + 1;
            }
            arguments.add(nullSeparator);
            this.visitRecursivePath(new SelfRenderingFunctionSqlAstExpression("concat", concat, arguments, stringType, stringType), columnSizeEstimate * 1000);
        }
    }

    protected void renderStringContainsExactlyPredicate(Expression haystack, Expression needle) {
        AbstractSqmSelfRenderingFunctionDescriptor position = this.findSelfRenderingFunction("position", 2);
        new SelfRenderingFunctionSqlAstExpression("position", position, List.of(needle, haystack), this.getStringType(), this.getStringType()).accept(this);
        this.append(">0");
    }

    private SqlAstNode wrapRowComponentAsOrderPreservingConcatArgument(Expression expression) {
        JdbcMapping jdbcMapping = expression.getExpressionType().getSingleJdbcMapping();
        switch (jdbcMapping.getCastType()) {
            case STRING: {
                return expression;
            }
            case BOOLEAN: 
            case INTEGER_BOOLEAN: 
            case TF_BOOLEAN: 
            case YN_BOOLEAN: {
                return this.castToString(expression);
            }
            case INTEGER: 
            case LONG: {
                return this.castNumberToString(expression, 19, 0);
            }
            case FIXED: {
                SqlTypedMapping sqlTypedMapping;
                if (expression.getExpressionType() instanceof SqlTypedMapping && (sqlTypedMapping = (SqlTypedMapping)((Object)expression.getExpressionType())).getPrecision() != null && sqlTypedMapping.getScale() != null) {
                    return this.castNumberToString(expression, sqlTypedMapping.getPrecision(), sqlTypedMapping.getScale());
                }
                throw new IllegalArgumentException(String.format("Can't emulate order preserving row constructor through string concatenation for numeric expression [%s] without precision or scale", expression));
            }
        }
        throw new IllegalArgumentException(String.format("Can't emulate order preserving row constructor through string concatenation for expression [%s] which is of type [%s]", new Object[]{expression, jdbcMapping.getCastType()}));
    }

    private int wrapRowComponentAsOrderPreservingConcatArgumentSizeEstimate(Expression expression) {
        JdbcMapping jdbcMapping = expression.getExpressionType().getSingleJdbcMapping();
        switch (jdbcMapping.getCastType()) {
            case STRING: {
                SqlTypedMapping sqlTypedMapping;
                if (expression.getExpressionType() instanceof SqlTypedMapping && (sqlTypedMapping = (SqlTypedMapping)((Object)expression.getExpressionType())).getLength() != null) {
                    return sqlTypedMapping.getLength().intValue();
                }
                return Short.MAX_VALUE;
            }
            case BOOLEAN: 
            case INTEGER_BOOLEAN: 
            case TF_BOOLEAN: 
            case YN_BOOLEAN: {
                return 5;
            }
            case INTEGER: 
            case LONG: {
                return 20;
            }
            case FIXED: {
                SqlTypedMapping sqlTypedMapping;
                if (!(expression.getExpressionType() instanceof SqlTypedMapping) || (sqlTypedMapping = (SqlTypedMapping)((Object)expression.getExpressionType())).getPrecision() == null || sqlTypedMapping.getScale() == null) break;
                return sqlTypedMapping.getPrecision() + sqlTypedMapping.getScale() + 2;
            }
        }
        return 1;
    }

    private SqlAstNode wrapRowComponentAsEqualityPreservingConcatArgument(Expression expression) {
        JdbcMapping jdbcMapping = expression.getExpressionType().getSingleJdbcMapping();
        switch (jdbcMapping.getCastType()) {
            case STRING: {
                return expression;
            }
            case BOOLEAN: 
            case INTEGER_BOOLEAN: 
            case TF_BOOLEAN: 
            case YN_BOOLEAN: 
            case INTEGER: 
            case LONG: 
            case FIXED: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case OFFSET_TIMESTAMP: 
            case ZONE_TIMESTAMP: {
                if (this.dialect.requiresCastForConcatenatingNonStrings()) {
                    return this.castToString(expression);
                }
                BasicType<String> stringType = this.getStringType();
                AbstractSqmSelfRenderingFunctionDescriptor concat = this.findSelfRenderingFunction("concat", 2);
                return new SelfRenderingFunctionSqlAstExpression("concat", concat, List.of(expression, new QueryLiteral<String>("", stringType)), stringType, stringType);
            }
        }
        throw new IllegalArgumentException(String.format("Can't emulate equality preserving row constructor through string concatenation for expression [%s] which is of type [%s]", new Object[]{expression, jdbcMapping.getCastType()}));
    }

    private int wrapRowComponentAsEqualityPreservingConcatArgumentSizeEstimate(Expression expression) {
        JdbcMapping jdbcMapping = expression.getExpressionType().getSingleJdbcMapping();
        switch (jdbcMapping.getCastType()) {
            case STRING: {
                SqlTypedMapping sqlTypedMapping;
                if (expression.getExpressionType() instanceof SqlTypedMapping && (sqlTypedMapping = (SqlTypedMapping)((Object)expression.getExpressionType())).getLength() != null) {
                    return sqlTypedMapping.getLength().intValue();
                }
                return Short.MAX_VALUE;
            }
            case BOOLEAN: 
            case INTEGER_BOOLEAN: 
            case TF_BOOLEAN: 
            case YN_BOOLEAN: {
                return 5;
            }
            case INTEGER: 
            case LONG: {
                return 20;
            }
            case FIXED: {
                SqlTypedMapping sqlTypedMapping;
                if (expression.getExpressionType() instanceof SqlTypedMapping && (sqlTypedMapping = (SqlTypedMapping)((Object)expression.getExpressionType())).getPrecision() != null && sqlTypedMapping.getScale() != null) {
                    return sqlTypedMapping.getPrecision() + sqlTypedMapping.getScale() + 2;
                }
            }
            case DATE: {
                return 10;
            }
            case TIME: {
                return 8;
            }
            case TIMESTAMP: {
                return 29;
            }
            case OFFSET_TIMESTAMP: 
            case ZONE_TIMESTAMP: {
                return 36;
            }
        }
        return 1;
    }

    private Expression abs(Expression expression) {
        AbstractSqmSelfRenderingFunctionDescriptor abs = this.findSelfRenderingFunction("abs", 2);
        return new SelfRenderingFunctionSqlAstExpression("abs", abs, List.of(expression), (ReturnableType)((Object)expression.getExpressionType()), expression.getExpressionType());
    }

    private Expression lpad(Expression expression, int stringLength, String padString) {
        BasicType<String> stringType = this.getStringType();
        AbstractSqmSelfRenderingFunctionDescriptor lpad = this.findSelfRenderingFunction("lpad", 3);
        return new SelfRenderingFunctionSqlAstExpression("lpad", lpad, List.of(expression, new QueryLiteral<Integer>(stringLength, this.getIntegerType()), new QueryLiteral<String>(padString, stringType)), stringType, stringType);
    }

    private AbstractSqmSelfRenderingFunctionDescriptor findSelfRenderingFunction(String functionName, int argumentCount) {
        SqmFunctionDescriptor functionDescriptor = this.sessionFactory.getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor(functionName);
        if (functionDescriptor instanceof MultipatternSqmFunctionDescriptor) {
            MultipatternSqmFunctionDescriptor multiPatternFunction = (MultipatternSqmFunctionDescriptor)functionDescriptor;
            return (AbstractSqmSelfRenderingFunctionDescriptor)multiPatternFunction.getFunction(argumentCount);
        }
        return (AbstractSqmSelfRenderingFunctionDescriptor)functionDescriptor;
    }

    protected Expression castNumberToString(Expression expression, int precision, int scale) {
        BasicType<String> stringType = this.getStringType();
        AbstractSqmSelfRenderingFunctionDescriptor concat = this.findSelfRenderingFunction("concat", 2);
        CaseSearchedExpression signExpression = new CaseSearchedExpression(stringType);
        signExpression.when(new ComparisonPredicate(expression, ComparisonOperator.LESS_THAN, new QueryLiteral<Integer>(0, this.getIntegerType())), new QueryLiteral<String>("-", stringType));
        signExpression.otherwise(new QueryLiteral<String>("-", stringType));
        int stringLength = precision + (scale > 0 ? scale + 1 : 0);
        return new SelfRenderingFunctionSqlAstExpression("concat", concat, List.of(signExpression, this.lpad(this.castToString(this.abs(expression)), stringLength, "0")), stringType, stringType);
    }

    private Expression castToString(SqlAstNode node) {
        BasicType<String> stringType = this.getStringType();
        return new SelfRenderingFunctionSqlAstExpression("cast", this.castFunction(), List.of(node, new CastTarget(stringType)), stringType, stringType);
    }

    private TableReference findTableReferenceByTableId(String tableExpression) {
        QuerySpec currentQuerySpec = (QuerySpec)this.getCurrentQueryPart();
        return currentQuerySpec.getFromClause().queryTableReferences(tableReference -> {
            if (tableExpression.equals(tableReference.getTableId())) {
                return tableReference;
            }
            return null;
        });
    }

    @Override
    public void visitQueryGroup(QueryGroup queryGroup) {
        this.renderQueryGroup(queryGroup, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderQueryGroup(QueryGroup queryGroup, boolean renderOrderByAndOffsetFetchClause) {
        QueryPart queryPartForRowNumbering = this.queryPartForRowNumbering;
        int queryPartForRowNumberingClauseDepth = this.queryPartForRowNumberingClauseDepth;
        boolean needsSelectAliases = this.needsSelectAliases;
        try {
            boolean needsParenthesis;
            boolean needsQueryGroupWrapper;
            String queryGroupAlias = null;
            QueryPart currentQueryPart = this.queryPartStack.getCurrent();
            if (currentQueryPart != null && queryPartForRowNumberingClauseDepth != this.clauseStack.depth()) {
                this.queryPartForRowNumbering = null;
                this.queryPartForRowNumberingClauseDepth = -1;
                this.needsSelectAliases = this.columnAliases != null;
            }
            boolean needsRowNumberingWrapper = queryPartForRowNumbering == queryGroup || this.additionalWherePredicate != null && !this.additionalWherePredicate.isEmpty();
            boolean bl = needsQueryGroupWrapper = currentQueryPart instanceof QueryGroup && !this.supportsSimpleQueryGrouping();
            if (currentQueryPart instanceof QueryGroup) {
                needsParenthesis = !needsRowNumberingWrapper && !needsQueryGroupWrapper;
            } else {
                boolean bl2 = needsParenthesis = queryGroup.hasOffsetOrFetchClause() && !queryGroup.isRoot();
            }
            if (needsParenthesis) {
                this.appendSql('(');
            }
            if (needsRowNumberingWrapper) {
                this.needsSelectAliases = true;
                queryGroupAlias = "grp_" + this.queryGroupAliasCounter + "_";
                ++this.queryGroupAliasCounter;
                this.appendSql("select ");
                this.appendSql(queryGroupAlias);
                this.appendSql(".* ");
                SelectClause firstSelectClause = queryGroup.getFirstQuerySpec().getSelectClause();
                List<SqlSelection> sqlSelections = firstSelectClause.getSqlSelections();
                int sqlSelectionsSize = sqlSelections.size();
                SelectClause syntheticSelectClause = new SelectClause(sqlSelectionsSize);
                for (int i = 0; i < sqlSelectionsSize; ++i) {
                    syntheticSelectClause.addSqlSelection(new SqlSelectionImpl(i, new ColumnReference(queryGroupAlias, "c" + i, false, null, this.getIntegerType())));
                }
                this.renderRowNumberingSelectItems(syntheticSelectClause, queryPartForRowNumbering);
                this.appendSql(" from (");
            } else if (needsQueryGroupWrapper) {
                this.needsSelectAliases = true;
                queryGroupAlias = "grp_" + this.queryGroupAliasCounter + "_";
                ++this.queryGroupAliasCounter;
                this.appendSql("select ");
                this.appendSql(queryGroupAlias);
                this.appendSql(".* ");
                this.appendSql(" from (");
            }
            this.queryPartStack.push(queryGroup);
            List<QueryPart> queryParts = queryGroup.getQueryParts();
            String setOperatorString = " " + queryGroup.getSetOperator().sqlString() + " ";
            Object separator = "";
            for (int i = 0; i < queryParts.size(); ++i) {
                this.appendSql((String)separator);
                queryParts.get(i).accept(this);
                separator = setOperatorString;
            }
            if (renderOrderByAndOffsetFetchClause) {
                this.visitOrderBy(queryGroup.getSortSpecifications());
                this.visitOffsetFetchClause(queryGroup);
            }
            if (queryGroupAlias != null) {
                this.appendSql(") ");
                this.appendSql(queryGroupAlias);
                if (this.additionalWherePredicate != null && !this.additionalWherePredicate.isEmpty()) {
                    this.visitWhereClause(this.additionalWherePredicate);
                }
            }
            if (needsParenthesis) {
                this.appendSql(')');
            }
        }
        finally {
            this.queryPartStack.pop();
            this.queryPartForRowNumbering = queryPartForRowNumbering;
            this.queryPartForRowNumberingClauseDepth = queryPartForRowNumberingClauseDepth;
            this.needsSelectAliases = needsSelectAliases;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitQuerySpec(QuerySpec querySpec) {
        QueryPart queryPartForRowNumbering = this.queryPartForRowNumbering;
        int queryPartForRowNumberingClauseDepth = this.queryPartForRowNumberingClauseDepth;
        boolean needsSelectAliases = this.needsSelectAliases;
        Predicate additionalWherePredicate = this.additionalWherePredicate;
        ForUpdateClause forUpdate = this.forUpdate;
        try {
            this.additionalWherePredicate = null;
            this.forUpdate = null;
            QueryPart currentQueryPart = this.queryPartStack.getCurrent();
            if (currentQueryPart != null && (queryPartForRowNumbering instanceof QueryGroup || queryPartForRowNumberingClauseDepth != this.clauseStack.depth())) {
                this.queryPartForRowNumbering = null;
                this.queryPartForRowNumberingClauseDepth = -1;
            }
            Object queryGroupAlias = null;
            if (currentQueryPart instanceof QueryGroup && (querySpec.hasOffsetOrFetchClause() || querySpec.hasSortSpecifications())) {
                queryGroupAlias = "";
                if ((!this.supportsSimpleQueryGrouping() || currentQueryPart.hasOffsetOrFetchClause()) && queryPartForRowNumbering != querySpec) {
                    queryGroupAlias = " grp_" + this.queryGroupAliasCounter + "_";
                    ++this.queryGroupAliasCounter;
                    this.appendSql("select");
                    this.appendSql((String)queryGroupAlias);
                    this.appendSql(".* from ");
                    this.needsSelectAliases = this.needsSelectAliases || this.hasDuplicateSelectItems(querySpec);
                } else if (!this.supportsDuplicateSelectItemsInQueryGroup()) {
                    this.needsSelectAliases = this.needsSelectAliases || this.hasDuplicateSelectItems(querySpec);
                }
            }
            this.queryPartStack.push(querySpec);
            if (queryGroupAlias != null) {
                this.appendSql('(');
            }
            this.visitSelectClause(querySpec.getSelectClause());
            this.visitFromClause(querySpec.getFromClause());
            this.visitWhereClause(querySpec.getWhereClauseRestrictions());
            this.visitGroupByClause(querySpec, this.dialect.getGroupBySelectItemReferenceStrategy());
            this.visitHavingClause(querySpec);
            this.visitOrderBy(querySpec.getSortSpecifications());
            this.visitOffsetFetchClause(querySpec);
            if (queryPartForRowNumbering == null) {
                this.visitForUpdateClause(querySpec);
            }
            if (queryGroupAlias != null) {
                this.appendSql(')');
                this.appendSql((String)queryGroupAlias);
            }
        }
        finally {
            this.queryPartStack.pop();
            this.queryPartForRowNumbering = queryPartForRowNumbering;
            this.queryPartForRowNumberingClauseDepth = queryPartForRowNumberingClauseDepth;
            this.needsSelectAliases = needsSelectAliases;
            this.additionalWherePredicate = additionalWherePredicate;
            if (queryPartForRowNumbering == null) {
                this.forUpdate = forUpdate;
            }
        }
    }

    private boolean hasDuplicateSelectItems(QuerySpec querySpec) {
        List<SqlSelection> sqlSelections = querySpec.getSelectClause().getSqlSelections();
        IdentityHashMap<Expression, Boolean> map = new IdentityHashMap<Expression, Boolean>(sqlSelections.size());
        for (int i = 0; i < sqlSelections.size(); ++i) {
            if (map.put(sqlSelections.get(i).getExpression(), Boolean.TRUE) == null) continue;
            return true;
        }
        return false;
    }

    protected boolean supportsSimpleQueryGrouping() {
        return true;
    }

    protected boolean supportsDuplicateSelectItemsInQueryGroup() {
        return true;
    }

    protected final void visitWhereClause(Predicate whereClauseRestrictions) {
        Predicate additionalWherePredicate = this.additionalWherePredicate;
        if (whereClauseRestrictions != null && !whereClauseRestrictions.isEmpty() || additionalWherePredicate != null) {
            this.appendSql(" where ");
            this.clauseStack.push(Clause.WHERE);
            try {
                if (whereClauseRestrictions != null && !whereClauseRestrictions.isEmpty()) {
                    whereClauseRestrictions.accept(this);
                    if (additionalWherePredicate != null) {
                        this.appendSql(" and ");
                        this.additionalWherePredicate = null;
                        additionalWherePredicate.accept(this);
                    }
                } else if (additionalWherePredicate != null) {
                    this.additionalWherePredicate = null;
                    additionalWherePredicate.accept(this);
                }
            }
            finally {
                this.clauseStack.pop();
            }
        }
    }

    protected Expression resolveAliasedExpression(Expression expression) {
        if (this.queryPartStack.getCurrent() == null) {
            assert (expression instanceof SqlSelectionExpression);
            return ((SqlSelectionExpression)expression).getSelection().getExpression();
        }
        return this.resolveAliasedExpression(this.queryPartStack.getCurrent().getFirstQuerySpec().getSelectClause().getSqlSelections(), expression);
    }

    protected Expression resolveAliasedExpression(List<SqlSelection> sqlSelections, Expression expression) {
        if (expression instanceof Literal) {
            Object literalValue = ((Literal)expression).getLiteralValue();
            if (literalValue instanceof Integer) {
                return sqlSelections.get((Integer)literalValue).getExpression();
            }
        } else {
            Expression sqlExpression;
            if (expression instanceof SqlSelectionExpression) {
                return ((SqlSelectionExpression)expression).getSelection().getExpression();
            }
            if (expression instanceof SqmPathInterpretation && (sqlExpression = ((SqmPathInterpretation)expression).getSqlExpression()) instanceof SqlSelectionExpression) {
                return ((SqlSelectionExpression)sqlExpression).getSelection().getExpression();
            }
        }
        return expression;
    }

    protected Expression resolveExpressionToAlias(Expression expression) {
        Expression sqlExpression;
        int index = -1;
        if (expression instanceof SqlSelectionExpression) {
            index = ((SqlSelectionExpression)expression).getSelection().getValuesArrayPosition();
        } else if (expression instanceof SqmPathInterpretation && (sqlExpression = ((SqmPathInterpretation)expression).getSqlExpression()) instanceof SqlSelectionExpression) {
            index = ((SqlSelectionExpression)sqlExpression).getSelection().getValuesArrayPosition();
        }
        if (index == -1) {
            return expression;
        }
        return new ColumnReference((String)null, "c" + index, false, null, expression.getExpressionType().getSingleJdbcMapping());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void visitGroupByClause(QuerySpec querySpec, SelectItemReferenceStrategy referenceStrategy) {
        List<Expression> partitionExpressions = querySpec.getGroupByClauseExpressions();
        if (!partitionExpressions.isEmpty()) {
            try {
                this.clauseStack.push(Clause.GROUP);
                this.appendSql(" group by ");
                this.visitPartitionExpressions(partitionExpressions, referenceStrategy);
            }
            finally {
                this.clauseStack.pop();
            }
        }
    }

    protected final void visitPartitionByClause(List<Expression> partitionExpressions) {
        if (!partitionExpressions.isEmpty()) {
            try {
                this.clauseStack.push(Clause.PARTITION);
                this.appendSql("partition by ");
                this.visitPartitionExpressions(partitionExpressions, SelectItemReferenceStrategy.EXPRESSION);
            }
            finally {
                this.clauseStack.pop();
            }
        }
    }

    protected final void visitPartitionExpressions(List<Expression> partitionExpressions, SelectItemReferenceStrategy referenceStrategy) {
        boolean inlineParametersOfAliasedExpressions;
        Function<Expression, Expression> resolveAliasExpression;
        switch (referenceStrategy) {
            case POSITION: {
                resolveAliasExpression = Function.identity();
                inlineParametersOfAliasedExpressions = false;
                break;
            }
            case ALIAS: {
                resolveAliasExpression = this::resolveExpressionToAlias;
                inlineParametersOfAliasedExpressions = false;
                break;
            }
            default: {
                resolveAliasExpression = this::resolveAliasedExpression;
                inlineParametersOfAliasedExpressions = true;
            }
        }
        this.visitPartitionExpressions(partitionExpressions, resolveAliasExpression, inlineParametersOfAliasedExpressions);
    }

    protected final void visitPartitionExpressions(List<Expression> partitionExpressions, Function<Expression, Expression> resolveAliasExpression, boolean inlineParametersOfAliasedExpressions) {
        String separator = "";
        for (Expression partitionExpression : partitionExpressions) {
            SqlTuple sqlTuple = SqlTupleContainer.getSqlTuple(partitionExpression);
            if (sqlTuple != null) {
                for (Expression expression : sqlTuple.getExpressions()) {
                    this.appendSql(separator);
                    Expression resolved = resolveAliasExpression.apply(expression);
                    if (inlineParametersOfAliasedExpressions && resolved != expression) {
                        SqlAstNodeRenderingMode original = this.parameterRenderingMode;
                        this.parameterRenderingMode = SqlAstNodeRenderingMode.INLINE_ALL_PARAMETERS;
                        this.renderPartitionItem(resolved);
                        this.parameterRenderingMode = original;
                    } else {
                        this.renderPartitionItem(resolved);
                    }
                    separator = ",";
                }
            } else {
                this.appendSql(separator);
                Expression resolved = resolveAliasExpression.apply(partitionExpression);
                if (inlineParametersOfAliasedExpressions && resolved != partitionExpression) {
                    SqlAstNodeRenderingMode sqlAstNodeRenderingMode = this.parameterRenderingMode;
                    this.parameterRenderingMode = SqlAstNodeRenderingMode.INLINE_ALL_PARAMETERS;
                    this.renderPartitionItem(resolved);
                    this.parameterRenderingMode = sqlAstNodeRenderingMode;
                } else {
                    this.renderPartitionItem(resolved);
                }
            }
            separator = ",";
        }
    }

    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("()");
        } else if (expression instanceof Summarization) {
            Summarization summarization = (Summarization)expression;
            this.appendSql(summarization.getKind().sqlText());
            this.appendSql('(');
            this.renderCommaSeparated(summarization.getGroupings());
            this.appendSql(')');
        } else {
            expression.accept(this);
        }
    }

    protected final void visitHavingClause(QuerySpec querySpec) {
        Predicate havingClauseRestrictions = querySpec.getHavingClauseRestrictions();
        if (havingClauseRestrictions != null && !havingClauseRestrictions.isEmpty()) {
            this.appendSql(" having ");
            this.clauseStack.push(Clause.HAVING);
            try {
                havingClauseRestrictions.accept(this);
            }
            finally {
                this.clauseStack.pop();
            }
        }
    }

    protected void visitOrderBy(List<SortSpecification> sortSpecifications) {
        if (this.queryPartForRowNumbering == null) {
            this.renderOrderBy(true, sortSpecifications);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderOrderBy(boolean addWhitespace, List<SortSpecification> sortSpecifications) {
        if (sortSpecifications != null && !sortSpecifications.isEmpty()) {
            if (addWhitespace) {
                this.appendSql(' ');
            }
            this.appendSql("order by ");
            this.clauseStack.push(Clause.ORDER);
            try {
                String separator = "";
                for (SortSpecification sortSpecification : sortSpecifications) {
                    this.appendSql(separator);
                    this.visitSortSpecification(sortSpecification);
                    separator = ",";
                }
            }
            finally {
                this.clauseStack.pop();
            }
        }
    }

    protected void emulateSelectTupleComparison(List<SqlSelection> lhsSelections, List<? extends SqlAstNode> rhsExpressions, ComparisonOperator operator, boolean indexOptimized) {
        List<SqlAstNode> lhsExpressions;
        if (lhsSelections.size() == rhsExpressions.size()) {
            lhsExpressions = lhsSelections;
        } else if (lhsSelections.size() == 1) {
            lhsExpressions = SqlTupleContainer.getSqlTuple(lhsSelections.get(0).getExpression()).getExpressions();
        } else {
            ArrayList<SqlSelection> list = new ArrayList<SqlSelection>(rhsExpressions.size());
            for (SqlSelection lhsSelection : lhsSelections) {
                list.addAll(SqlTupleContainer.getSqlTuple(lhsSelection.getExpression()).getExpressions());
            }
            lhsExpressions = list;
        }
        this.emulateTupleComparison(lhsExpressions, rhsExpressions, operator, indexOptimized);
    }

    protected void emulateTupleComparison(List<? extends SqlAstNode> lhsExpressions, List<? extends SqlAstNode> rhsExpressions, ComparisonOperator operator, boolean indexOptimized) {
        boolean isCurrentWhereClause;
        boolean bl = isCurrentWhereClause = this.clauseStack.getCurrent() == Clause.WHERE;
        if (isCurrentWhereClause) {
            this.appendSql('(');
        }
        int size = lhsExpressions.size();
        assert (size == rhsExpressions.size());
        switch (operator) {
            case DISTINCT_FROM: {
                this.appendSql("not ");
            }
            case NOT_DISTINCT_FROM: {
                if (this.supportsIntersect()) {
                    this.appendSql("exists (select ");
                    this.renderCommaSeparatedSelectExpression(lhsExpressions);
                    this.appendSql(this.getFromDualForSelectOnly());
                    this.appendSql(" intersect select ");
                    this.renderCommaSeparatedSelectExpression(rhsExpressions);
                    this.appendSql(this.getFromDualForSelectOnly());
                    this.appendSql(')');
                    break;
                }
                this.appendSql("exists (select 1 from ");
                this.appendSql(this.getDual());
                this.appendSql(" d_ where (");
                String separator = "";
                for (int i = 0; i < size; ++i) {
                    this.appendSql(separator);
                    lhsExpressions.get(i).accept(this);
                    this.appendSql('=');
                    rhsExpressions.get(i).accept(this);
                    this.appendSql(" or ");
                    lhsExpressions.get(i).accept(this);
                    this.appendSql(" is null and ");
                    rhsExpressions.get(i).accept(this);
                    this.appendSql(" is null");
                    separator = ") and (";
                }
                this.appendSql("))");
                break;
            }
            case EQUAL: {
                String operatorText = operator.sqlText();
                String separator = "";
                for (int i = 0; i < size; ++i) {
                    this.appendSql(separator);
                    lhsExpressions.get(i).accept(this);
                    this.appendSql(operatorText);
                    rhsExpressions.get(i).accept(this);
                    separator = " and ";
                }
                break;
            }
            case NOT_EQUAL: {
                String operatorText = operator.sqlText();
                String separator = "";
                for (int i = 0; i < size; ++i) {
                    this.appendSql(separator);
                    lhsExpressions.get(i).accept(this);
                    this.appendSql(operatorText);
                    rhsExpressions.get(i).accept(this);
                    separator = " or ";
                }
                break;
            }
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: 
            case GREATER_THAN: {
                if (indexOptimized) {
                    lhsExpressions.get(0).accept(this);
                    this.appendSql(operator.broader().sqlText());
                    rhsExpressions.get(0).accept(this);
                    this.appendSql(" and not ");
                    String negatedOperatorText = operator.negated().sqlText();
                    this.emulateTupleComparisonSimple(lhsExpressions, rhsExpressions, negatedOperatorText, negatedOperatorText, true);
                    break;
                }
                this.emulateTupleComparisonSimple(lhsExpressions, rhsExpressions, operator.sharper().sqlText(), operator.sqlText(), false);
            }
        }
        if (isCurrentWhereClause) {
            this.appendSql(')');
        }
    }

    protected boolean supportsIntersect() {
        return true;
    }

    protected boolean supportsNestedSubqueryCorrelation() {
        return true;
    }

    protected void renderExpressionsAsSubquery(List<? extends Expression> expressions) {
        this.clauseStack.push(Clause.SELECT);
        try {
            this.appendSql("select ");
            this.renderCommaSeparatedSelectExpression(expressions);
            this.appendSql(this.getFromDualForSelectOnly());
        }
        finally {
            this.clauseStack.pop();
        }
    }

    private void emulateTupleComparisonSimple(List<? extends SqlAstNode> lhsExpressions, List<? extends SqlAstNode> rhsExpressions, String operatorText, String finalOperatorText, boolean optimized) {
        int i;
        int size = lhsExpressions.size();
        int lastIndex = size - 1;
        this.appendSql('(');
        String separator = "";
        if (optimized) {
            i = 1;
        } else {
            lhsExpressions.get(0).accept(this);
            this.appendSql(operatorText);
            rhsExpressions.get(0).accept(this);
            separator = " or ";
            i = 1;
        }
        while (i < lastIndex) {
            this.appendSql(separator);
            lhsExpressions.get(i - 1).accept(this);
            this.appendSql('=');
            rhsExpressions.get(i - 1).accept(this);
            this.appendSql(" and (");
            lhsExpressions.get(i).accept(this);
            this.appendSql(operatorText);
            rhsExpressions.get(i).accept(this);
            separator = " or ";
            ++i;
        }
        this.appendSql(separator);
        lhsExpressions.get(lastIndex - 1).accept(this);
        this.appendSql('=');
        rhsExpressions.get(lastIndex - 1).accept(this);
        this.appendSql(" and ");
        lhsExpressions.get(lastIndex).accept(this);
        this.appendSql(finalOperatorText);
        rhsExpressions.get(lastIndex).accept(this);
        int n = i = optimized ? 1 : 0;
        while (i < lastIndex + 1) {
            this.appendSql(')');
            ++i;
        }
    }

    protected void renderSelectSimpleComparison(List<SqlSelection> lhsExpressions, Expression expression, ComparisonOperator operator) {
        this.renderComparison(lhsExpressions.get(0).getExpression(), operator, expression);
    }

    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.renderTupleComparisonStandard(lhsExpressions, tuple, operator);
    }

    protected void renderTupleComparisonStandard(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.appendSql('(');
        String separator = "";
        for (SqlSelection lhsExpression : lhsExpressions) {
            this.appendSql(separator);
            lhsExpression.getExpression().accept(this);
            separator = ",";
        }
        this.appendSql(')');
        this.appendSql(operator.sqlText());
        tuple.accept(this);
    }

    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        this.renderComparisonStandard(lhs, operator, rhs);
    }

    protected void renderComparisonStandard(Expression lhs, ComparisonOperator operator, Expression rhs) {
        lhs.accept(this);
        this.appendSql(operator.sqlText());
        rhs.accept(this);
    }

    protected void renderComparisonDistinctOperator(Expression lhs, ComparisonOperator operator, Expression rhs) {
        String operatorText;
        boolean notWrapper;
        switch (operator) {
            case DISTINCT_FROM: {
                notWrapper = true;
                operatorText = "<=>";
                break;
            }
            case NOT_DISTINCT_FROM: {
                notWrapper = false;
                operatorText = "<=>";
                break;
            }
            default: {
                notWrapper = false;
                operatorText = operator.sqlText();
            }
        }
        if (notWrapper) {
            this.appendSql("not(");
        }
        lhs.accept(this);
        this.appendSql(operatorText);
        rhs.accept(this);
        if (notWrapper) {
            this.appendSql(')');
        }
    }

    protected void renderComparisonEmulateDecode(Expression lhs, ComparisonOperator operator, Expression rhs) {
        this.renderComparisonEmulateDecode(lhs, operator, rhs, SqlAstNodeRenderingMode.DEFAULT);
    }

    protected void renderComparisonEmulateDecode(Expression lhs, ComparisonOperator operator, Expression rhs, SqlAstNodeRenderingMode firstArgRenderingMode) {
        switch (operator) {
            case DISTINCT_FROM: {
                this.appendSql("decode(");
                this.render(lhs, firstArgRenderingMode);
                this.appendSql(',');
                rhs.accept(this);
                this.appendSql(",0,1)=1");
                break;
            }
            case NOT_DISTINCT_FROM: {
                this.appendSql("decode(");
                this.render(lhs, firstArgRenderingMode);
                this.appendSql(',');
                rhs.accept(this);
                this.appendSql(",0,1)=0");
                break;
            }
            default: {
                lhs.accept(this);
                this.appendSql(operator.sqlText());
                rhs.accept(this);
            }
        }
    }

    protected void renderComparisonEmulateCase(Expression lhs, ComparisonOperator operator, Expression rhs) {
        switch (operator) {
            case DISTINCT_FROM: {
                this.appendSql("case when ");
                lhs.accept(this);
                this.appendSql('=');
                rhs.accept(this);
                this.appendSql(" or ");
                lhs.accept(this);
                this.appendSql(" is null and ");
                rhs.accept(this);
                this.appendSql(" is null then 0 else 1 end=1");
                break;
            }
            case NOT_DISTINCT_FROM: {
                this.appendSql("case when ");
                lhs.accept(this);
                this.appendSql('=');
                rhs.accept(this);
                this.appendSql(" or ");
                lhs.accept(this);
                this.appendSql(" is null and ");
                rhs.accept(this);
                this.appendSql(" is null then 0 else 1 end=0");
                break;
            }
            default: {
                lhs.accept(this);
                this.appendSql(operator.sqlText());
                rhs.accept(this);
            }
        }
    }

    protected void renderComparisonEmulateIntersect(Expression lhs, ComparisonOperator operator, Expression rhs) {
        switch (operator) {
            case DISTINCT_FROM: {
                this.appendSql("not ");
            }
            case NOT_DISTINCT_FROM: {
                this.appendSql("exists (select ");
                this.clauseStack.push(Clause.SELECT);
                this.visitSqlSelectExpression(lhs);
                this.appendSql(this.getFromDualForSelectOnly());
                this.appendSql(" intersect select ");
                this.visitSqlSelectExpression(rhs);
                this.appendSql(this.getFromDualForSelectOnly());
                this.clauseStack.pop();
                this.appendSql(')');
                return;
            }
        }
        lhs.accept(this);
        this.appendSql(operator.sqlText());
        rhs.accept(this);
    }

    @Override
    public void visitSortSpecification(SortSpecification sortSpecification) {
        Expression sortExpression = sortSpecification.getSortExpression();
        NullPrecedence nullPrecedence = sortSpecification.getNullPrecedence();
        SortDirection sortOrder = sortSpecification.getSortOrder();
        boolean ignoreCase = sortSpecification.isIgnoreCase();
        SqlTuple sqlTuple = SqlTupleContainer.getSqlTuple(sortExpression);
        if (sqlTuple != null) {
            String separator = "";
            for (Expression expression : sqlTuple.getExpressions()) {
                this.appendSql(separator);
                this.visitSortSpecification(expression, sortOrder, nullPrecedence, ignoreCase);
                separator = ",";
            }
        } else {
            this.visitSortSpecification(sortExpression, sortOrder, nullPrecedence, ignoreCase);
        }
    }

    protected void visitSortSpecification(Expression sortExpression, SortDirection sortOrder, NullPrecedence nullPrecedence, boolean ignoreCase) {
        boolean supportsNullPrecedence;
        if (nullPrecedence == null || nullPrecedence == NullPrecedence.NONE) {
            nullPrecedence = this.sessionFactory.getSessionFactoryOptions().getDefaultNullPrecedence();
        }
        boolean renderNullPrecedence = nullPrecedence != null && !nullPrecedence.isDefaultOrdering(sortOrder, this.dialect.getNullOrdering());
        boolean bl = supportsNullPrecedence = renderNullPrecedence && this.supportsNullPrecedence();
        if (renderNullPrecedence && !supportsNullPrecedence) {
            this.emulateSortSpecificationNullPrecedence(sortExpression, nullPrecedence);
        }
        this.renderSortExpression(sortExpression, ignoreCase);
        if (sortOrder == SortDirection.DESCENDING) {
            this.appendSql(" desc");
        } else if (sortOrder == SortDirection.ASCENDING && renderNullPrecedence && supportsNullPrecedence) {
            this.appendSql(" asc");
        }
        if (renderNullPrecedence && supportsNullPrecedence) {
            this.appendSql(" nulls ");
            this.appendSql(nullPrecedence == NullPrecedence.LAST ? "last" : "first");
        }
    }

    protected void renderSortExpression(Expression sortExpression, boolean ignoreCase) {
        if (ignoreCase) {
            this.appendSql(this.dialect.getLowercaseFunction());
            this.appendSql('(');
        }
        if (this.inOverOrWithinGroupClause() || ignoreCase) {
            this.resolveAliasedExpression(sortExpression).accept(this);
        } else {
            sortExpression.accept(this);
        }
        if (ignoreCase) {
            this.appendSql(')');
        }
    }

    protected boolean supportsNullPrecedence() {
        return this.dialect.supportsNullPrecedence();
    }

    protected void emulateSortSpecificationNullPrecedence(Expression sortExpression, NullPrecedence nullPrecedence) {
        this.appendSql("case when (");
        this.resolveAliasedExpression(sortExpression).accept(this);
        this.appendSql(") is null then ");
        if (nullPrecedence == NullPrecedence.FIRST) {
            this.appendSql("0 else 1");
        } else {
            this.appendSql("1 else 0");
        }
        this.appendSql(" end");
        this.appendSql(',');
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!this.isRowNumberingCurrentQueryPart()) {
            this.renderOffsetFetchClause(queryPart, true);
        }
    }

    protected void renderOffsetFetchClause(QueryPart queryPart, boolean renderOffsetRowsKeyword) {
        if (queryPart.isRoot() && this.hasLimit()) {
            this.prepareLimitOffsetParameters();
            this.renderOffsetFetchClause(this.getOffsetParameter(), this.getLimitParameter(), FetchClauseType.ROWS_ONLY, renderOffsetRowsKeyword);
        } else {
            this.renderOffsetFetchClause(queryPart.getOffsetClauseExpression(), queryPart.getFetchClauseExpression(), queryPart.getFetchClauseType(), renderOffsetRowsKeyword);
        }
    }

    protected void renderOffsetFetchClause(Expression offsetExpression, Expression fetchExpression, FetchClauseType fetchClauseType, boolean renderOffsetRowsKeyword) {
        if (offsetExpression != null) {
            this.renderOffset(offsetExpression, renderOffsetRowsKeyword);
        }
        if (fetchExpression != null) {
            this.renderFetch(fetchExpression, null, fetchClauseType);
        }
    }

    protected void renderOffset(Expression offsetExpression, boolean renderOffsetRowsKeyword) {
        this.appendSql(" offset ");
        this.clauseStack.push(Clause.OFFSET);
        try {
            this.renderOffsetExpression(offsetExpression);
        }
        finally {
            this.clauseStack.pop();
        }
        if (renderOffsetRowsKeyword) {
            this.appendSql(" rows");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderFetch(Expression fetchExpression, Expression offsetExpressionToAdd, FetchClauseType fetchClauseType) {
        this.appendSql(" fetch first ");
        this.clauseStack.push(Clause.FETCH);
        try {
            if (offsetExpressionToAdd == null) {
                this.renderFetchExpression(fetchExpression);
            } else {
                this.renderFetchPlusOffsetExpression(fetchExpression, offsetExpressionToAdd, 0);
            }
        }
        finally {
            this.clauseStack.pop();
        }
        switch (fetchClauseType) {
            case ROWS_ONLY: {
                this.appendSql(" rows only");
                break;
            }
            case ROWS_WITH_TIES: {
                this.appendSql(" rows with ties");
                break;
            }
            case PERCENT_ONLY: {
                this.appendSql(" percent rows only");
                break;
            }
            case PERCENT_WITH_TIES: {
                this.appendSql(" percent rows with ties");
            }
        }
    }

    protected void renderOffsetExpression(Expression offsetExpression) {
        offsetExpression.accept(this);
    }

    protected void renderFetchExpression(Expression fetchExpression) {
        fetchExpression.accept(this);
    }

    protected void renderTopClause(QuerySpec querySpec, boolean addOffset, boolean needsParenthesis) {
        if (querySpec.isRoot() && this.hasLimit()) {
            this.prepareLimitOffsetParameters();
            this.renderTopClause(this.getOffsetParameter(), this.getLimitParameter(), FetchClauseType.ROWS_ONLY, addOffset, needsParenthesis);
        } else {
            this.renderTopClause(querySpec.getOffsetClauseExpression(), querySpec.getFetchClauseExpression(), querySpec.getFetchClauseType(), addOffset, needsParenthesis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderTopClause(Expression offsetExpression, Expression fetchExpression, FetchClauseType fetchClauseType, boolean addOffset, boolean needsParenthesis) {
        if (fetchExpression != null) {
            this.appendSql("top ");
            if (needsParenthesis) {
                this.appendSql('(');
            }
            Stack<Clause> clauseStack = this.getClauseStack();
            clauseStack.push(Clause.FETCH);
            try {
                if (addOffset && offsetExpression != null) {
                    this.renderFetchPlusOffsetExpression(fetchExpression, offsetExpression, 0);
                } else {
                    this.renderFetchExpression(fetchExpression);
                }
            }
            finally {
                clauseStack.pop();
            }
            if (needsParenthesis) {
                this.appendSql(')');
            }
            this.appendSql(' ');
            switch (fetchClauseType) {
                case ROWS_WITH_TIES: {
                    this.appendSql("with ties ");
                    break;
                }
                case PERCENT_ONLY: {
                    this.appendSql("percent ");
                    break;
                }
                case PERCENT_WITH_TIES: {
                    this.appendSql("percent with ties ");
                }
            }
        }
    }

    protected void renderTopStartAtClause(QuerySpec querySpec) {
        if (querySpec.isRoot() && this.hasLimit()) {
            this.prepareLimitOffsetParameters();
            this.renderTopStartAtClause(this.getOffsetParameter(), this.getLimitParameter(), FetchClauseType.ROWS_ONLY);
        } else {
            this.renderTopStartAtClause(querySpec.getOffsetClauseExpression(), querySpec.getFetchClauseExpression(), querySpec.getFetchClauseType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderTopStartAtClause(Expression offsetExpression, Expression fetchExpression, FetchClauseType fetchClauseType) {
        if (fetchExpression != null) {
            this.appendSql("top ");
            Stack<Clause> clauseStack = this.getClauseStack();
            clauseStack.push(Clause.FETCH);
            try {
                this.renderFetchExpression(fetchExpression);
            }
            finally {
                clauseStack.pop();
            }
            if (offsetExpression != null) {
                clauseStack.push(Clause.OFFSET);
                try {
                    this.appendSql(" start at ");
                    this.renderOffsetExpression(offsetExpression);
                }
                finally {
                    clauseStack.pop();
                }
            }
            this.appendSql(' ');
            switch (fetchClauseType) {
                case ROWS_WITH_TIES: {
                    this.appendSql("with ties ");
                    break;
                }
                case PERCENT_ONLY: {
                    this.appendSql("percent ");
                    break;
                }
                case PERCENT_WITH_TIES: {
                    this.appendSql("percent with ties ");
                }
            }
        }
    }

    protected void renderRowsToClause(QuerySpec querySpec) {
        if (querySpec.isRoot() && this.hasLimit()) {
            this.prepareLimitOffsetParameters();
            this.renderRowsToClause(this.getOffsetParameter(), this.getLimitParameter());
        } else {
            this.assertRowsOnlyFetchClauseType(querySpec);
            this.renderRowsToClause(querySpec.getOffsetClauseExpression(), querySpec.getFetchClauseExpression());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderRowsToClause(Expression offsetClauseExpression, Expression fetchClauseExpression) {
        if (fetchClauseExpression != null) {
            this.appendSql("rows ");
            Stack<Clause> clauseStack = this.getClauseStack();
            clauseStack.push(Clause.FETCH);
            try {
                this.renderFetchExpression(fetchClauseExpression);
            }
            finally {
                clauseStack.pop();
            }
            if (offsetClauseExpression != null) {
                clauseStack.push(Clause.OFFSET);
                try {
                    this.appendSql(" to ");
                    this.renderFetchPlusOffsetExpression(fetchClauseExpression, offsetClauseExpression, 1);
                }
                finally {
                    clauseStack.pop();
                }
            }
            this.appendSql(' ');
        }
    }

    protected void renderFetchPlusOffsetExpression(Expression fetchClauseExpression, Expression offsetClauseExpression, int offset) {
        this.renderFetchExpression(fetchClauseExpression);
        this.appendSql('+');
        this.renderOffsetExpression(offsetClauseExpression);
        if (offset != 0) {
            this.appendSql('+');
            this.appendSql(offset);
        }
    }

    protected void renderFetchPlusOffsetExpressionAsLiteral(Expression fetchClauseExpression, Expression offsetClauseExpression, int offset) {
        Number offsetCount = (Number)this.interpretExpression(offsetClauseExpression, this.jdbcParameterBindings);
        Number fetchCount = (Number)this.interpretExpression(fetchClauseExpression, this.jdbcParameterBindings);
        this.appendSql(fetchCount.intValue() + offsetCount.intValue() + offset);
    }

    protected void renderFetchPlusOffsetExpressionAsSingleParameter(Expression fetchClauseExpression, Expression offsetClauseExpression, int offset) {
        if (fetchClauseExpression instanceof Literal) {
            Number fetchCount = (Number)((Literal)fetchClauseExpression).getLiteralValue();
            if (offsetClauseExpression instanceof Literal) {
                Number offsetCount = (Number)((Literal)offsetClauseExpression).getLiteralValue();
                this.appendSql(fetchCount.intValue() + offsetCount.intValue() + offset);
            } else {
                this.appendSql('?');
                JdbcParameter offsetParameter = (JdbcParameter)offsetClauseExpression;
                int offsetValue = offset + fetchCount.intValue();
                this.jdbcParameters.addParameter(offsetParameter);
                this.parameterBinders.add((statement, startPosition, jdbcParameterBindings, executionContext) -> {
                    JdbcParameterBinding binding = jdbcParameterBindings.getBinding(offsetParameter);
                    if (binding == null) {
                        throw new ExecutionException("JDBC parameter value not bound - " + String.valueOf(offsetParameter));
                    }
                    Number bindValue = (Number)binding.getBindValue();
                    offsetParameter.getExpressionType().getSingleJdbcMapping().getJdbcValueBinder().bind(statement, Integer.valueOf(bindValue.intValue() + offsetValue), startPosition, (WrapperOptions)executionContext.getSession());
                });
            }
        } else {
            this.appendSql('?');
            JdbcParameter offsetParameter = (JdbcParameter)offsetClauseExpression;
            JdbcParameter fetchParameter = (JdbcParameter)fetchClauseExpression;
            OffsetReceivingParameterBinder fetchBinder = new OffsetReceivingParameterBinder(offsetParameter, fetchParameter, offset);
            if (!(offsetParameter instanceof OffsetJdbcParameter)) {
                this.jdbcParameters.addParameter(offsetParameter);
                this.parameterBinders.add((statement, startPosition, jdbcParameterBindings, executionContext) -> {
                    JdbcParameterBinding binding = jdbcParameterBindings.getBinding(offsetParameter);
                    if (binding == null) {
                        throw new ExecutionException("JDBC parameter value not bound - " + String.valueOf(offsetParameter));
                    }
                    fetchBinder.dynamicOffset = (Number)binding.getBindValue();
                });
            }
            this.jdbcParameters.addParameter(fetchParameter);
            this.parameterBinders.add(fetchBinder);
        }
    }

    protected void renderFirstSkipClause(QuerySpec querySpec) {
        if (querySpec.isRoot() && this.hasLimit()) {
            this.prepareLimitOffsetParameters();
            this.renderFirstSkipClause(this.getOffsetParameter(), this.getLimitParameter());
        } else {
            this.assertRowsOnlyFetchClauseType(querySpec);
            this.renderFirstSkipClause(querySpec.getOffsetClauseExpression(), querySpec.getFetchClauseExpression());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderFirstSkipClause(Expression offsetExpression, Expression fetchExpression) {
        Stack<Clause> clauseStack = this.getClauseStack();
        if (fetchExpression != null) {
            this.appendSql("first ");
            clauseStack.push(Clause.FETCH);
            try {
                this.renderFetchExpression(fetchExpression);
            }
            finally {
                clauseStack.pop();
            }
            this.appendSql(' ');
        }
        if (offsetExpression != null) {
            this.appendSql("skip ");
            clauseStack.push(Clause.OFFSET);
            try {
                this.renderOffsetExpression(offsetExpression);
            }
            finally {
                clauseStack.pop();
            }
            this.appendSql(' ');
        }
    }

    protected void renderSkipFirstClause(QuerySpec querySpec) {
        if (querySpec.isRoot() && this.hasLimit()) {
            this.prepareLimitOffsetParameters();
            this.renderSkipFirstClause(this.getOffsetParameter(), this.getLimitParameter());
        } else {
            this.assertRowsOnlyFetchClauseType(querySpec);
            this.renderSkipFirstClause(querySpec.getOffsetClauseExpression(), querySpec.getFetchClauseExpression());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderSkipFirstClause(Expression offsetExpression, Expression fetchExpression) {
        Stack<Clause> clauseStack = this.getClauseStack();
        if (offsetExpression != null) {
            this.appendSql("skip ");
            clauseStack.push(Clause.OFFSET);
            try {
                this.renderOffsetExpression(offsetExpression);
            }
            finally {
                clauseStack.pop();
            }
            this.appendSql(' ');
        }
        if (fetchExpression != null) {
            this.appendSql("first ");
            clauseStack.push(Clause.FETCH);
            try {
                this.renderFetchExpression(fetchExpression);
            }
            finally {
                clauseStack.pop();
            }
            this.appendSql(' ');
        }
    }

    protected void renderFirstClause(QuerySpec querySpec) {
        if (querySpec.isRoot() && this.hasLimit()) {
            this.prepareLimitOffsetParameters();
            this.renderFirstClause(this.getOffsetParameter(), this.getLimitParameter());
        } else {
            this.assertRowsOnlyFetchClauseType(querySpec);
            this.renderFirstClause(querySpec.getOffsetClauseExpression(), querySpec.getFetchClauseExpression());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderFirstClause(Expression offsetExpression, Expression fetchExpression) {
        Stack<Clause> clauseStack = this.getClauseStack();
        if (fetchExpression != null) {
            this.appendSql("first ");
            clauseStack.push(Clause.FETCH);
            try {
                this.renderFetchPlusOffsetExpression(fetchExpression, offsetExpression, 0);
            }
            finally {
                clauseStack.pop();
            }
            this.appendSql(' ');
        }
    }

    protected void renderCombinedLimitClause(QueryPart queryPart) {
        if (queryPart.isRoot() && this.hasLimit()) {
            this.prepareLimitOffsetParameters();
            this.renderCombinedLimitClause(this.getOffsetParameter(), this.getLimitParameter());
        } else {
            this.assertRowsOnlyFetchClauseType(queryPart);
            this.renderCombinedLimitClause(queryPart.getOffsetClauseExpression(), queryPart.getFetchClauseExpression());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderCombinedLimitClause(Expression offsetExpression, Expression fetchExpression) {
        if (offsetExpression != null) {
            Stack<Clause> clauseStack = this.getClauseStack();
            this.appendSql(" limit ");
            clauseStack.push(Clause.OFFSET);
            try {
                this.renderOffsetExpression(offsetExpression);
            }
            finally {
                clauseStack.pop();
            }
            this.appendSql(',');
            if (fetchExpression != null) {
                clauseStack.push(Clause.FETCH);
                try {
                    this.renderFetchExpression(fetchExpression);
                }
                finally {
                    clauseStack.pop();
                }
            } else {
                this.appendSql(Integer.MAX_VALUE);
            }
        } else if (fetchExpression != null) {
            Stack<Clause> clauseStack = this.getClauseStack();
            this.appendSql(" limit ");
            clauseStack.push(Clause.FETCH);
            try {
                this.renderFetchExpression(fetchExpression);
            }
            finally {
                clauseStack.pop();
            }
        }
    }

    protected void renderLimitOffsetClause(QueryPart queryPart) {
        if (queryPart.isRoot() && this.hasLimit()) {
            this.prepareLimitOffsetParameters();
            this.renderLimitOffsetClause(this.getOffsetParameter(), this.getLimitParameter());
        } else {
            this.assertRowsOnlyFetchClauseType(queryPart);
            this.renderLimitOffsetClause(queryPart.getOffsetClauseExpression(), queryPart.getFetchClauseExpression());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderLimitOffsetClause(Expression offsetExpression, Expression fetchExpression) {
        if (fetchExpression != null) {
            this.appendSql(" limit ");
            this.clauseStack.push(Clause.FETCH);
            try {
                this.renderFetchExpression(fetchExpression);
            }
            finally {
                this.clauseStack.pop();
            }
        } else if (offsetExpression != null) {
            this.appendSql(" limit ");
            this.appendSql(Integer.MAX_VALUE);
        }
        if (offsetExpression != null) {
            Stack<Clause> clauseStack = this.getClauseStack();
            this.appendSql(" offset ");
            clauseStack.push(Clause.OFFSET);
            try {
                this.renderOffsetExpression(offsetExpression);
            }
            finally {
                clauseStack.pop();
            }
        }
    }

    protected void assertRowsOnlyFetchClauseType(QueryPart queryPart) {
        FetchClauseType fetchClauseType;
        if (!(queryPart.isRoot() && this.hasLimit() || (fetchClauseType = queryPart.getFetchClauseType()) == null || fetchClauseType == FetchClauseType.ROWS_ONLY)) {
            throw new IllegalArgumentException("Can't emulate fetch clause type: " + String.valueOf((Object)fetchClauseType));
        }
    }

    protected QueryPart getQueryPartForRowNumbering() {
        return this.queryPartForRowNumbering;
    }

    protected boolean isRowNumberingCurrentQueryPart() {
        return this.queryPartForRowNumbering != null;
    }

    protected void emulateFetchOffsetWithWindowFunctions(QueryPart queryPart, boolean emulateFetchClause) {
        if (queryPart.isRoot() && this.hasLimit()) {
            this.prepareLimitOffsetParameters();
            this.emulateFetchOffsetWithWindowFunctions(queryPart, this.getOffsetParameter(), this.getLimitParameter(), FetchClauseType.ROWS_ONLY, emulateFetchClause);
        } else {
            this.emulateFetchOffsetWithWindowFunctions(queryPart, queryPart.getOffsetClauseExpression(), queryPart.getFetchClauseExpression(), queryPart.getFetchClauseType(), emulateFetchClause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void emulateFetchOffsetWithWindowFunctions(QueryPart queryPart, Expression offsetExpression, Expression fetchExpression, FetchClauseType fetchClauseType, boolean emulateFetchClause) {
        QueryPart queryPartForRowNumbering = this.queryPartForRowNumbering;
        int queryPartForRowNumberingClauseDepth = this.queryPartForRowNumberingClauseDepth;
        boolean needsSelectAliases = this.needsSelectAliases;
        try {
            boolean needsParenthesis;
            this.queryPartForRowNumbering = queryPart;
            this.queryPartForRowNumberingClauseDepth = this.clauseStack.depth();
            this.needsSelectAliases = true;
            String alias = "r_" + this.queryPartForRowNumberingAliasCounter + "_";
            ++this.queryPartForRowNumberingAliasCounter;
            boolean bl = needsParenthesis = queryPart instanceof QueryGroup && queryPart.hasOffsetOrFetchClause() && !queryPart.isRoot();
            if (needsParenthesis) {
                this.appendSql('(');
            }
            this.appendSql("select ");
            if (this.getClauseStack().isEmpty() && !(this.getStatement() instanceof InsertSelectStatement) && !(this.getCurrentQueryPart() instanceof QueryGroup)) {
                this.appendSql('*');
            } else if (this.columnAliases != null) {
                String separator = "";
                for (String columnAlias : this.columnAliases) {
                    this.appendSql(separator);
                    this.appendSql(alias);
                    this.appendSql('.');
                    this.appendSql(columnAlias);
                    separator = ",";
                }
            } else {
                int size = 0;
                for (SqlSelection sqlSelection : queryPart.getFirstQuerySpec().getSelectClause().getSqlSelections()) {
                    size += sqlSelection.getExpressionType().getJdbcTypeCount();
                }
                String separator = "";
                for (int i = 0; i < size; ++i) {
                    this.appendSql(separator);
                    this.appendSql(alias);
                    this.appendSql(".c");
                    this.appendSql(i);
                    separator = ",";
                }
            }
            this.appendSql(" from ");
            this.emulateFetchOffsetWithWindowFunctionsVisitQueryPart(queryPart);
            this.appendSql(' ');
            this.appendSql(alias);
            this.appendSql(" where ");
            Stack<Clause> clauseStack = this.getClauseStack();
            clauseStack.push(Clause.WHERE);
            try {
                Predicate additionalWherePredicate;
                if (emulateFetchClause && fetchExpression != null) {
                    switch (fetchClauseType) {
                        case PERCENT_ONLY: {
                            this.appendSql(alias);
                            this.appendSql(".rn<=");
                            if (offsetExpression != null) {
                                offsetExpression.accept(this);
                                this.appendSql('+');
                            }
                            this.appendSql("ceil(");
                            this.appendSql(alias);
                            this.appendSql(".cnt*");
                            fetchExpression.accept(this);
                            this.appendSql("/100)");
                            break;
                        }
                        case ROWS_ONLY: {
                            this.appendSql(alias);
                            this.appendSql(".rn<=");
                            if (offsetExpression != null) {
                                offsetExpression.accept(this);
                                this.appendSql('+');
                            }
                            fetchExpression.accept(this);
                            break;
                        }
                        case PERCENT_WITH_TIES: {
                            this.appendSql(alias);
                            this.appendSql(".rnk<=");
                            if (offsetExpression != null) {
                                offsetExpression.accept(this);
                                this.appendSql('+');
                            }
                            this.appendSql("ceil(");
                            this.appendSql(alias);
                            this.appendSql(".cnt*");
                            fetchExpression.accept(this);
                            this.appendSql("/100)");
                            break;
                        }
                        case ROWS_WITH_TIES: {
                            this.appendSql(alias);
                            this.appendSql(".rnk<=");
                            if (offsetExpression != null) {
                                offsetExpression.accept(this);
                                this.appendSql('+');
                            }
                            fetchExpression.accept(this);
                        }
                    }
                }
                if (offsetExpression == null) {
                    additionalWherePredicate = this.additionalWherePredicate;
                    if (additionalWherePredicate != null && !additionalWherePredicate.isEmpty()) {
                        this.additionalWherePredicate = null;
                        this.appendSql(" and ");
                        additionalWherePredicate.accept(this);
                    }
                    if (queryPart.isRoot()) {
                        switch (fetchClauseType) {
                            case ROWS_ONLY: 
                            case PERCENT_ONLY: {
                                this.appendSql(" order by ");
                                this.appendSql(alias);
                                this.appendSql(".rn");
                                break;
                            }
                            case ROWS_WITH_TIES: 
                            case PERCENT_WITH_TIES: {
                                this.appendSql(" order by ");
                                this.appendSql(alias);
                                this.appendSql(".rnk");
                            }
                        }
                    }
                } else {
                    if (emulateFetchClause && fetchExpression != null) {
                        this.appendSql(" and ");
                    }
                    this.appendSql(alias);
                    this.appendSql(".rn>");
                    offsetExpression.accept(this);
                    additionalWherePredicate = this.additionalWherePredicate;
                    if (additionalWherePredicate != null && !additionalWherePredicate.isEmpty()) {
                        this.additionalWherePredicate = null;
                        this.appendSql(" and ");
                        additionalWherePredicate.accept(this);
                    }
                    if (queryPart.isRoot()) {
                        this.appendSql(" order by ");
                        this.appendSql(alias);
                        this.appendSql(".rn");
                    }
                }
                if (queryPart instanceof QuerySpec) {
                    this.visitForUpdateClause((QuerySpec)queryPart);
                }
            }
            finally {
                clauseStack.pop();
            }
            if (needsParenthesis) {
                this.appendSql(')');
            }
        }
        finally {
            this.queryPartForRowNumbering = queryPartForRowNumbering;
            this.queryPartForRowNumberingClauseDepth = queryPartForRowNumberingClauseDepth;
            this.needsSelectAliases = needsSelectAliases;
        }
    }

    protected void emulateFetchOffsetWithWindowFunctionsVisitQueryPart(QueryPart queryPart) {
        this.appendSql('(');
        queryPart.accept(this);
        this.appendSql(')');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void withRowNumbering(QueryPart queryPart, boolean needsSelectAliases, Runnable r) {
        QueryPart queryPartForRowNumbering = this.queryPartForRowNumbering;
        int queryPartForRowNumberingClauseDepth = this.queryPartForRowNumberingClauseDepth;
        boolean originalNeedsSelectAliases = this.needsSelectAliases;
        try {
            this.queryPartForRowNumbering = queryPart;
            this.queryPartForRowNumberingClauseDepth = this.clauseStack.depth();
            this.needsSelectAliases = needsSelectAliases;
            r.run();
        }
        finally {
            this.queryPartForRowNumbering = queryPartForRowNumbering;
            this.queryPartForRowNumberingClauseDepth = queryPartForRowNumberingClauseDepth;
            this.needsSelectAliases = originalNeedsSelectAliases;
        }
    }

    @Override
    public void visitSelectClause(SelectClause selectClause) {
        this.clauseStack.push(Clause.SELECT);
        try {
            this.appendSql("select ");
            if (selectClause.isDistinct()) {
                this.appendSql("distinct ");
            }
            this.visitSqlSelections(selectClause);
            this.renderVirtualSelections(selectClause);
        }
        finally {
            this.clauseStack.pop();
        }
    }

    protected void visitSqlSelections(SelectClause selectClause) {
        List<SqlSelection> sqlSelections = selectClause.getSqlSelections();
        int size = sqlSelections.size();
        SelectItemReferenceStrategy referenceStrategy = this.dialect.getGroupBySelectItemReferenceStrategy();
        BitSet selectItemsToInline = referenceStrategy == SelectItemReferenceStrategy.EXPRESSION ? this.getSelectItemsToInline() : null;
        SqlAstNodeRenderingMode original = this.parameterRenderingMode;
        SqlAstNodeRenderingMode defaultRenderingMode = this.getStatement() instanceof InsertSelectStatement && this.clauseStack.depth() == 1 && this.queryPartStack.depth() == 1 ? SqlAstNodeRenderingMode.DEFAULT : SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER;
        if (this.needsSelectAliases || referenceStrategy == SelectItemReferenceStrategy.ALIAS && this.hasSelectAliasInGroupByClause()) {
            String separator = "";
            int offset = 0;
            for (int i = 0; i < size; ++i) {
                SqlSelection sqlSelection = sqlSelections.get(i);
                if (sqlSelection.isVirtual()) continue;
                this.parameterRenderingMode = selectItemsToInline != null && selectItemsToInline.get(i) ? SqlAstNodeRenderingMode.INLINE_ALL_PARAMETERS : defaultRenderingMode;
                Expression expression = sqlSelection.getExpression();
                SqlTuple sqlTuple = SqlTupleContainer.getSqlTuple(expression);
                if (sqlTuple != null) {
                    List<? extends Expression> expressions = sqlTuple.getExpressions();
                    for (Expression expression2 : expressions) {
                        this.appendSql(separator);
                        this.renderSelectExpression(expression2);
                        this.appendSql(' ');
                        if (this.columnAliases == null) {
                            this.appendSql('c');
                            this.appendSql(offset);
                        } else {
                            this.appendSql(this.columnAliases.get(offset));
                        }
                        ++offset;
                        separator = ",";
                    }
                } else {
                    this.appendSql(separator);
                    this.renderSelectExpression(expression);
                    this.appendSql(' ');
                    if (this.columnAliases == null) {
                        this.appendSql('c');
                        this.appendSql(offset);
                    } else {
                        this.appendSql(this.columnAliases.get(offset));
                    }
                    ++offset;
                    separator = ",";
                }
                this.parameterRenderingMode = original;
            }
            if (this.queryPartForRowNumbering != null) {
                this.renderRowNumberingSelectItems(selectClause, this.queryPartForRowNumbering);
            }
        } else {
            assert (this.columnAliases == null);
            String separator = "";
            for (int i = 0; i < size; ++i) {
                SqlSelection sqlSelection = sqlSelections.get(i);
                if (sqlSelection.isVirtual()) continue;
                this.appendSql(separator);
                this.parameterRenderingMode = selectItemsToInline != null && selectItemsToInline.get(i) ? SqlAstNodeRenderingMode.INLINE_ALL_PARAMETERS : defaultRenderingMode;
                this.visitSqlSelection(sqlSelection);
                this.parameterRenderingMode = original;
                separator = ",";
            }
        }
    }

    protected void renderVirtualSelections(SelectClause selectClause) {
        this.renderRecursiveCteVirtualSelections(selectClause);
    }

    private BitSet getSelectItemsToInline() {
        QuerySpec querySpec = (QuerySpec)this.getQueryPartStack().getCurrent();
        List<SqlSelection> sqlSelections = querySpec.getSelectClause().getSqlSelections();
        BitSet bitSet = new BitSet(sqlSelections.size());
        for (Expression groupByClauseExpression : querySpec.getGroupByClauseExpressions()) {
            SqlSelectionExpression selectItemReference = this.getSelectItemReference(groupByClauseExpression);
            if (selectItemReference == null) continue;
            bitSet.set(sqlSelections.indexOf(selectItemReference.getSelection()));
        }
        return bitSet;
    }

    private boolean hasSelectAliasInGroupByClause() {
        QuerySpec querySpec = (QuerySpec)this.getQueryPartStack().getCurrent();
        for (Expression groupByClauseExpression : querySpec.getGroupByClauseExpressions()) {
            if (this.getSelectItemReference(groupByClauseExpression) == null) continue;
            return true;
        }
        return false;
    }

    protected final SqlSelectionExpression getSelectItemReference(Expression expression) {
        SqlTuple sqlTuple = SqlTupleContainer.getSqlTuple(expression);
        if (sqlTuple != null) {
            for (Expression expression2 : sqlTuple.getExpressions()) {
                Expression sqlExpression;
                if (expression2 instanceof SqlSelectionExpression) {
                    return (SqlSelectionExpression)expression2;
                }
                if (!(expression2 instanceof SqmPathInterpretation) || !((sqlExpression = ((SqmPathInterpretation)expression2).getSqlExpression()) instanceof SqlSelectionExpression)) continue;
                return (SqlSelectionExpression)sqlExpression;
            }
        } else {
            Expression sqlExpression;
            if (expression instanceof SqlSelectionExpression) {
                return (SqlSelectionExpression)expression;
            }
            if (expression instanceof SqmPathInterpretation && (sqlExpression = ((SqmPathInterpretation)expression).getSqlExpression()) instanceof SqlSelectionExpression) {
                return (SqlSelectionExpression)sqlExpression;
            }
        }
        return null;
    }

    protected void renderRowNumberingSelectItems(SelectClause selectClause, QueryPart queryPart) {
        FetchClauseType fetchClauseType = this.getFetchClauseTypeForRowNumbering(queryPart);
        if (fetchClauseType != null) {
            this.appendSql(',');
            switch (fetchClauseType) {
                case PERCENT_ONLY: {
                    this.appendSql("count(*) over () cnt,");
                }
                case ROWS_ONLY: {
                    this.renderRowNumber(selectClause, queryPart);
                    this.appendSql(" rn");
                    break;
                }
                case PERCENT_WITH_TIES: {
                    this.appendSql("count(*) over () cnt,");
                }
                case ROWS_WITH_TIES: {
                    if (queryPart.getOffsetClauseExpression() != null) {
                        this.renderRowNumber(selectClause, queryPart);
                        this.appendSql(" rn,");
                    }
                    if (selectClause.isDistinct()) {
                        this.appendSql("dense_rank()");
                    } else {
                        this.appendSql("rank()");
                    }
                    this.visitOverClause(Collections.emptyList(), this.getSortSpecificationsRowNumbering(selectClause, queryPart));
                    this.appendSql(" rnk");
                }
            }
        }
    }

    protected FetchClauseType getFetchClauseTypeForRowNumbering(QueryPart queryPartForRowNumbering) {
        if (queryPartForRowNumbering.isRoot() && this.hasLimit()) {
            return FetchClauseType.ROWS_ONLY;
        }
        return queryPartForRowNumbering.getFetchClauseType();
    }

    @Override
    public void visitOver(Over<?> over) {
        OrderedSetAggregateFunctionExpression expression;
        Expression overExpression = over.getExpression();
        overExpression.accept(this);
        boolean orderedSetAggregate = overExpression instanceof OrderedSetAggregateFunctionExpression ? (expression = (OrderedSetAggregateFunctionExpression)overExpression).getWithinGroup() != null && !expression.getWithinGroup().isEmpty() : false;
        this.visitOverClause(over.getPartitions(), over.getOrderList(), over.getMode(), over.getStartKind(), over.getStartExpression(), over.getEndKind(), over.getEndExpression(), over.getExclusion(), orderedSetAggregate);
    }

    protected final void visitOverClause(List<Expression> partitionExpressions, List<SortSpecification> sortSpecifications) {
        this.visitOverClause(partitionExpressions, sortSpecifications, FrameMode.RANGE, FrameKind.UNBOUNDED_PRECEDING, null, FrameKind.CURRENT_ROW, null, FrameExclusion.NO_OTHERS, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitOverClause(List<Expression> partitionExpressions, List<SortSpecification> sortSpecifications, FrameMode mode, FrameKind startKind, Expression startExpression, FrameKind endKind, Expression endExpression, FrameExclusion exclusion, boolean orderedSetAggregate) {
        try {
            this.clauseStack.push(Clause.OVER);
            this.appendSql(" over(");
            this.visitPartitionByClause(partitionExpressions);
            if (!orderedSetAggregate) {
                this.renderOrderBy(!partitionExpressions.isEmpty(), sortSpecifications);
            }
            if (mode != FrameMode.RANGE || startKind != FrameKind.UNBOUNDED_PRECEDING || endKind != FrameKind.CURRENT_ROW || exclusion != FrameExclusion.NO_OTHERS) {
                if (!partitionExpressions.isEmpty() || !sortSpecifications.isEmpty()) {
                    this.append(' ');
                }
                switch (mode) {
                    case GROUPS: {
                        this.append("groups ");
                        break;
                    }
                    case RANGE: {
                        this.append("range ");
                        break;
                    }
                    case ROWS: {
                        this.append("rows ");
                    }
                }
                if (endKind == FrameKind.CURRENT_ROW) {
                    this.renderFrameKind(startKind, startExpression);
                } else {
                    this.append("between ");
                    this.renderFrameKind(startKind, startExpression);
                    this.append(" and ");
                    this.renderFrameKind(endKind, endExpression);
                }
                switch (exclusion) {
                    case TIES: {
                        this.append(" exclude ties");
                        break;
                    }
                    case CURRENT_ROW: {
                        this.append(" exclude current row");
                        break;
                    }
                    case GROUP: {
                        this.append(" exclude group");
                    }
                }
            }
            this.appendSql(')');
        }
        finally {
            this.clauseStack.pop();
        }
    }

    private void renderFrameKind(FrameKind kind, Expression expression) {
        switch (kind) {
            case CURRENT_ROW: {
                this.append("current row");
                break;
            }
            case UNBOUNDED_PRECEDING: {
                this.append("unbounded preceding");
                break;
            }
            case UNBOUNDED_FOLLOWING: {
                this.append("unbounded following");
                break;
            }
            case OFFSET_PRECEDING: {
                expression.accept(this);
                this.append(" preceding");
                break;
            }
            case OFFSET_FOLLOWING: {
                expression.accept(this);
                this.append(" following");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported frame kind: " + String.valueOf((Object)kind));
            }
        }
    }

    protected void renderRowNumber(SelectClause selectClause, QueryPart queryPart) {
        if (selectClause.isDistinct()) {
            this.appendSql("dense_rank()");
        } else {
            this.appendSql("row_number()");
        }
        this.visitOverClause(Collections.emptyList(), this.getSortSpecificationsRowNumbering(selectClause, queryPart));
    }

    protected final boolean isParameter(Expression expression) {
        return expression instanceof JdbcParameter || expression instanceof SqmParameterInterpretation;
    }

    protected final boolean isLiteral(Expression expression) {
        return expression instanceof Literal;
    }

    protected List<SortSpecification> getSortSpecificationsRowNumbering(SelectClause selectClause, QueryPart queryPart) {
        List<Object> sortSpecifications = queryPart.hasSortSpecifications() ? queryPart.getSortSpecifications() : Collections.emptyList();
        if (selectClause.isDistinct()) {
            ArrayList<SqlSelection> sqlSelections = new ArrayList<SqlSelection>(selectClause.getSqlSelections());
            int specificationsSize = sortSpecifications.size();
            block0: for (int i = sqlSelections.size() - 1; i != 0; --i) {
                Expression selectionExpression = ((SqlSelection)sqlSelections.get(i)).getExpression();
                for (int j = 0; j < specificationsSize; ++j) {
                    Expression expression = this.resolveAliasedExpression(sqlSelections, ((SortSpecification)sortSpecifications.get(j)).getSortExpression());
                    if (!expression.equals(selectionExpression)) continue;
                    sqlSelections.remove(i);
                    continue block0;
                }
            }
            int sqlSelectionsSize = sqlSelections.size();
            if (sqlSelectionsSize == 0) {
                return sortSpecifications;
            }
            ArrayList<SortSpecification> sortSpecificationsRowNumbering = new ArrayList<SortSpecification>(sqlSelectionsSize + specificationsSize);
            sortSpecificationsRowNumbering.addAll(sortSpecifications);
            for (int i = 0; i < sqlSelectionsSize; ++i) {
                sortSpecificationsRowNumbering.add(new SortSpecification(new SqlSelectionExpression((SqlSelection)sqlSelections.get(i)), SortDirection.ASCENDING, NullPrecedence.NONE));
            }
            return sortSpecificationsRowNumbering;
        }
        if (queryPart instanceof QueryGroup) {
            int specificationsSize = sortSpecifications.size();
            ArrayList<SortSpecification> sortSpecificationsRowNumbering = new ArrayList<SortSpecification>(specificationsSize);
            List<SqlSelection> sqlSelections = selectClause.getSqlSelections();
            for (int i = 0; i < specificationsSize; ++i) {
                int position;
                SortSpecification sortSpecification = (SortSpecification)sortSpecifications.get(i);
                if (sortSpecification.getSortExpression() instanceof SqlSelectionExpression) {
                    position = ((SqlSelectionExpression)sortSpecification.getSortExpression()).getSelection().getValuesArrayPosition();
                } else {
                    assert (sortSpecification.getSortExpression() instanceof QueryLiteral);
                    QueryLiteral queryLiteral = (QueryLiteral)sortSpecification.getSortExpression();
                    assert (queryLiteral.getLiteralValue() instanceof Integer);
                    position = (Integer)queryLiteral.getLiteralValue();
                }
                sortSpecificationsRowNumbering.add(new SortSpecification(new SqlSelectionExpression(sqlSelections.get(position)), sortSpecification.getSortOrder(), sortSpecification.getNullPrecedence()));
            }
            return sortSpecificationsRowNumbering;
        }
        return sortSpecifications;
    }

    @Override
    public void visitSqlSelection(SqlSelection sqlSelection) {
        this.visitSqlSelectExpression(sqlSelection.getExpression());
    }

    protected void visitSqlSelectExpression(Expression expression) {
        SqlTuple sqlTuple = SqlTupleContainer.getSqlTuple(expression);
        if (sqlTuple != null) {
            boolean isFirst = true;
            for (Expression expression2 : sqlTuple.getExpressions()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    this.appendSql(',');
                }
                this.renderSelectExpression(expression2);
            }
        } else {
            this.renderSelectExpression(expression);
        }
    }

    protected void renderSelectExpression(Expression expression) {
        this.renderExpressionAsClauseItem(expression);
    }

    protected void renderExpressionAsClauseItem(Expression expression) {
        if (expression instanceof Predicate) {
            this.appendSql("case when ");
            expression.accept(this);
            this.appendSql(" then ");
            this.dialect.appendBooleanValueString(this, true);
            this.appendSql(" else ");
            this.dialect.appendBooleanValueString(this, false);
            this.appendSql(" end");
        } else {
            expression.accept(this);
        }
    }

    protected void renderSelectExpressionWithCastedOrInlinedPlainParameters(Expression expression) {
        if (expression instanceof Literal) {
            Literal literal = (Literal)expression;
            if (literal.getLiteralValue() == null) {
                this.renderCasted(literal);
            } else {
                this.renderLiteral(literal, true);
            }
        } else if (this.isParameter(expression)) {
            SqlAstNodeRenderingMode parameterRenderingMode = this.getParameterRenderingMode();
            if (parameterRenderingMode == SqlAstNodeRenderingMode.INLINE_PARAMETERS || parameterRenderingMode == SqlAstNodeRenderingMode.INLINE_ALL_PARAMETERS) {
                this.renderExpressionAsLiteral(expression, this.getJdbcParameterBindings());
            } else {
                this.renderCasted(expression);
            }
        } else if (expression instanceof CaseSimpleExpression) {
            this.visitCaseSimpleExpression((CaseSimpleExpression)expression, true);
        } else if (expression instanceof CaseSearchedExpression) {
            this.visitCaseSearchedExpression((CaseSearchedExpression)expression, true);
        } else {
            this.renderExpressionAsClauseItem(expression);
        }
    }

    protected void renderCasted(Expression expression) {
        CastTarget castTarget;
        if (expression instanceof SqmParameterInterpretation) {
            expression = ((SqmParameterInterpretation)expression).getResolvedExpression();
        }
        ArrayList<Expression> arguments = new ArrayList<Expression>(2);
        arguments.add(expression);
        if (expression instanceof SqlTypedMappingJdbcParameter) {
            SqlTypedMappingJdbcParameter parameter = (SqlTypedMappingJdbcParameter)expression;
            SqlTypedMapping sqlTypedMapping = parameter.getSqlTypedMapping();
            castTarget = new CastTarget(parameter.getJdbcMapping(), sqlTypedMapping.getColumnDefinition(), sqlTypedMapping.getLength(), sqlTypedMapping.getTemporalPrecision() != null ? sqlTypedMapping.getTemporalPrecision() : sqlTypedMapping.getPrecision(), sqlTypedMapping.getScale());
        } else {
            castTarget = new CastTarget(expression.getExpressionType().getSingleJdbcMapping());
        }
        arguments.add(castTarget);
        this.castFunction().render((SqlAppender)this, arguments, (ReturnableType)((Object)castTarget.getJdbcMapping()), this);
    }

    protected void renderLiteral(Literal literal, boolean castParameter) {
        assert (literal.getExpressionType().getJdbcTypeCount() == 1);
        JdbcMapping jdbcMapping = literal.getJdbcMapping();
        JdbcLiteralFormatter literalFormatter = jdbcMapping.getJdbcLiteralFormatter();
        if (literalFormatter == null) {
            this.parameterBinders.add(literal);
            String marker = this.parameterMarkerStrategy.createMarker(this.parameterBinders.size(), literal.getJdbcMapping().getJdbcType());
            LiteralAsParameter jdbcParameter = new LiteralAsParameter(literal, marker);
            if (castParameter) {
                this.renderCasted(jdbcParameter);
            } else {
                this.appendSql('?');
            }
        } else {
            literalFormatter.appendJdbcLiteral(this, literal.getLiteralValue(), this.dialect, this.getWrapperOptions());
        }
    }

    @Override
    public void visitFromClause(FromClause fromClause) {
        if (fromClause == null || fromClause.getRoots().isEmpty()) {
            this.appendSql(this.getFromDualForSelectOnly());
        } else {
            this.appendSql(" from ");
            this.renderFromClauseSpaces(fromClause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderFromClauseSpaces(FromClause fromClause) {
        try {
            this.clauseStack.push(Clause.FROM);
            String separator = "";
            for (TableGroup root : fromClause.getRoots()) {
                separator = this.renderFromClauseRoot(root, separator);
            }
        }
        finally {
            this.clauseStack.pop();
        }
    }

    protected void renderFromClauseAfterUpdateSet(UpdateStatement statement) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderFromClauseExcludingDmlTargetReference(UpdateStatement statement) {
        FromClause fromClause = statement.getFromClause();
        if (AbstractSqlAstTranslator.hasNonTrivialFromClause(fromClause)) {
            this.appendSql(" from ");
            try {
                this.clauseStack.push(Clause.FROM);
                List<TableGroup> roots = fromClause.getRoots();
                this.renderDmlTargetTableGroup(roots.get(0));
                for (int i = 1; i < roots.size(); ++i) {
                    TableGroup root = roots.get(i);
                    this.renderFromClauseRoot(root, ",");
                }
            }
            finally {
                this.clauseStack.pop();
            }
        }
    }

    protected void renderFromClauseJoiningDmlTargetReference(UpdateStatement statement) {
        FromClause fromClause = statement.getFromClause();
        if (AbstractSqlAstTranslator.hasNonTrivialFromClause(fromClause)) {
            this.visitFromClause(fromClause);
            TableGroup dmlTargetTableGroup = statement.getFromClause().getRoots().get(0);
            assert (dmlTargetTableGroup.getPrimaryTableReference() == statement.getTargetTable());
            this.addAdditionalWherePredicate(this.createRowMatchingPredicate(dmlTargetTableGroup, statement.getTargetTable().getTableExpression(), statement.getTargetTable().getIdentificationVariable()));
        }
    }

    protected Predicate createRowMatchingPredicate(TableGroup dmlTargetTableGroup, String lhsAlias, String rhsAlias) {
        String rowIdExpression = this.dialect.rowId(null);
        if (rowIdExpression == null) {
            EntityIdentifierMapping identifierMapping = dmlTargetTableGroup.getModelPart().asEntityMappingType().getIdentifierMapping();
            int jdbcTypeCount = identifierMapping.getJdbcTypeCount();
            ArrayList targetExpressions = new ArrayList(jdbcTypeCount);
            ArrayList sourceExpressions = new ArrayList(jdbcTypeCount);
            identifierMapping.forEachSelectable(0, (selectionIndex, selectableMapping) -> {
                targetExpressions.add(new ColumnReference(lhsAlias, selectableMapping.getSelectionExpression(), selectableMapping.isFormula(), selectableMapping.getCustomReadExpression(), selectableMapping.getJdbcMapping()));
                sourceExpressions.add(new ColumnReference(rhsAlias, selectableMapping.getSelectionExpression(), selectableMapping.isFormula(), selectableMapping.getCustomReadExpression(), selectableMapping.getJdbcMapping()));
            });
            return new ComparisonPredicate(targetExpressions.size() == 1 ? (Expression)targetExpressions.get(0) : new SqlTuple(targetExpressions, identifierMapping), ComparisonOperator.EQUAL, sourceExpressions.size() == 1 ? (Expression)sourceExpressions.get(0) : new SqlTuple(sourceExpressions, identifierMapping));
        }
        return new SelfRenderingPredicate(new SelfRenderingSqlFragmentExpression(lhsAlias + "." + rowIdExpression + "=" + rhsAlias + "." + rowIdExpression));
    }

    protected void renderDmlTargetTableGroup(TableGroup tableGroup) {
        assert (this.getStatementStack().getCurrent() instanceof UpdateStatement && ((UpdateStatement)this.getStatementStack().getCurrent()).getTargetTable() == tableGroup.getPrimaryTableReference());
        this.appendSql(this.getDual());
        this.renderTableReferenceJoins(tableGroup);
        this.processNestedTableGroupJoins(tableGroup, null);
        this.processTableGroupJoins(tableGroup);
        ModelPartContainer modelPart = tableGroup.getModelPart();
        if (modelPart instanceof AbstractEntityPersister) {
            String[] querySpaces = (String[])((AbstractEntityPersister)modelPart).getQuerySpaces();
            for (int i = 0; i < querySpaces.length; ++i) {
                this.registerAffectedTable(querySpaces[i]);
            }
        }
    }

    private String renderFromClauseRoot(TableGroup root, String separator) {
        if (root.isVirtual()) {
            for (TableGroupJoin tableGroupJoin : root.getTableGroupJoins()) {
                this.addAdditionalWherePredicate(tableGroupJoin.getPredicate());
                separator = this.renderFromClauseRoot(tableGroupJoin.getJoinedGroup(), separator);
            }
            for (TableGroupJoin tableGroupJoin : root.getNestedTableGroupJoins()) {
                this.addAdditionalWherePredicate(tableGroupJoin.getPredicate());
                separator = this.renderFromClauseRoot(tableGroupJoin.getJoinedGroup(), separator);
            }
        } else if (root.isInitialized()) {
            this.appendSql(separator);
            this.renderRootTableGroup(root, null);
            separator = ",";
        }
        return separator;
    }

    protected void renderRootTableGroup(TableGroup tableGroup, List<TableGroupJoin> tableGroupJoinCollector) {
        LockMode effectiveLockMode = this.getEffectiveLockMode(tableGroup.getSourceAlias());
        boolean usesLockHint = this.renderPrimaryTableReference(tableGroup, effectiveLockMode);
        if (tableGroup.isLateral() && !this.dialect.supportsLateral()) {
            this.addAdditionalWherePredicate(this.determineLateralEmulationPredicate(tableGroup));
        }
        this.renderTableReferenceJoins(tableGroup);
        this.processNestedTableGroupJoins(tableGroup, tableGroupJoinCollector);
        if (tableGroupJoinCollector != null) {
            tableGroupJoinCollector.addAll(tableGroup.getTableGroupJoins());
        } else {
            this.processTableGroupJoins(tableGroup);
        }
        ModelPartContainer modelPart = tableGroup.getModelPart();
        if (modelPart instanceof AbstractEntityPersister) {
            String[] querySpaces = (String[])((AbstractEntityPersister)modelPart).getQuerySpaces();
            for (int i = 0; i < querySpaces.length; ++i) {
                this.registerAffectedTable(querySpaces[i]);
            }
        }
        if (!usesLockHint && tableGroup.getSourceAlias() != null && LockMode.READ.lessThan(effectiveLockMode)) {
            if (this.forUpdate == null) {
                this.forUpdate = new ForUpdateClause(effectiveLockMode);
            } else {
                this.forUpdate.setLockMode(effectiveLockMode);
            }
            this.forUpdate.applyAliases(this.dialect.getLockRowIdentifier(effectiveLockMode), tableGroup);
        }
    }

    protected void renderTableGroup(TableGroup tableGroup, Predicate predicate, List<TableGroupJoin> tableGroupJoinCollector) {
        Object lateralEmulationPredicate;
        ArrayList<TableGroupJoin> tableGroupJoins;
        boolean realTableGroup;
        int swappedJoinIndex = -1;
        boolean forceLeftJoin = false;
        if (tableGroup.isRealTableGroup()) {
            if (this.hasNestedTableGroupsToRender(tableGroup.getNestedTableGroupJoins())) {
                realTableGroup = true;
            } else {
                int referenceJoinIndexForPredicateSwap = TableGroupHelper.findReferenceJoinForPredicateSwap(tableGroup, predicate);
                if (referenceJoinIndexForPredicateSwap == Integer.MAX_VALUE) {
                    realTableGroup = true;
                } else if (referenceJoinIndexForPredicateSwap == -1) {
                    realTableGroup = false;
                    forceLeftJoin = !tableGroup.canUseInnerJoins();
                } else {
                    realTableGroup = false;
                    forceLeftJoin = !tableGroup.canUseInnerJoins();
                    swappedJoinIndex = referenceJoinIndexForPredicateSwap;
                    TableReferenceJoin tableReferenceJoin = tableGroup.getTableReferenceJoins().get(swappedJoinIndex);
                    this.renderNamedTableReference(tableReferenceJoin.getJoinedTableReference(), LockMode.NONE);
                    if (predicate != null) {
                        this.appendSql(" on ");
                        predicate.accept(this);
                    }
                    this.appendSql(' ');
                    if (tableGroup.canUseInnerJoins()) {
                        this.appendSql(tableReferenceJoin.getJoinType().getText());
                    } else {
                        this.append("left ");
                    }
                    this.appendSql("join ");
                }
            }
        } else {
            realTableGroup = false;
        }
        if (realTableGroup) {
            this.appendSql('(');
        }
        LockMode effectiveLockMode = this.getEffectiveLockMode(tableGroup.getSourceAlias());
        boolean usesLockHint = this.renderPrimaryTableReference(tableGroup, effectiveLockMode);
        if (realTableGroup) {
            this.renderTableReferenceJoins(tableGroup);
            if (tableGroupJoinCollector == null) {
                tableGroupJoins = new ArrayList<TableGroupJoin>();
                this.processNestedTableGroupJoins(tableGroup, tableGroupJoins);
            } else {
                tableGroupJoins = null;
                this.processNestedTableGroupJoins(tableGroup, tableGroupJoinCollector);
            }
            this.appendSql(')');
        } else {
            tableGroupJoins = null;
        }
        if (predicate != null && swappedJoinIndex == -1) {
            this.appendSql(" on ");
            predicate.accept(this);
        }
        if (tableGroup.isLateral() && !this.dialect.supportsLateral() && (lateralEmulationPredicate = this.determineLateralEmulationPredicate(tableGroup)) != null) {
            if (predicate == null) {
                this.appendSql(" on ");
            } else {
                this.appendSql(" and ");
            }
            lateralEmulationPredicate.accept(this);
        }
        if (!realTableGroup) {
            this.renderTableReferenceJoins(tableGroup, swappedJoinIndex, forceLeftJoin);
            this.processNestedTableGroupJoins(tableGroup, tableGroupJoinCollector);
        }
        if (tableGroupJoinCollector != null) {
            tableGroupJoinCollector.addAll(tableGroup.getTableGroupJoins());
        } else {
            if (tableGroupJoins != null) {
                for (TableGroupJoin tableGroupJoin : tableGroupJoins) {
                    this.processTableGroupJoin(tableGroupJoin, null);
                }
            }
            this.processTableGroupJoins(tableGroup);
        }
        ModelPartContainer modelPart = tableGroup.getModelPart();
        if (modelPart instanceof AbstractEntityPersister) {
            String[] querySpaces = (String[])((AbstractEntityPersister)modelPart).getQuerySpaces();
            for (int i = 0; i < querySpaces.length; ++i) {
                this.registerAffectedTable(querySpaces[i]);
            }
        }
        if (!usesLockHint && tableGroup.getSourceAlias() != null && LockMode.READ.lessThan(effectiveLockMode)) {
            if (this.forUpdate == null) {
                this.forUpdate = new ForUpdateClause(effectiveLockMode);
            } else {
                this.forUpdate.setLockMode(effectiveLockMode);
            }
            this.forUpdate.applyAliases(this.dialect.getLockRowIdentifier(effectiveLockMode), tableGroup);
        }
    }

    protected boolean needsLocking(QuerySpec querySpec) {
        return querySpec.getFromClause().queryTableGroups(tableGroup -> {
            if (LockMode.READ.lessThan(this.getEffectiveLockMode(tableGroup.getSourceAlias(), querySpec.isRoot()))) {
                return true;
            }
            return null;
        }) != null;
    }

    protected boolean hasNestedTableGroupsToRender(List<TableGroupJoin> nestedTableGroupJoins) {
        for (TableGroupJoin nestedTableGroupJoin : nestedTableGroupJoins) {
            TableGroup joinedGroup = nestedTableGroupJoin.getJoinedGroup();
            if (!joinedGroup.isInitialized()) continue;
            if (joinedGroup.isVirtual()) {
                if (!this.hasNestedTableGroupsToRender(joinedGroup.getNestedTableGroupJoins())) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    protected boolean renderPrimaryTableReference(TableGroup tableGroup, LockMode lockMode) {
        if (this.shouldInlineCte(tableGroup)) {
            this.inlineCteTableGroup(tableGroup, lockMode);
            return false;
        }
        TableReference tableReference = tableGroup.getPrimaryTableReference();
        if (tableReference instanceof NamedTableReference) {
            return this.renderNamedTableReference((NamedTableReference)tableReference, lockMode);
        }
        DerivedTableReference derivedTableReference = (DerivedTableReference)tableReference;
        if (derivedTableReference.isLateral()) {
            if (this.dialect.supportsLateral()) {
                this.appendSql("lateral ");
            } else if (tableReference instanceof QueryPartTableReference) {
                List<String> columnNames;
                QueryPartTableReference queryPartTableReference = (QueryPartTableReference)tableReference;
                SelectStatement emulationStatement = this.stripToSelectClause(queryPartTableReference.getStatement());
                QueryPart queryPart = queryPartTableReference.getStatement().getQueryPart();
                QueryPart emulationQueryPart = emulationStatement.getQueryPart();
                if (queryPart instanceof QuerySpec && this.needsLateralSortExpressionVirtualSelections((QuerySpec)queryPart)) {
                    columnNames = new ArrayList<String>(queryPartTableReference.getColumnNames());
                    QuerySpec querySpec = (QuerySpec)queryPart;
                    QuerySpec emulationQuerySpec = (QuerySpec)emulationQueryPart;
                    List<SqlSelection> sqlSelections = emulationQuerySpec.getSelectClause().getSqlSelections();
                    List<SortSpecification> sortSpecifications = queryPart.getSortSpecifications();
                    for (int i = 0; i < sortSpecifications.size(); ++i) {
                        SortSpecification sortSpecification = sortSpecifications.get(i);
                        int sortSelectionIndex = this.getSortSelectionIndex(querySpec, sortSpecification);
                        if (sortSelectionIndex != -1) continue;
                        columnNames.add("sort_col_" + i);
                        sqlSelections.add(new SqlSelectionImpl(sqlSelections.size(), sortSpecification.getSortExpression()));
                    }
                } else {
                    columnNames = queryPartTableReference.getColumnNames();
                }
                QueryPartTableReference emulationTableReference = new QueryPartTableReference(emulationStatement, tableReference.getIdentificationVariable(), columnNames, false, this.sessionFactory);
                emulationTableReference.accept(this);
                return false;
            }
        }
        tableReference.accept(this);
        return false;
    }

    protected void inlineCteTableGroup(TableGroup tableGroup, LockMode lockMode) {
        TableReference tableReference = tableGroup.getPrimaryTableReference();
        CteStatement cteStatement = this.getCteStatement(tableReference.getTableId());
        List<CteColumn> cteColumns = cteStatement.getCteTable().getCteColumns();
        ArrayList<String> columnNames = new ArrayList<String>(cteColumns.size());
        for (CteColumn cteColumn : cteColumns) {
            columnNames.add(cteColumn.getColumnExpression());
        }
        SelectStatement cteDefinition = (SelectStatement)cteStatement.getCteDefinition();
        QueryPartTableGroup queryPartTableGroup = new QueryPartTableGroup(tableGroup.getNavigablePath(), cteStatement.getCteTable().getTableGroupProducer(), cteDefinition, tableReference.getIdentificationVariable(), columnNames, this.isCorrelated(cteStatement), true, null);
        Limit oldLimit = this.limit;
        this.limit = null;
        this.statementStack.push(cteDefinition);
        this.renderPrimaryTableReference(queryPartTableGroup, lockMode);
        if (queryPartTableGroup.isLateral() && !this.dialect.supportsLateral()) {
            this.addAdditionalWherePredicate(this.determineLateralEmulationPredicate(queryPartTableGroup));
        }
        this.limit = oldLimit;
        this.statementStack.pop();
    }

    protected boolean isCorrelated(CteStatement cteStatement) {
        return this.statementStack.getCurrent() instanceof SelectStatement && !((SelectStatement)this.statementStack.getCurrent()).getQueryPart().isRoot();
    }

    protected boolean renderNamedTableReference(NamedTableReference tableReference, LockMode lockMode) {
        this.appendSql(tableReference.getTableExpression());
        this.registerAffectedTable(tableReference);
        this.renderTableReferenceIdentificationVariable(tableReference);
        return false;
    }

    @Override
    public void visitValuesTableReference(ValuesTableReference tableReference) {
        this.append('(');
        this.visitValuesList(tableReference.getValuesList());
        this.append(')');
        this.renderDerivedTableReference(tableReference);
    }

    @Override
    public void visitQueryPartTableReference(QueryPartTableReference tableReference) {
        if (tableReference.getQueryPart().isRoot()) {
            this.appendSql('(');
            tableReference.getStatement().accept(this);
            this.appendSql(')');
        } else {
            tableReference.getStatement().accept(this);
        }
        this.renderDerivedTableReference(tableReference);
    }

    @Override
    public void visitFunctionTableReference(FunctionTableReference tableReference) {
        tableReference.getFunctionExpression().accept(this);
        this.renderDerivedTableReference(tableReference);
    }

    protected void emulateQueryPartTableReferenceColumnAliasing(QueryPartTableReference tableReference) {
        boolean needsSelectAliases = this.needsSelectAliases;
        List<String> columnAliases = this.columnAliases;
        this.needsSelectAliases = true;
        this.columnAliases = tableReference.getColumnNames();
        if (tableReference.getQueryPart().isRoot()) {
            this.appendSql('(');
            tableReference.getStatement().accept(this);
            this.appendSql(')');
        } else {
            tableReference.getStatement().accept(this);
        }
        this.needsSelectAliases = needsSelectAliases;
        this.columnAliases = columnAliases;
        this.renderTableReferenceIdentificationVariable(tableReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void emulateValuesTableReferenceColumnAliasing(ValuesTableReference tableReference) {
        List<Values> valuesList = tableReference.getValuesList();
        this.append('(');
        Stack<Clause> clauseStack = this.getClauseStack();
        clauseStack.push(Clause.VALUES);
        try {
            clauseStack.push(Clause.SELECT);
            try {
                this.appendSql("select ");
                this.renderCommaSeparatedSelectExpression(valuesList.get(0).getExpressions(), tableReference.getColumnNames());
                this.appendSql(this.getFromDualForSelectOnly());
            }
            finally {
                clauseStack.pop();
            }
            for (int i = 1; i < valuesList.size(); ++i) {
                this.appendSql(" union all ");
                this.renderExpressionsAsSubquery(valuesList.get(i).getExpressions());
            }
        }
        finally {
            clauseStack.pop();
        }
        this.append(')');
        this.renderTableReferenceIdentificationVariable(tableReference);
    }

    protected void renderDerivedTableReference(DerivedTableReference tableReference) {
        String identificationVariable = tableReference.getIdentificationVariable();
        if (identificationVariable != null) {
            this.append(' ');
            this.append(tableReference.getIdentificationVariable());
            List<String> columnNames = tableReference.getColumnNames();
            this.append('(');
            this.append(columnNames.get(0));
            for (int i = 1; i < columnNames.size(); ++i) {
                this.append(',');
                this.append(columnNames.get(i));
            }
            this.append(')');
        }
    }

    protected void renderTableReferenceIdentificationVariable(TableReference tableReference) {
        String identificationVariable = tableReference.getIdentificationVariable();
        if (identificationVariable != null) {
            this.append(' ');
            this.append(tableReference.getIdentificationVariable());
        }
    }

    protected void registerAffectedTable(NamedTableReference tableReference) {
        tableReference.applyAffectedTableNames(this::registerAffectedTable);
    }

    protected void registerAffectedTable(String tableExpression) {
        this.affectedTableNames.add(tableExpression);
    }

    protected void renderTableReferenceJoins(TableGroup tableGroup) {
        this.renderTableReferenceJoins(tableGroup, -1, false);
    }

    protected void renderTableReferenceJoins(TableGroup tableGroup, int swappedJoinIndex, boolean forceLeftJoin) {
        TableReferenceJoin swappedJoin;
        List<TableReferenceJoin> joins = tableGroup.getTableReferenceJoins();
        if (joins == null || joins.isEmpty()) {
            return;
        }
        if (swappedJoinIndex != -1 && (swappedJoin = joins.get(swappedJoinIndex)).getPredicate() != null && !swappedJoin.getPredicate().isEmpty()) {
            this.appendSql(" on ");
            swappedJoin.getPredicate().accept(this);
        }
        for (int i = 0; i < joins.size(); ++i) {
            if (swappedJoinIndex == i) continue;
            TableReferenceJoin tableJoin = joins.get(i);
            this.appendSql(' ');
            if (forceLeftJoin) {
                this.append("left ");
            } else {
                this.appendSql(tableJoin.getJoinType().getText());
            }
            this.appendSql("join ");
            this.renderNamedTableReference(tableJoin.getJoinedTableReference(), LockMode.NONE);
            if (tableJoin.getPredicate() == null || tableJoin.getPredicate().isEmpty()) continue;
            this.appendSql(" on ");
            tableJoin.getPredicate().accept(this);
        }
    }

    protected void processTableGroupJoins(TableGroup source) {
        source.visitTableGroupJoins(tableGroupJoin -> this.processTableGroupJoin((TableGroupJoin)tableGroupJoin, null));
    }

    protected void processNestedTableGroupJoins(TableGroup source, List<TableGroupJoin> tableGroupJoinCollector) {
        source.visitNestedTableGroupJoins(tableGroupJoin -> this.processTableGroupJoin((TableGroupJoin)tableGroupJoin, tableGroupJoinCollector));
    }

    protected void processTableGroupJoin(TableGroupJoin tableGroupJoin, List<TableGroupJoin> tableGroupJoinCollector) {
        TableGroup joinedGroup = tableGroupJoin.getJoinedGroup();
        if (joinedGroup.isVirtual()) {
            this.processNestedTableGroupJoins(joinedGroup, tableGroupJoinCollector);
            if (tableGroupJoinCollector != null) {
                tableGroupJoinCollector.addAll(joinedGroup.getTableGroupJoins());
            } else {
                this.processTableGroupJoins(joinedGroup);
            }
        } else if (joinedGroup.isInitialized()) {
            this.renderTableGroupJoin(tableGroupJoin, tableGroupJoinCollector);
        } else if (joinedGroup instanceof LazyTableGroup) {
            this.processNestedTableGroupJoins(joinedGroup, tableGroupJoinCollector);
            if (tableGroupJoinCollector != null) {
                tableGroupJoinCollector.addAll(joinedGroup.getTableGroupJoins());
            } else {
                this.processTableGroupJoins(joinedGroup);
            }
        }
    }

    protected void renderTableGroupJoin(TableGroupJoin tableGroupJoin, List<TableGroupJoin> tableGroupJoinCollector) {
        this.appendSql(' ');
        this.appendSql(tableGroupJoin.getJoinType().getText());
        this.appendSql("join ");
        Object predicate = tableGroupJoin.getPredicate() == null ? (tableGroupJoin.getJoinType() == SqlAstJoinType.CROSS ? null : new BooleanExpressionPredicate(new QueryLiteral<Boolean>(true, this.getBooleanType()))) : tableGroupJoin.getPredicate();
        if (predicate != null && !predicate.isEmpty()) {
            this.renderTableGroup(tableGroupJoin.getJoinedGroup(), (Predicate)predicate, tableGroupJoinCollector);
        } else {
            this.renderTableGroup(tableGroupJoin.getJoinedGroup(), null, tableGroupJoinCollector);
        }
    }

    protected Predicate determineLateralEmulationPredicate(TableGroup tableGroup) {
        if (tableGroup.getPrimaryTableReference() instanceof QueryPartTableReference) {
            Expression countUpper;
            DomainResultProducer<Integer> countLower;
            QueryPartTableReference tableReference = (QueryPartTableReference)tableGroup.getPrimaryTableReference();
            List<String> columnNames = tableReference.getColumnNames();
            ArrayList<ColumnReference> columnReferences = new ArrayList<ColumnReference>(columnNames.size());
            SelectStatement statement = tableReference.getStatement();
            for (String string : columnNames) {
                columnReferences.add(new ColumnReference(tableReference, string, false, null, null));
            }
            if ((columnReferences.size() == 1 || this.supportsRowValueConstructorSyntax()) && this.supportsRowValueConstructorDistinctFromSyntax() && this.isFetchFirstRowOnly(statement.getQueryPart())) {
                return new ComparisonPredicate(new SqlTuple(columnReferences, tableGroup.getModelPart()), ComparisonOperator.NOT_DISTINCT_FROM, statement);
            }
            if (this.shouldEmulateLateralWithIntersect(statement.getQueryPart())) {
                QuerySpec lhsReferencesQuery = new QuerySpec(false);
                for (ColumnReference columnReference : columnReferences) {
                    lhsReferencesQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(columnReference));
                }
                ArrayList<QueryPart> arrayList = new ArrayList<QueryPart>(2);
                arrayList.add(lhsReferencesQuery);
                arrayList.add(statement.getQueryPart());
                return new ExistsPredicate(new SelectStatement(statement, new QueryGroup(false, SetOperator.INTERSECT, arrayList), Collections.emptyList()), false, this.getBooleanType());
            }
            if (this.supportsNestedSubqueryCorrelation()) {
                QueryPartTableGroup subTableGroup = new QueryPartTableGroup(tableGroup.getNavigablePath(), (TableGroupProducer)tableGroup.getModelPart(), new SelectStatement(statement.getQueryPart()), "synth_", columnNames, false, true, this.sessionFactory);
                ArrayList<ColumnReference> arrayList = new ArrayList<ColumnReference>(columnNames.size());
                for (String columnName : columnNames) {
                    arrayList.add(new ColumnReference(subTableGroup.getPrimaryTableReference(), columnName, false, null, null));
                }
                QuerySpec existsQuery = new QuerySpec(false, 1);
                existsQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(new QueryLiteral<Integer>(1, this.getIntegerType())));
                existsQuery.getFromClause().addRoot(subTableGroup);
                existsQuery.applyPredicate(new ComparisonPredicate(new SqlTuple(columnReferences, tableGroup.getModelPart()), ComparisonOperator.NOT_DISTINCT_FROM, new SqlTuple(arrayList, tableGroup.getModelPart())));
                return new ExistsPredicate(new SelectStatement(statement, existsQuery, Collections.emptyList()), false, this.getBooleanType());
            }
            QueryPart queryPart = statement.getQueryPart();
            if (queryPart instanceof QueryGroup) {
                throw new UnsupportedOperationException("Can't emulate lateral query group with limit/offset");
            }
            QuerySpec querySpec = (QuerySpec)queryPart;
            ArrayList<? extends Expression> subExpressions = new ArrayList<Expression>(columnNames.size());
            for (SqlSelection sqlSelection : querySpec.getSelectClause().getSqlSelections()) {
                Expression selectionExpression = sqlSelection.getExpression();
                SqlTuple sqlTuple = SqlTupleContainer.getSqlTuple(selectionExpression);
                if (sqlTuple == null) {
                    subExpressions.add(selectionExpression);
                    continue;
                }
                subExpressions.addAll(sqlTuple.getExpressions());
            }
            QuerySpec existsQuery = new QuerySpec(false, querySpec.getFromClause().getRoots().size());
            existsQuery.getFromClause().getRoots().addAll(querySpec.getFromClause().getRoots());
            existsQuery.applyPredicate(querySpec.getWhereClauseRestrictions());
            existsQuery.setGroupByClauseExpressions(querySpec.getGroupByClauseExpressions());
            existsQuery.setHavingClauseRestrictions(querySpec.getHavingClauseRestrictions());
            existsQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(new QueryLiteral<Integer>(1, this.getIntegerType())));
            existsQuery.applyPredicate(new ComparisonPredicate(new SqlTuple(columnReferences, tableGroup.getModelPart()), ComparisonOperator.NOT_DISTINCT_FROM, new SqlTuple(subExpressions, tableGroup.getModelPart())));
            ExistsPredicate existsPredicate = new ExistsPredicate(new SelectStatement(statement, existsQuery, Collections.emptyList()), false, this.getBooleanType());
            if (!queryPart.hasOffsetOrFetchClause()) {
                return existsPredicate;
            }
            QuerySpec countQuery = new QuerySpec(querySpec.isRoot(), querySpec.getFromClause().getRoots().size());
            countQuery.getFromClause().getRoots().addAll(querySpec.getFromClause().getRoots());
            countQuery.applyPredicate(querySpec.getWhereClauseRestrictions());
            countQuery.setGroupByClauseExpressions(querySpec.getGroupByClauseExpressions());
            countQuery.setHavingClauseRestrictions(querySpec.getHavingClauseRestrictions());
            countQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(new SelfRenderingAggregateFunctionSqlAstExpression("count", (sqlAppender, sqlAstArguments, returnType, walker) -> sqlAppender.append("count(*)"), List.of(Star.INSTANCE), null, this.getIntegerType(), this.getIntegerType())));
            List<SortSpecification> sortSpecifications = queryPart.getSortSpecifications();
            for (int i = 0; i < sortSpecifications.size(); ++i) {
                Expression sortExpression;
                ColumnReference currentRowColumnReference;
                SortSpecification sortSpecification = sortSpecifications.get(i);
                int sortSelectionIndex = this.getSortSelectionIndex(querySpec, sortSpecification);
                if (sortSelectionIndex == -1) {
                    currentRowColumnReference = new ColumnReference(tableReference, "sort_col_" + i, false, null, null);
                    sortExpression = sortSpecification.getSortExpression();
                } else {
                    currentRowColumnReference = (ColumnReference)columnReferences.get(sortSelectionIndex);
                    sortExpression = querySpec.getSelectClause().getSqlSelections().get(sortSelectionIndex).getExpression();
                }
                boolean isNullsFirst = this.isNullsFirst(sortSpecification);
                Predicate nullHandlingPredicate = isNullsFirst ? new NullnessPredicate(sortExpression) : new Junction(Junction.Nature.CONJUNCTION, List.of(new NullnessPredicate(sortExpression), new NullnessPredicate(currentRowColumnReference)), this.getBooleanType());
                ComparisonOperator comparisonOperator = sortSpecification.getSortOrder() == SortDirection.DESCENDING ? ComparisonOperator.GREATER_THAN_OR_EQUAL : ComparisonOperator.LESS_THAN_OR_EQUAL;
                countQuery.applyPredicate(new Junction(Junction.Nature.DISJUNCTION, List.of(nullHandlingPredicate, new ComparisonPredicate(sortExpression, comparisonOperator, currentRowColumnReference)), this.getBooleanType()));
            }
            if (queryPart.getOffsetClauseExpression() == null) {
                countLower = new QueryLiteral<Integer>(1, this.getIntegerType());
                countUpper = queryPart.getFetchClauseExpression();
            } else {
                countLower = new BinaryArithmeticExpression(queryPart.getOffsetClauseExpression(), BinaryArithmeticOperator.ADD, new QueryLiteral<Integer>(1, this.getIntegerType()), this.getIntegerType());
                countUpper = new BinaryArithmeticExpression(queryPart.getOffsetClauseExpression(), BinaryArithmeticOperator.ADD, queryPart.getFetchClauseExpression(), this.getIntegerType());
            }
            return new Junction(Junction.Nature.CONJUNCTION, List.of(existsPredicate, new BetweenPredicate(new SelectStatement(statement, countQuery, Collections.emptyList()), (Expression)((Object)countLower), countUpper, false, this.getBooleanType())), this.getBooleanType());
        }
        return null;
    }

    protected boolean shouldEmulateLateralWithIntersect(QueryPart queryPart) {
        return this.supportsIntersect();
    }

    private boolean isNullsFirst(SortSpecification sortSpecification) {
        NullPrecedence nullPrecedence = sortSpecification.getNullPrecedence();
        if (nullPrecedence == null || nullPrecedence == NullPrecedence.NONE) {
            switch (this.dialect.getNullOrdering()) {
                case FIRST: {
                    nullPrecedence = NullPrecedence.FIRST;
                    break;
                }
                case LAST: {
                    nullPrecedence = NullPrecedence.LAST;
                    break;
                }
                case SMALLEST: {
                    nullPrecedence = sortSpecification.getSortOrder() == SortDirection.ASCENDING ? NullPrecedence.FIRST : NullPrecedence.LAST;
                    break;
                }
                case GREATEST: {
                    nullPrecedence = sortSpecification.getSortOrder() == SortDirection.DESCENDING ? NullPrecedence.FIRST : NullPrecedence.LAST;
                }
            }
        }
        return nullPrecedence == NullPrecedence.FIRST;
    }

    private int getSortSelectionIndex(QuerySpec querySpec, SortSpecification sortSpecification) {
        Expression sortExpression = sortSpecification.getSortExpression();
        if (sortExpression instanceof SqlSelectionExpression) {
            SqlSelection selection = ((SqlSelectionExpression)sortExpression).getSelection();
            return selection.getValuesArrayPosition();
        }
        List<SqlSelection> sqlSelections = querySpec.getSelectClause().getSqlSelections();
        for (int j = 0; j < sqlSelections.size(); ++j) {
            SqlSelection sqlSelection = sqlSelections.get(j);
            if (sqlSelection.getExpression() != sortExpression) continue;
            return j;
        }
        return -1;
    }

    private boolean isFetchFirstRowOnly(QueryPart queryPart) {
        return queryPart.getFetchClauseType() == FetchClauseType.ROWS_ONLY && queryPart.getFetchClauseExpression() != null && Integer.valueOf(1).equals(this.getLiteralValue(queryPart.getFetchClauseExpression()));
    }

    public <X> X getLiteralValue(Expression expression) {
        return (X)this.interpretExpression(expression, this.jdbcParameterBindings);
    }

    private SelectStatement stripToSelectClause(SelectStatement statement) {
        return new SelectStatement(statement, this.stripToSelectClause(statement.getQueryPart()), Collections.emptyList());
    }

    private QueryPart stripToSelectClause(QueryPart queryPart) {
        if (queryPart instanceof QueryGroup) {
            return this.stripToSelectClause((QueryGroup)queryPart);
        }
        return this.stripToSelectClause((QuerySpec)queryPart);
    }

    private QueryGroup stripToSelectClause(QueryGroup queryGroup) {
        ArrayList<QueryPart> parts = new ArrayList<QueryPart>(queryGroup.getQueryParts().size());
        for (QueryPart queryPart : queryGroup.getQueryParts()) {
            parts.add(this.stripToSelectClause(queryPart));
        }
        return new QueryGroup(queryGroup.isRoot(), queryGroup.getSetOperator(), parts);
    }

    private QuerySpec stripToSelectClause(QuerySpec querySpec) {
        if (querySpec.getGroupByClauseExpressions() != null && !querySpec.getGroupByClauseExpressions().isEmpty()) {
            throw new UnsupportedOperationException("Can't emulate lateral join for query spec with group by clause");
        }
        if (querySpec.getHavingClauseRestrictions() != null && !querySpec.getHavingClauseRestrictions().isEmpty()) {
            throw new UnsupportedOperationException("Can't emulate lateral join for query spec with having clause");
        }
        QuerySpec newQuerySpec = new QuerySpec(querySpec.isRoot(), querySpec.getFromClause().getRoots().size());
        for (TableGroup root : querySpec.getFromClause().getRoots()) {
            newQuerySpec.getFromClause().addRoot(root);
        }
        for (SqlSelection selection : querySpec.getSelectClause().getSqlSelections()) {
            if (AggregateFunctionChecker.hasAggregateFunctions(selection.getExpression())) {
                throw new UnsupportedOperationException("Can't emulate lateral join for query spec with aggregate function");
            }
            newQuerySpec.getSelectClause().addSqlSelection(selection);
        }
        return newQuerySpec;
    }

    private boolean needsLateralSortExpressionVirtualSelections(QuerySpec querySpec) {
        return (querySpec.getSelectClause().getSqlSelections().size() != 1 && !this.supportsRowValueConstructorSyntax() || !this.supportsDistinctFromPredicate() || !this.isFetchFirstRowOnly(querySpec)) && !this.shouldEmulateLateralWithIntersect(querySpec) && !this.supportsNestedSubqueryCorrelation() && querySpec.hasOffsetOrFetchClause();
    }

    @Override
    public void visitTableGroup(TableGroup tableGroup) {
        throw new UnsupportedOperationException("This should never be invoked as org.hibernate.query.sqm.sql.BaseSqmToSqlAstConverter.visitTableGroup should handle this");
    }

    @Override
    public void visitTableGroupJoin(TableGroupJoin tableGroupJoin) {
        throw new UnsupportedOperationException("This should never be invoked as org.hibernate.query.sqm.sql.BaseSqmToSqlAstConverter.visitTableGroup should handle this");
    }

    @Override
    public void visitNamedTableReference(NamedTableReference tableReference) {
    }

    @Override
    public void visitTableReferenceJoin(TableReferenceJoin tableReferenceJoin) {
    }

    @Override
    public void visitColumnReference(ColumnReference columnReference) {
        String qualifier = this.determineColumnReferenceQualifier(columnReference);
        if (columnReference.isColumnExpressionFormula()) {
            Object replacement = qualifier != null ? "$1" + qualifier + ".$3" : "$1$3";
            this.appendSql(columnReference.getColumnExpression().replaceAll("(\\b)(" + columnReference.getQualifier() + "\\.)(\\b)", (String)replacement));
        } else {
            columnReference.appendReadExpression(this, qualifier);
        }
    }

    @Override
    public void visitNestedColumnReference(NestedColumnReference nestedColumnReference) {
        int idx;
        String readExpression = nestedColumnReference.getReadExpression();
        int start = 0;
        while ((idx = readExpression.indexOf("$PlaceHolder$", start)) != -1) {
            this.append(readExpression, start, idx);
            nestedColumnReference.getBaseExpression().accept(this);
            start = idx + "$PlaceHolder$".length();
        }
        this.append(readExpression, start, readExpression.length());
    }

    @Override
    public void visitAggregateColumnWriteExpression(AggregateColumnWriteExpression aggregateColumnWriteExpression) {
        aggregateColumnWriteExpression.appendWriteExpression(this, this, this.determineColumnReferenceQualifier(aggregateColumnWriteExpression.getColumnReference()));
    }

    protected String determineColumnReferenceQualifier(ColumnReference columnReference) {
        String dmlAlias;
        MutationStatement currentDmlStatement;
        DmlTargetColumnQualifierSupport qualifierSupport = this.getDialect().getDmlTargetColumnQualifierSupport();
        if (qualifierSupport == DmlTargetColumnQualifierSupport.TABLE_ALIAS || (currentDmlStatement = this.getCurrentDmlStatement()) == null || (dmlAlias = currentDmlStatement.getTargetTable().getIdentificationVariable()) == null || !dmlAlias.equals(columnReference.getQualifier())) {
            return columnReference.getQualifier();
        }
        if (qualifierSupport != DmlTargetColumnQualifierSupport.NONE || !this.queryPartStack.isEmpty()) {
            return this.getCurrentDmlStatement().getTargetTable().getTableExpression();
        }
        return null;
    }

    @Override
    public void visitExtractUnit(ExtractUnit extractUnit) {
        this.appendSql(this.dialect.translateExtractField(extractUnit.getUnit()));
    }

    @Override
    public void visitDurationUnit(DurationUnit unit) {
        this.appendSql(this.dialect.translateDurationField(unit.getUnit()));
    }

    @Override
    public void visitFormat(Format format) {
        this.appendSql('\'');
        this.dialect.appendDatetimeFormat(this, format.getFormat());
        this.appendSql('\'');
    }

    @Override
    public void visitStar(Star star) {
        this.appendSql('*');
    }

    @Override
    public void visitTrimSpecification(TrimSpecification trimSpecification) {
        this.appendSql(' ');
        this.appendSql(trimSpecification.getSpecification().toSqlText());
        this.appendSql(' ');
    }

    @Override
    public void visitCastTarget(CastTarget castTarget) {
        this.appendSql(AbstractSqlAstTranslator.getCastTypeName((SqlTypedMapping)castTarget, this.sessionFactory.getTypeConfiguration()));
    }

    @Deprecated(forRemoval=true)
    public static String getSqlTypeName(SqlTypedMapping castTarget, SessionFactoryImplementor factory) {
        return AbstractSqlAstTranslator.getSqlTypeName(castTarget, factory.getTypeConfiguration());
    }

    public static String getSqlTypeName(SqlTypedMapping castTarget, TypeConfiguration typeConfiguration) {
        BasicType expressionType;
        if (castTarget.getColumnDefinition() != null) {
            return castTarget.getColumnDefinition();
        }
        Size castTargetSize = castTarget.toSize();
        DdlTypeRegistry ddlTypeRegistry = typeConfiguration.getDdlTypeRegistry();
        DdlType ddlType = ddlTypeRegistry.getDescriptor((expressionType = (BasicType)castTarget.getJdbcMapping()).getJdbcType().getDdlTypeCode());
        if (ddlType == null) {
            ddlType = ddlTypeRegistry.getDescriptor(4);
        }
        return ddlType.getTypeName(castTargetSize, expressionType, ddlTypeRegistry);
    }

    @Deprecated(forRemoval=true)
    public static String getCastTypeName(SqlTypedMapping castTarget, SessionFactoryImplementor factory) {
        return AbstractSqlAstTranslator.getCastTypeName(castTarget, factory.getTypeConfiguration());
    }

    public static String getCastTypeName(SqlTypedMapping castTarget, TypeConfiguration typeConfiguration) {
        BasicType expressionType;
        if (castTarget.getColumnDefinition() != null) {
            return castTarget.getColumnDefinition();
        }
        Size castTargetSize = castTarget.toSize();
        DdlTypeRegistry ddlTypeRegistry = typeConfiguration.getDdlTypeRegistry();
        DdlType ddlType = ddlTypeRegistry.getDescriptor((expressionType = (BasicType)castTarget.getJdbcMapping()).getJdbcType().getDdlTypeCode());
        if (ddlType == null) {
            ddlType = ddlTypeRegistry.getDescriptor(4);
        }
        return ddlType.getCastTypeName(castTargetSize, expressionType, ddlTypeRegistry);
    }

    @Override
    public void visitDistinct(Distinct distinct) {
        this.appendSql("distinct ");
        distinct.getExpression().accept(this);
    }

    @Override
    public void visitOverflow(Overflow overflow) {
        overflow.getSeparatorExpression().accept(this);
        this.appendSql(" on overflow ");
        if (overflow.getFillerExpression() == null) {
            this.appendSql("error");
        } else {
            this.appendSql(" truncate ");
            overflow.getFillerExpression().accept(this);
            if (overflow.isWithCount()) {
                this.appendSql(" with count");
            } else {
                this.appendSql(" without count");
            }
        }
    }

    @Override
    public void visitParameter(JdbcParameter jdbcParameter) {
        switch (this.getParameterRenderingMode()) {
            case NO_UNTYPED: 
            case NO_PLAIN_PARAMETER: {
                this.renderCasted(jdbcParameter);
                break;
            }
            case INLINE_PARAMETERS: 
            case INLINE_ALL_PARAMETERS: {
                this.renderExpressionAsLiteral(jdbcParameter, this.jdbcParameterBindings);
                break;
            }
            case WRAP_ALL_PARAMETERS: {
                this.renderWrappedParameter(jdbcParameter);
                break;
            }
            default: {
                this.visitParameterAsParameter(jdbcParameter);
            }
        }
    }

    protected void visitParameterAsParameter(JdbcParameter jdbcParameter) {
        this.renderParameterAsParameter(jdbcParameter);
        this.parameterBinders.add(jdbcParameter.getParameterBinder());
        this.jdbcParameters.addParameter(jdbcParameter);
    }

    protected final void renderParameterAsParameter(JdbcParameter jdbcParameter) {
        JdbcType jdbcType = jdbcParameter.getExpressionType().getJdbcMapping(0).getJdbcType();
        assert (jdbcType != null);
        this.renderParameterAsParameter(this.parameterBinders.size() + 1, jdbcParameter);
    }

    protected void renderWrappedParameter(JdbcParameter jdbcParameter) {
        this.clauseStack.push(Clause.SELECT);
        try {
            this.appendSql("(select ");
            this.visitParameterAsParameter(jdbcParameter);
            this.appendSql(this.getFromDualForSelectOnly());
            this.appendSql(')');
        }
        finally {
            this.clauseStack.pop();
        }
    }

    protected void renderParameterAsParameter(int position, JdbcParameter jdbcParameter) {
        JdbcType jdbcType = jdbcParameter.getExpressionType().getJdbcMapping(0).getJdbcType();
        assert (jdbcType != null);
        String parameterMarker = this.parameterMarkerStrategy.createMarker(position, jdbcType);
        jdbcType.appendWriteExpression(parameterMarker, this, this.dialect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(SqlAstNode sqlAstNode, SqlAstNodeRenderingMode renderingMode) {
        SqlAstNodeRenderingMode original = this.parameterRenderingMode;
        if (original != SqlAstNodeRenderingMode.INLINE_ALL_PARAMETERS && original != SqlAstNodeRenderingMode.WRAP_ALL_PARAMETERS) {
            this.parameterRenderingMode = renderingMode;
        }
        try {
            sqlAstNode.accept(this);
        }
        finally {
            this.parameterRenderingMode = original;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void withParameterRenderingMode(SqlAstNodeRenderingMode renderingMode, Runnable runnable) {
        SqlAstNodeRenderingMode original = this.parameterRenderingMode;
        if (original != SqlAstNodeRenderingMode.INLINE_ALL_PARAMETERS && original != SqlAstNodeRenderingMode.WRAP_ALL_PARAMETERS) {
            this.parameterRenderingMode = renderingMode;
        }
        try {
            runnable.run();
        }
        finally {
            this.parameterRenderingMode = original;
        }
    }

    @Override
    public void visitTuple(SqlTuple tuple) {
        boolean wrap;
        boolean bl = wrap = this.clauseStack.getCurrent() != Clause.VALUES;
        if (wrap) {
            this.appendSql('(');
        }
        this.renderCommaSeparated(tuple.getExpressions());
        if (wrap) {
            this.appendSql(')');
        }
    }

    protected final void renderCommaSeparated(Iterable<? extends SqlAstNode> expressions) {
        String separator = "";
        for (SqlAstNode sqlAstNode : expressions) {
            this.appendSql(separator);
            sqlAstNode.accept(this);
            separator = ",";
        }
    }

    protected final void renderCommaSeparatedSelectExpression(Iterable<? extends SqlAstNode> expressions) {
        String separator = "";
        for (SqlAstNode sqlAstNode : expressions) {
            SqlTuple sqlTuple = SqlTupleContainer.getSqlTuple(sqlAstNode);
            if (sqlTuple != null) {
                for (Expression expression : sqlTuple.getExpressions()) {
                    this.appendSql(separator);
                    this.renderSelectExpression(expression);
                    separator = ",";
                }
            } else if (sqlAstNode instanceof Expression) {
                this.appendSql(separator);
                this.renderSelectExpression((Expression)sqlAstNode);
            } else {
                this.appendSql(separator);
                sqlAstNode.accept(this);
            }
            separator = ",";
        }
    }

    protected final void renderCommaSeparatedSelectExpression(Iterable<? extends SqlAstNode> expressions, Iterable<String> aliases) {
        String separator = "";
        Iterator<String> aliasIterator = aliases.iterator();
        for (SqlAstNode sqlAstNode : expressions) {
            SqlTuple sqlTuple = SqlTupleContainer.getSqlTuple(sqlAstNode);
            if (sqlTuple != null) {
                for (Expression expression : sqlTuple.getExpressions()) {
                    this.appendSql(separator);
                    this.renderSelectExpression(expression);
                    separator = ",";
                }
            } else if (sqlAstNode instanceof Expression) {
                this.appendSql(separator);
                this.renderSelectExpression((Expression)sqlAstNode);
            } else {
                this.appendSql(separator);
                sqlAstNode.accept(this);
            }
            separator = ",";
            this.append(' ');
            this.append(aliasIterator.next());
        }
    }

    @Override
    public void visitCollation(Collation collation) {
        this.appendSql(collation.getCollation());
    }

    @Override
    public void visitSqlSelectionExpression(SqlSelectionExpression expression) {
        if (this.dialect.supportsOrdinalSelectItemReference()) {
            this.appendSql(expression.getSelection().getJdbcResultSetIndex());
        } else {
            expression.getSelection().getExpression().accept(this);
        }
    }

    @Override
    public void visitEntityTypeLiteral(EntityTypeLiteral expression) {
        this.appendSql(expression.getEntityTypeDescriptor().getDiscriminatorSQLValue());
    }

    @Override
    public void visitEmbeddableTypeLiteral(EmbeddableTypeLiteral expression) {
        BasicValueConverter valueConverter = expression.getJdbcMapping().getValueConverter();
        this.appendSql(DiscriminatorHelper.jdbcLiteral(valueConverter != null ? valueConverter.toRelationalValue(expression.getEmbeddableClass()) : expression.getEmbeddableClass(), expression.getExpressionType().getSingleJdbcMapping().getJdbcLiteralFormatter(), this.getDialect()));
    }

    @Override
    public void visitBinaryArithmeticExpression(BinaryArithmeticExpression arithmeticExpression) {
        BinaryArithmeticOperator operator = arithmeticExpression.getOperator();
        if (operator == BinaryArithmeticOperator.MODULO) {
            this.append("mod");
            this.appendSql('(');
            this.visitArithmeticOperand(arithmeticExpression.getLeftHandOperand());
            this.appendSql(',');
            this.visitArithmeticOperand(arithmeticExpression.getRightHandOperand());
            this.appendSql(')');
        } else {
            this.appendSql('(');
            this.visitArithmeticOperand(arithmeticExpression.getLeftHandOperand());
            this.appendSql(arithmeticExpression.getOperator().getOperatorSqlTextString());
            this.visitArithmeticOperand(arithmeticExpression.getRightHandOperand());
            this.appendSql(')');
        }
    }

    protected void visitArithmeticOperand(Expression expression) {
        expression.accept(this);
    }

    @Override
    public void visitDuration(Duration duration) {
        duration.getMagnitude().accept(this);
        if (!duration.getExpressionType().getJdbcMapping().getJdbcType().isInterval()) {
            this.appendSql(duration.getUnit().conversionFactor(TemporalUnit.NANOSECOND, this.dialect));
        }
    }

    @Override
    public void visitConversion(Conversion conversion) {
        Duration duration = conversion.getDuration();
        duration.getMagnitude().accept(this);
        this.appendSql(duration.getUnit().conversionFactor(conversion.getUnit(), this.dialect));
    }

    @Override
    public final void visitCaseSearchedExpression(CaseSearchedExpression caseSearchedExpression) {
        this.visitCaseSearchedExpression(caseSearchedExpression, false);
    }

    protected void visitCaseSearchedExpression(CaseSearchedExpression caseSearchedExpression, boolean inSelect) {
        if (inSelect) {
            this.visitAnsiCaseSearchedExpression(caseSearchedExpression, this::renderSelectExpression);
        } else {
            this.visitAnsiCaseSearchedExpression(caseSearchedExpression, e -> e.accept(this));
        }
    }

    protected void visitAnsiCaseSearchedExpression(CaseSearchedExpression caseSearchedExpression, Consumer<Expression> resultRenderer) {
        this.appendSql("case");
        SqlAstNodeRenderingMode original = this.parameterRenderingMode;
        for (CaseSearchedExpression.WhenFragment whenFragment : caseSearchedExpression.getWhenFragments()) {
            if (original != SqlAstNodeRenderingMode.INLINE_ALL_PARAMETERS && original != SqlAstNodeRenderingMode.WRAP_ALL_PARAMETERS) {
                this.parameterRenderingMode = SqlAstNodeRenderingMode.DEFAULT;
            }
            this.appendSql(" when ");
            whenFragment.getPredicate().accept(this);
            this.parameterRenderingMode = original;
            this.appendSql(" then ");
            resultRenderer.accept(whenFragment.getResult());
        }
        Expression otherwise = caseSearchedExpression.getOtherwise();
        if (otherwise != null) {
            this.appendSql(" else ");
            resultRenderer.accept(otherwise);
        }
        this.appendSql(" end");
    }

    protected void visitDecodeCaseSearchedExpression(CaseSearchedExpression caseSearchedExpression) {
        this.appendSql("decode( ");
        SqlAstNodeRenderingMode original = this.parameterRenderingMode;
        List<CaseSearchedExpression.WhenFragment> whenFragments = caseSearchedExpression.getWhenFragments();
        int caseNumber = whenFragments.size();
        CaseSearchedExpression.WhenFragment firstWhenFragment = null;
        for (int i = 0; i < caseNumber; ++i) {
            CaseSearchedExpression.WhenFragment whenFragment = whenFragments.get(i);
            Predicate predicate = whenFragment.getPredicate();
            if (original != SqlAstNodeRenderingMode.INLINE_ALL_PARAMETERS && original != SqlAstNodeRenderingMode.WRAP_ALL_PARAMETERS) {
                this.parameterRenderingMode = SqlAstNodeRenderingMode.DEFAULT;
            }
            if (i != 0) {
                this.appendSql(',');
                this.getLeftHandExpression(predicate).accept(this);
                this.parameterRenderingMode = original;
                this.appendSql(',');
                whenFragment.getResult().accept(this);
                continue;
            }
            this.getLeftHandExpression(predicate).accept(this);
            firstWhenFragment = whenFragment;
        }
        this.parameterRenderingMode = original;
        this.appendSql(',');
        firstWhenFragment.getResult().accept(this);
        Expression otherwise = caseSearchedExpression.getOtherwise();
        if (otherwise != null) {
            this.appendSql(',');
            otherwise.accept(this);
        }
        this.appendSql(')');
    }

    @Override
    public final void visitCaseSimpleExpression(CaseSimpleExpression caseSimpleExpression) {
        this.visitAnsiCaseSimpleExpression(caseSimpleExpression, e -> e.accept(this));
    }

    protected void visitCaseSimpleExpression(CaseSimpleExpression caseSimpleExpression, boolean inSelect) {
        if (inSelect) {
            this.visitAnsiCaseSimpleExpression(caseSimpleExpression, this::renderSelectExpression);
        } else {
            this.visitAnsiCaseSimpleExpression(caseSimpleExpression, e -> e.accept(this));
        }
    }

    protected void visitAnsiCaseSimpleExpression(CaseSimpleExpression caseSimpleExpression, Consumer<Expression> resultRenderer) {
        this.appendSql("case ");
        SqlAstNodeRenderingMode original = this.parameterRenderingMode;
        if (original != SqlAstNodeRenderingMode.INLINE_ALL_PARAMETERS && original != SqlAstNodeRenderingMode.WRAP_ALL_PARAMETERS) {
            this.parameterRenderingMode = SqlAstNodeRenderingMode.DEFAULT;
        }
        caseSimpleExpression.getFixture().accept(this);
        for (CaseSimpleExpression.WhenFragment whenFragment : caseSimpleExpression.getWhenFragments()) {
            if (original != SqlAstNodeRenderingMode.INLINE_ALL_PARAMETERS && original != SqlAstNodeRenderingMode.WRAP_ALL_PARAMETERS) {
                this.parameterRenderingMode = SqlAstNodeRenderingMode.DEFAULT;
            }
            this.appendSql(" when ");
            whenFragment.getCheckValue().accept(this);
            this.parameterRenderingMode = original;
            this.appendSql(" then ");
            resultRenderer.accept(whenFragment.getResult());
        }
        this.parameterRenderingMode = original;
        Expression otherwise = caseSimpleExpression.getOtherwise();
        if (otherwise != null) {
            this.appendSql(" else ");
            resultRenderer.accept(otherwise);
        }
        this.appendSql(" end");
    }

    protected boolean areAllResultsParameters(CaseSearchedExpression caseSearchedExpression) {
        List<CaseSearchedExpression.WhenFragment> whenFragments = caseSearchedExpression.getWhenFragments();
        Expression firstResult = whenFragments.get(0).getResult();
        if (this.isParameter(firstResult)) {
            for (int i = 1; i < whenFragments.size(); ++i) {
                if (this.isParameter(whenFragments.get(i).getResult())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean areAllResultsParameters(CaseSimpleExpression caseSimpleExpression) {
        List<CaseSimpleExpression.WhenFragment> whenFragments = caseSimpleExpression.getWhenFragments();
        Expression firstResult = whenFragments.get(0).getResult();
        if (this.isParameter(firstResult)) {
            for (int i = 1; i < whenFragments.size(); ++i) {
                if (this.isParameter(whenFragments.get(i).getResult())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void visitAny(Any any) {
        this.appendSql("any");
        any.getSubquery().accept(this);
    }

    @Override
    public void visitEvery(Every every) {
        this.appendSql("all");
        every.getSubquery().accept(this);
    }

    @Override
    public void visitSummarization(Summarization every) {
    }

    @Override
    public void visitJdbcLiteral(JdbcLiteral<?> jdbcLiteral) {
        this.visitLiteral(jdbcLiteral);
    }

    @Override
    public void visitQueryLiteral(QueryLiteral<?> queryLiteral) {
        this.visitLiteral(queryLiteral);
    }

    @Override
    public <N extends Number> void visitUnparsedNumericLiteral(UnparsedNumericLiteral<N> literal) {
        this.appendSql(literal.getUnparsedLiteralValue());
    }

    private void visitLiteral(Literal literal) {
        if (literal.getLiteralValue() == null) {
            this.renderNull(literal);
        } else {
            this.renderLiteral(literal, false);
        }
    }

    protected void renderNull(Literal literal) {
        if (this.getParameterRenderingMode() == SqlAstNodeRenderingMode.NO_UNTYPED) {
            this.renderCasted(literal);
        } else {
            this.appendSql("null");
        }
    }

    protected void renderAsLiteral(JdbcParameter jdbcParameter, Object literalValue) {
        if (literalValue == null) {
            this.renderNull(new QueryLiteral<Object>(null, (BasicValuedMapping)jdbcParameter.getExpressionType()));
        } else {
            assert (jdbcParameter.getExpressionType().getJdbcTypeCount() == 1);
            JdbcMapping jdbcMapping = jdbcParameter.getExpressionType().getSingleJdbcMapping();
            JdbcLiteralFormatter literalFormatter = jdbcMapping.getJdbcLiteralFormatter();
            if (literalFormatter == null) {
                throw new IllegalArgumentException("Can't render parameter as literal, no literal formatter found");
            }
            literalFormatter.appendJdbcLiteral(this, literalValue, this.dialect, this.getWrapperOptions());
        }
    }

    @Override
    public void visitUnaryOperationExpression(UnaryOperation unaryOperationExpression) {
        if (unaryOperationExpression.getOperator() == UnaryArithmeticOperator.UNARY_PLUS) {
            this.appendSql(UnaryArithmeticOperator.UNARY_PLUS.getOperatorChar());
        } else {
            this.appendSql(UnaryArithmeticOperator.UNARY_MINUS.getOperatorChar());
        }
        unaryOperationExpression.getOperand().accept(this);
    }

    @Override
    public void visitModifiedSubQueryExpression(ModifiedSubQueryExpression expression) {
        ModifiedSubQueryExpression.Modifier modifier = expression.getModifier();
        this.appendSql(modifier.getSqlName());
        this.appendSql(" ");
        expression.getSubQuery().accept(this);
    }

    @Override
    public void visitSelfRenderingPredicate(SelfRenderingPredicate selfRenderingPredicate) {
        selfRenderingPredicate.getSelfRenderingExpression().renderToSql(this, this, this.getSessionFactory());
    }

    @Override
    public void visitSelfRenderingExpression(SelfRenderingExpression expression) {
        expression.renderToSql(this, this, this.getSessionFactory());
    }

    @Override
    public void visitBooleanExpressionPredicate(BooleanExpressionPredicate booleanExpressionPredicate) {
        booleanExpressionPredicate.getExpression().accept(this);
        this.appendSql('=');
        if (booleanExpressionPredicate.isNegated()) {
            this.dialect.appendBooleanValueString(this, false);
        } else {
            this.dialect.appendBooleanValueString(this, true);
        }
    }

    @Override
    public void visitBetweenPredicate(BetweenPredicate betweenPredicate) {
        betweenPredicate.getExpression().accept(this);
        if (betweenPredicate.isNegated()) {
            this.appendSql(" not");
        }
        this.appendSql(" between ");
        betweenPredicate.getLowerBound().accept(this);
        this.appendSql(" and ");
        betweenPredicate.getUpperBound().accept(this);
    }

    @Override
    public void visitFilterPredicate(FilterPredicate filterPredicate) {
        List<FilterPredicate.FilterFragmentPredicate> filters = filterPredicate.getFragments();
        for (int i = 0; i < filters.size(); ++i) {
            FilterPredicate.FilterFragmentPredicate filter = filters.get(i);
            this.visitFilterFragmentPredicate(filter);
            if (i + 1 >= filters.size()) continue;
            this.appendSql(" and ");
        }
    }

    @Override
    public void visitFilterFragmentPredicate(FilterPredicate.FilterFragmentPredicate filter) {
        String sqlFragment = filter.getSqlFragment();
        if (filter.getParameters() == null) {
            this.sqlBuffer.append(sqlFragment);
            return;
        }
        int lastEnd = 0;
        for (int p = 0; p < filter.getParameters().size(); ++p) {
            FilterPredicate.FilterFragmentParameter parameter = filter.getParameters().get(p);
            lastEnd = this.processFilterParameter(parameter, sqlFragment, lastEnd);
        }
        if (lastEnd < sqlFragment.length()) {
            this.appendSql(sqlFragment.substring(lastEnd));
        }
    }

    private int processFilterParameter(FilterPredicate.FilterFragmentParameter parameter, String sqlFragment, int startPosition) {
        String marker = ":" + parameter.getFilterName() + "." + parameter.getParameterName();
        int markerStart = sqlFragment.indexOf(marker, startPosition);
        this.appendSql(sqlFragment.substring(startPosition, markerStart));
        Object value = parameter.getValue();
        JdbcMapping valueMapping = parameter.getValueMapping();
        if (value instanceof Iterable && !valueMapping.getJavaTypeDescriptor().isInstance(value)) {
            this.processIterableFilterParameterValue(valueMapping, ((Iterable)value).iterator());
        } else {
            this.processSingularFilterParameterValue(valueMapping, value);
        }
        return markerStart + marker.length();
    }

    private void processSingularFilterParameterValue(JdbcMapping valueMapping, Object value) {
        this.visitParameterAsParameter(new FilterJdbcParameter(valueMapping, value));
    }

    private void processIterableFilterParameterValue(JdbcMapping valueMapping, Iterator<?> iterator) {
        while (iterator.hasNext()) {
            Object element = iterator.next();
            this.processSingularFilterParameterValue(valueMapping, element);
            if (!iterator.hasNext()) continue;
            this.appendSql(",");
        }
    }

    @Override
    public void visitSqlFragmentPredicate(SqlFragmentPredicate predicate) {
        assert (StringHelper.isNotEmpty(predicate.getSqlFragment()));
        this.appendSql(predicate.getSqlFragment());
    }

    @Override
    public void visitGroupedPredicate(GroupedPredicate groupedPredicate) {
        if (groupedPredicate.isEmpty()) {
            return;
        }
        this.appendSql('(');
        groupedPredicate.getSubPredicate().accept(this);
        this.appendSql(')');
    }

    @Override
    public void visitInListPredicate(InListPredicate inListPredicate) {
        boolean parenthesis;
        int bindValueCount;
        List<Expression> listExpressions = inListPredicate.getListExpressions();
        if (listExpressions.isEmpty()) {
            this.appendSql("1=" + (inListPredicate.isNegated() ? "1" : "0"));
            return;
        }
        Function<Object, Object> itemAccessor = Function.identity();
        SqlTuple lhsTuple = SqlTupleContainer.getSqlTuple(inListPredicate.getTestExpression());
        if (lhsTuple != null) {
            if (lhsTuple.getExpressions().size() == 1) {
                if (SqlTupleContainer.getSqlTuple(listExpressions.get(0)) != null) {
                    itemAccessor = listExpression -> SqlTupleContainer.getSqlTuple(listExpression).getExpressions().get(0);
                }
            } else if (!this.supportsRowValueConstructorSyntaxInInList()) {
                if (this.supportsRowValueConstructorSyntaxInInSubQuery() && this.dialect.supportsUnionAll()) {
                    inListPredicate.getTestExpression().accept(this);
                    if (inListPredicate.isNegated()) {
                        this.appendSql(" not");
                    }
                    this.appendSql(" in (");
                    String separator = "";
                    for (Expression expression : listExpressions) {
                        this.appendSql(separator);
                        this.renderExpressionsAsSubquery(SqlTupleContainer.getSqlTuple(expression).getExpressions());
                        separator = " union all ";
                    }
                    this.appendSql(')');
                } else {
                    ComparisonOperator tupleComparisonOperator = inListPredicate.isNegated() ? ComparisonOperator.NOT_EQUAL : ComparisonOperator.EQUAL;
                    String expressionJunction = inListPredicate.isNegated() ? " and " : " or ";
                    this.appendSql('(');
                    String separator = "";
                    for (Expression expression : listExpressions) {
                        this.appendSql(separator);
                        this.emulateTupleComparison(lhsTuple.getExpressions(), SqlTupleContainer.getSqlTuple(expression).getExpressions(), tupleComparisonOperator, true);
                        separator = expressionJunction;
                    }
                    this.appendSql(')');
                }
                return;
            }
        }
        int bindValueCountWithPadding = bindValueCount = listExpressions.size();
        int inExprLimit = this.dialect.getInExpressionCountLimit();
        if (this.getSessionFactory().getSessionFactoryOptions().inClauseParameterPaddingEnabled()) {
            bindValueCountWithPadding = AbstractSqlAstTranslator.addPadding(bindValueCount, inExprLimit);
        }
        boolean bl = parenthesis = !inListPredicate.isNegated() && inExprLimit > 0 && listExpressions.size() > inExprLimit;
        if (parenthesis) {
            this.appendSql('(');
        }
        inListPredicate.getTestExpression().accept(this);
        if (inListPredicate.isNegated()) {
            this.appendSql(" not");
        }
        this.appendSql(" in (");
        String separator = "";
        Iterator<Expression> iterator = listExpressions.iterator();
        Expression listExpression2 = null;
        int clauseItemNumber = 0;
        int i = 0;
        while (i < bindValueCountWithPadding) {
            if (inExprLimit > 0 && inExprLimit == clauseItemNumber) {
                clauseItemNumber = 0;
                this.appendInClauseSeparator(inListPredicate);
                separator = "";
            }
            if (iterator.hasNext()) {
                listExpression2 = (Expression)itemAccessor.apply(iterator.next());
            }
            assert (listExpression2 != null);
            this.appendSql(separator);
            listExpression2.accept(this);
            separator = ",";
            if (!(listExpression2 instanceof JdbcParameter || listExpression2 instanceof SqmParameterInterpretation || listExpression2 instanceof Literal)) {
                inExprLimit = 0;
                bindValueCountWithPadding = bindValueCount;
            }
            ++i;
            ++clauseItemNumber;
        }
        this.appendSql(')');
        if (parenthesis) {
            this.appendSql(')');
        }
    }

    private void appendInClauseSeparator(InListPredicate inListPredicate) {
        this.appendSql(')');
        this.appendSql(inListPredicate.isNegated() ? " and " : " or ");
        inListPredicate.getTestExpression().accept(this);
        if (inListPredicate.isNegated()) {
            this.appendSql(" not");
        }
        this.appendSql(" in ");
        this.appendSql('(');
    }

    private static int addPadding(int bindValueCount, int inExprLimit) {
        int ceilingPowerOfTwo = MathHelper.ceilingPowerOfTwo(bindValueCount);
        if (inExprLimit <= 0 || ceilingPowerOfTwo <= inExprLimit) {
            return ceilingPowerOfTwo;
        }
        int numberOfInClauses = MathHelper.divideRoundingUp(bindValueCount, inExprLimit);
        int numberOfInClausesWithPadding = MathHelper.ceilingPowerOfTwo(numberOfInClauses);
        return numberOfInClausesWithPadding * inExprLimit;
    }

    @Override
    public void visitInArrayPredicate(InArrayPredicate inArrayPredicate) {
        this.sqlBuffer.append("array_contains(");
        inArrayPredicate.getArrayParameter().accept(this);
        this.sqlBuffer.append(",");
        inArrayPredicate.getTestExpression().accept(this);
        this.sqlBuffer.append(')');
    }

    @Override
    public void visitInSubQueryPredicate(InSubQueryPredicate inSubQueryPredicate) {
        SqlTuple lhsTuple = SqlTupleContainer.getSqlTuple(inSubQueryPredicate.getTestExpression());
        if (lhsTuple != null) {
            if (lhsTuple.getExpressions().size() == 1) {
                lhsTuple.getExpressions().get(0).accept(this);
                if (inSubQueryPredicate.isNegated()) {
                    this.appendSql(" not");
                }
                this.appendSql(" in ");
                inSubQueryPredicate.getSubQuery().accept(this);
            } else if (!this.supportsRowValueConstructorSyntaxInInSubQuery()) {
                this.emulateSubQueryRelationalRestrictionPredicate(inSubQueryPredicate, inSubQueryPredicate.isNegated(), inSubQueryPredicate.getSubQuery(), lhsTuple, this::renderSelectTupleComparison, ComparisonOperator.EQUAL);
            } else {
                inSubQueryPredicate.getTestExpression().accept(this);
                if (inSubQueryPredicate.isNegated()) {
                    this.appendSql(" not");
                }
                this.appendSql(" in ");
                inSubQueryPredicate.getSubQuery().accept(this);
            }
        } else {
            inSubQueryPredicate.getTestExpression().accept(this);
            if (inSubQueryPredicate.isNegated()) {
                this.appendSql(" not");
            }
            this.appendSql(" in ");
            inSubQueryPredicate.getSubQuery().accept(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected <X extends Expression> void emulateSubQueryRelationalRestrictionPredicate(Predicate predicate, boolean negated, SelectStatement selectStatement, X lhsTuple, SubQueryRelationalRestrictionEmulationRenderer<X> renderer, ComparisonOperator tupleComparisonOperator) {
        queryPart = selectStatement.getQueryPart();
        if (queryPart instanceof QuerySpec && queryPart.getFetchClauseExpression() == null && queryPart.getOffsetClauseExpression() == null) {
            subQuery = (QuerySpec)queryPart;
            if (negated) {
                this.appendSql("not ");
            }
            queryPartForRowNumbering = this.queryPartForRowNumbering;
            queryPartForRowNumberingClauseDepth = this.queryPartForRowNumberingClauseDepth;
            needsSelectAliases = this.needsSelectAliases;
            try {
                this.queryPartForRowNumbering = null;
                this.queryPartForRowNumberingClauseDepth = -1;
                this.needsSelectAliases = false;
                this.queryPartStack.push(subQuery);
                this.appendSql("exists (");
                if (!subQuery.getGroupByClauseExpressions().isEmpty() || subQuery.getHavingClauseRestrictions() != null) {
                    this.visitSelectClause(subQuery.getSelectClause());
                    this.visitFromClause(subQuery.getFromClause());
                    this.visitWhereClause(subQuery.getWhereClauseRestrictions());
                    this.visitGroupByClause(subQuery, SelectItemReferenceStrategy.EXPRESSION);
                    this.appendSql(" having ");
                    this.clauseStack.push(Clause.HAVING);
                    try {
                        renderer.renderComparison(subQuery.getSelectClause().getSqlSelections(), lhsTuple, tupleComparisonOperator);
                        havingClauseRestrictions = subQuery.getHavingClauseRestrictions();
                        if (havingClauseRestrictions == null) ** GOTO lbl50
                        this.appendSql(" and (");
                        havingClauseRestrictions.accept(this);
                        this.appendSql(')');
                    }
                    finally {
                        this.clauseStack.pop();
                    }
                } else {
                    this.appendSql("select 1");
                    this.visitFromClause(subQuery.getFromClause());
                    this.appendSql(" where ");
                    this.clauseStack.push(Clause.WHERE);
                    try {
                        renderer.renderComparison(subQuery.getSelectClause().getSqlSelections(), lhsTuple, tupleComparisonOperator);
                        whereClauseRestrictions = subQuery.getWhereClauseRestrictions();
                        if (whereClauseRestrictions != null) {
                            this.appendSql(" and (");
                            whereClauseRestrictions.accept(this);
                            this.appendSql(')');
                        }
                    }
                    finally {
                        this.clauseStack.pop();
                    }
                }
                this.appendSql(')');
            }
            finally {
                this.queryPartStack.pop();
                this.queryPartForRowNumbering = queryPartForRowNumbering;
                this.queryPartForRowNumberingClauseDepth = queryPartForRowNumberingClauseDepth;
                this.needsSelectAliases = needsSelectAliases;
            }
        }
        throw new IllegalArgumentException("Can't emulate IN predicate with tuples and limit/offset or set operations: " + String.valueOf(predicate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void emulateQuantifiedTupleSubQueryPredicate(Predicate predicate, SelectStatement selectStatement, SqlTuple lhsTuple, ComparisonOperator tupleComparisonOperator) {
        QueryPart queryPart = selectStatement.getQueryPart();
        if (queryPart instanceof QuerySpec && queryPart.getFetchClauseExpression() == null && queryPart.getOffsetClauseExpression() == null) {
            QuerySpec subQuery = (QuerySpec)queryPart;
            lhsTuple.accept(this);
            this.appendSql(tupleComparisonOperator.sqlText());
            QueryPart queryPartForRowNumbering = this.queryPartForRowNumbering;
            int queryPartForRowNumberingClauseDepth = this.queryPartForRowNumberingClauseDepth;
            boolean needsSelectAliases = this.needsSelectAliases;
            try {
                this.queryPartForRowNumbering = null;
                this.queryPartForRowNumberingClauseDepth = -1;
                this.needsSelectAliases = false;
                this.queryPartStack.push(subQuery);
                this.appendSql('(');
                this.visitSelectClause(subQuery.getSelectClause());
                this.visitFromClause(subQuery.getFromClause());
                this.visitWhereClause(subQuery.getWhereClauseRestrictions());
                this.visitGroupByClause(subQuery, this.dialect.getGroupBySelectItemReferenceStrategy());
                this.visitHavingClause(subQuery);
                this.appendSql(" order by ");
                List<SqlSelection> sqlSelections = subQuery.getSelectClause().getSqlSelections();
                String order = tupleComparisonOperator == ComparisonOperator.LESS_THAN || tupleComparisonOperator == ComparisonOperator.LESS_THAN_OR_EQUAL ? "" : " desc";
                this.appendSql('1');
                this.appendSql(order);
                for (int i = 1; i < sqlSelections.size(); ++i) {
                    this.appendSql(',');
                    this.appendSql(i + 1);
                    this.appendSql(order);
                }
                this.renderFetch(new QueryLiteral<Integer>(1, this.getIntegerType()), null, FetchClauseType.ROWS_ONLY);
                this.appendSql(')');
            }
            finally {
                this.queryPartStack.pop();
                this.queryPartForRowNumbering = queryPartForRowNumbering;
                this.queryPartForRowNumberingClauseDepth = queryPartForRowNumberingClauseDepth;
                this.needsSelectAliases = needsSelectAliases;
            }
        } else {
            throw new IllegalArgumentException("Can't emulate in predicate with tuples and limit/offset or set operations: " + String.valueOf(predicate));
        }
    }

    @Override
    public void visitExistsPredicate(ExistsPredicate existsPredicate) {
        if (existsPredicate.isNegated()) {
            this.appendSql("not ");
        }
        this.appendSql("exists");
        existsPredicate.getExpression().accept(this);
    }

    @Override
    public void visitJunction(Junction junction) {
        if (junction.isEmpty()) {
            return;
        }
        Junction.Nature nature = junction.getNature();
        String separator = nature == Junction.Nature.CONJUNCTION ? " and " : " or ";
        List<Predicate> predicates = junction.getPredicates();
        this.visitJunctionPredicate(nature, predicates.get(0));
        for (int i = 1; i < predicates.size(); ++i) {
            this.appendSql(separator);
            this.visitJunctionPredicate(nature, predicates.get(i));
        }
    }

    private void visitJunctionPredicate(Junction.Nature nature, Predicate p) {
        if (p instanceof Junction) {
            Junction junction = (Junction)p;
            if (nature == junction.getNature() || nature == Junction.Nature.DISJUNCTION) {
                p.accept(this);
            } else {
                this.appendSql('(');
                p.accept(this);
                this.appendSql(')');
            }
        } else {
            p.accept(this);
        }
    }

    @Override
    public void visitLikePredicate(LikePredicate likePredicate) {
        if (likePredicate.isCaseSensitive()) {
            likePredicate.getMatchExpression().accept(this);
            if (likePredicate.isNegated()) {
                this.appendSql(" not");
            }
            this.appendSql(" like ");
            likePredicate.getPattern().accept(this);
            if (likePredicate.getEscapeCharacter() != null) {
                this.appendSql(" escape ");
                likePredicate.getEscapeCharacter().accept(this);
            }
        } else if (this.dialect.supportsCaseInsensitiveLike()) {
            likePredicate.getMatchExpression().accept(this);
            if (likePredicate.isNegated()) {
                this.appendSql(" not");
            }
            this.appendSql(' ');
            this.appendSql(this.dialect.getCaseInsensitiveLike());
            this.appendSql(' ');
            likePredicate.getPattern().accept(this);
            if (likePredicate.getEscapeCharacter() != null) {
                this.appendSql(" escape ");
                likePredicate.getEscapeCharacter().accept(this);
            }
        } else {
            this.renderCaseInsensitiveLikeEmulation(likePredicate.getMatchExpression(), likePredicate.getPattern(), likePredicate.getEscapeCharacter(), likePredicate.isNegated());
        }
    }

    protected void renderCaseInsensitiveLikeEmulation(Expression lhs, Expression rhs, Expression escapeCharacter, boolean negated) {
        this.appendSql(this.dialect.getLowercaseFunction());
        this.appendSql('(');
        lhs.accept(this);
        this.appendSql(')');
        if (negated) {
            this.appendSql(" not");
        }
        this.appendSql(" like ");
        this.appendSql(this.dialect.getLowercaseFunction());
        this.appendSql('(');
        rhs.accept(this);
        this.appendSql(')');
        if (escapeCharacter != null) {
            this.appendSql(" escape ");
            escapeCharacter.accept(this);
        }
    }

    protected void renderBackslashEscapedLikePattern(Expression pattern, Expression escapeCharacter, boolean noBackslashEscapes) {
        Object literalValue;
        boolean isExplicitEscape = false;
        if (escapeCharacter instanceof Literal) {
            literalValue = ((Literal)escapeCharacter).getLiteralValue();
            boolean bl = isExplicitEscape = literalValue != null && !literalValue.toString().equals("");
        }
        if (isExplicitEscape) {
            pattern.accept(this);
        } else if (pattern instanceof Literal) {
            literalValue = ((Literal)pattern).getLiteralValue();
            if (literalValue == null) {
                pattern.accept(this);
            } else {
                this.appendBackslashEscapedLikeLiteral(this, literalValue.toString(), noBackslashEscapes);
            }
        } else {
            this.appendSql("replace");
            this.appendSql('(');
            pattern.accept(this);
            if (noBackslashEscapes) {
                this.appendSql(",'\\','\\\\'");
            } else {
                this.appendSql(",'\\\\','\\\\\\\\'");
            }
            this.appendSql(')');
        }
    }

    protected void appendBackslashEscapedLikeLiteral(SqlAppender appender, String literal, boolean noBackslashEscapes) {
        appender.appendSql('\'');
        for (int i = 0; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            switch (c) {
                case '\'': {
                    appender.appendSql('\'');
                    break;
                }
                case '\\': {
                    if (noBackslashEscapes) {
                        appender.appendSql('\\');
                        break;
                    }
                    appender.appendSql("\\\\\\");
                }
            }
            appender.appendSql(c);
        }
        appender.appendSql('\'');
    }

    @Override
    public void visitNegatedPredicate(NegatedPredicate negatedPredicate) {
        if (negatedPredicate.isEmpty()) {
            return;
        }
        this.appendSql("not(");
        negatedPredicate.getPredicate().accept(this);
        this.appendSql(')');
    }

    @Override
    public void visitNullnessPredicate(NullnessPredicate nullnessPredicate) {
        Expression expression = nullnessPredicate.getExpression();
        String predicateValue = nullnessPredicate.isNegated() ? " is not null" : " is null";
        SqlTuple tuple = SqlTupleContainer.getSqlTuple(expression);
        if (tuple != null) {
            String separator = "";
            if (nullnessPredicate.isNegated() && expression.getExpressionType() instanceof AttributeMapping) {
                this.appendSql('(');
                for (Expression expression2 : tuple.getExpressions()) {
                    this.appendSql(separator);
                    expression2.accept(this);
                    this.appendSql(predicateValue);
                    separator = " or ";
                }
                this.appendSql(')');
            } else {
                for (Expression expression3 : tuple.getExpressions()) {
                    this.appendSql(separator);
                    expression3.accept(this);
                    this.appendSql(predicateValue);
                    separator = " and ";
                }
            }
            return;
        }
        expression.accept(this);
        this.appendSql(predicateValue);
    }

    @Override
    public void visitThruthnessPredicate(ThruthnessPredicate thruthnessPredicate) {
        if (this.dialect.supportsIsTrue()) {
            thruthnessPredicate.getExpression().accept(this);
            this.appendSql(" is ");
            if (thruthnessPredicate.isNegated()) {
                this.appendSql("not ");
            }
            this.appendSql(thruthnessPredicate.getBooleanValue());
        } else {
            String literalTrue = this.dialect.toBooleanValueString(true);
            String literalFalse = this.dialect.toBooleanValueString(false);
            this.appendSql("(case ");
            thruthnessPredicate.getExpression().accept(this);
            this.appendSql(" when ");
            this.appendSql(thruthnessPredicate.getBooleanValue() ? literalTrue : literalFalse);
            this.appendSql(" then ");
            this.appendSql(thruthnessPredicate.isNegated() ? literalFalse : literalTrue);
            this.appendSql(" when ");
            this.appendSql(thruthnessPredicate.getBooleanValue() ? literalFalse : literalTrue);
            this.appendSql(" then ");
            this.appendSql(thruthnessPredicate.isNegated() ? literalTrue : literalFalse);
            this.appendSql(" else ");
            this.appendSql(thruthnessPredicate.isNegated() ? literalTrue : literalFalse);
            this.appendSql(" end = ");
            this.appendSql(literalTrue);
            this.appendSql(")");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visitRelationalPredicate(ComparisonPredicate comparisonPredicate) {
        SqlTuple lhsTuple = SqlTupleContainer.getSqlTuple(comparisonPredicate.getLeftHandExpression());
        if (lhsTuple != null) {
            boolean all;
            SelectStatement subquery;
            Expression rhsExpression = comparisonPredicate.getRightHandExpression();
            if (rhsExpression instanceof SelectStatement) {
                subquery = (SelectStatement)rhsExpression;
                all = true;
            } else if (rhsExpression instanceof Every) {
                subquery = ((Every)rhsExpression).getSubquery();
                all = true;
            } else if (rhsExpression instanceof Any) {
                subquery = ((Any)rhsExpression).getSubquery();
                all = false;
            } else {
                subquery = null;
                all = false;
            }
            ComparisonOperator operator = comparisonPredicate.getOperator();
            if (lhsTuple.getExpressions().size() == 1) {
                SqlTuple rhsTuple;
                if (subquery == null && (rhsTuple = SqlTupleContainer.getSqlTuple(comparisonPredicate.getRightHandExpression())) != null) {
                    this.renderComparison(lhsTuple.getExpressions().get(0), operator, rhsTuple.getExpressions().get(0));
                    return;
                } else {
                    this.renderComparison(lhsTuple.getExpressions().get(0), operator, rhsExpression);
                }
                return;
            } else if (subquery != null && !this.supportsRowValueConstructorSyntaxInQuantifiedPredicates()) {
                if (!this.needsTupleComparisonEmulation(operator) && all) {
                    switch (operator) {
                        case LESS_THAN_OR_EQUAL: 
                        case GREATER_THAN_OR_EQUAL: 
                        case LESS_THAN: 
                        case GREATER_THAN: {
                            this.emulateQuantifiedTupleSubQueryPredicate(comparisonPredicate, subquery, lhsTuple, operator);
                            return;
                        }
                        case DISTINCT_FROM: 
                        case NOT_DISTINCT_FROM: 
                        case EQUAL: 
                        case NOT_EQUAL: {
                            if (!this.isFetchFirstRowOnly(subquery.getQueryPart())) break;
                            this.renderComparison(lhsTuple, operator, subquery);
                            return;
                        }
                    }
                }
                this.emulateSubQueryRelationalRestrictionPredicate(comparisonPredicate, all, subquery, lhsTuple, this::renderSelectTupleComparison, all ? operator.negated() : operator);
                return;
            } else if (this.needsTupleComparisonEmulation(operator)) {
                SqlTuple rhsTuple = SqlTupleContainer.getSqlTuple(rhsExpression);
                assert (rhsTuple != null);
                if ((operator == ComparisonOperator.EQUAL || operator == ComparisonOperator.NOT_EQUAL) && this.supportsRowValueConstructorSyntaxInInList()) {
                    comparisonPredicate.getLeftHandExpression().accept(this);
                    if (operator == ComparisonOperator.NOT_EQUAL) {
                        this.appendSql(" not");
                    }
                    this.appendSql(" in (");
                    rhsTuple.accept(this);
                    this.appendSql(')');
                    return;
                } else {
                    this.emulateTupleComparison(lhsTuple.getExpressions(), rhsTuple.getExpressions(), operator, true);
                }
                return;
            } else {
                this.renderComparison(comparisonPredicate.getLeftHandExpression(), operator, rhsExpression);
            }
            return;
        } else {
            SqlTuple rhsTuple = SqlTupleContainer.getSqlTuple(comparisonPredicate.getRightHandExpression());
            if (rhsTuple != null) {
                Expression lhsExpression = comparisonPredicate.getLeftHandExpression();
                if (!(lhsExpression instanceof SqlTupleContainer) && (!(lhsExpression instanceof SelectStatement) || !(((SelectStatement)lhsExpression).getQueryPart() instanceof QueryGroup))) throw new IllegalStateException("Unsupported tuple comparison combination. LHS is neither a tuple nor a tuple subquery but RHS is a tuple: " + String.valueOf(comparisonPredicate));
                if (rhsTuple.getExpressions().size() == 1) {
                    this.renderComparison(lhsExpression, comparisonPredicate.getOperator(), rhsTuple.getExpressions().get(0));
                    return;
                } else if (!this.needsTupleComparisonEmulation(comparisonPredicate.getOperator())) {
                    this.renderComparison(lhsExpression, comparisonPredicate.getOperator(), comparisonPredicate.getRightHandExpression());
                    return;
                } else {
                    this.emulateSubQueryRelationalRestrictionPredicate(comparisonPredicate, false, (SelectStatement)lhsExpression, rhsTuple, this::renderSelectTupleComparison, comparisonPredicate.getOperator().invert());
                }
                return;
            } else {
                this.renderComparison(comparisonPredicate.getLeftHandExpression(), comparisonPredicate.getOperator(), comparisonPredicate.getRightHandExpression());
            }
        }
    }

    private boolean needsTupleComparisonEmulation(ComparisonOperator operator) {
        if (!this.supportsRowValueConstructorSyntax()) {
            return true;
        }
        switch (operator) {
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: 
            case GREATER_THAN: {
                return !this.supportsRowValueConstructorGtLtSyntax();
            }
            case DISTINCT_FROM: 
            case NOT_DISTINCT_FROM: {
                return !this.supportsRowValueConstructorDistinctFromSyntax();
            }
        }
        return false;
    }

    protected boolean supportsQuantifiedPredicates() {
        return true;
    }

    protected boolean supportsDistinctFromPredicate() {
        return this.dialect.supportsDistinctFromPredicate();
    }

    protected boolean supportsRowValueConstructorSyntax() {
        return true;
    }

    protected boolean supportsRowValueConstructorGtLtSyntax() {
        return this.supportsRowValueConstructorSyntax();
    }

    protected boolean supportsRowValueConstructorDistinctFromSyntax() {
        return this.supportsRowValueConstructorSyntax() && this.supportsDistinctFromPredicate();
    }

    protected boolean supportsRowValueConstructorSyntaxInSet() {
        return this.supportsRowValueConstructorSyntax();
    }

    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return true;
    }

    protected boolean supportsRowValueConstructorSyntaxInInList() {
        return true;
    }

    protected boolean supportsRowValueConstructorSyntaxInInSubQuery() {
        return this.supportsRowValueConstructorSyntaxInInList();
    }

    protected boolean supportsJoinInMutationStatementSubquery() {
        return true;
    }

    @Deprecated(forRemoval=true)
    protected String getFromDual() {
        return " from " + this.getDual() + " d_";
    }

    protected String getDual() {
        return this.dialect.getDual();
    }

    protected String getFromDualForSelectOnly() {
        return this.dialect.getFromDualForSelectOnly();
    }

    private T translateTableMutation(TableMutation<?> mutation) {
        mutation.accept(this);
        return (T)((JdbcOperation)mutation.createMutationOperation(this.getSql(), this.parameterBinders));
    }

    @Override
    public void visitStandardTableInsert(TableInsertStandard tableInsert) {
        this.getCurrentClauseStack().push(Clause.INSERT);
        try {
            this.renderInsertInto(tableInsert);
            if (tableInsert.getNumberOfReturningColumns() > 0) {
                this.visitReturningColumns(tableInsert::getReturningColumns);
            }
        }
        finally {
            this.getCurrentClauseStack().pop();
        }
    }

    private void renderInsertInto(TableInsertStandard tableInsert) {
        this.applySqlComment(tableInsert.getMutationComment());
        if (tableInsert.getNumberOfValueBindings() == 0) {
            this.renderInsertIntoNoColumns(tableInsert);
            return;
        }
        this.renderIntoIntoAndTable(tableInsert);
        tableInsert.forEachValueBinding((columnPosition, columnValueBinding) -> {
            if (columnPosition == 0) {
                this.sqlBuffer.append('(');
            } else {
                this.sqlBuffer.append(',');
            }
            this.sqlBuffer.append(columnValueBinding.getColumnReference().getColumnExpression());
        });
        this.getCurrentClauseStack().push(Clause.VALUES);
        try {
            this.sqlBuffer.append(") values (");
            tableInsert.forEachValueBinding((columnPosition, columnValueBinding) -> {
                if (columnPosition > 0) {
                    this.sqlBuffer.append(',');
                }
                columnValueBinding.getValueExpression().accept(this);
            });
        }
        finally {
            this.getCurrentClauseStack().pop();
        }
        this.sqlBuffer.append(")");
    }

    protected void renderIntoIntoAndTable(TableInsertStandard tableInsert) {
        this.sqlBuffer.append("insert into ");
        this.appendSql(tableInsert.getMutatingTable().getTableName());
        this.registerAffectedTable(tableInsert.getMutatingTable().getTableName());
        this.sqlBuffer.append(' ');
    }

    protected void renderInsertIntoNoColumns(TableInsertStandard tableInsert) {
        this.renderIntoIntoAndTable(tableInsert);
        this.sqlBuffer.append(this.dialect.getNoColumnsInsertString());
    }

    @Override
    public void visitCustomTableInsert(TableInsertCustomSql tableInsert) {
        assert (this.sqlBuffer.toString().isEmpty());
        this.sqlBuffer.append(tableInsert.getCustomSql());
        tableInsert.forEachParameter(this::applyParameter);
    }

    @Override
    public void visitStandardTableUpdate(TableUpdateStandard tableUpdate) {
        this.getCurrentClauseStack().push(Clause.UPDATE);
        try {
            this.visitTableUpdate(tableUpdate);
            if (tableUpdate.getWhereFragment() != null) {
                this.sqlBuffer.append(" and (").append(tableUpdate.getWhereFragment()).append(")");
            }
            if (tableUpdate.getNumberOfReturningColumns() > 0) {
                this.visitReturningColumns(tableUpdate::getReturningColumns);
            }
        }
        finally {
            this.getCurrentClauseStack().pop();
        }
    }

    @Override
    public void visitOptionalTableUpdate(OptionalTableUpdate tableUpdate) {
        this.getCurrentClauseStack().push(Clause.UPDATE);
        try {
            this.visitTableUpdate(tableUpdate);
        }
        finally {
            this.getCurrentClauseStack().pop();
        }
    }

    private void visitTableUpdate(RestrictedTableMutation<? extends MutationOperation> tableUpdate) {
        this.applySqlComment(tableUpdate.getMutationComment());
        this.sqlBuffer.append("update ");
        this.appendSql(tableUpdate.getMutatingTable().getTableName());
        this.registerAffectedTable(tableUpdate.getMutatingTable().getTableName());
        this.getCurrentClauseStack().push(Clause.SET);
        try {
            this.sqlBuffer.append(" set");
            tableUpdate.forEachValueBinding((columnPosition, columnValueBinding) -> {
                if (columnPosition == 0) {
                    this.sqlBuffer.append(' ');
                } else {
                    this.sqlBuffer.append(',');
                }
                this.sqlBuffer.append(columnValueBinding.getColumnReference().getColumnExpression());
                this.sqlBuffer.append('=');
                columnValueBinding.getValueExpression().accept(this);
            });
        }
        finally {
            this.getCurrentClauseStack().pop();
        }
        this.getCurrentClauseStack().push(Clause.WHERE);
        try {
            this.sqlBuffer.append(" where");
            tableUpdate.forEachKeyBinding((position, columnValueBinding) -> {
                if (position == 0) {
                    this.sqlBuffer.append(' ');
                } else {
                    this.sqlBuffer.append(" and ");
                }
                this.sqlBuffer.append(columnValueBinding.getColumnReference().getColumnExpression());
                this.sqlBuffer.append('=');
                columnValueBinding.getValueExpression().accept(this);
            });
            if (tableUpdate.getNumberOfOptimisticLockBindings() > 0) {
                tableUpdate.forEachOptimisticLockBinding((position, columnValueBinding) -> {
                    this.sqlBuffer.append(" and ");
                    this.sqlBuffer.append(columnValueBinding.getColumnReference().getColumnExpression());
                    if (columnValueBinding.getValueExpression() == null) {
                        this.sqlBuffer.append(" is null");
                    } else {
                        this.sqlBuffer.append("=");
                        columnValueBinding.getValueExpression().accept(this);
                    }
                });
            }
        }
        finally {
            this.getCurrentClauseStack().pop();
        }
    }

    private void applySqlComment(String comment) {
        if (this.sessionFactory.getSessionFactoryOptions().isCommentsEnabled() && comment != null) {
            this.appendSql("/* ");
            this.appendSql(Dialect.escapeComment(comment));
            this.appendSql(" */");
        }
    }

    @Override
    public void visitCustomTableUpdate(TableUpdateCustomSql tableUpdate) {
        assert (this.sqlBuffer.toString().isEmpty());
        this.sqlBuffer.append(tableUpdate.getCustomSql());
        tableUpdate.forEachParameter(this::applyParameter);
    }

    @Override
    public void visitStandardTableDelete(TableDeleteStandard tableDelete) {
        this.getCurrentClauseStack().push(Clause.DELETE);
        try {
            this.applySqlComment(tableDelete.getMutationComment());
            this.sqlBuffer.append("delete from ");
            this.appendSql(tableDelete.getMutatingTable().getTableName());
            this.registerAffectedTable(tableDelete.getMutatingTable().getTableName());
            this.getCurrentClauseStack().push(Clause.WHERE);
            try {
                this.sqlBuffer.append(" where ");
                tableDelete.forEachKeyBinding((columnPosition, columnValueBinding) -> {
                    this.sqlBuffer.append(columnValueBinding.getColumnReference().getColumnExpression());
                    this.sqlBuffer.append("=");
                    columnValueBinding.getValueExpression().accept(this);
                    if (columnPosition < tableDelete.getNumberOfKeyBindings() - 1) {
                        this.sqlBuffer.append(" and ");
                    }
                });
                if (tableDelete.getNumberOfOptimisticLockBindings() > 0) {
                    this.sqlBuffer.append(" and ");
                    tableDelete.forEachOptimisticLockBinding((columnPosition, columnValueBinding) -> {
                        this.sqlBuffer.append(columnValueBinding.getColumnReference().getColumnExpression());
                        if (columnValueBinding.getValueExpression() == null) {
                            this.sqlBuffer.append(" is null");
                        } else {
                            this.sqlBuffer.append("=");
                            columnValueBinding.getValueExpression().accept(this);
                        }
                        if (columnPosition < tableDelete.getNumberOfOptimisticLockBindings() - 1) {
                            this.sqlBuffer.append(" and ");
                        }
                    });
                }
                if (tableDelete.getWhereFragment() != null) {
                    this.sqlBuffer.append(" and (").append(tableDelete.getWhereFragment()).append(")");
                }
            }
            finally {
                this.getCurrentClauseStack().pop();
            }
        }
        finally {
            this.getCurrentClauseStack().pop();
        }
    }

    @Override
    public void visitCustomTableDelete(TableDeleteCustomSql tableDelete) {
        assert (this.sqlBuffer.toString().isEmpty());
        this.sqlBuffer.append(tableDelete.getCustomSql());
        tableDelete.forEachParameter(this::applyParameter);
    }

    protected void applyParameter(ColumnValueParameter parameter) {
        assert (parameter != null);
        this.parameterBinders.add(parameter.getParameterBinder());
        this.jdbcParameters.addParameter(parameter);
    }

    @Override
    public void visitColumnWriteFragment(ColumnWriteFragment columnWriteFragment) {
        if (CollectionHelper.isEmpty(columnWriteFragment.getParameters()) || ParameterMarkerStrategyStandard.isStandardRenderer(this.parameterMarkerStrategy)) {
            this.simpleColumnWriteFragmentRendering(columnWriteFragment);
            return;
        }
        String sqlFragment = columnWriteFragment.getFragment();
        int lastEnd = 0;
        for (ColumnValueParameter parameter : columnWriteFragment.getParameters()) {
            int markerStart = sqlFragment.indexOf(63, lastEnd);
            this.appendSql(sqlFragment.substring(lastEnd, markerStart));
            this.visitParameterAsParameter(parameter);
            lastEnd = markerStart + 1;
        }
        if (lastEnd < sqlFragment.length()) {
            this.appendSql(sqlFragment.substring(lastEnd));
        }
    }

    protected void simpleColumnWriteFragmentRendering(ColumnWriteFragment columnWriteFragment) {
        this.appendSql(columnWriteFragment.getFragment());
        for (ColumnValueParameter parameter : columnWriteFragment.getParameters()) {
            this.parameterBinders.add(parameter.getParameterBinder());
            this.jdbcParameters.addParameter(parameter);
        }
    }

    protected static class ForUpdateClause {
        private LockMode lockMode;
        private int timeoutMillis = -1;
        private Map<String, String[]> keyColumnNames;
        private Map<String, String> aliases;

        public ForUpdateClause(LockMode lockMode) {
            this.lockMode = lockMode;
        }

        public ForUpdateClause() {
            this.lockMode = LockMode.NONE;
        }

        public void applyAliases(RowLockStrategy lockIdentifier, QuerySpec querySpec) {
            if (lockIdentifier != RowLockStrategy.NONE) {
                querySpec.getFromClause().visitTableGroups(tableGroup -> this.applyAliases(lockIdentifier, (TableGroup)tableGroup));
            }
        }

        public void applyAliases(RowLockStrategy lockIdentifier, TableGroup tableGroup) {
            if (this.aliases != null && lockIdentifier != RowLockStrategy.NONE) {
                String tableAlias = tableGroup.getPrimaryTableReference().getIdentificationVariable();
                if (this.aliases.containsKey(tableGroup.getSourceAlias())) {
                    this.addAlias(tableGroup.getSourceAlias(), tableAlias);
                    if (lockIdentifier == RowLockStrategy.COLUMN) {
                        this.addKeyColumnNames(tableGroup);
                    }
                }
            }
        }

        public LockMode getLockMode() {
            return this.lockMode;
        }

        public void setLockMode(LockMode lockMode) {
            if (this.lockMode != LockMode.NONE && lockMode != this.lockMode) {
                throw new QueryException("Mixed LockModes");
            }
            this.lockMode = lockMode;
        }

        public void addKeyColumnNames(TableGroup tableGroup) {
            String[] keyColumnNames = this.determineKeyColumnNames(tableGroup.getModelPart());
            if (keyColumnNames == null) {
                throw new IllegalArgumentException("Can't lock table group: " + String.valueOf(tableGroup));
            }
            this.addKeyColumnNames(tableGroup.getSourceAlias(), tableGroup.getPrimaryTableReference().getIdentificationVariable(), keyColumnNames);
        }

        private String[] determineKeyColumnNames(ModelPart modelPart) {
            if (modelPart instanceof Loadable) {
                return ((Loadable)modelPart).getIdentifierColumnNames();
            }
            if (modelPart instanceof PluralAttributeMapping) {
                return ((PluralAttributeMapping)modelPart).getCollectionDescriptor().getKeyColumnAliases(null);
            }
            if (modelPart instanceof EntityAssociationMapping) {
                return this.determineKeyColumnNames(((EntityAssociationMapping)modelPart).getAssociatedEntityMappingType());
            }
            return null;
        }

        private void addKeyColumnNames(String alias, String tableAlias, String[] keyColumnNames) {
            if (this.keyColumnNames == null) {
                this.keyColumnNames = new HashMap<String, String[]>();
            }
            this.keyColumnNames.put(tableAlias, keyColumnNames);
        }

        public boolean hasAlias(String alias) {
            return this.aliases != null && this.aliases.containsKey(alias);
        }

        private void addAlias(String alias, String tableAlias) {
            if (this.aliases == null) {
                this.aliases = new HashMap<String, String>();
            }
            this.aliases.put(alias, tableAlias);
        }

        public int getTimeoutMillis() {
            return this.timeoutMillis;
        }

        public boolean hasAliases() {
            return this.aliases != null;
        }

        public void appendAliases(SqlAppender appender) {
            if (this.aliases == null) {
                return;
            }
            if (this.keyColumnNames != null) {
                boolean first = true;
                for (String tableAlias : this.aliases.values()) {
                    String[] keyColumns = this.keyColumnNames.get(tableAlias);
                    if (keyColumns == null) {
                        throw new IllegalArgumentException("alias not found: " + tableAlias);
                    }
                    for (String keyColumn : keyColumns) {
                        if (first) {
                            first = false;
                        } else {
                            appender.appendSql(',');
                        }
                        appender.appendSql(tableAlias);
                        appender.appendSql('.');
                        appender.appendSql(keyColumn);
                    }
                }
            } else {
                boolean first = true;
                for (String tableAlias : this.aliases.values()) {
                    if (first) {
                        first = false;
                    } else {
                        appender.appendSql(',');
                    }
                    appender.appendSql(tableAlias);
                }
            }
        }

        public String getAliases() {
            if (this.aliases == null) {
                return null;
            }
            return this.aliases.toString();
        }

        public void merge(LockOptions lockOptions) {
            if (lockOptions != null) {
                LockMode upgradeType = LockMode.NONE;
                if (lockOptions.getAliasLockCount() == 0) {
                    upgradeType = lockOptions.getLockMode();
                } else {
                    for (Map.Entry<String, LockMode> entry : lockOptions.getAliasSpecificLocks()) {
                        LockMode lockMode = entry.getValue();
                        if (!LockMode.READ.lessThan(lockMode)) continue;
                        this.addAlias(entry.getKey(), null);
                        if (upgradeType != LockMode.NONE && lockMode != upgradeType) {
                            throw new QueryException("Mixed LockModes");
                        }
                        upgradeType = lockMode;
                    }
                }
                this.lockMode = upgradeType;
                this.timeoutMillis = lockOptions.getTimeOut();
            }
        }
    }

    protected static enum LockStrategy {
        CLAUSE,
        FOLLOW_ON,
        NONE;

    }

    protected static interface SubQueryRelationalRestrictionEmulationRenderer<X extends Expression> {
        public void renderComparison(List<SqlSelection> var1, X var2, ComparisonOperator var3);
    }

    private static class OffsetReceivingParameterBinder
    implements JdbcParameterBinder {
        private final JdbcParameter offsetParameter;
        private final JdbcParameter fetchParameter;
        private final int staticOffset;
        private Number dynamicOffset;

        public OffsetReceivingParameterBinder(JdbcParameter offsetParameter, JdbcParameter fetchParameter, int staticOffset) {
            this.offsetParameter = offsetParameter;
            this.fetchParameter = fetchParameter;
            this.staticOffset = staticOffset;
        }

        @Override
        public void bindParameterValue(PreparedStatement statement, int startPosition, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) throws SQLException {
            int offsetValue;
            Number bindValue;
            if (this.fetchParameter instanceof LimitJdbcParameter) {
                bindValue = executionContext.getQueryOptions().getEffectiveLimit().getMaxRows();
            } else {
                JdbcParameterBinding binding = jdbcParameterBindings.getBinding(this.fetchParameter);
                if (binding == null) {
                    throw new ExecutionException("JDBC parameter value not bound - " + String.valueOf(this.fetchParameter));
                }
                bindValue = (Number)binding.getBindValue();
            }
            if (this.offsetParameter instanceof OffsetJdbcParameter) {
                offsetValue = executionContext.getQueryOptions().getEffectiveLimit().getFirstRow();
            } else {
                offsetValue = this.dynamicOffset.intValue() + this.staticOffset;
                this.dynamicOffset = null;
            }
            this.fetchParameter.getExpressionType().getSingleJdbcMapping().getJdbcValueBinder().bind(statement, Integer.valueOf(bindValue.intValue() + offsetValue), startPosition, (WrapperOptions)executionContext.getSession());
        }
    }

    private static enum LockKind {
        NONE,
        SHARE,
        UPDATE;

    }

    private static class LimitJdbcParameter
    extends AbstractJdbcParameter {
        public LimitJdbcParameter(BasicType<Integer> type) {
            super(type);
        }

        @Override
        public void bindParameterValue(PreparedStatement statement, int startPosition, JdbcParameterBindings jdbcParamBindings, ExecutionContext executionContext) throws SQLException {
            this.getJdbcMapping().getJdbcValueBinder().bind(statement, executionContext.getQueryOptions().getLimit().getMaxRows(), startPosition, (WrapperOptions)executionContext.getSession());
        }
    }

    private static class OffsetJdbcParameter
    extends AbstractJdbcParameter {
        public OffsetJdbcParameter(BasicType<Integer> type) {
            super(type);
        }

        @Override
        public void bindParameterValue(PreparedStatement statement, int startPosition, JdbcParameterBindings jdbcParamBindings, ExecutionContext executionContext) throws SQLException {
            this.getJdbcMapping().getJdbcValueBinder().bind(statement, executionContext.getQueryOptions().getLimit().getFirstRow(), startPosition, (WrapperOptions)executionContext.getSession());
        }
    }

    private static class LazySessionWrapperOptions
    extends AbstractDelegatingWrapperOptions {
        private final SessionFactoryImplementor sessionFactory;
        private SessionImplementor session;

        public LazySessionWrapperOptions(SessionFactoryImplementor sessionFactory) {
            this.sessionFactory = sessionFactory;
        }

        public void cleanup() {
            if (this.session != null) {
                this.session.close();
                this.session = null;
            }
        }

        @Override
        protected SessionImplementor delegate() {
            if (this.session == null) {
                this.session = this.sessionFactory.openTemporarySession();
            }
            return this.session;
        }

        @Override
        public SharedSessionContractImplementor getSession() {
            return this.delegate();
        }

        @Override
        public SessionFactoryImplementor getSessionFactory() {
            return this.sessionFactory;
        }

        @Override
        public boolean useStreamForLobBinding() {
            return this.sessionFactory.getFastSessionServices().useStreamForLobBinding();
        }

        @Override
        public int getPreferredSqlTypeCodeForBoolean() {
            return this.sessionFactory.getFastSessionServices().getPreferredSqlTypeCodeForBoolean();
        }

        @Override
        public TimeZone getJdbcTimeZone() {
            return this.sessionFactory.getSessionFactoryOptions().getJdbcTimeZone();
        }
    }
}

